//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Midstream Physical Channel Control
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module midstream_control
(
  /*****************************************************************************
  * System
  *****************************************************************************/
  input wire                      clk,
  input wire                      rst_n,

  /*****************************************************************************
  * Channel Control
  *****************************************************************************/
  input  wire                     channel_sel,
  input  wire                     channel_req,
  input  wire              [31:0] channel_saddr,
  input  wire              [31:0] channel_daddr,
  input  wire               [3:0] channel_tag,
  input  wire              [15:0] channel_length,
  output wire                     channel_busy,
  output reg                      channel_ack,
  output wire               [3:0] channel_ack_tag,
  output wire                     channel_ack_error,
  input  wire                     channel_ack_ack,

  /***************************************************************************
  * fragment parameters
  ***************************************************************************/
  output reg                      start,
  output reg               [31:0] src_addr,
  output reg               [31:0] dst_addr,
  output reg               [15:0] byte_length,
  input  wire                     done
);

  /*****************************************************************************
  * declarations
  *****************************************************************************/
  localparam  S_IDLE =2'b00,
              S_WORK =2'b01,
              S_DONE =2'b10,
              S_ERROR=2'b11;
              
  reg   [1:0] state;
  reg   [3:0] tag;

  /*****************************************************************************
  * assignment
  *****************************************************************************/
  assign channel_busy       = state!=S_IDLE;
  assign channel_ack_tag    = tag;
  assign channel_ack_error  = (state==S_ERROR) ? 1'b1 : 1'b0;

  /*****************************************************************************
  * FSM
  *****************************************************************************/
  always @(posedge clk, negedge rst_n)
  begin
    if(rst_n==1'b0)
    begin
      start        <= 1'b0;
      src_addr     <= 32'b0;
      dst_addr     <= 32'b0;
      byte_length  <= 16'b0;
      tag          <= 4'b0;
      channel_ack  <= 1'b0;
      state        <= S_IDLE;
    end
    else
    begin
      case(state)
      default: //S_IDLE:
      begin
        if(channel_sel & channel_req)
        begin
          // Bad configuration: source & destination are from AHB address space
          if (channel_saddr[24:23]!=2'b0 & channel_daddr[24:23]!=2'b0)
          begin
            start            <= 1'b0;
            src_addr         <= channel_saddr;
            dst_addr         <= channel_daddr;
            byte_length      <= channel_length;
            tag              <= channel_tag;
            state            <= S_ERROR;
          end
          else
          begin
            start            <= 1'b1;
            src_addr         <= channel_saddr;
            dst_addr         <= channel_daddr;
            byte_length      <= channel_length;
            tag              <= channel_tag;
            state            <= S_WORK;
          end
        end
      end
      
      S_WORK:
      begin
        if(done)
        begin
          start              <= 1'b0;
          channel_ack        <= 1'b1;
          state              <= S_DONE;
        end
      end
      
      S_DONE:
      begin
        if(channel_ack_ack)
        begin
          channel_ack        <= 1'b0;
          state              <= S_IDLE;
        end
      end

      S_ERROR:
      begin
        channel_ack          <= 1'b1;
        if(channel_ack_ack)
        begin
          channel_ack        <= 1'b0;
          state              <= S_IDLE;
        end
      end
      endcase
    end
  end
 

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// Additional Code to ease verification
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
`ifdef RW_SIMU_ON
// pragma coverage block = off 
  reg [16*8-1:0] state_str;
  
  always @(*)
  begin
    case (state)
    S_IDLE:   state_str = "S_IDLE";
    S_WORK:   state_str = "S_WORK";
    S_DONE:   state_str = "S_DONE";   
    S_ERROR:  state_str = "S_ERROR";   
    default:  state_str = "XXX";
    endcase    
  end
// pragma coverage block = on 
`endif


endmodule
`default_nettype wire
////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////

