//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of rw_host_dma module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module rw_host_dma
(
  /*****************************************************************************
  * System
  *****************************************************************************/
  input wire                      clk,
  input wire                      rst_n,

  /*****************************************************************************
  * interrupts
  *****************************************************************************/
  output wire [15:0]              lli_irq,
  output wire [ 4:0]              channel_irq,
  output wire                     error_irq,

  /*****************************************************************************
  * AHB slave (control registers)
  *****************************************************************************/
  input  wire                     hready_in_regb,
  input  wire                     hsel_regb,
  input  wire [ 7:0]              haddr_regb,
  input  wire [ 1:0]              htrans_regb,
  input  wire                     hwrite_regb,
  output wire [31:0]              hrdata_regb,
  input  wire [31:0]              hwdata_regb,
  output wire [ 1:0]              hresp_regb,
  output wire                     hready_regb,

  /*****************************************************************************
  * AHB master (embeded sram)
  *****************************************************************************/
  input  wire                     hready_lli,
  output wire [31:0]              haddr_lli,
  output wire [ 1:0]              htrans_lli,
  output wire                     hwrite_lli,
  input  wire [31:0]              hrdata_lli,
  input  wire [ 1:0]              hresp_lli,

  /*****************************************************************************
  * Upstream AXI interface
  *****************************************************************************/
  output wire              [ 3:0] dma0_awid,
  output wire              [31:0] dma0_awaddr,
  output wire              [ 7:0] dma0_awlen,
  output wire              [ 2:0] dma0_awsize,
  output wire              [ 1:0] dma0_awburst,
  output wire              [11:0] dma0_awuser,
  output wire                     dma0_awvalid,
  input  wire                     dma0_awready,

  output wire              [ 3:0] dma0_wid,
  output wire              [63:0] dma0_wdata,
  output wire              [ 7:0] dma0_wstrb,
  output wire                     dma0_wlast,
  output wire                     dma0_wvalid,
  input  wire                     dma0_wready,

  input  wire               [3:0] dma0_bid,
  input  wire               [1:0] dma0_bresp,
  input  wire                     dma0_bvalid,
  output wire                     dma0_bready,

  /*****************************************************************************
  * Downstream AXI interface
  *****************************************************************************/
  output wire              [ 3:0] dma1_arid,
  output wire              [31:0] dma1_araddr,
  output wire              [ 7:0] dma1_arlen,
  output wire              [ 2:0] dma1_arsize,
  output wire              [ 1:0] dma1_arburst,
  output wire                     dma1_arvalid,
  input  wire                     dma1_arready,

  input  wire              [ 3:0] dma1_rid,
  input  wire              [63:0] dma1_rdata,
  input  wire              [ 1:0] dma1_rresp,
  input  wire                     dma1_rlast,
  input  wire                     dma1_rvalid,
  output wire                     dma1_rready,

  /*****************************************************************************
  * AHB master (AHB memory map)
  *****************************************************************************/
  output wire [31:0]              dma_haddr,
  output wire [ 1:0]              dma_htrans,
  output wire                     dma_hwrite,
  output wire [ 1:0]              dma_hsize,      
  output wire [31:0]              dma_hwdata,
  input  wire [31:0]              dma_hrdata,
  input  wire  [1:0]              dma_hresp,
  input  wire                     dma_hready,

  /*****************************************************************************
  * Bus interfaces
  *****************************************************************************/
  /* upstream */
  input  wire                     dma0_ready,
  output wire [31:0]              dma0_addr,
  output wire                     dma0_trans,
  input  wire [63:0]              dma0_rdata,

  /* downstream */
  input  wire                     dma1_ready,
  output wire [31:0]              dma1_addr,
  output wire                     dma1_trans,
  output wire [ 7:0]              dma1_we,
  output wire [63:0]              dma1_wdata,

  /* midstream read */
  output wire [31:0]              dma2_addr,
  output wire                     dma2_trans,
  input  wire [63:0]              dma2_rdata,
  input  wire                     dma2_ready,

  /* midstream write */
  output wire [31:0]              dma3_addr,
  output wire                     dma3_trans,
  output wire [63:0]              dma3_wdata,
  output wire  [7:0]              dma3_we,
  input  wire                     dma3_ready,

  /*****************************************************************************
  * Debug interface
  *****************************************************************************/
  output wire [31:0]              diag_port_top,
  output wire [15:0]              diag_port_downstream_axi0,
  output wire [15:0]              diag_port_downstream_axi1,
  output wire [15:0]              diag_port_downstream_axi2
);

  /*****************************************************************************
  * declarations
  *****************************************************************************/
  wire  [2:0] channel_sel;
  wire        channel_req;
  wire [31:0] channel_saddr;
  wire [31:0] channel_daddr;
  wire [15:0] channel_length;
  wire [ 3:0] channel_tag;

  wire        upstream_busy;
  wire        upstream_ack;
  wire [ 3:0] upstream_ack_tag;
  wire        upstream_ack_error;
  wire        upstream_ack_ack;

  wire        downstream_busy;
  wire        downstream_ack;
  wire [ 3:0] downstream_ack_tag;
  wire        downstream_ack_error;
  wire        downstream_ack_ack;
  
  wire        midstream_busy;
  wire        midstream_ack;
  wire  [3:0] midstream_ack_tag;
  wire        midstream_ack_error;
  wire        midstream_ack_ack;

  wire        dma0_hready;
  wire [31:0] dma0_haddr;
  wire  [1:0] dma0_htrans;
  wire [31:0] dma0_hrdata;

  wire        dma1_hready;
  wire [31:0] dma1_haddr;
  wire  [1:0] dma1_htrans;
  wire  [1:0] dma1_hsize;
  wire [31:0] dma1_hwdata;
  wire  [1:0] dma1_hresp;

  wire        dma2_hready;
  wire [31:0] dma2_haddr;
  wire  [1:0] dma2_htrans;
  wire        dma2_hwrite;
  wire  [1:0] dma2_hsize;
  wire [31:0] dma2_hrdata;
  wire [31:0] dma2_hwdata;
  wire  [1:0] dma2_hresp;

  wire  [3:0] axi_burst_length_limit;

  //////////////////////////////////////////////////////////////////////////////
  //
  //  DMA CONTROL
  //
  //////////////////////////////////////////////////////////////////////////////
  dma_ctrl dma_ctrl_0
  (
    /***************************************************************************
    * System
    ***************************************************************************/
    .clk                   (clk                   ),
    .rst_n                 (rst_n                 ),

    /***************************************************************************
    * Interrupts
    ***************************************************************************/
    .lli_irq               (lli_irq               ),
    .channel_irq           (channel_irq           ),
    .error_irq             (error_irq             ),
    
    /***************************************************************************
    * register bank interface
    ***************************************************************************/
    .hready_in_regb        (hready_in_regb        ),
    .hsel_regb             (hsel_regb             ),
    .haddr_regb            (haddr_regb            ),
    .htrans_regb           (htrans_regb           ),
    .hwrite_regb           (hwrite_regb           ),
    .hrdata_regb           (hrdata_regb           ),
    .hwdata_regb           (hwdata_regb           ),
    .hready_regb           (hready_regb           ),
    .hresp_regb            (hresp_regb            ),

    /***************************************************************************
    * configuration from register
    ***************************************************************************/
    .axi_burst_length_limit(axi_burst_length_limit),

    /***************************************************************************
    * LLI AHB master interface
    ***************************************************************************/
    .hready_lli            (hready_lli            ),
    .haddr_lli             (haddr_lli             ),
    .htrans_lli            (htrans_lli            ),
    .hwrite_lli            (hwrite_lli            ),
    .hrdata_lli            (hrdata_lli            ),
    .hresp_lli             (hresp_lli             ),

    /***************************************************************************
    * physical channel interface
    ***************************************************************************/
    // fragment request
    .channel_sel           (channel_sel           ),
    .channel_req           (channel_req           ),
    
    // fragment request parameters
    .channel_saddr         (channel_saddr         ),
    .channel_daddr         (channel_daddr         ),
    .channel_length        (channel_length        ),
    .channel_tag           (channel_tag           ),
        
    // upstream physical busy), can't accept request
    .upstream_busy         (upstream_busy         ),
    
    // upstream physical channel acknowledge 
    .upstream_ack          (upstream_ack          ),
    .upstream_ack_tag      (upstream_ack_tag      ),
    .upstream_ack_error    (upstream_ack_error    ),
    .upstream_ack_ack      (upstream_ack_ack      ),
    
    // upstream physical busy), can't accept request
    .downstream_busy       (downstream_busy       ),
    
    // upstream physical channel acknowledge 
    .downstream_ack        (downstream_ack        ),
    .downstream_ack_tag    (downstream_ack_tag    ),
    .downstream_ack_error  (downstream_ack_error  ),
    .downstream_ack_ack    (downstream_ack_ack    ),

    // midstream physical busy, can't accept request
    .midstream_busy        (midstream_busy        ),
    
    // midstream physical channel acknowledge 
    .midstream_ack         (midstream_ack         ),
    .midstream_ack_tag     (midstream_ack_tag     ),
    .midstream_ack_error   (midstream_ack_error   ),
    .midstream_ack_ack     (midstream_ack_ack     )
  );


  //////////////////////////////////////////////////////////////////////////////
  //
  //  UPSTREAM PATH
  //
  //////////////////////////////////////////////////////////////////////////////
  upstream_channel upstream_channel_0
  (
    /***************************************************************************
    * System
    ***************************************************************************/
    .clk                    (clk                    ),
    .rst_n                  (rst_n                  ),
    
    /***************************************************************************
    * Configuration from register
    ***************************************************************************/
    .axi_burst_length_limit (axi_burst_length_limit ),

    /***************************************************************************
    * Channel Control
    ***************************************************************************/
    .channel_sel            (channel_sel[0]         ),
    .channel_req            (channel_req            ),
    .channel_saddr          (channel_saddr          ),
    .channel_daddr          (channel_daddr          ),
    .channel_tag            (channel_tag            ),
    .channel_length         (channel_length         ),
    .channel_busy           (upstream_busy          ),
    .upstream_ack           (upstream_ack           ),
    .upstream_ack_tag       (upstream_ack_tag       ),
    .upstream_ack_error     (upstream_ack_error     ),
    .upstream_ack_ack       (upstream_ack_ack       ),
    
    /***************************************************************************
    * Upstream AXI interface
    ***************************************************************************/
    .dma0_awid              (dma0_awid              ),
    .dma0_awaddr            (dma0_awaddr            ),
    .dma0_awlen             (dma0_awlen             ),
    .dma0_awsize            (dma0_awsize            ),
    .dma0_awburst           (dma0_awburst           ),
    .dma0_awuser            (dma0_awuser            ),
    .dma0_awvalid           (dma0_awvalid           ),
    .dma0_awready           (dma0_awready           ),

    .dma0_wid               (dma0_wid               ),
    .dma0_wdata             (dma0_wdata             ),
    .dma0_wstrb             (dma0_wstrb             ),
    .dma0_wlast             (dma0_wlast             ),
    .dma0_wvalid            (dma0_wvalid            ),
    .dma0_wready            (dma0_wready            ),

    .dma0_bid               (dma0_bid               ),
    .dma0_bresp             (dma0_bresp             ),
    .dma0_bvalid            (dma0_bvalid            ),
    .dma0_bready            (dma0_bready            ),
    
    /***************************************************************************
    * Bus interfaces (SRAM)
    ***************************************************************************/
    .dma0_ready             (dma0_ready             ),
    .dma0_addr              (dma0_addr              ),
    .dma0_trans             (dma0_trans             ),
    .dma0_rdata             (dma0_rdata             ),
    
    /***************************************************************************
    * AHB master (AHB Memory Map)
    ***************************************************************************/
    .dma0_hready            (dma0_hready            ),
    .dma0_haddr             (dma0_haddr             ),
    .dma0_htrans            (dma0_htrans            ),
    .dma0_hrdata            (dma0_hrdata            )
  );


  //////////////////////////////////////////////////////////////////////////////
  //
  //  DOWNSTREAM PATH
  //
  //////////////////////////////////////////////////////////////////////////////
  downstream_channel downstream_channel_0
  (
    /***************************************************************************
    * System
    ***************************************************************************/
    .clk                       (clk                       ),
    .rst_n                     (rst_n                     ),
    
    /***************************************************************************
    * Configuration from register
    ***************************************************************************/
    .axi_burst_length_limit    (axi_burst_length_limit    ),

    /***************************************************************************
    * Channel Control
    ***************************************************************************/
    .channel_sel               (channel_sel[1]            ),
    .channel_req               (channel_req               ),
    .channel_saddr             (channel_saddr             ),
    .channel_daddr             (channel_daddr             ),
    .channel_tag               (channel_tag               ),
    .channel_length            (channel_length            ),
    .channel_busy              (downstream_busy           ),
    .downstream_ack            (downstream_ack            ),
    .downstream_ack_tag        (downstream_ack_tag        ),
    .downstream_ack_error      (downstream_ack_error      ),
    .downstream_ack_ack        (downstream_ack_ack        ),
    
    /***************************************************************************
    * AXI interface
    ***************************************************************************/
    .dma1_arid                 (dma1_arid                 ),
    .dma1_araddr               (dma1_araddr               ),
    .dma1_arlen                (dma1_arlen                ),
    .dma1_arsize               (dma1_arsize               ),
    .dma1_arburst              (dma1_arburst              ),
    .dma1_arvalid              (dma1_arvalid              ),
    .dma1_arready              (dma1_arready              ),

    .dma1_rid                  (dma1_rid                  ),
    .dma1_rdata                (dma1_rdata                ),
    .dma1_rresp                (dma1_rresp                ),
    .dma1_rlast                (dma1_rlast                ),
    .dma1_rvalid               (dma1_rvalid               ),
    .dma1_rready               (dma1_rready               ),

    /***************************************************************************
    * Bus interfaces (SRAM)
    ***************************************************************************/
    .dma1_ready                (dma1_ready                ),
    .dma1_addr                 (dma1_addr                 ),
    .dma1_trans                (dma1_trans                ),
    .dma1_we                   (dma1_we                   ),
    .dma1_wdata                (dma1_wdata                ),

    /***************************************************************************
    * AHB Master (AHB Address Map)
    ***************************************************************************/
    .dma1_hready               (dma1_hready               ),
    .dma1_haddr                (dma1_haddr                ),
    .dma1_htrans               (dma1_htrans               ),
    .dma1_hsize                (dma1_hsize                ),
    .dma1_hwdata               (dma1_hwdata               ),
    .dma1_hresp                (dma1_hresp                ),

    /***************************************************************************
    * Debug interface
    ***************************************************************************/
    .diag_port_downstream_axi0 (diag_port_downstream_axi0 ),
    .diag_port_downstream_axi1 (diag_port_downstream_axi1 ),
    .diag_port_downstream_axi2 (diag_port_downstream_axi2 )
  );


  //////////////////////////////////////////////////////////////////////////////
  //
  //  MIDSTREAM PATH
  //
  //////////////////////////////////////////////////////////////////////////////
  midstream_channel  midstream_channel_0
  (
    /***************************************************************************
    * System
    ***************************************************************************/
    .clk                (clk                  ),
    .rst_n              (rst_n                ),
    
    /***************************************************************************
    * Channel Control
    ***************************************************************************/
    .channel_sel        (channel_sel[2]       ),
    .channel_req        (channel_req          ),
    .channel_saddr      (channel_saddr        ),
    .channel_daddr      (channel_daddr        ),
    .channel_tag        (channel_tag          ),
    .channel_length     (channel_length       ),
    .channel_busy       (midstream_busy       ),
    .channel_ack        (midstream_ack        ),
    .channel_ack_tag    (midstream_ack_tag    ),
    .channel_ack_error  (midstream_ack_error  ),
    .channel_ack_ack    (midstream_ack_ack    ),
    
    /***************************************************************************
    * Bus interfaces 0 (Shared SRAM)
    ***************************************************************************/
    .p0_addr            (dma2_addr            ),
    .p0_trans           (dma2_trans           ),
    .p0_rdata           (dma2_rdata           ),
    .p0_ready           (dma2_ready           ),

    /***************************************************************************
    * Bus interfaces 1 (Shared SRAM)
    ***************************************************************************/
    .p1_addr            (dma3_addr            ),
    .p1_trans           (dma3_trans           ),
    .p1_wdata           (dma3_wdata           ),
    .p1_we              (dma3_we              ),
    .p1_ready           (dma3_ready           ),

    /***************************************************************************
    * AHB master( IP)
    ***************************************************************************/
    .p2_hready          (dma2_hready          ),
    .p2_haddr           (dma2_haddr           ),
    .p2_htrans          (dma2_htrans          ),
    .p2_hwrite          (dma2_hwrite          ),
    .p2_hsize           (dma2_hsize           ),
    .p2_hrdata          (dma2_hrdata          ),
    .p2_hwdata          (dma2_hwdata          ),
    .p2_hresp           (dma2_hresp           )
  );


  //////////////////////////////////////////////////////////////////////////////
  //
  //  AHB Multiport Arbiter
  //
  //////////////////////////////////////////////////////////////////////////////
  ahb_mpa3
  #(
    /***************************************************************************
    * AHB addres bus length (byte address)
    ***************************************************************************/
    .g_addr_width (32)
  )
  ahb_mpa3_0
  (  
    /***************************************************************************
    * System
    ***************************************************************************/
    .clk          (clk         ),
    .rst_n        (rst_n       ),
    
    /***************************************************************************
    * AHB Slave 0 bus 
    ***************************************************************************/
    .s0_hready_in (dma0_hready ),
    .s0_hsel      (1'b1        ),
    .s0_haddr     (dma0_haddr  ),
    .s0_htrans    (dma0_htrans ),
    .s0_hwrite    (1'b0        ),
    .s0_hsize     (2'b10       ),      
    .s0_hwdata    (32'h0       ),
    .s0_hrdata    (dma0_hrdata ),
    .s0_hresp     (/*Open*/    ),
    .s0_hready    (dma0_hready ),
   
    /***************************************************************************
    * AHB Slave 1 bus 
    ***************************************************************************/
    .s1_hready_in (dma1_hready ),
    .s1_hsel      (1'b1        ),
    .s1_haddr     (dma1_haddr  ),
    .s1_htrans    (dma1_htrans ),
    .s1_hwrite    (1'b1        ),
    .s1_hsize     (dma1_hsize  ),      
    .s1_hwdata    (dma1_hwdata ),
    .s1_hrdata    (/*Open*/    ),
    .s1_hresp     (dma1_hresp  ),
    .s1_hready    (dma1_hready ),
   
    /***************************************************************************
    * AHB Slave 2 bus 
    ***************************************************************************/
    .s2_hready_in (dma2_hready ),
    .s2_hsel      (1'b1        ),
    .s2_haddr     (dma2_haddr  ),
    .s2_htrans    (dma2_htrans ),
    .s2_hwrite    (dma2_hwrite ),
    .s2_hsize     (dma2_hsize  ),      
    .s2_hwdata    (dma2_hwdata ),
    .s2_hrdata    (dma2_hrdata ),
    .s2_hresp     (dma2_hresp  ),
    .s2_hready    (dma2_hready ),
   
    /***************************************************************************
    * AHB Master bus 
    ***************************************************************************/
    .m_hready_in  (/*Open*/    ),
    .m_hsel       (/*Open*/    ),
    .m_haddr      (dma_haddr   ),
    .m_htrans     (dma_htrans  ),
    .m_hwrite     (dma_hwrite  ),
    .m_hsize      (dma_hsize   ),      
    .m_hwdata     (dma_hwdata  ),
    .m_hrdata     (dma_hrdata  ),
    .m_hresp      (dma_hresp   ),
    .m_hready     (dma_hready  )
  );

  /*****************************************************************************
  * Debug Port
  *****************************************************************************/
  assign diag_port_top = {
     midstream_ack_tag[3:0],
     midstream_ack_ack,
     midstream_ack_error,
     midstream_ack,
     midstream_busy,
     downstream_ack_tag[3:0],
     downstream_ack_ack,
     downstream_ack_error,
     downstream_ack,
     downstream_busy,
     upstream_ack_tag[3:0],
     upstream_ack_ack,
     upstream_ack_error,
     upstream_ack,
     upstream_busy,
     channel_tag[3:0],
     channel_req,
     channel_sel[2:0]
  };

endmodule
