//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Upstream Physical Channel Top
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module upstream_channel
(
  /*****************************************************************************
  * System
  *****************************************************************************/
  input wire                      clk,
  input wire                      rst_n,

  /*****************************************************************************
  * Configuration from register
  *****************************************************************************/
  input  wire               [3:0] axi_burst_length_limit,

  /*****************************************************************************
  * Channel Control
  *****************************************************************************/
  input  wire                     channel_sel,
  input  wire                     channel_req,
  input  wire              [31:0] channel_saddr,
  input  wire              [31:0] channel_daddr,
  input  wire               [3:0] channel_tag,
  input  wire              [15:0] channel_length,
  output wire                     channel_busy,
  output wire                     upstream_ack,
  output wire               [3:0] upstream_ack_tag,
  output wire                     upstream_ack_error,
  input  wire                     upstream_ack_ack,

  /*****************************************************************************
  * AXI interface
  *****************************************************************************/
  output wire              [ 3:0] dma0_awid,
  output wire              [31:0] dma0_awaddr,
  output wire              [ 7:0] dma0_awlen,
  output wire              [ 2:0] dma0_awsize,
  output wire              [ 1:0] dma0_awburst,
  output wire              [11:0] dma0_awuser,
  output wire                     dma0_awvalid,
  input  wire                     dma0_awready,

  output wire              [ 3:0] dma0_wid,
  output wire              [63:0] dma0_wdata,
  output wire              [ 7:0] dma0_wstrb,
  output wire                     dma0_wlast,
  output wire                     dma0_wvalid,
  input  wire                     dma0_wready,

  input  wire               [3:0] dma0_bid,
  input  wire               [1:0] dma0_bresp,
  input  wire                     dma0_bvalid,
  output wire                     dma0_bready,

  /*****************************************************************************
  * Bus interfaces (SRAM)
  *****************************************************************************/
  input  wire                     dma0_ready,
  output wire              [31:0] dma0_addr,
  output wire                     dma0_trans,
  input  wire              [63:0] dma0_rdata,

  /*****************************************************************************
  * AHB master (AHB Memory Map)
  *****************************************************************************/
  input  wire                     dma0_hready,
  output wire              [31:0] dma0_haddr,
  output wire              [ 1:0] dma0_htrans,
  input  wire              [31:0] dma0_hrdata
);

  /*****************************************************************************
  * declarations
  *****************************************************************************/
  // Upstream control
  wire        upstream_start;
  wire [31:0] upstream_saddr;
  wire [ 2:0] upstream_daddr;
  wire [11:0] upstream_length;
  reg         upstream_busif_start;
  reg         upstream_ahbif_start;

  // Data from Aligner
  wire [63:0] upstream_aligner_data;
  wire        upstream_aligner_data_en;
  wire        upstream_aligner_data_rdy;

  // Data from FIFO
  wire [63:0] upstream_fifo_data;
  wire        upstream_fifo_data_en;
  wire        upstream_fifo_data_last;

  // Data muxed from AHB/BUS interface
  reg  [63:0] upstream_data;
  reg         upstream_data_en;
  reg         upstream_data_last;
  wire        upstream_data_pause;

  // Data from BUS interface
  wire [63:0] upstream_busif_data;
  wire        upstream_busif_data_en;
  wire        upstream_busif_data_last;

  // Data from AHB interface
  wire [63:0] upstream_ahbif_data;
  wire        upstream_ahbif_data_en;
  wire        upstream_ahbif_data_last;

  // Data To Aligner
  wire [63:0] aligner_datai;
  wire        aligner_datai_en;
  wire        aligner_datai_last;

  //////////////////////////////////////////////////////////////////////////////
  //
  //  AXI Interface
  //
  //////////////////////////////////////////////////////////////////////////////
  upstream_axi upstream_axi_0
  (
    /***************************************************************************
    * System
    ***************************************************************************/
    .clk                    (clk                       ),
    .rst_n                  (rst_n                     ),
    
    /***************************************************************************
    * Configuration from register
    ***************************************************************************/
    .axi_burst_length_limit (axi_burst_length_limit    ),

    /***************************************************************************
    * Channel Control
    ***************************************************************************/
    .channel_sel            (channel_sel               ),
    .channel_req            (channel_req               ),
    .channel_saddr          (channel_saddr             ),
    .channel_daddr          (channel_daddr             ),
    .channel_tag            (channel_tag               ),
    .channel_length         (channel_length            ),
    .channel_busy           (channel_busy              ),
    .channel_ack            (upstream_ack              ),
    .channel_ack_tag        (upstream_ack_tag          ),
    .channel_ack_error      (upstream_ack_error        ),
    .channel_ack_ack        (upstream_ack_ack          ),
    
    /***************************************************************************
    * Upstream Control
    ***************************************************************************/
    .start                  (upstream_start            ),
    .saddr                  (upstream_saddr            ),
    .daddr                  (upstream_daddr            ),
    .length                 (upstream_length           ),
    
    /***************************************************************************
    * AXI interface
    ***************************************************************************/
    .awid                   (dma0_awid                 ),
    .awaddr                 (dma0_awaddr               ),
    .awlen                  (dma0_awlen                ),
    .awsize                 (dma0_awsize               ),
    .awburst                (dma0_awburst              ),
    .awuser                 (dma0_awuser               ),
    .awvalid                (dma0_awvalid              ),
    .awready                (dma0_awready              ),
    
    .wid                    (dma0_wid                  ),
    .wdata                  (dma0_wdata                ),
    .wstrb                  (dma0_wstrb                ),
    .wlast                  (dma0_wlast                ),
    .wvalid                 (dma0_wvalid               ),
    .wready                 (dma0_wready               ),
    
    .bid                    (dma0_bid                  ),
    .bresp                  (dma0_bresp                ),
    .bvalid                 (dma0_bvalid               ),
    .bready                 (dma0_bready               ),
    
    /***************************************************************************
    * Aligner interface
    ***************************************************************************/
    .datai                  (upstream_aligner_data     ),
    .datai_en               (upstream_aligner_data_en  ),
    .datai_rdy              (upstream_aligner_data_rdy )
  );
   

  //////////////////////////////////////////////////////////////////////////////
  //
  //  Aligner
  //
  //////////////////////////////////////////////////////////////////////////////
  aligner upstream_aligner_0
  (
    /***************************************************************************
    * System
    ***************************************************************************/
    .clk        (clk                      ),
    .rst_n      (rst_n                    ),

    /***************************************************************************
    * 
    ***************************************************************************/
    .start      (upstream_start           ),
    .src_addr   (upstream_saddr[2:0]      ),
    .dst_addr   (upstream_daddr[2:0]      ),

    /***************************************************************************
    * 
    ***************************************************************************/
    .datai      (aligner_datai            ),
    .datai_en   (aligner_datai_en         ),
    .datai_last (aligner_datai_last       ),

    /***************************************************************************
    * 
    ***************************************************************************/
    .datao      (upstream_aligner_data    ),
    .datao_en   (upstream_aligner_data_en )
  );

  assign aligner_datai      = upstream_fifo_data;
  assign aligner_datai_en   = upstream_fifo_data_en && upstream_aligner_data_rdy;
  assign aligner_datai_last = upstream_fifo_data_last;


  //////////////////////////////////////////////////////////////////////////////
  //
  //  FIFO
  //
  //////////////////////////////////////////////////////////////////////////////
  upstream_fifo upstream_fifo_0
  (
    /***************************************************************************
    * Clock & Reset
    ***************************************************************************/
    .clk         (clk                       ),
    .rst_n       (rst_n                     ),
    /***************************************************************************
    * Write Interface
    ***************************************************************************/
    .datai       (upstream_data             ),
    .datai_en    (upstream_data_en          ),
    .datai_last  (upstream_data_last        ),
    .datai_pause (upstream_data_pause       ),
    /***************************************************************************
    * Read Interface
    ***************************************************************************/
    .datao       (upstream_fifo_data        ),
    .datao_last  (upstream_fifo_data_last   ),
    .datao_en    (upstream_fifo_data_en     ),
    .datao_rdy   (upstream_aligner_data_rdy )
  );


  /*****************************************************************************
  * Aligner Mux
  *****************************************************************************/
  always @*
  begin
    // If the source Addr is in the SRAM, the upstream_busif interface is used
    if (upstream_saddr[24:23] == 2'b0)
    begin
      upstream_busif_start = upstream_start;
      upstream_ahbif_start = 1'b0;
      upstream_data        = upstream_busif_data;
      upstream_data_en     = upstream_busif_data_en;
      upstream_data_last   = upstream_busif_data_last;
    end
    else  
    // If the source Addr is not in the SRAM, the upstream_ahbif interface is used
    begin
      upstream_busif_start = 1'b0;
      upstream_ahbif_start = upstream_start;
      upstream_data        = upstream_ahbif_data;
      upstream_data_en     = upstream_ahbif_data_en;
      upstream_data_last   = upstream_ahbif_data_last;
    end
  end
  
  
  //////////////////////////////////////////////////////////////////////////////
  //
  //  Bus IF
  //
  //////////////////////////////////////////////////////////////////////////////
  upstream_busif upstream_busif_0
  (
    /*****************************************************************************
    * System
    *****************************************************************************/
    .clk        (clk                        ),
    .rst_n      (rst_n                      ),

    /*****************************************************************************
    * control/state
    *****************************************************************************/
    .start      (upstream_busif_start       ),
    .pause      (upstream_data_pause        ),
    .done       (/*Open*/                   ),

    /*****************************************************************************
    * Static parameters
    *****************************************************************************/
    .src_addr   (upstream_saddr             ),
    .src_length (upstream_length            ),
   
    /*****************************************************************************
    * bus interface
    *****************************************************************************/
    .bus_ready  (dma0_ready                 ),
    .bus_addr   (dma0_addr                  ),
    .bus_trans  (dma0_trans                 ),
    .bus_data   (dma0_rdata                 ),

    /*****************************************************************************
    * aligner interface
    *****************************************************************************/
    .data       (upstream_busif_data        ),
    .data_en    (upstream_busif_data_en     ),
    .data_last  (upstream_busif_data_last   )            
  );


  //////////////////////////////////////////////////////////////////////////////
  //
  //  AHB IF
  //
  //////////////////////////////////////////////////////////////////////////////
  upstream_ahbif upstream_ahbif_0
  (
    /*****************************************************************************
    * System
    *****************************************************************************/
    .clk        (clk                        ),
    .rst_n      (rst_n                      ),

    /*****************************************************************************
    * control/state
    *****************************************************************************/
    .start      (upstream_ahbif_start       ),
    .pause      (upstream_data_pause        ),
    .done       (/*Open*/                   ),

    /*****************************************************************************
    * Static parameters
    *****************************************************************************/
    .src_addr   (upstream_saddr             ),
    .src_length (upstream_length            ),
   
    /*****************************************************************************
    * AHB interface
    *****************************************************************************/
    .hready     (dma0_hready                ),
    .haddr      (dma0_haddr                 ),
    .htrans     (dma0_htrans                ),
    .hrdata     (dma0_hrdata                ),

    /*****************************************************************************
    * aligner interface
    *****************************************************************************/
    .data       (upstream_ahbif_data        ),
    .data_en    (upstream_ahbif_data_en     ),
    .data_last  (upstream_ahbif_data_last   )            
  );


endmodule
`default_nettype wire
////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////
