//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Upstream FIFO
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module upstream_fifo 
(
   //**************************************************************************
   // Clock & Reset
   //**************************************************************************
   input  wire                   clk,
   input  wire                   rst_n, 
   //**************************************************************************
   // Write Interface
   //**************************************************************************
   input  wire            [63:0] datai,
   input  wire                   datai_last,
   input  wire                   datai_en,
   output wire                   datai_pause,
   //**************************************************************************
   // Read Interface
   //**************************************************************************
   output wire            [63:0] datao,
   output wire                   datao_last,
   output wire                   datao_en,
   input  wire                   datao_rdy
);

//////////////////////////////////////////////////////////////////////////////
// Signals Declaration
//////////////////////////////////////////////////////////////////////////////
reg             [64:0] mem[2:0];
reg              [2:0] wr_addr;
reg              [2:0] rd_addr;
wire             [2:0] next_wr_addr;
wire             [2:0] next_rd_addr;
wire                   wr_enable;
wire                   rd_enable;
wire                   full;
wire                   almost_empty;
wire                   empty;

//////////////////////////////////////////////////////////////////////////////
// FIFO
//////////////////////////////////////////////////////////////////////////////
// Memory
always @(posedge clk or negedge rst_n)
begin
   if (!rst_n)
   begin
      wr_addr  <= 3'b0;
      rd_addr  <= 3'b0;
      mem[0]   <= 65'h0;
      mem[1]   <= 65'h0;
      mem[2]   <= 65'h0;
   end
   else
   begin
      if (wr_enable)
      begin
         wr_addr           <= next_wr_addr;
         mem[wr_addr[1:0]] <= {datai_last,datai};
      end

      if (rd_enable)
      begin
         rd_addr           <= next_rd_addr;
      end
   end
end

assign wr_enable    = (datai_en && !full); // Should Write Remaining Data until fifo full
assign rd_enable    = (datao_en && datao_rdy);

assign next_wr_addr = (wr_addr[1:0]==2'b10) ? {~wr_addr[2],2'b00} : wr_addr+3'b1;
assign next_rd_addr = (rd_addr[1:0]==2'b10) ? {~rd_addr[2],2'b00} : rd_addr+3'b1;

// Data In
assign datai_pause = !empty && !almost_empty;

// Data Output
assign datao      = mem[rd_addr[1:0]][63:0];
assign datao_last = mem[rd_addr[1:0]][64];
assign datao_en   = !empty;

// Status
assign full        = ((wr_addr[1:0] == rd_addr[1:0]) &
                      (wr_addr[2]   != rd_addr[2]) ) ? 1'b1 : 1'b0;
assign empty        = (wr_addr      == rd_addr     ) ? 1'b1 : 1'b0;
assign almost_empty = (wr_addr      == next_rd_addr) && rd_enable ? 1'b1 : 1'b0;

endmodule
`default_nettype wire
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
