//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : RW HSU registers
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
// 
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module rw_hsu_reg (
    ////////////////////////////////////////////
    //$port_g Clock and reset
    ////////////////////////////////////////////
    input wire            ahb_nrst,  // AHB Hard Reset
    input wire            ahb_clk,   // AHB clock

    ////////////////////////////////////////////
    // Registers
    ////////////////////////////////////////////
    //$port_g REVISION register.
    input wire            rsa_4096                    , // Indicates whether the current hsu version included the feature RSA-4096
    input wire            rsa_2048                    , // Indicates whether the current hsu version included the feature RSA-2048
    input wire            rsa_1024                    , // Indicates whether the current hsu version included the feature RSA-1024
    input wire            hmac_sha512_sha384          , // Indicates whether the current hsu version included the feature HMAC-SHA512 and SHA-384
    input wire            hmac_sha256_sha224          , // Indicates whether the current hsu version included the feature HMAC-SHA256 and HMAC-SHA224
    input wire            hmac_sha1                   , // Indicates whether the current hsu version included the feature HMAC-SHA1
    input wire            sha_512_384                 , // Indicates whether the current hsu version included the feature SHA-512 and SHA-384
    input wire            sha_256_224                 , // Indicates whether the current hsu version included the feature SHA-256 and SHA224
    input wire            sha_1                       , // Indicates whether the current hsu version included the feature SHA-1
    input wire            ip_chk                      , // Indicates whether the current hsu version included the feature IP checksum
    input wire            aes_128_cmac                , // Indicates whether the current hsu version included the feature AES-128-CMAC
    input wire            tkip_mic                    , // Indicates whether the current hsu version included the feature TKIP-MIC
    input wire [15 : 0]   version                     , // Version number of the HSU.
    input wire            start_in                    , // Set by software to start processing, reset by hardware when processing is done In
    input wire            start_in_valid              , // Set by software to start processing, reset by hardware when processing is done In Valid
    //$port_g STATUS_SET register.
    input wire            done_set                    , // Done status, this bit is set by the HW when the processing is done
    input wire            done_clear_in               , // This bit is written by software to clear the done status. In
    input wire            done_clear_in_valid         , // This bit is written by software to clear the done status. In Valid
    input wire [31 : 0]   mic0_in                     , // MIC value In
    input wire            mic0_in_valid               , // MIC value In Valid
    input wire [31 : 0]   mic1_in                     , // MIC value In
    input wire            mic1_in_valid               , // MIC value In Valid
    //$port_g REMAINING register.
    input wire [1 : 0]    remaining_length_in         , // Indicate the remaing length (in bytes), only in TKIP MIC mode In
    input wire            remaining_length_in_valid   , // Indicate the remaing length (in bytes), only in TKIP MIC mode In Valid
    input wire [7 : 0]    remaining_byte2_in          , // Indicate the remaing byte 2, only in TKIP MIC mode In
    input wire            remaining_byte2_in_valid    , // Indicate the remaing byte 2, only in TKIP MIC mode In Valid
    input wire [7 : 0]    remaining_byte1_in          , // Indicate the remaing byte 1, only in TKIP MIC mode In
    input wire            remaining_byte1_in_valid    , // Indicate the remaing byte 1, only in TKIP MIC mode In Valid
    input wire [7 : 0]    remaining_byte0_in          , // Indicate the remaing byte 0, only in TKIP MIC mode In
    input wire            remaining_byte0_in_valid    , // Indicate the remaing byte 0, only in TKIP MIC mode In Valid
`ifdef RW_HSU_SHA_EN                   
    //$port_g SHA_TAB0 register.
    input wire [31 : 0]   sha0                        , // SHA Result Value
    //$port_g SHA_TAB1 register.
    input wire [31 : 0]   sha1                        , // SHA Result Value
    //$port_g SHA_TAB2 register.
    input wire [31 : 0]   sha2                        , // SHA Result Value
    //$port_g SHA_TAB3 register.
    input wire [31 : 0]   sha3                        , // SHA Result Value
    //$port_g SHA_TAB4 register.
    input wire [31 : 0]   sha4                        , // SHA Result Value
    //$port_g SHA_TAB5 register.
    input wire [31 : 0]   sha5                        , // SHA Result Value
    //$port_g SHA_TAB6 register.
    input wire [31 : 0]   sha6                        , // SHA Result Value
    //$port_g SHA_TAB7 register.
    input wire [31 : 0]   sha7                        , // SHA Result Value
    //$port_g SHA_TAB8 register.
    input wire [31 : 0]   sha8                        , // SHA Result Value
    //$port_g SHA_TAB9 register.
    input wire [31 : 0]   sha9                        , // SHA Result Value
    //$port_g SHA_TAB10 register.
    input wire [31 : 0]   sha10                       , // SHA Result Value
    //$port_g SHA_TAB11 register.
    input wire [31 : 0]   sha11                       , // SHA Result Value
    //$port_g SHA_TAB12 register.
    input wire [31 : 0]   sha12                       , // SHA Result Value
    //$port_g SHA_TAB13 register.
    input wire [31 : 0]   sha13                       , // SHA Result Value
    //$port_g SHA_TAB14 register.
    input wire [31 : 0]   sha14                       , // SHA Result Value
    //$port_g SHA_TAB15 register.
    input wire [31 : 0]   sha15                       , // SHA Result Value
`endif // RW_HSU_SHA_EN                   
`ifdef RW_HSU_RSA_EN                   
`endif // RW_HSU_RSA_EN                   
    //
    //$port_g REVISION register.
    //$port_g CONTROL register.
    output wire [4 : 0]    mode                       , // Select the mode, {MODE3, MODE}
    output wire            last_buffer                , // Set when the buffer to process is the last buffer
    output wire            first_buffer               , // Set when the buffer to process is the first buffer
    output wire            start                      , // Set by software to start processing, reset by hardware when processing is done
    //$port_g STATUS_SET register.
    //$port_g STATUS_CLEAR register.
    output wire            done_clear                 , // This bit is written by software to clear the done status.
    //$port_g KEY_TAB0 register.
    output wire [31 : 0]   key0                       , // Security key, 64bits for TKIP MIC(63:0), 128bits for CMAC
    //$port_g KEY_TAB1 register.
    output wire [31 : 0]   key1                       , // Security key, 64bits for TKIP MIC(63:0), 128bits for CMAC
    //$port_g KEY_TAB2 register.
    output wire [31 : 0]   key2                       , // Security key, 64bits for TKIP MIC(63:0), 128bits for CMAC
    //$port_g KEY_TAB3 register.
    output wire [31 : 0]   key3                       , // Security key, 64bits for TKIP MIC(63:0), 128bits for CMAC
    //$port_g SOURCE_ADDR register.
    output wire [31 : 0]   source_addr                , // Source address register
    //$port_g LENGTH register.
    output wire [15 : 0]   length                     , // Length register
    //$port_g MIC_TAB0 register.
    output wire [31 : 0]   mic0                       , // MIC value
    //$port_g MIC_TAB1 register.
    output wire [31 : 0]   mic1                       , // MIC value
    //$port_g REMAINING register.
    output wire [1 : 0]    remaining_length           , // Indicate the remaing length (in bytes), only in TKIP MIC mode
    output wire [7 : 0]    remaining_byte2            , // Indicate the remaing byte 2, only in TKIP MIC mode
    output wire [7 : 0]    remaining_byte1            , // Indicate the remaing byte 1, only in TKIP MIC mode
    output wire [7 : 0]    remaining_byte0            , // Indicate the remaing byte 0, only in TKIP MIC mode
`ifdef RW_HSU_SHA_EN                   
`endif // RW_HSU_SHA_EN                   
`ifdef RW_HSU_RSA_EN                   
    //$port_g DESTINATION_ADDR register.
    output wire [31 : 0]   dest_addr                  , // Indicate the base address of the destination buffer to process
`endif // RW_HSU_RSA_EN                   

    ////////////////////////////////////////////
    //$port_g Bus interface
    ////////////////////////////////////////////
    input  wire            hready_in,
    input  wire            hsel,
    input  wire [6:0]     haddr,
    input  wire [ 1:0]     htrans,
    input  wire            hwrite,
    input  wire [31:0]     hwdata,
    output wire [31:0]     hrdata,
    output wire [ 1:0]     hresp,
    output wire            hready
    );
  
////////////////////////////////////////////////////////////////////////////////
// Port Declaration 
////////////////////////////////////////////////////////////////////////////////

  //////////////////////////////////////////////////////////////////////////////
  // Constants for registers addresses
  //////////////////////////////////////////////////////////////////////////////
  // Register configuration
  

  // Constants for register addresses.
  localparam RW_HSU_REVISION_ADDR_CT          = 5'b00000;
  localparam RW_HSU_CONTROL_ADDR_CT           = 5'b00001;
  localparam RW_HSU_STATUS_SET_ADDR_CT        = 5'b00010;
  localparam RW_HSU_STATUS_CLEAR_ADDR_CT      = 5'b00011;
  localparam RW_HSU_KEY_TAB0_ADDR_CT          = 5'b00100;
  localparam RW_HSU_KEY_TAB1_ADDR_CT          = 5'b00101;
  localparam RW_HSU_KEY_TAB2_ADDR_CT          = 5'b00110;
  localparam RW_HSU_KEY_TAB3_ADDR_CT          = 5'b00111;
  localparam RW_HSU_SOURCE_ADDR_ADDR_CT       = 5'b01000;
  localparam RW_HSU_LENGTH_ADDR_CT            = 5'b01001;
  localparam RW_HSU_MIC_TAB0_ADDR_CT          = 5'b01010;
  localparam RW_HSU_MIC_TAB1_ADDR_CT          = 5'b01011;
  localparam RW_HSU_REMAINING_ADDR_CT         = 5'b01100;
`ifdef RW_HSU_SHA_EN                   
  localparam RW_HSU_SHA_TAB0_ADDR_CT          = 5'b01101;
  localparam RW_HSU_SHA_TAB1_ADDR_CT          = 5'b01110;
  localparam RW_HSU_SHA_TAB2_ADDR_CT          = 5'b01111;
  localparam RW_HSU_SHA_TAB3_ADDR_CT          = 5'b10000;
  localparam RW_HSU_SHA_TAB4_ADDR_CT          = 5'b10001;
  localparam RW_HSU_SHA_TAB5_ADDR_CT          = 5'b10010;
  localparam RW_HSU_SHA_TAB6_ADDR_CT          = 5'b10011;
  localparam RW_HSU_SHA_TAB7_ADDR_CT          = 5'b10100;
  localparam RW_HSU_SHA_TAB8_ADDR_CT          = 5'b10101;
  localparam RW_HSU_SHA_TAB9_ADDR_CT          = 5'b10110;
  localparam RW_HSU_SHA_TAB10_ADDR_CT         = 5'b10111;
  localparam RW_HSU_SHA_TAB11_ADDR_CT         = 5'b11000;
  localparam RW_HSU_SHA_TAB12_ADDR_CT         = 5'b11001;
  localparam RW_HSU_SHA_TAB13_ADDR_CT         = 5'b11010;
  localparam RW_HSU_SHA_TAB14_ADDR_CT         = 5'b11011;
  localparam RW_HSU_SHA_TAB15_ADDR_CT         = 5'b11100;
`endif // RW_HSU_SHA_EN                   
`ifdef RW_HSU_RSA_EN                   
  localparam RW_HSU_DESTINATION_ADDR_ADDR_CT  = 5'b11101;
`endif // RW_HSU_RSA_EN                   
 
  //////////////////////////////////////////////////////////////////////////////
  // Signals
  //////////////////////////////////////////////////////////////////////////////
  reg  [31: 0] int_reg_dr;
  wire [31: 0] int_reg_dw;
  reg          int_reg_rdy;
  reg          pending_write;
  reg          pending_read;
  reg   [4:0]  pending_addr;

  // REVISION register.
  // CONTROL register.
  reg [4 : 0] int_mode               ;
  reg         int_last_buffer        ;
  reg         int_first_buffer       ;
  reg         int_start              ;
  // STATUS_SET register.
  // STATUS_CLEAR register.
  reg         int_done_clear         ;
  // KEY_TAB0 register.
  reg [31 : 0] int_key0               ;
  // KEY_TAB1 register.
  reg [31 : 0] int_key1               ;
  // KEY_TAB2 register.
  reg [31 : 0] int_key2               ;
  // KEY_TAB3 register.
  reg [31 : 0] int_key3               ;
  // SOURCE_ADDR register.
  reg [31 : 0] int_source_addr        ;
  // LENGTH register.
  reg [15 : 0] int_length             ;
  // MIC_TAB0 register.
  reg [31 : 0] int_mic0               ;
  // MIC_TAB1 register.
  reg [31 : 0] int_mic1               ;
  // REMAINING register.
  reg [1 : 0] int_remaining_length   ;
  reg [7 : 0] int_remaining_byte2    ;
  reg [7 : 0] int_remaining_byte1    ;
  reg [7 : 0] int_remaining_byte0    ;
`ifdef RW_HSU_SHA_EN                   
`endif // RW_HSU_SHA_EN                   
`ifdef RW_HSU_RSA_EN                   
  // DESTINATION_ADDR register.
  reg [31 : 0] int_dest_addr          ;
`endif // RW_HSU_RSA_EN                   


  //////////////////////////////////////////////////////////////////////////////
  // Ouput linkage
  //////////////////////////////////////////////////////////////////////////////
  assign mode               = int_mode               ;
  assign last_buffer        = int_last_buffer        ;
  assign first_buffer       = int_first_buffer       ;
  assign start              = int_start              ;
  assign done_clear         = int_done_clear         ;
  assign key0               = int_key0               ;
  assign key1               = int_key1               ;
  assign key2               = int_key2               ;
  assign key3               = int_key3               ;
  assign source_addr        = int_source_addr        ;
  assign length             = int_length             ;
  assign mic0               = int_mic0               ;
  assign mic1               = int_mic1               ;
  assign remaining_length   = int_remaining_length   ;
  assign remaining_byte2    = int_remaining_byte2    ;
  assign remaining_byte1    = int_remaining_byte1    ;
  assign remaining_byte0    = int_remaining_byte0    ;
`ifdef RW_HSU_SHA_EN                   
`endif // RW_HSU_SHA_EN                   
`ifdef RW_HSU_RSA_EN                   
  assign dest_addr          = int_dest_addr          ;
`endif // RW_HSU_RSA_EN                   


  //////////////////////////////////////////////////////////////////////////////
  // Register write
  //////////////////////////////////////////////////////////////////////////////
  always @(posedge ahb_clk or negedge ahb_nrst)
  begin
    if (!ahb_nrst) 
    begin
      pending_write             <= 1'b0;
      pending_read              <= 1'b0;
      pending_addr              <= 5'b0;
      int_reg_dr                <= 32'b0;
      int_reg_rdy               <= 1'b1;
      // REVISION register.
      // CONTROL register.
      int_mode                <= 5'b00000;
      int_last_buffer         <= 1'b0;
      int_first_buffer        <= 1'b0;
      int_start               <= 1'b0;
      // STATUS_SET register.
      // STATUS_CLEAR register.
      int_done_clear          <= 1'b0;
      // KEY_TAB0 register.
      int_key0                <= 32'b00000000000000000000000000000000;
      // KEY_TAB1 register.
      int_key1                <= 32'b00000000000000000000000000000000;
      // KEY_TAB2 register.
      int_key2                <= 32'b00000000000000000000000000000000;
      // KEY_TAB3 register.
      int_key3                <= 32'b00000000000000000000000000000000;
      // SOURCE_ADDR register.
      int_source_addr         <= 32'b00000000000000000000000000000000;
      // LENGTH register.
      int_length              <= 16'b0000000000000000;
      // MIC_TAB0 register.
      int_mic0                <= 32'b00000000000000000000000000000000;
      // MIC_TAB1 register.
      int_mic1                <= 32'b00000000000000000000000000000000;
      // REMAINING register.
      int_remaining_length    <= 2'b00;
      int_remaining_byte2     <= 8'b00000000;
      int_remaining_byte1     <= 8'b00000000;
      int_remaining_byte0     <= 8'b00000000;
`ifdef RW_HSU_SHA_EN                   
`endif // RW_HSU_SHA_EN                   
`ifdef RW_HSU_RSA_EN                   
      // DESTINATION_ADDR register.
      int_dest_addr           <= 32'b00000000000000000000000000000000;
`endif // RW_HSU_RSA_EN                   
    end
    else
    begin
      int_reg_rdy <= 1'b1;

      if (pending_write==1'b1)
      begin
        
        pending_write <= 1'b0;
        
        case(pending_addr)

          // Write REVISION register.
          RW_HSU_REVISION_ADDR_CT :
          begin
          end

          // Write CONTROL register.
          RW_HSU_CONTROL_ADDR_CT :
          begin
              int_mode                <= int_reg_dw[12 : 8];
              int_last_buffer         <= int_reg_dw[5];
              int_first_buffer        <= int_reg_dw[4];
              int_start               <= int_reg_dw[0];
          end

          // Write STATUS_SET register.
          RW_HSU_STATUS_SET_ADDR_CT :
          begin
          end

          // Write STATUS_CLEAR register.
          RW_HSU_STATUS_CLEAR_ADDR_CT :
          begin
              int_done_clear          <= int_reg_dw[0];
          end

          // Write KEY_TAB0 register.
          RW_HSU_KEY_TAB0_ADDR_CT :
          begin
              int_key0                <= int_reg_dw[31 : 0];
          end

          // Write KEY_TAB1 register.
          RW_HSU_KEY_TAB1_ADDR_CT :
          begin
              int_key1                <= int_reg_dw[31 : 0];
          end

          // Write KEY_TAB2 register.
          RW_HSU_KEY_TAB2_ADDR_CT :
          begin
              int_key2                <= int_reg_dw[31 : 0];
          end

          // Write KEY_TAB3 register.
          RW_HSU_KEY_TAB3_ADDR_CT :
          begin
              int_key3                <= int_reg_dw[31 : 0];
          end

          // Write SOURCE_ADDR register.
          RW_HSU_SOURCE_ADDR_ADDR_CT :
          begin
              int_source_addr         <= int_reg_dw[31 : 0];
          end

          // Write LENGTH register.
          RW_HSU_LENGTH_ADDR_CT :
          begin
              int_length              <= int_reg_dw[15 : 0];
          end

          // Write MIC_TAB0 register.
          RW_HSU_MIC_TAB0_ADDR_CT :
          begin
              int_mic0                <= int_reg_dw[31 : 0];
          end

          // Write MIC_TAB1 register.
          RW_HSU_MIC_TAB1_ADDR_CT :
          begin
              int_mic1                <= int_reg_dw[31 : 0];
          end

          // Write REMAINING register.
          RW_HSU_REMAINING_ADDR_CT :
          begin
              int_remaining_length    <= int_reg_dw[25 : 24];
              int_remaining_byte2     <= int_reg_dw[23 : 16];
              int_remaining_byte1     <= int_reg_dw[15 : 8];
              int_remaining_byte0     <= int_reg_dw[7 : 0];
          end
`ifdef RW_HSU_SHA_EN                   
`endif // RW_HSU_SHA_EN                   
`ifdef RW_HSU_RSA_EN                   

          // Write DESTINATION_ADDR register.
          RW_HSU_DESTINATION_ADDR_ADDR_CT :
          begin
              int_dest_addr           <= int_reg_dw[31 : 0];
          end
`endif // RW_HSU_RSA_EN                   
        
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : 
          begin
          end
          // pragma coverage block = on 

        endcase
      end

      if (pending_read==1'b1)
      begin
        
        pending_read <= 1'b0;
        int_reg_dr   <= 32'b0;
        
        case(pending_addr)

        // Read REVISION register.
        RW_HSU_REVISION_ADDR_CT :
        begin
          int_reg_dr[27]            <= rsa_4096;
          int_reg_dr[26]            <= rsa_2048;
          int_reg_dr[25]            <= rsa_1024;
          int_reg_dr[24]            <= hmac_sha512_sha384;
          int_reg_dr[23]            <= hmac_sha256_sha224;
          int_reg_dr[22]            <= hmac_sha1;
          int_reg_dr[21]            <= sha_512_384;
          int_reg_dr[20]            <= sha_256_224;
          int_reg_dr[19]            <= sha_1;
          int_reg_dr[18]            <= ip_chk;
          int_reg_dr[17]            <= aes_128_cmac;
          int_reg_dr[16]            <= tkip_mic;
          int_reg_dr[15 : 0]        <= version;
        end

        // Read CONTROL register.
        RW_HSU_CONTROL_ADDR_CT :
        begin
          int_reg_dr[12 : 8]        <= mode;
          int_reg_dr[5]             <= last_buffer;
          int_reg_dr[4]             <= first_buffer;
          int_reg_dr[0]             <= start;
        end

        // Read STATUS_SET register.
        RW_HSU_STATUS_SET_ADDR_CT :
        begin
          int_reg_dr[0]             <= done_set;
        end

        // Read STATUS_CLEAR register.
        RW_HSU_STATUS_CLEAR_ADDR_CT :
        begin
          int_reg_dr[0]             <= done_clear;
        end

        // Read KEY_TAB0 register.
        RW_HSU_KEY_TAB0_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= key0;
        end

        // Read KEY_TAB1 register.
        RW_HSU_KEY_TAB1_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= key1;
        end

        // Read KEY_TAB2 register.
        RW_HSU_KEY_TAB2_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= key2;
        end

        // Read KEY_TAB3 register.
        RW_HSU_KEY_TAB3_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= key3;
        end

        // Read SOURCE_ADDR register.
        RW_HSU_SOURCE_ADDR_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= source_addr;
        end

        // Read LENGTH register.
        RW_HSU_LENGTH_ADDR_CT :
        begin
          int_reg_dr[15 : 0]        <= length;
        end

        // Read MIC_TAB0 register.
        RW_HSU_MIC_TAB0_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= mic0;
        end

        // Read MIC_TAB1 register.
        RW_HSU_MIC_TAB1_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= mic1;
        end

        // Read REMAINING register.
        RW_HSU_REMAINING_ADDR_CT :
        begin
          int_reg_dr[25 : 24]       <= remaining_length;
          int_reg_dr[23 : 16]       <= remaining_byte2;
          int_reg_dr[15 : 8]        <= remaining_byte1;
          int_reg_dr[7 : 0]         <= remaining_byte0;
        end
`ifdef RW_HSU_SHA_EN                   

        // Read SHA_TAB0 register.
        RW_HSU_SHA_TAB0_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha0;
        end

        // Read SHA_TAB1 register.
        RW_HSU_SHA_TAB1_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha1;
        end

        // Read SHA_TAB2 register.
        RW_HSU_SHA_TAB2_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha2;
        end

        // Read SHA_TAB3 register.
        RW_HSU_SHA_TAB3_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha3;
        end

        // Read SHA_TAB4 register.
        RW_HSU_SHA_TAB4_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha4;
        end

        // Read SHA_TAB5 register.
        RW_HSU_SHA_TAB5_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha5;
        end

        // Read SHA_TAB6 register.
        RW_HSU_SHA_TAB6_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha6;
        end

        // Read SHA_TAB7 register.
        RW_HSU_SHA_TAB7_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha7;
        end

        // Read SHA_TAB8 register.
        RW_HSU_SHA_TAB8_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha8;
        end

        // Read SHA_TAB9 register.
        RW_HSU_SHA_TAB9_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha9;
        end

        // Read SHA_TAB10 register.
        RW_HSU_SHA_TAB10_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha10;
        end

        // Read SHA_TAB11 register.
        RW_HSU_SHA_TAB11_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha11;
        end

        // Read SHA_TAB12 register.
        RW_HSU_SHA_TAB12_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha12;
        end

        // Read SHA_TAB13 register.
        RW_HSU_SHA_TAB13_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha13;
        end

        // Read SHA_TAB14 register.
        RW_HSU_SHA_TAB14_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha14;
        end

        // Read SHA_TAB15 register.
        RW_HSU_SHA_TAB15_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= sha15;
        end
`endif // RW_HSU_SHA_EN                   
`ifdef RW_HSU_RSA_EN                   

        // Read DESTINATION_ADDR register.
        RW_HSU_DESTINATION_ADDR_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= dest_addr;
        end
`endif // RW_HSU_RSA_EN                   
        
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : int_reg_dr <= 32'b0;
          // pragma coverage block = on 

        endcase
      end

      // Pulse generation
`ifdef RW_HSU_SHA_EN                   
`endif // RW_HSU_SHA_EN                   
`ifdef RW_HSU_RSA_EN                   
`endif // RW_HSU_RSA_EN                   
      // Hardware update
        if (start_in_valid)
          int_start               <= start_in;
        if (done_clear_in_valid)
          int_done_clear          <= done_clear_in;
        if (mic0_in_valid)
          int_mic0                <= mic0_in;
        if (mic1_in_valid)
          int_mic1                <= mic1_in;
        if (remaining_length_in_valid)
          int_remaining_length    <= remaining_length_in;
        if (remaining_byte2_in_valid)
          int_remaining_byte2     <= remaining_byte2_in;
        if (remaining_byte1_in_valid)
          int_remaining_byte1     <= remaining_byte1_in;
        if (remaining_byte0_in_valid)
          int_remaining_byte0     <= remaining_byte0_in;
`ifdef RW_HSU_SHA_EN                   
`endif // RW_HSU_SHA_EN                   
`ifdef RW_HSU_RSA_EN                   
`endif // RW_HSU_RSA_EN                   

      if(hready_in==1'b1 && hsel==1'b1 && htrans[1]==1'b1)
      begin
        if(hwrite==1'b1)
        begin
          pending_addr  <= haddr[6:2];
          pending_write <= 1'b1;
        end
        else
        begin
          pending_addr  <= haddr[6:2];
          pending_read  <= 1'b1;
          int_reg_rdy   <= 1'b0;
        end
      end
    end
  end




  //////////////////////////////////////////////////////////////////////////////
  // Read data 
  //////////////////////////////////////////////////////////////////////////////
  assign  hrdata     = int_reg_dr;

  //////////////////////////////////////////////////////////////////////////////
  // Write data 
  //////////////////////////////////////////////////////////////////////////////
  assign  int_reg_dw = hwdata;

  assign  hready = int_reg_rdy;
  assign  hresp  = 2'b0;

`ifdef RW_ASSERT_ON

`endif // RW_ASSERT_ON
  
endmodule

////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////

