//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of rw_nx_platform module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
//
//////////////////////////////////////////////////////////////////////////////
`ifndef RW_SHARED_RAM_ADDR_WIDTH
  `define RW_SHARED_RAM_ADDR_WIDTH 18
`endif // RW_SHARED_RAM_ADDR_WIDTH

`default_nettype none
module rw_nx_platform ( 
  //////////////////////////////////////////////////////////////////////////////
  //$port_g Resets
  //////////////////////////////////////////////////////////////////////////////
  input  wire                     plf_rst_n,      // Active low hard reset signal synchronized to the plf_clk.
  input  wire                     mac_core_rst_n, // Active low hard reset signal synchronized to the mac_core_clk.
  input  wire                     mac_wt_rst_n,   // Active low hard reset signal synchronized to the mac_wt_lk.
  input  wire                     mpif_rst_n,     // Active low hard reset signal synchronized to the mpif_clk.  
 
  //////////////////////////////////////////////////////////////////////////////
  //$port_g  Clocks
  //////////////////////////////////////////////////////////////////////////////
  input  wire                     mac_pi_clk,     // Primary MAC Platform Interface Clock
  input  wire                     mac_pi_tx_clk,  // Secondary MAC Platform Interface Clock for TX
  input  wire                     mac_pi_rx_clk,  // Secondary MAC Platform Interface Clock for RX
  input  wire                     mac_core_clk,   // Primary MAC Core Clock
  input  wire                     mac_core_tx_clk,// Secondary MAC Core Clock for TX
  input  wire                     mac_core_rx_clk,// Secondary MAC Core Clock for RX
  input  wire                     mac_crypt_clk,  // Secondary MAC Crypt Clock for CryptoEngine
  input  wire                     mac_lp_clk,     // MAC Low Power clock. 
  input  wire                     mac_wt_clk,     // Clock input for WEP/TKIP blocks.
  input  wire                     mpif_clk,       // MAC PHY Interface Clock
  input  wire                     plf_clk,        // Platform Clock
`ifdef RW_MUMIMO_SEC_USER1_EN
  input  wire                     sec_u1_mac_pi_tx_clk,  // Secondary MAC Platform Interface Clock
                                                         // for TX for Secondary User 1 Tx Path
  input  wire                     sec_u1_mac_core_tx_clk,// Secondary MAC Core Clock for TX
                                                         // for Secondary User 1 Tx Path
  input  wire                     sec_u1_mac_crypt_clk,  // Secondary MAC Crypt Clock
                                                         // for Secondary User 1 CryptoEngine
  input  wire                     sec_u1_mpif_clk,       // MAC PHY Interface Clock
                                                         // for Secondary User 1 Tx Path
`endif // RW_MUMIMO_SEC_USER1_EN
`ifdef RW_MUMIMO_SEC_USER2_EN
  input  wire                     sec_u2_mac_pi_tx_clk,  // Secondary MAC Platform Interface Clock
                                                         // for TX for Secondary User 2 Tx Path
  input  wire                     sec_u2_mac_core_tx_clk,// Secondary MAC Core Clock for TX
                                                         // for Secondary User 2 Tx Path
  input  wire                     sec_u2_mac_crypt_clk,  // Secondary MAC Crypt Clock 
                                                         // for Secondary User 2 CryptoEngine
  input  wire                     sec_u2_mpif_clk,       // MAC PHY Interface Clock
                                                         // for Secondary User 2 Tx Path
`endif // RW_MUMIMO_SEC_USER2_EN
`ifdef RW_MUMIMO_SEC_USER3_EN
  input  wire                     sec_u3_mac_pi_tx_clk,  // Secondary MAC Platform Interface Clock
                                                         // for TX for Secondary User 3 Tx Path
  input  wire                     sec_u3_mac_core_tx_clk,// Secondary MAC Core Clock for TX
                                                         // for Secondary User 3 Tx Path
  input  wire                     sec_u3_mac_crypt_clk,  // Secondary MAC Crypt Clock
                                                         // for Secondary User 3 CryptoEngine
  input  wire                     sec_u3_mpif_clk,       // MAC PHY Interface Clock
                                                         // for Secondary User 3 Tx Path
`endif // RW_MUMIMO_SEC_USER3_EN
  
  //////////////////////////////////////////////////////////////////////////////
  //$port_g  Clock Enables
  //////////////////////////////////////////////////////////////////////////////
  output wire                     platform_wake_up, // Wake Up platform
  output wire                     mac_pi_clken,     // Clock Enable for macPIClk Clocks
  output wire                     mac_pi_tx_clken,  // Clock Enable for macPITxClk Clock
  output wire                     mac_pi_rx_clken,  // Clock Enable for macPIRxClk Clock
  output wire                     mac_core_clken,   // Clock Enable for macCoreClk Clock
  output wire                     mac_core_tx_clken,// Clock Enable for macCoreTxClk Clock
  output wire                     mac_core_rx_clken,// Clock Enable for macCoreRxClk Clock
  output wire                     mac_crypt_clken,  // Clock Enable for macCryptClk Clock
  output wire                     mac_wt_clken,     // Clock Enable for macWTClk Clock
  output wire                     mpif_clken,       // Clock Enable for mpIFClk Clock  
  output wire                     mac_lp_clkswitch, // Switch MAC Lower Clock.
`ifdef RW_MUMIMO_SEC_USER1_EN
  output wire                     sec_u1_mac_pi_tx_clken,  // Clock Enable for macPITxClk Clock
                                                           // for Secondary User 1 Tx Path
  output wire                     sec_u1_mac_core_tx_clken,// Clock Enable for macCoreTxClk Clock
                                                           // for Secondary User 1 Tx Path
  output wire                     sec_u1_mac_crypt_clken,  // Clock Enable for macCryptClk Clock
                                                           // for Secondary User 1 CryptoEngine
  output wire                     sec_u1_mpif_clken,       // Clock Enable for mpIFClkEn Clock
                                                           // for Secondary User 1 Tx Path
`endif // RW_MUMIMO_SEC_USER1_EN
`ifdef RW_MUMIMO_SEC_USER2_EN
  output wire                     sec_u2_mac_pi_tx_clken,  // Clock Enable for macPITxClk Clock
                                                           // for Secondary User 2 Tx Path
  output wire                     sec_u2_mac_core_tx_clken,// Clock Enable for macCoreTxClk Clock
                                                           // for Secondary User 2 Tx Path
  output wire                     sec_u2_mac_crypt_clken,  // Clock Enable for macCryptClk Clock
                                                           // for Secondary User 2 CryptoEngine
  output wire                     sec_u2_mpif_clken,       // Clock Enable for mpIFClkEn Clock
                                                           // for Secondary User 2 Tx Path
`endif // RW_MUMIMO_SEC_USER2_EN
`ifdef RW_MUMIMO_SEC_USER3_EN
  output wire                     sec_u3_mac_pi_tx_clken,  // Clock Enable for macPITxClk Clock
                                                           // for Secondary User 3 Tx Path
  output wire                     sec_u3_mac_core_tx_clken,// Clock Enable for macCoreTxClk Clock
                                                           // for Secondary User 3 Tx Path
  output wire                     sec_u3_mac_crypt_clken,  // Clock Enable for macCryptClk Clock
                                                           // for Secondary User 3 CryptoEngine
  output wire                     sec_u3_mpif_clken,       // Clock Enable for mpIFClkEn Clock
                                                           // for Secondary User 3 Tx Path
`endif // RW_MUMIMO_SEC_USER3_EN

  //////////////////////////////////////////////////////////////////////////////
  //$port_g  interrupt sources
  //////////////////////////////////////////////////////////////////////////////
`ifdef  RW_FPGA_AHB
  input  wire                     fpga_irq,        // Interrupt from FPGA
`endif//RW_FPGA_AHB
  output wire                     host_irq,        // Interrupt to host
  output wire  [95:20]            proc_irq,        // Interrupts to processor
  output wire                     cpu_single_irq,  // Single Interrupt to processor (Active High)
  output wire                     tick_timer_irq,  // Tick Timer Interrupt to processor (Active High)
  output wire                     soft_irq,        // Software Interrupt to processor (Active High)

  // external sources //
  input  wire                     phy_irq_n,       // Interrupt from PHY  
  input  wire                     rc_irq_n,        // Interrupt from Radio Controller   

  //////////////////////////////////////////////////////////////////////////////
  //$port_g  Diag
  //////////////////////////////////////////////////////////////////////////////
  output wire                     reg_diag_sel_en,     // Diag Port Enable
  //output wire  [15:0]             reg_diag_sel,        // Diag Port selection
  output wire   [1:0]             reg_diag_sel6,        // Diag Port6 selection
  output wire   [1:0]             reg_diag_sel5,        // Diag Port5 selection
  output wire   [1:0]             reg_diag_sel4,        // Diag Port4 selection
  output wire   [1:0]             reg_diag_sel3,        // Diag Port3 selection
  output wire   [1:0]             reg_diag_sel2,        // Diag Port2 selection
  output wire   [1:0]             reg_diag_sel1,        // Diag Port1 selection
  output wire   [1:0]             reg_diag_sel0,        // Diag Port0 selection
  output wire   [5:0]             reg_diag_presel6,     // Diag Port6 selection
  output wire   [5:0]             reg_diag_presel5,     // Diag Port5 selection
  output wire   [5:0]             reg_diag_presel4,     // Diag Port4 selection
  output wire   [5:0]             reg_diag_presel3,     // Diag Port3 selection
  output wire   [5:0]             reg_diag_presel2,     // Diag Port2 selection
  output wire   [5:0]             reg_diag_presel1,     // Diag Port1 selection
  output wire   [5:0]             reg_diag_presel0,     // Diag Port0 selection
  output wire                     reg_diag_trigger,     // LA trigger
  output wire                     reg_diag_mpif_mask_en,// MPIF Diag Port Mask Enable
  output wire   [5:0]             reg_diag_mpif_hdr_nbr,// MPIF Diag Port Number of HDR Bytes
  input  wire  [31:0]             diag_value,           // Diagnostic port read back value
  output wire                     reg_bootrom_enable,  // CPU Boot enable
  output wire                     reg_fpgaa_reset_req, // FPGA A reset request
  output wire                     reg_fpgab_reset_req, // FPGA B reset request 
  input  wire                     nmb_io_busy,         // NMB IO Busy indication
    
  //////////////////////////////////////////////////////////////////////////////
  //$port_g  Processor (firmware)  AHB interface 
  //////////////////////////////////////////////////////////////////////////////
  output wire                     proc_hready,         // Processor hready
  input  wire                     proc_hready_in,      // Processor hready_in
  input  wire  [27:0]             proc_haddr,          // Processor haddr
  input  wire  [ 1:0]             proc_htrans,         // Processor htrans
  input  wire                     proc_hwrite,         // Processor hwrite 
  input  wire  [ 1:0]             proc_hsize,          // Processor hsize
  output wire  [31:0]             proc_hrdata,         // Processor hrdata
  input  wire  [31:0]             proc_hwdata,         // Processor hwdata
  output wire  [ 1:0]             proc_hresp,          // Processor hresp

  //////////////////////////////////////////////////////////////////////////////
  //$port_g  AXI to DINI interfaces
  //////////////////////////////////////////////////////////////////////////////

  //$port_g  upstream interface // 
  output wire              [ 3:0] dma0_awid,           // DMA Upstream awid
  output wire              [31:0] dma0_awaddr,         // DMA Upstream awaddr
  output wire              [ 7:0] dma0_awlen,          // DMA Upstream awlen 
  output wire              [ 2:0] dma0_awsize,         // DMA Upstream awsize
  output wire              [ 1:0] dma0_awburst,        // DMA Upstream awburst
  output wire              [11:0] dma0_awuser,         // DMA Upstream awuser
  output wire                     dma0_awvalid,        // DMA Upstream awvalid
  input  wire                     dma0_awready,        // DMA Upstream awready

  output wire              [ 3:0] dma0_wid,            // DMA Upstream wid
  output wire              [63:0] dma0_wdata,          // DMA Upstream wdata 
  output wire              [ 7:0] dma0_wstrb,          // DMA Upstream wstrb
  output wire                     dma0_wlast,          // DMA Upstream wlast
  output wire                     dma0_wvalid,         // DMA Upstream wvalid
  input  wire                     dma0_wready,         // DMA Upstream wready

  input  wire               [3:0] dma0_bid,            // DMA Upstream bid
  input  wire               [1:0] dma0_bresp,          // DMA Upstream bresp
  input  wire                     dma0_bvalid,         // DMA Upstream bvalid
  output wire                     dma0_bready,         // DMA Upstream bready
  
  //$port_g  downstream interface // 
  output wire              [ 3:0] dma1_arid,           // DMA Downstream arid
  output wire              [31:0] dma1_araddr,         // DMA Downstream araddr
  output wire              [ 7:0] dma1_arlen,          // DMA Downstream arlen
  output wire              [ 2:0] dma1_arsize,         // DMA Downstream arsize
  output wire              [ 1:0] dma1_arburst,        // DMA Downstream arburst
  output wire                     dma1_arvalid,        // DMA Downstream arvalid
  input  wire                     dma1_arready,        // DMA Downstream arready

  input  wire              [ 3:0] dma1_rid,            // DMA Downstream rid
  input  wire              [63:0] dma1_rdata,          // DMA Downstream rdata
  input  wire              [ 1:0] dma1_rresp,          // DMA Downstream rresp
  input  wire                     dma1_rlast,          // DMA Downstream rlast
  input  wire                     dma1_rvalid,         // DMA Downstream rvalid
  output wire                     dma1_rready,         // DMA Downstream rready

  //////////////////////////////////////////////////////////////////////////////
  //$port_g  AHB to PHY interface (master gasket)
  //////////////////////////////////////////////////////////////////////////////
  output wire                     phy_hready_in,  // PHY hready_in
  output wire                     phy_hsel,       // PHY hsel
  output wire [27:0]              phy_haddr,      // PHY haddr
  output wire [ 1:0]              phy_htrans,     // PHY htrans
  output wire                     phy_hwrite,     // PHY hwrite
  output wire [ 1:0]              phy_hsize,      // PHY hsize
  input  wire [31:0]              phy_hrdata,     // PHY hrdata
  output wire [31:0]              phy_hwdata,     // PHY hwdata
  input  wire [ 1:0]              phy_hresp,      // PHY hresp
  input  wire                     phy_hready,     // PHY hready

`ifdef RW_EMBEDDED_LA
  //////////////////////////////////////////////////////////////////////////////
  //$port_g  AHB to LA interface (master gasket)
  //////////////////////////////////////////////////////////////////////////////
  output wire                     la_hready_in,    // Embedded Logic Analyzer hready_in
  output wire                     la_hsel,         // Embedded Logic Analyzer hsel
  output wire [20:0]              la_haddr,        // Embedded Logic Analyzer haddr
  output wire [ 1:0]              la_htrans,       // Embedded Logic Analyzer htrans
  output wire                     la_hwrite,       // Embedded Logic Analyzer hwrite
  output wire [ 1:0]              la_hsize,        // Embedded Logic Analyzer hsize
  input  wire [31:0]              la_hrdata,       // Embedded Logic Analyzer hrdata
  output wire [31:0]              la_hwdata,       // Embedded Logic Analyzer hwdata
  input  wire [ 1:0]              la_hresp,        // Embedded Logic Analyzer hresp
  input  wire                     la_hready,       // Embedded Logic Analyzer hready
  input  wire                     la_interrupt,    // Embedded Logic Analyzer Interrut
`endif // RW_EMBEDDED_LA

`ifdef RW_FPGA_AHB
  //////////////////////////////////////////////////////////////////////////////
  //$port_g  AHB to FPGA
  //////////////////////////////////////////////////////////////////////////////
  output wire                     fpga_hready_in, // FPGA hready_in
  output wire                     fpga_hsel,      // FPGA hsel
  output wire [19:0]              fpga_haddr,     // FPGA haddr
  output wire [ 1:0]              fpga_htrans,    // FPGA htrans
  output wire                     fpga_hwrite,    // FPGA hwrite
  input  wire [31:0]              fpga_hrdata,    // FPGA hrdata
  output wire [31:0]              fpga_hwdata,    // FPGA hwdata
  input  wire [ 1:0]              fpga_hresp,     // FPGA hresp
  input  wire                     fpga_hready,    // FPGA hready
`endif // RW_FPGA_AHB

  //////////////////////////////////////////////////////////////////////////////
  //$port_g  AHB to CRM
  //////////////////////////////////////////////////////////////////////////////
  output wire                     crm_hready_in, // CRM hready_in
  output wire                     crm_hsel,      // CRM hsel
  output wire  [9:0]              crm_haddr,     // CRM haddr
  output wire [ 1:0]              crm_htrans,    // CRM htrans
  output wire                     crm_hwrite,    // CRM hwrite
  input  wire [31:0]              crm_hrdata,    // CRM hrdata
  output wire [31:0]              crm_hwdata,    // CRM hwdata
  input  wire [ 1:0]              crm_hresp,     // CRM hresp
  input  wire                     crm_hready,    // CRM hready

`ifdef RW_WLAN_COEX_EN
  //////////////////////////////////////////////////////////////////////////////
  //$port_g  Bluetooth Coexistence Interface
  //////////////////////////////////////////////////////////////////////////////
  input  wire                     coex_bt_tx,         // BT Transmission On-going
  input  wire                     coex_bt_rx,         // BT Reception    On-going
  input  wire                     coex_bt_event,      // BT Event        On-going
  output wire                     coex_bt_tx_abort,   // BT Transmission Abort Request
  output wire                     coex_bt_rx_abort,   // BT Reception    Abort Request
  input  wire [3:0]               coex_bt_pti,        // BT Packet Traffic Information
  input  wire [6:0]               coex_bt_channel,    // BT Channel (0-78)
  input  wire                     coex_bt_bw,         // BT Bandwidth (0:1MHz, 1:2MHz)
`endif // RW_WLAN_COEX_EN

  //////////////////////////////////////////////////////////////////////////////
  //$port_g  RC Coexistence interface
  //////////////////////////////////////////////////////////////////////////////
  output wire                     rc_tx_abort, // Radio Controller Transmission Abort Request
  output wire                     rc_rx_abort, // Radio Controller Reception    Abort Request

`ifdef RW_BFMEE_EN
  //////////////////////////////////////////////////////////////////////////////
  //$port_g BFR HW Accelerator Interface
  //////////////////////////////////////////////////////////////////////////////
  output wire                     bfr_start,          // BFR computation started
  input  wire                     bfr_done,           // Beamforming Report computation is done
  output wire               [1:0] bfr_ch_bw,          // Beamforming report Channel Width
  output wire               [1:0] bfr_grouping,       // Beamforming report Grouping
  output wire                     bfr_codebook,       // Beamforming report Codebook Information
  output wire               [1:0] bfr_feedback_type,  // Beamforming report Feedback Type
  output wire               [2:0] bfr_nr,             // Beamforming report Nr Index
  output wire               [2:0] bfr_nc,             // Beamforming report Nc Index
  output wire                     bfr_he,             // Beamforming report Format
                                                      // (0:VHT or 1:HE)
  output wire               [6:0] bfr_he_rustartidx,  // Beamforming report RU Start index for HE
  output wire               [6:0] bfr_he_ruendidx,    // Beamforming report RU end index for HE
  input  wire               [7:0] bfr_data,           // Beamforming report byte
  input  wire                     bfr_data_valid,     // Beamforming report byte valid          
  output wire                     bfr_data_ready,     // Beamforming report byte request
`endif //RW_BFMEE_EN

  //////////////////////////////////////////////////////////////////////////////
  //$port_g  MAC static parameter
  //////////////////////////////////////////////////////////////////////////////
  input  wire                     mac_debug_ksr,   // Debug Key Storage RAM.
  
  //////////////////////////////////////////////////////////////////////////////
  //$port_g  MAC/PHY interface
  //////////////////////////////////////////////////////////////////////////////
  output wire                     mpif_txreq,             // Tx request 
  output wire [ 7:0]              mpif_txdata,            // Tx data     
  output wire                     mpif_macdatavalid,      // Data valid 
  output wire                     mpif_mimocmdvalid,      // Mimo command   
  input  wire                     mpif_phyrdy,            // Data valid signal    
  input  wire                     mpif_txend_p,           // End of transaction
  output wire                     mpif_rxreq,             // Rx request 
  input  wire [ 7:0]              mpif_rxdata,            // Rx data  
  input  wire                     mpif_cca_pri20,         // CCA on Primary 20MHz channel   
  input  wire                     mpif_cca_sec20,         // CCA on Secondary 20MHz channel 
  input  wire                     mpif_cca_sec40,         // CCA on Secondary 40MHz channel 
  input  wire                     mpif_rxendfortiming_p,  // End of transmission (antenna) 
  input  wire                     mpif_rxerr_p,           // Rx error 
  input  wire                     mpif_rxend_p,           // Rx end
  output wire                     mpif_keeprfon,          // Keep RF on   
  input  wire                     mpif_phyerr_p,          // Phy error  
  input  wire                     mpif_rifsrxdetected,    // RIFS detected 
  output wire                     mpif_rfshutdown,        // RF shutdown

`ifdef  RW_MUMIMO_SEC_USER1_EN
  output wire [ 7:0]              mpif_txdata_u1,         // Tx data for secondary user 1
  output wire                     mpif_macdatavalid_u1,   // Data valid  for secondary user 1
  input  wire                     mpif_phyrdy_u1,         // Data valid signal for secondary user 1
`endif //  RW_MUMIMO_SEC_USER1_EN
   
`ifdef  RW_MUMIMO_SEC_USER2_EN
  output wire [ 7:0]              mpif_txdata_u2,         // Tx data for secondary user 2
  output wire                     mpif_macdatavalid_u2,   // Data valid  for secondary user 2
  input  wire                     mpif_phyrdy_u2,         // Data valid signal for secondary user 2
`endif //  RW_MUMIMO_SEC_USER2_EN
   
`ifdef  RW_MUMIMO_SEC_USER3_EN
  output wire [ 7:0]              mpif_txdata_u3,         // Tx data for secondary user 3
  output wire                     mpif_macdatavalid_u3,   // Data valid  for secondary user 3
  input  wire                     mpif_phyrdy_u3,         // Data valid signal for secondary user 3
`endif //  RW_MUMIMO_SEC_USER3_EN
   
  //////////////////////////////////////////////////////////////////////////////
  //$port_g  MAC Memories
  //////////////////////////////////////////////////////////////////////////////

  ///////////////////////////////////////////////
  //$port_g TxFIFO 64*38 Two Ports SRAM 
  ///////////////////////////////////////////////

  //$port_g     read port synchronous to macCoreTxClk   
  output wire                        tx_fifo_rd_en,          // Transmit FIFO Read Enable. 
  output wire [`TXFIFOADDRWIDTH-1:0] tx_fifo_rd_addr,        // Transmit FIFO Read Address bus.
  input  wire [37:0]                 tx_fifo_rd_data,        // Transmit FIFO Read Data bus.

  //$port_g     write port synchronous to macPITxClk
  output wire                        tx_fifo_wr_en,          // Transmit FIFO Write Enable.
  output wire [`TXFIFOADDRWIDTH-1:0] tx_fifo_wr_addr,        // Transmit FIFO Write Address bus.
  output wire [37:0]                 tx_fifo_wr_data,        // Transmit FIFO Write Data bus.  

`ifdef  RW_MUMIMO_SEC_USER1_EN
  ///////////////////////////////////////////////
  //$port_g Secondary User 1 TxFIFO 64*38 Two Ports SRAM 
  ///////////////////////////////////////////////

  //$port_g     read port synchronous to macCoreTxClk   
  output wire                        sec_u1_tx_fifo_rd_en,   // Secondary User 1 Transmit FIFO Read Enable. 
  output wire [`TXFIFOADDRWIDTH-1:0] sec_u1_tx_fifo_rd_addr, // Secondary User 1 Transmit FIFO Read Address bus.
  input  wire [37:0]                 sec_u1_tx_fifo_rd_data, // Secondary User 1 Transmit FIFO Read Data bus.

  //$port_g     write port synchronous to macPITxClk
  output wire                        sec_u1_tx_fifo_wr_en,   // Secondary User 1 Transmit FIFO Write Enable.
  output wire [`TXFIFOADDRWIDTH-1:0] sec_u1_tx_fifo_wr_addr, // Secondary User 1 Transmit FIFO Write Address bus.
  output wire [37:0]                 sec_u1_tx_fifo_wr_data, // Secondary User 1 Transmit FIFO Write Data bus.  
`endif // RW_MUMIMO_SEC_USER1_EN

`ifdef  RW_MUMIMO_SEC_USER2_EN
  ///////////////////////////////////////////////
  //$port_g Secondary User 2 TxFIFO 64*38 Two Ports SRAM 
  ///////////////////////////////////////////////

  //$port_g     read port synchronous to macCoreTxClk   
  output wire                        sec_u2_tx_fifo_rd_en,   // Secondary User 2 Transmit FIFO Read Enable. 
  output wire [`TXFIFOADDRWIDTH-1:0] sec_u2_tx_fifo_rd_addr, // Secondary User 2 Transmit FIFO Read Address bus.
  input  wire [37:0]                 sec_u2_tx_fifo_rd_data, // Secondary User 2 Transmit FIFO Read Data bus.

  //$port_g     write port synchronous to macPITxClk
  output wire                        sec_u2_tx_fifo_wr_en,   // Secondary User 2 Transmit FIFO Write Enable.
  output wire [`TXFIFOADDRWIDTH-1:0] sec_u2_tx_fifo_wr_addr, // Secondary User 2 Transmit FIFO Write Address bus.
  output wire [37:0]                 sec_u2_tx_fifo_wr_data, // Secondary User 2 Transmit FIFO Write Data bus.  
`endif // RW_MUMIMO_SEC_USER2_EN


`ifdef  RW_MUMIMO_SEC_USER3_EN
  ///////////////////////////////////////////////
  //$port_g Secondary User 3 TxFIFO 64*38 Two Ports SRAM 
  ///////////////////////////////////////////////

  //$port_g     read port synchronous to macCoreTxClk   
  output wire                        sec_u3_tx_fifo_rd_en,   // Secondary User 3 Transmit FIFO Read Enable. 
  output wire [`TXFIFOADDRWIDTH-1:0] sec_u3_tx_fifo_rd_addr, // Secondary User 3 Transmit FIFO Read Address bus.
  input  wire [37:0]                 sec_u3_tx_fifo_rd_data, // Secondary User 3 Transmit FIFO Read Data bus.

  //$port_g     write port synchronous to macPITxClk
  output wire                        sec_u3_tx_fifo_wr_en,   // Secondary User 3 Transmit FIFO Write Enable.
  output wire [`TXFIFOADDRWIDTH-1:0] sec_u3_tx_fifo_wr_addr, // Secondary User 3 Transmit FIFO Write Address bus.
  output wire [37:0]                 sec_u3_tx_fifo_wr_data, // Secondary User 3 Transmit FIFO Write Data bus.  
`endif // RW_MUMIMO_SEC_USER3_EN

   ///////////////////////////////////////////////
  //$port_g RxFIFO 64*36 Two Ports SRAM 
  ///////////////////////////////////////////////

  //$port_g     read port synchronous to macPIRxClk
  output wire                        rx_fifo_rd_en,          // Receive FIFO Read Enable. 
  output wire [`RXFIFOADDRWIDTH-1:0] rx_fifo_rd_addr,        // Receive FIFO Read Address bus.
  input  wire [35:0]                 rx_fifo_rd_data,        // Receive FIFO Read Data bus.

  //$port_g     write port synchronous to macCoreRxClk
  output wire                        rx_fifo_wr_en,          // Receive FIFO Write Enable.
  output wire [`RXFIFOADDRWIDTH-1:0] rx_fifo_wr_addr,        // Receive FIFO Write Address bus.
  output wire [35:0]                 rx_fifo_wr_data,        // Receive FIFO Write Data bus.

  ///////////////////////////////////////////////
  //$port_g Key Storage RAM 64*186 Single Port SRAM 
  ///////////////////////////////////////////////

  //$port_g     port synchronous to macWTClk          
  output wire                     keystorage_en,      // Enable Key Storage RAM
                                                      // This signal is asserted for both read and write operations to the Key Storage RAM.
  output wire                     keystorage_wr_en,   // Write Enable Key Storage RAM
                                                      // This signal is asserted for write operations to the Key Storage RAM.
  output wire [`RW_KEY_INDEX_WIDTH-1:0] keystorage_addr,    // Key Storage RAM write data bus
  input  wire  [`RW_KEY_DATA_WIDTH-1:0] keystorage_rd_data, // Key Storage RAM read data bus.
  output wire  [`RW_KEY_DATA_WIDTH-1:0] keystorage_wr_data, // Key Storage RAM address bus.  

  ///////////////////////////////////////////////
  //$port_g RC4 PRNG 128*16 Two Ports SRAM
  ///////////////////////////////////////////////
  //$port_g     port synchronous to macWTClk
  input  wire  [15:0]                 sbox_mem_rdata,     // SBOX data bus from internal RAM
  output wire   [6:0]                 sbox_mem_waddr,     // SBOX address bus to internal RAM, port write
  output wire   [6:0]                 sbox_mem_raddr,     // SBOX address bus to internal RAM, port read
  output wire  [15:0]                 sbox_mem_wdata,     // SBOX data bus to internal RAM
  output wire   [1:0]                 sbox_mem_wen,       // SBOX write enable signal for internal RAM
  output wire                         sbox_mem_ren,       // SBOX read enable signal for internal RAM


  ///////////////////////////////////////////////
  //$port_g MAC-PHY IF TX FIFO RAM 2**`MPIFTXADDRWIDTH*8 Two Ports SRAM
  ///////////////////////////////////////////////

  //$port_g     read port synchronous to mpIFClk
  output wire                         mpif_tx_fifo_rd_en,     // MAC-PHY Interface Transmit FIFO Read Enable. 
                                                              // This signal is asserted for read operations to the MAC-PHY interface Transmit FIFO.
  output wire [ `MPIFTXADDRWIDTH-1:0] mpif_tx_fifo_rd_addr,   // MAC-PHY Interface Transmit FIFO Read Address bus.
  input  wire [ 7:0]                  mpif_tx_fifo_rd_data,   // MAC-PHY Interface Transmit FIFO Read Data bus.
                                                          
  //$port_g     write port synchronous to macCoreClk      
  output wire                         mpif_tx_fifo_wr_en,     // MAC-PHY InterFace Transmit FIFO Write Enable.
                                                              // This signal is asserted for write operations to the MAC-PHY interface Transmit FIFO.
  output wire [ `MPIFTXADDRWIDTH-1:0] mpif_tx_fifo_wr_addr,   // MAC-PHY Interface Transmit FIFO Write Address bus.
  output wire [ 7:0]                  mpif_tx_fifo_wr_data,   // MAC-PHY Interface Transmit FIFO Write Data bus.

`ifdef  RW_MUMIMO_SEC_USER1_EN
  ///////////////////////////////////////////////
  //$port_g Secondary User 1 MAC-PHY IF TX FIFO RAM 2**`MPIFTXADDRWIDTH*8 Two Ports SRAM
  ///////////////////////////////////////////////
  //$port_g     read port synchronous to mpIFClk
  output wire                         sec_u1_mpif_tx_fifo_rd_en,     // Secondary User 1 MAC-PHY Interface Transmit FIFO Read Enable. 
                                                                     // This signal is asserted for read operations to the MAC-PHY interface Transmit FIFO.
  output wire [ `MPIFTXADDRWIDTH-1:0] sec_u1_mpif_tx_fifo_rd_addr,   // Secondary User 1 MAC-PHY Interface Transmit FIFO Read Address bus.
  input  wire [ 7:0]                  sec_u1_mpif_tx_fifo_rd_data,   // Secondary User 1 MAC-PHY Interface Transmit FIFO Read Data bus.
                                                          
  //$port_g     write port synchronous to macCoreClk      
  output wire                         sec_u1_mpif_tx_fifo_wr_en,     // Secondary User 1 MAC-PHY InterFace Transmit FIFO Write Enable.
                                                                     // This signal is asserted for write operations to the MAC-PHY interface Transmit FIFO.
  output wire [ `MPIFTXADDRWIDTH-1:0] sec_u1_mpif_tx_fifo_wr_addr,   // Secondary User 1 MAC-PHY Interface Transmit FIFO Write Address bus.
  output wire [ 7:0]                  sec_u1_mpif_tx_fifo_wr_data,   // Secondary User 1 MAC-PHY Interface Transmit FIFO Write Data bus.
`endif // RW_MUMIMO_SEC_USER1_EN

`ifdef  RW_MUMIMO_SEC_USER2_EN
  ///////////////////////////////////////////////
  //$port_g Secondary User 2 MAC-PHY IF TX FIFO RAM 2**`MPIFTXADDRWIDTH*8 Two Ports SRAM
  ///////////////////////////////////////////////
  //$port_g     read port synchronous to mpIFClk
  output wire                         sec_u2_mpif_tx_fifo_rd_en,     // Secondary User 2 MAC-PHY Interface Transmit FIFO Read Enable. 
                                                                     // This signal is asserted for read operations to the MAC-PHY interface Transmit FIFO.
  output wire [ `MPIFTXADDRWIDTH-1:0] sec_u2_mpif_tx_fifo_rd_addr,   // Secondary User 2 MAC-PHY Interface Transmit FIFO Read Address bus.
  input  wire [ 7:0]                  sec_u2_mpif_tx_fifo_rd_data,   // Secondary User 2 MAC-PHY Interface Transmit FIFO Read Data bus.
                                                          
  //$port_g     write port synchronous to macCoreClk      
  output wire                         sec_u2_mpif_tx_fifo_wr_en,     // Secondary User 2 MAC-PHY InterFace Transmit FIFO Write Enable.
                                                                     // This signal is asserted for write operations to the MAC-PHY interface Transmit FIFO.
  output wire [ `MPIFTXADDRWIDTH-1:0] sec_u2_mpif_tx_fifo_wr_addr,   // Secondary User 2 MAC-PHY Interface Transmit FIFO Write Address bus.
  output wire [ 7:0]                  sec_u2_mpif_tx_fifo_wr_data,   // Secondary User 2 MAC-PHY Interface Transmit FIFO Write Data bus.
`endif // RW_MUMIMO_SEC_USER2_EN

`ifdef  RW_MUMIMO_SEC_USER3_EN
  ///////////////////////////////////////////////
  //$port_g Secondary User 3 MAC-PHY IF TX FIFO RAM 2**`MPIFTXADDRWIDTH*8 Two Ports SRAM
  ///////////////////////////////////////////////
  //$port_g     read port synchronous to mpIFClk
  output wire                         sec_u3_mpif_tx_fifo_rd_en,     // Secondary User 3 MAC-PHY Interface Transmit FIFO Read Enable. 
                                                                     // This signal is asserted for read operations to the MAC-PHY interface Transmit FIFO.
  output wire [ `MPIFTXADDRWIDTH-1:0] sec_u3_mpif_tx_fifo_rd_addr,   // Secondary User 3 MAC-PHY Interface Transmit FIFO Read Address bus.
  input  wire [ 7:0]                  sec_u3_mpif_tx_fifo_rd_data,   // Secondary User 3 MAC-PHY Interface Transmit FIFO Read Data bus.
                                                          
  //$port_g     write port synchronous to macCoreClk      
  output wire                         sec_u3_mpif_tx_fifo_wr_en,     // Secondary User 3 MAC-PHY InterFace Transmit FIFO Write Enable.
                                                                     // This signal is asserted for write operations to the MAC-PHY interface Transmit FIFO.
  output wire [ `MPIFTXADDRWIDTH-1:0] sec_u3_mpif_tx_fifo_wr_addr,   // Secondary User 3 MAC-PHY Interface Transmit FIFO Write Address bus.
  output wire [ 7:0]                  sec_u3_mpif_tx_fifo_wr_data,   // Secondary User 3 MAC-PHY Interface Transmit FIFO Write Data bus.
`endif // RW_MUMIMO_SEC_USER3_EN

  ///////////////////////////////////////////////
  //$port_g MAC-PHY IF RX FIFO RAM 64*8 Two Ports SRAM
  ///////////////////////////////////////////////

  //$port_g     read port synchronous to macCoreClk
  output wire                         mpif_rx_fifo_rd_en,     // MAC-PHY Interface Receive FIFO Read Enable. 
                                                          // This signal is asserted for read operations to the MAC-PHY interface Receive FIFO.
  output wire [ `MPIFRXADDRWIDTH-1:0] mpif_rx_fifo_rd_addr,   // MAC-PHY Interface Receive FIFO Read Address bus.
  input  wire [ 7:0]                  mpif_rx_fifo_rd_data,   // MAC-PHY Interface Receive FIFO Read Data bus.

  //$port_g     write port synchronous to mpIFClk
  output wire                         mpif_rx_fifo_wr_en,     // MAC-PHY InterFace Receive FIFO Write Enable.
                                                          // This signal is asserted for write operations to the MAC-PHY interface Receive FIFO.
  output wire [ `MPIFRXADDRWIDTH-1:0] mpif_rx_fifo_wr_addr,   // MAC-PHY Interface Receive FIFO Write Address bus.
  output wire [ 7:0]                  mpif_rx_fifo_wr_data,   // MAC-PHY Interface Receive FIFO Write Data bus.
 
  ///////////////////////////////////////////////
  //$port_g MIB Table RAM 256*32 Single Port SRAM
  ///////////////////////////////////////////////

  //$port_g     port synchronous to macCoreClk
  output wire                     mib_table_en,          // MIB Table Enable. 
                                                         // This signal is asserted for both read and write operations to the MIB Table.
  output wire                     mib_table_wr_en,       // MIB Table Write Enable.
                                                         // This signal is asserted for write operations to the MIB Table.
  output wire [ 7:0]              mib_table_addr,        // MIB Table Address bus.
  input  wire [31:0]              mib_table_rd_data,     // MIB Table Read Data bus.
  output wire [31:0]              mib_table_wr_data,     // MIB Table Write Data bus.

  //////////////////////////////////////////////////////////////////////////////
  //$port_g  Platform memory 32768/64 single sram port (one write enable per byte lane)
  //////////////////////////////////////////////////////////////////////////////

  output wire                                 shared_ram_en,         // Shared RAM Enable
  output wire [`RW_SHARED_RAM_ADDR_WIDTH-4:0] shared_ram_addr,       // Shared RAM Address
  output wire [ 7:0]                          shared_ram_wr_en,      // Shared RAM Write Byte Enable
  output wire [63:0]                          shared_ram_wr_data,    // Shared RAM Write Data
  input  wire [63:0]                          shared_ram_rd_data,    // Shared RAM Read Data

  //////////////////////////////////////////////////////////////////////////////
  // HSU RSA SRAM interface
  //////////////////////////////////////////////////////////////////////////////
`ifdef  RW_HSU_RSA_EN
  output wire                                 rsa_sram_en,           // RSA SRAM Enable
  output wire      [`RW_RSA_RAM_ADDWIDTH-1:0] rsa_sram_addr,         // RSA SRAM Address
  output wire                           [3:0] rsa_sram_wr_en,        // RSA SRAM Write Enable
  output wire     [`RW_RSA_RAM_DATAWIDTH-1:0] rsa_sram_din,          // RSA SRAM Write Data
  input  wire     [`RW_RSA_RAM_DATAWIDTH-1:0] rsa_sram_dout,         // RSA SRAM Read  Data
`endif//RW_HSU_RSA_EN

  //////////////////////////////////////////////////////////////////////////////
  //$port_g  Diagnostic ports
  //////////////////////////////////////////////////////////////////////////////
  output wire [31:0]              diag_platform0,    // Reference Platform Diagnostic port 0
  output wire [31:0]              diag_platform1,    // Reference Platform Diagnostic port 1
  output wire [31:0]              diag_platform2,    // Reference Platform Diagnostic port 2
  output wire [15:0]              mac_diag0,         // MAC HW Diagnostic port 0
  output wire [15:0]              mac_diag1,         // MAC HW Diagnostic port 1
  output wire [15:0]              mac_diag2,         // MAC HW Diagnostic port 2
  output wire [15:0]              mac_diag3,         // MAC HW Diagnostic port 3
  output wire [15:0]              mac_diag4,         // MAC HW Diagnostic port 4
  output wire [15:0]              mac_diag5,         // MAC HW Diagnostic port 5
  output wire [15:0]              mac_diag6,         // MAC HW Diagnostic port 6
  output wire [15:0]              mac_diag7,         // MAC HW Diagnostic port 7
  output wire [15:0]              mac_diag8,         // MAC HW Diagnostic port 8
  output wire [15:0]              mac_diag9,         // MAC HW Diagnostic port 9
  output wire [15:0]              mac_diag10,        // MAC HW Diagnostic port 10
  output wire [15:0]              mac_diag11,        // MAC HW Diagnostic port 11
  output wire [15:0]              mac_diag12,        // MAC HW Diagnostic port 12
  output wire [15:0]              mac_diag13,        // MAC HW Diagnostic port 13
  output wire [15:0]              mac_diag14,        // MAC HW Diagnostic port 14
  output wire [15:0]              mac_diag15,        // MAC HW Diagnostic port 15
  output wire [15:0]              mac_diag16,        // MAC HW Diagnostic port 16
  output wire [15:0]              mac_diag17,        // MAC HW Diagnostic port 17
  output wire [15:0]              mac_diag18,        // MAC HW Diagnostic port 18
  output wire [15:0]              mac_diag19,        // MAC HW Diagnostic port 19
  output wire [15:0]              mac_diag20,        // MAC HW Diagnostic port 20
  output wire [15:0]              mac_diag21,        // MAC HW Diagnostic port 21
  output wire [15:0]              mac_diag22,        // MAC HW Diagnostic port 22
  output wire [15:0]              mac_diag23,        // MAC HW Diagnostic port 23
  output wire [15:0]              mac_diag24,        // MAC HW Diagnostic port 24
  output wire [15:0]              mac_diag25,        // MAC HW Diagnostic port 25
  output wire [15:0]              mac_diag26,        // MAC HW Diagnostic port 26
  output wire [15:0]              mac_diag27,        // MAC HW Diagnostic port 27
  output wire [15:0]              mac_diag28,        // MAC HW Diagnostic port 28
  output wire [15:0]              mac_diag29,        // MAC HW Diagnostic port 29
  output wire [15:0]              mac_diag30,        // MAC HW Diagnostic port 30
  output wire [15:0]              mac_diag31,        // MAC HW Diagnostic port 31
  output wire [15:0]              mac_diag32,        // MAC HW Diagnostic port 32
  output wire [15:0]              mac_diag33,        // MAC HW Diagnostic port 33
  output wire [15:0]              mac_diag34,        // MAC HW Diagnostic port 34
  output wire [15:0]              mac_diag35,        // MAC HW Diagnostic port 35
  output wire [15:0]              mac_diag36,        // MAC HW Diagnostic port 36
  output wire [15:0]              mac_diag37,        // MAC HW Diagnostic port 37
  output wire [15:0]              mac_diag38,        // MAC HW Diagnostic port 38
  output wire [15:0]              mac_diag39,        // MAC HW Diagnostic port 39
  output wire [15:0]              mac_diag40,        // MAC HW Diagnostic port 40
  output wire [15:0]              mac_diag41,        // MAC HW Diagnostic port 41
  output wire [15:0]              mac_diag42,        // MAC HW Diagnostic port 42
  output wire [15:0]              mac_diag43,        // MAC HW Diagnostic port 43
  output wire [15:0]              mac_diag44,        // MAC HW Diagnostic port 44
  output wire [15:0]              mac_diag45,        // MAC HW Diagnostic port 45
  output wire [15:0]              mac_diag46,        // MAC HW Diagnostic port 46
  output wire [15:0]              mac_diag47,        // MAC HW Diagnostic port 47
  output wire [15:0]              mac_diag48,        // MAC HW Diagnostic port 48
  output wire [15:0]              mac_diag49,        // MAC HW Diagnostic port 49
  output wire [15:0]              mac_diag50,        // MAC HW Diagnostic port 50
  output wire [15:0]              mac_diag51,        // MAC HW Diagnostic port 51
  output wire [15:0]              mac_diag52,        // MAC HW Diagnostic port 52
  output wire [15:0]              mac_diag53,        // MAC HW Diagnostic port 53
  output wire [15:0]              mac_diag54,        // MAC HW Diagnostic port 54
  output wire [15:0]              mac_diag55,        // MAC HW Diagnostic port 55
  output wire [15:0]              mac_diag56,        // MAC HW Diagnostic port 56
  output wire [15:0]              mac_diag57,        // MAC HW Diagnostic port 57
  output wire [15:0]              mac_diag58,        // MAC HW Diagnostic port 58
  output wire [15:0]              mac_diag59,        // MAC HW Diagnostic port 59
  output wire [15:0]              mac_diag60,        // MAC HW Diagnostic port 60
  output wire [15:0]              mac_diag61,        // MAC HW Diagnostic port 61
  output wire [63:0]              diag_mac_sw,       // MAC SW Diagnostic Port
  output wire [31:0]              diag_coex,         // Coexistence Diagnostic Port
  output wire [31:0]              diag_dma_top,      // HOST DMA Diagnostic Port
  output wire [15:0]              diag_dma_downstream_axi0,// HOST DMA Diagnostic Port
  output wire [15:0]              diag_dma_downstream_axi1,// HOST DMA Diagnostic Port
  output wire [15:0]              diag_dma_downstream_axi2,// HOST DMA Diagnostic Port
  output wire [31:0]              diag_hsu,          // HSU Diagnostic Port
  output wire                     mac_internal_error,// MAC internal Error
  
  //////////////////////////////////////////////////////////////////////////////
  //$port_g  GPIO interface
  //////////////////////////////////////////////////////////////////////////////
  output wire [31:0]              gpio_out,  // GPIO output
  input  wire [31:0]              gpio_in,   // GPIO input
  output wire [31:0]              gpio_oen   // GPIO output enable
);

  /*****************************************************************************
  * declarations
  *****************************************************************************/
  /* clock gating */
  wire           reg_sec_mac_pi_tx_clk_gating_en;   // secondary path gating enable
  wire           reg_sec_mac_crypt_clk_gating_en;   // secondary path gating enable
  wire           reg_sec_mac_core_tx_clk_gating_en; // secondary path gating enable
  wire           reg_sec_mpif_clk_gating_en;        // secondary path gating enable
  wire           reg_mac_pi_clk_gating_en;          // mac_pi_clk Interface force enable 
  wire           reg_mac_pi_tx_clk_gating_en;       // mac_pi_clk Interface force enable 
  wire           reg_mac_pi_rx_clk_gating_en;       // mac_pi_clk Interface force enable 
  wire           reg_mac_core_clk_gating_en;        // mac_core_clk Interface force enable 
  wire           reg_mac_crypt_clk_gating_en;       // mac_core_clk Interface force enable 
  wire           reg_mac_core_tx_clk_gating_en;     // mac_core_clk Interface force enable 
  wire           reg_mac_core_rx_clk_gating_en;     // mac_core_clk Interface force enable 
  wire           reg_mac_wt_clk_gating_en;          // mac_wt_clk Interface force enable 
  wire           reg_mpif_clk_gating_en;            // mpif_clk Interface force enable 
                                                    
  wire           mac_pri_clken_i;                   // Clock Enable for macPriClk Clocks
  wire           mac_pi_tx_clken_i;                 // Clock Enable for macPITxClk Clock
  wire           mac_pi_rx_clken_i;                 // Clock Enable for macPIRxClk Clock
  wire           mac_core_tx_clken_i;               // Clock Enable for macCoreTxClk Clock
  wire           mac_core_rx_clken_i;               // Clock Enable for macCoreRxClk Clock
  wire           mac_crypt_clken_i;                 // Clock Enable for macCryptClk Clock
  wire           mac_wt_clken_i;                    // Clock Enable for macWTClk Clock
  wire           mpif_clken_i;                      // Clock Enable for mpIFClk Clock  
                                                    
`ifdef RW_MUMIMO_SEC_USER1_EN                       
  wire           sec_u1_mac_pi_tx_clken_i;          // Clock Enable for secU1MacPITxClk Clock
  wire           sec_u1_mac_core_tx_clken_i;        // Clock Enable for secU1MacCoreTxClk Clock
  wire           sec_u1_mac_crypt_clken_i;          // Clock Enable for secU1macCryptClk Clock
  wire           sec_u1_mpif_clken_i;               // Clock Enable for secU1MpIFClkEn Clock
`endif // RW_MUMIMO_SEC_USER1_EN                    
`ifdef RW_MUMIMO_SEC_USER2_EN                       
  wire           sec_u2_mac_pi_tx_clken_i;          // Clock Enable for secU2MacPITxClk Clock
  wire           sec_u2_mac_core_tx_clken_i;        // Clock Enable for secU2MacCoreTxClk Clock
  wire           sec_u2_mac_crypt_clken_i;          // Clock Enable for SecU2macCryptClk Clock
  wire           sec_u2_mpif_clken_i;               // Clock Enable for secU2MpIFClkEn Clock
`endif // RW_MUMIMO_SEC_USER2_EN                    
`ifdef RW_MUMIMO_SEC_USER3_EN                       
  wire           sec_u3_mac_pi_tx_clken_i;          // Clock Enable for secU3MacPITxClk Clock
  wire           sec_u3_mac_core_tx_clken_i;        // Clock Enable for secU3MacCoreTxClk Clock
  wire           sec_u3_mac_crypt_clken_i;          // Clock Enable for SecU3macCryptClk Clock
  wire           sec_u3_mpif_clken_i;               // Clock Enable for secU3MpIFClkEn Clock
`endif // RW_MUMIMO_SEC_USER3_EN

  /* interrupts */
  wire [ 3:0]    ipc_irq;
  wire [15:0]    dma_lli_irq;
  wire [ 4:0]    dma_channel_irq;
  wire           dma_error_irq;
  wire           mac_int_gen_n;
  wire           mac_int_prot_trigger_n;
  wire           mac_int_tx_trigger_n;
  wire           mac_int_rx_trigger_n;
  wire           mac_int_tx_rx_misc_n;
  wire           mac_int_tx_rx_timer_n;
  wire           hsu_irq;
  wire [63:0]    irq_source;

  /* dma0 bus interface */
  wire           dma0_ready;
  wire [31:0]    dma0_addr;
  wire           dma0_trans;
  wire [63:0]    dma0_rdata;

  /* dma1 bus interface */
  wire           dma1_ready;
  wire [31:0]    dma1_addr;
  wire           dma1_trans;
  wire [ 7:0]    dma1_we;
  wire [63:0]    dma1_wdata;

  /* dma2 bus interface */
  wire           dma2_ready;
  wire [31:0]    dma2_addr;
  wire           dma2_trans;
  wire [63:0]    dma2_rdata;

  /* dma3 bus interface */
  wire           dma3_ready;
  wire [31:0]    dma3_addr;
  wire           dma3_trans;
  wire [ 7:0]    dma3_we;
  wire [63:0]    dma3_wdata;

  /* dma2 bus interface */
  wire           dma_hready;
  wire [31:0]    dma_haddr;
  wire  [1:0]    dma_htrans;
  wire [31:0]    dma_hrdata;
  wire           dma_hwrite;
  wire  [1:0]    dma_hsize;
  wire [31:0]    dma_hwdata;
  wire  [1:0]    dma_hresp;

  /* dma lli interface */
  wire           lli_hready;
  wire [31:0]    lli_haddr;
  wire [1:0]     lli_htrans;
  wire [31:0]    lli_hrdata;

  /* mac bus interface */
  wire [31:0]    mac_hmaddr;
  wire [ 1:0]    mac_hmtrans;
  wire           mac_hmwrite;
  wire [ 2:0]    mac_hmsize;
  wire [31:0]    mac_hmrdata;
  wire [31:0]    mac_hmwdata;
  wire [ 1:0]    mac_hmresp;
  wire           mac_hmready;
  
  /* processor bus interface */
  wire           proc_hsel_default;
  wire           proc_hsel_periph;
  wire [31:0]    proc_hrdata_periph;
  wire [ 1:0]    proc_hresp_periph;
  wire           proc_hready_periph;
  wire           proc_hsel_ram;
  wire [31:0]    proc_hrdata_ram;
  wire [ 1:0]    proc_hresp_ram;
  wire           proc_hready_ram;
  wire           proc_hsel_dma;
  wire [31:0]    proc_hrdata_dma;
  wire [ 1:0]    proc_hresp_dma;
  wire           proc_hready_dma;
  wire           proc_hsel_mac;
  wire [31:0]    proc_hrdata_mac;
  wire [ 1:0]    proc_hresp_mac;
  wire           proc_hready_mac;
  wire           proc_hsel_phy;
  wire [31:0]    proc_hrdata_phy;
  wire [ 1:0]    proc_hresp_phy;
  wire           proc_hready_phy;
  wire           proc_hsel_laphy;
  reg            proc_hsel_ram_1t;
  reg            proc_hsel_dma_1t;     
  reg            proc_hsel_periph_1t;     
  reg            proc_hsel_mac_1t;     
  reg            proc_hsel_phy_1t;     
  reg            proc_hsel_default_1t;
  wire           cpu_single_irq_n;  // Single Interrupt to processor (Active Low)
 
  /* peripheral bus interface */
  wire           periph_hsel_default;
  wire           periph_hready;
  wire [31:0]    periph_haddr;
  wire [ 1:0]    periph_htrans;
  wire           periph_hwrite;
  wire [ 2:0]    periph_hsize;
  wire [31:0]    periph_hrdata;
  wire [31:0]    periph_hwdata;
  wire [ 1:0]    periph_hresp;
  wire           periph_hsel_ipc;
  wire [31:0]    periph_hrdata_ipc;
  wire [ 1:0]    periph_hresp_ipc;
  wire           periph_hready_ipc;
  wire           periph_hsel_systctrl;
  wire [31:0]    periph_hrdata_systctrl;
  wire [ 1:0]    periph_hresp_systctrl;
  wire           periph_hready_systctrl;
  wire           periph_hsel_intctrl;
  wire [31:0]    periph_hrdata_intctrl;
  wire [ 1:0]    periph_hresp_intctrl;
  wire           periph_hready_intctrl;
  wire           periph_hsel_pta;
  wire [31:0]    periph_hrdata_pta;
  wire [ 1:0]    periph_hresp_pta;
  wire           periph_hready_pta;
  wire           periph_hsel_hsu;
  wire [31:0]    periph_hrdata_hsu;
  wire [ 1:0]    periph_hresp_hsu;
  wire           periph_hready_hsu;
  wire           periph_hsel_crm;
  wire [31:0]    periph_hrdata_crm;
  wire [ 1:0]    periph_hresp_crm;
  wire           periph_hready_crm;
  wire           periph_hsel_la;
  wire [31:0]    periph_hrdata_la;
  wire [ 1:0]    periph_hresp_la;
  wire           periph_hready_la;
  wire           periph_hsel_fpga;
  wire [31:0]    periph_hrdata_fpga;
  wire [ 1:0]    periph_hresp_fpga;
  wire           periph_hready_fpga;
  reg            periph_hsel_ipc_1t;     
  reg            periph_hsel_systctrl_1t;
  reg            periph_hsel_intctrl_1t;
  reg            periph_hsel_pta_1t;
  reg            periph_hsel_hsu_1t;
  reg            periph_hsel_crm_1t;
  reg            periph_hsel_la_1t;      
  reg            periph_hsel_fpga_1t;
  reg            periph_hsel_default_1t;

  /* DMA2 bus interface */
  wire           dma_hsel_default;
  wire           dma_hsel_phy;
  wire [31:0]    dma_hrdata_phy;
  wire [ 1:0]    dma_hresp_phy;
  wire           dma_hready_phy;
`ifdef RW_EMBEDDED_LA
  wire           dma_hsel_laphy;
  wire           dma_hsel_la;
  wire [31:0]    dma_hrdata_la;
  wire [ 1:0]    dma_hresp_la;
  wire           dma_hready_la;
  reg            dma_hsel_la_1t;      
`endif // RW_EMBEDDED_LA
  reg            dma_hsel_phy_1t;     
  reg            dma_hsel_default_1t;

`ifdef RW_WLAN_COEX_EN
  wire           coex_wlan_tx;
  wire           coex_wlan_rx;
  wire           coex_wlan_tx_abort;
  wire           coex_wlan_rx_abort;
  wire     [3:0] coex_wlan_pti;
  wire           coex_wlan_pti_tog;
  wire     [6:0] coex_wlan_chan_freq;
  wire           coex_wlan_chan_bw;
  wire           coex_wlan_chan_offset;
`endif // RW_WLAN_COEX_EN

  /* HSU AHB bus interface */
  wire    [31:0] hsu_haddr;
  wire    [ 1:0] hsu_htrans;
  wire           hsu_hwrite;
  wire    [ 1:0] hsu_hsize;
  wire    [31:0] hsu_hwdata;
  wire    [31:0] hsu_hrdata;
  wire    [ 1:0] hsu_hresp;
  wire           hsu_hready;

`ifdef  RW_HSU_RSA_EN
  /* HSU SRAM interface */
  wire           rsa_sram_rd_en;
`endif//RW_HSU_RSA_EN

  // diags
  wire           reg_diag_mux;
  
  //assign reg_diag_sel = {reg_diag_mux,reg_diag_sel2,reg_diag_sel1,reg_diag_sel0};

  /*****************************************************************************
  * clock gating logic
  *****************************************************************************/
  assign mac_pi_clken      =  mac_pri_clken_i     | ~reg_mac_pi_clk_gating_en;     
  assign mac_pi_tx_clken   =  mac_pi_tx_clken_i   | ~reg_mac_pi_tx_clk_gating_en;  
  assign mac_pi_rx_clken   =  mac_pi_rx_clken_i   | ~reg_mac_pi_rx_clk_gating_en;  
  assign mac_core_clken    =  mac_pri_clken_i     | ~reg_mac_core_clk_gating_en;   
  assign mac_core_tx_clken =  mac_core_tx_clken_i | ~reg_mac_core_tx_clk_gating_en;
  assign mac_core_rx_clken =  mac_core_rx_clken_i | ~reg_mac_core_rx_clk_gating_en;
  assign mac_crypt_clken   =  mac_crypt_clken_i   | ~reg_mac_crypt_clk_gating_en;  
  assign mac_wt_clken      =  mac_wt_clken_i      | ~reg_mac_wt_clk_gating_en;     
  assign mpif_clken        =  (mac_pri_clken_i & mpif_clken_i) | ~reg_mpif_clk_gating_en;       
                                                                                   

`ifdef RW_MUMIMO_SEC_USER1_EN
  assign sec_u1_mac_pi_tx_clken   =  sec_u1_mac_pi_tx_clken_i   | ~reg_sec_mac_pi_tx_clk_gating_en;
  assign sec_u1_mac_core_tx_clken =  sec_u1_mac_core_tx_clken_i | ~reg_sec_mac_core_tx_clk_gating_en;
  assign sec_u1_mac_crypt_clken   =  sec_u1_mac_crypt_clken_i   | ~reg_sec_mac_crypt_clk_gating_en;  
  assign sec_u1_mpif_clken        =  (mac_pri_clken_i & sec_u1_mpif_clken_i) | ~reg_sec_mpif_clk_gating_en;
`endif // RW_MUMIMO_SEC_USER1_EN
`ifdef RW_MUMIMO_SEC_USER2_EN
  assign sec_u2_mac_pi_tx_clken   =  sec_u2_mac_pi_tx_clken_i   | ~reg_sec_mac_pi_tx_clk_gating_en;
  assign sec_u2_mac_core_tx_clken =  sec_u2_mac_core_tx_clken_i | ~reg_sec_mac_core_tx_clk_gating_en;
  assign sec_u2_mac_crypt_clken   =  sec_u2_mac_crypt_clken_i   | ~reg_sec_mac_crypt_clk_gating_en;  
  assign sec_u2_mpif_clken        =  (mac_pri_clken_i & sec_u2_mpif_clken_i) | ~reg_sec_mpif_clk_gating_en;
`endif // RW_MUMIMO_SEC_USER2_EN
`ifdef RW_MUMIMO_SEC_USER3_EN
  assign sec_u3_mac_pi_tx_clken   =  sec_u3_mac_pi_tx_clken_i   | ~reg_sec_mac_pi_tx_clk_gating_en;
  assign sec_u3_mac_core_tx_clken =  sec_u3_mac_core_tx_clken_i | ~reg_sec_mac_core_tx_clk_gating_en;
  assign sec_u3_mac_crypt_clken   =  sec_u3_mac_crypt_clken_i   | ~reg_sec_mac_crypt_clk_gating_en;  
  assign sec_u3_mpif_clken        =  (mac_pri_clken_i & sec_u3_mpif_clken_i) | ~reg_sec_mpif_clk_gating_en;
`endif // RW_MUMIMO_SEC_USER3_EN

  /*****************************************************************************
  * interruption sources mapping
  *****************************************************************************/
  /* RESERVED */
  assign proc_irq[95:80] = 'b0;                                     
  
  /* PHY */
  assign proc_irq[79:72] = 'b0;                                     
  assign proc_irq[71]    = ~rc_irq_n;                                       
  assign proc_irq[70]    = ~phy_irq_n;                                       
  
  /* IPC */
  assign proc_irq[69:64] = 'b0;                                     
  assign proc_irq[63:60] = ipc_irq[3:0];                                       
  
  /* MAC */
  assign proc_irq[59:56] = 'b0;                                     
  assign proc_irq[55]    = ~mac_int_prot_trigger_n;                                     
  assign proc_irq[54]    = ~mac_int_gen_n;                                             
  assign proc_irq[53]    = ~mac_int_tx_trigger_n;                                       
  assign proc_irq[52]    = ~mac_int_rx_trigger_n;                                       
  assign proc_irq[51]    = ~mac_int_tx_rx_misc_n;                                        
  assign proc_irq[50]    = ~mac_int_tx_rx_timer_n;                                       
  
  /* LA */
`ifdef RW_EMBEDDED_LA
  assign proc_irq[49]    = la_interrupt;
`else // RW_EMBEDDED_LA
  assign proc_irq[49]    = 1'b0;
`endif // RW_EMBEDDED_LA

  /* HSU */
  assign proc_irq[48]    = hsu_irq;

  /* Tick Timer */
  assign proc_irq[47]    = tick_timer_irq;
  assign proc_irq[46]    = soft_irq;

  /* DMA */
  assign proc_irq[45:42] = 'b0;
  assign proc_irq[41]    = dma_channel_irq[4];
  assign proc_irq[40]    = dma_error_irq;
  assign proc_irq[39:24] = dma_lli_irq[15:0];
  assign proc_irq[23:20] = dma_channel_irq[3:0];

  assign irq_source[19:13] = 7'b0;
`ifdef  RW_FPGA_AHB
  assign irq_source[12]    = fpga_irq;
`else //RW_FPGA_AHB
  assign irq_source[12]    = 1'b0;
`endif//RW_FPGA_AHB
  assign irq_source[11]    = ~rc_irq_n;
  assign irq_source[10]    = ~phy_irq_n;
  assign irq_source[9:0]   = 10'b0;
  assign irq_source[63:20] = proc_irq[63:20];
  
  /*****************************************************************************
  * processor ahb infrastructure
  *
  * 0x.00000000 : shared ram
  * 0x.00800000 : Periph
  * 0x.00900000 : Periph
  * 0x.00A00000 : dma
  * 0x.00B00000 : MAC
  * 0x.00C00000 : PHY
  * 0x.00D00000 : reserved
  * 0x.00E00000 : Periph
  * 0x.00F00000 : Periph
  * 0x.01000000 : Periph
  * 0x.01800000 : PHY LA
  *
  *****************************************************************************/
  /* decoder */
  assign proc_hsel_ram      = proc_haddr[24:23]==2'b00;
  assign proc_hsel_periph   = proc_haddr[24:23]==2'b01 && proc_haddr[22:21]==2'b00  ||
                              proc_haddr[24:23]==2'b01 && proc_haddr[22:21]==3'b11  ||
                              proc_haddr[24:23]==2'b10;
  assign proc_hsel_dma      = proc_haddr[24:23]==2'b01 && proc_haddr[22:20]==3'b010;
  assign proc_hsel_mac      = proc_haddr[24:23]==2'b01 && proc_haddr[22:20]==3'b011;
  assign proc_hsel_phy      = proc_haddr[24:23]==2'b01 && proc_haddr[22:20]==3'b100;
  assign proc_hsel_laphy    = proc_haddr[24:23]==2'b11;
  
  assign proc_hsel_default  = ~(proc_hsel_ram | proc_hsel_periph | proc_hsel_dma | proc_hsel_mac | proc_hsel_phy | proc_hsel_laphy);
  
  /* master hready */
  assign proc_hready        = proc_hready_ram & 
                              proc_hready_dma &
                              proc_hready_periph &
                              proc_hready_mac &
                              proc_hready_phy ;

  /* data mux control */
  always @(posedge plf_clk, negedge plf_rst_n)
  begin
    
    if(plf_rst_n==0)
    begin
    
      proc_hsel_ram_1t      <= 1'b0; 
      proc_hsel_dma_1t      <= 1'b0; 
      proc_hsel_periph_1t   <= 1'b0; 
      proc_hsel_mac_1t      <= 1'b0; 
      proc_hsel_phy_1t      <= 1'b0; 
      proc_hsel_default_1t  <= 1'b0;   
    
    end
    else
    begin
    
      if(proc_hready_in==1'b1 && proc_htrans[1]==1'b1)
      begin
      
        proc_hsel_ram_1t      <= proc_hsel_ram; 
        proc_hsel_dma_1t      <= proc_hsel_dma; 
        proc_hsel_periph_1t   <= proc_hsel_periph; 
        proc_hsel_mac_1t      <= proc_hsel_mac; 
        proc_hsel_phy_1t      <= proc_hsel_phy | proc_hsel_laphy; 
        proc_hsel_default_1t  <= proc_hsel_default;   
        
      end
    
    end  
  
  end
  
  /* data mux */
  assign {proc_hresp,proc_hrdata} =
     {proc_hresp_ram,proc_hrdata_ram}           & {34{proc_hsel_ram_1t}} |
     {proc_hresp_periph,proc_hrdata_periph}     & {34{proc_hsel_periph_1t}} |
     {proc_hresp_dma,proc_hrdata_dma}           & {34{proc_hsel_dma_1t}} |
     {proc_hresp_mac,proc_hrdata_mac}           & {34{proc_hsel_mac_1t}} |
     {proc_hresp_phy,proc_hrdata_phy}           & {34{proc_hsel_phy_1t}} |
     {2'b00,32'hdead5555}                       & {34{proc_hsel_default_1t}};
   
  /*****************************************************************************
  * peripheral ahb infrastructure
  *
  * 0x.00800000 : IPC 
  * 0x.00900000 : system controller
  * 0x.00910000 : interrupt controller
  * 0x.00920000 : packet traffic arbiter
  * 0x.00930000 : hardware security unit
  * 0x.00940000 : clock and reset manager
  * 0x.00E00000 : LA Reg
  * 0x.00F00000 : FPGA
  * 0x.01000000 : LA
  *
  *****************************************************************************/
  /* decoder */
  assign periph_hsel_ipc      = periph_haddr[24:23]==2'b01 && periph_haddr[22:20]==3'b000;
  assign periph_hsel_systctrl = periph_haddr[24:23]==2'b01 && periph_haddr[22:20]==3'b001 && periph_haddr[19:16]==4'b0000;
  assign periph_hsel_intctrl  = periph_haddr[24:23]==2'b01 && periph_haddr[22:20]==3'b001 && periph_haddr[19:16]==4'b0001;
  assign periph_hsel_pta      = periph_haddr[24:23]==2'b01 && periph_haddr[22:20]==3'b001 && periph_haddr[19:16]==4'b0010;
  assign periph_hsel_hsu      = periph_haddr[24:23]==2'b01 && periph_haddr[22:20]==3'b001 && periph_haddr[19:16]==4'b0011;
  assign periph_hsel_crm      = periph_haddr[24:23]==2'b01 && periph_haddr[22:20]==3'b001 && periph_haddr[19:16]==4'b0100;
  assign periph_hsel_la       = periph_haddr[24:23]==2'b10 ||
                               (periph_haddr[24:23]==2'b01 && periph_haddr[22:20]==3'b110);
  assign periph_hsel_fpga     = periph_haddr[24:23]==2'b01 && periph_haddr[22:20]==3'b111;
  
  assign periph_hsel_default  = ~(periph_hsel_ipc      |
                                  periph_hsel_systctrl |
                                  periph_hsel_intctrl  |
                                  periph_hsel_pta      |
                                  periph_hsel_hsu      |
                                  periph_hsel_crm      |
                                  periph_hsel_la       |
                                  periph_hsel_fpga     );
  
  /* master hready */
  assign periph_hready        = periph_hready_ipc      &
                                periph_hready_systctrl &
                                periph_hready_intctrl  &
                                periph_hready_pta      &
                                periph_hready_hsu      &
                                periph_hready_crm      &
                                periph_hready_la       &
                                periph_hready_fpga;

  /* data mux control */
  always @(posedge plf_clk, negedge plf_rst_n)
  begin
    
    if(plf_rst_n==0)
    begin
    
      periph_hsel_ipc_1t      <= 1'b0; 
      periph_hsel_systctrl_1t <= 1'b0;   
      periph_hsel_intctrl_1t  <= 1'b0;   
      periph_hsel_pta_1t      <= 1'b0;   
      periph_hsel_hsu_1t      <= 1'b0;   
      periph_hsel_crm_1t      <= 1'b0;   
      periph_hsel_la_1t       <= 1'b0;   
      periph_hsel_fpga_1t     <= 1'b0;   
      periph_hsel_default_1t  <= 1'b0;   
    
    end
    else
    begin
    
      if(periph_hready==1'b1 && periph_htrans[1]==1'b1)
      begin
      
        periph_hsel_ipc_1t      <= periph_hsel_ipc; 
        periph_hsel_systctrl_1t <= periph_hsel_systctrl;   
        periph_hsel_intctrl_1t  <= periph_hsel_intctrl;   
        periph_hsel_pta_1t      <= periph_hsel_pta;   
        periph_hsel_hsu_1t      <= periph_hsel_hsu;   
        periph_hsel_crm_1t      <= periph_hsel_crm;   
        periph_hsel_la_1t       <= periph_hsel_la;   
        periph_hsel_fpga_1t     <= periph_hsel_fpga;   
        periph_hsel_default_1t  <= periph_hsel_default;   
        
      end
    
    end  
  
  end
  
  /* data mux */
  assign {periph_hresp     ,periph_hrdata} =
     {periph_hresp_ipc     ,periph_hrdata_ipc}      & {34{periph_hsel_ipc_1t}}      |
     {periph_hresp_systctrl,periph_hrdata_systctrl} & {34{periph_hsel_systctrl_1t}} |
     {periph_hresp_intctrl ,periph_hrdata_intctrl}  & {34{periph_hsel_intctrl_1t}}  |
     {periph_hresp_pta     ,periph_hrdata_pta}      & {34{periph_hsel_pta_1t}}      |
     {periph_hresp_hsu     ,periph_hrdata_hsu}      & {34{periph_hsel_hsu_1t}}      |
     {periph_hresp_crm     ,periph_hrdata_crm}      & {34{periph_hsel_crm_1t}}      |
     {periph_hresp_la      ,periph_hrdata_la}       & {34{periph_hsel_la_1t}}       |
     {periph_hresp_fpga    ,periph_hrdata_fpga}     & {34{periph_hsel_fpga_1t}}     |
     {2'b00                ,32'hdead5555}           & {34{periph_hsel_default_1t}};
   
  /*****************************************************************************
  * DMA Host ahb infrastructure
  *
  * 0x.00C00000 : PHY
  * 0x.01000000 : LA
  * 0x.01800000 : PHY LA
  *
  *****************************************************************************/
  /* decoder */
  assign dma_hsel_phy      = dma_haddr[24:23]==2'b01 && dma_haddr[22:20]==3'b100;
`ifdef RW_EMBEDDED_LA
  assign dma_hsel_la       = dma_haddr[24:23]==2'b10;
  assign dma_hsel_laphy    = dma_haddr[24:23]==2'b11;
  assign dma_hsel_default  = ~(dma_hsel_la | dma_hsel_laphy | dma_hsel_phy);
  /* master hready */
  assign dma_hready        = dma_hready_la &
                             dma_hready_phy;
`else
  assign dma_hsel_default  = ~(dma_hsel_phy);
  assign dma_hready        = dma_hready_phy;
`endif // RW_EMBEDDED_LA
  
  

  /* data mux control */
  always @(posedge plf_clk, negedge plf_rst_n)
  begin
    
    if(plf_rst_n==0)
    begin
    
    `ifdef RW_EMBEDDED_LA
      dma_hsel_la_1t       <= 1'b0; 
    `endif // RW_EMBEDDED_LA
      dma_hsel_phy_1t      <= 1'b0; 
      dma_hsel_default_1t  <= 1'b0;
      
    end
    else
    begin
    
      if(dma_hready==1'b1 && dma_htrans[1]==1'b1)
      begin
      
      `ifdef RW_EMBEDDED_LA
        dma_hsel_phy_1t      <= dma_hsel_phy | dma_hsel_laphy; 
        dma_hsel_la_1t       <= dma_hsel_la; 
        dma_hsel_default_1t  <= dma_hsel_default;   
      `else
        dma_hsel_phy_1t      <= dma_hsel_phy; 
        dma_hsel_default_1t  <= dma_hsel_default;   
      `endif // RW_EMBEDDED_LA
        
      end
    
    end  
  
  end
  
  /* data mux */
  assign {dma_hresp,dma_hrdata} =
     {dma_hresp_phy,dma_hrdata_phy}           & {34{dma_hsel_phy_1t}} |
`ifdef RW_EMBEDDED_LA
     {dma_hresp_la,dma_hrdata_la}             & {34{dma_hsel_la_1t}} |
`endif // RW_EMBEDDED_LA
     {2'b00,32'hdead5555}                     & {34{dma_hsel_default_1t}};
   
  /*****************************************************************************
  * system controller
  *****************************************************************************/
  system_ctrl system_ctrl_0
  (
    /***************************************************************************
    * System
    ***************************************************************************/
    .clk(                               plf_clk),
    .rst_n(                             plf_rst_n),
  
    /***************************************************************************
    * AHB interface
    ***************************************************************************/
    .hready_in(                         periph_hready),
    .hsel(                              periph_hsel_systctrl),
    .haddr(                             periph_haddr[9:0]),
    .htrans(                            periph_htrans), 
    .hwrite(                            periph_hwrite),
    .hrdata(                            periph_hrdata_systctrl),
    .hwdata(                            periph_hwdata),
    .hready(                            periph_hready_systctrl),
    .hresp(                             periph_hresp_systctrl),

    /***************************************************************************
    * clock/ctrl
    ***************************************************************************/
    .nmb_io_busy(                       nmb_io_busy),
    .reg_bootrom_enable(                reg_bootrom_enable),
    .reg_fpgaa_reset_req(               reg_fpgaa_reset_req),
    .reg_fpgab_reset_req(               reg_fpgab_reset_req),
    .reg_sec_mac_pi_tx_clk_gating_en(   reg_sec_mac_pi_tx_clk_gating_en),
    .reg_sec_mac_crypt_clk_gating_en(   reg_sec_mac_crypt_clk_gating_en),
    .reg_sec_mac_core_tx_clk_gating_en( reg_sec_mac_core_tx_clk_gating_en),
    .reg_sec_mpif_clk_gating_en(        reg_sec_mpif_clk_gating_en),
    .reg_mac_pi_clk_gating_en(          reg_mac_pi_clk_gating_en), 
    .reg_mac_pi_tx_clk_gating_en(       reg_mac_pi_tx_clk_gating_en), 
    .reg_mac_pi_rx_clk_gating_en(       reg_mac_pi_rx_clk_gating_en), 
    .reg_mac_crypt_clk_gating_en(       reg_mac_crypt_clk_gating_en), 
    .reg_mac_core_clk_gating_en(        reg_mac_core_clk_gating_en), 
    .reg_mac_core_tx_clk_gating_en(     reg_mac_core_tx_clk_gating_en), 
    .reg_mac_core_rx_clk_gating_en(     reg_mac_core_rx_clk_gating_en), 
    .reg_mac_wt_clk_gating_en(          reg_mac_wt_clk_gating_en), 
    .reg_mpif_clk_gating_en(            reg_mpif_clk_gating_en), 
    .tick_timer_irq(                    tick_timer_irq),
    .soft_irq(                          soft_irq),

    /***************************************************************************
    * diag registers
    ***************************************************************************/
    .reg_diag_sel_en(                   reg_diag_sel_en), 
    .reg_diag_mux(                      reg_diag_mux),
    .reg_diag_sel6(                     reg_diag_sel6),
    .reg_diag_sel5(                     reg_diag_sel5),
    .reg_diag_sel4(                     reg_diag_sel4),
    .reg_diag_sel3(                     reg_diag_sel3),
    .reg_diag_sel2(                     reg_diag_sel2),
    .reg_diag_sel1(                     reg_diag_sel1),
    .reg_diag_sel0(                     reg_diag_sel0),
    .reg_diag_presel6(                  reg_diag_presel6),
    .reg_diag_presel5(                  reg_diag_presel5),
    .reg_diag_presel4(                  reg_diag_presel4),
    .reg_diag_presel3(                  reg_diag_presel3),
    .reg_diag_presel2(                  reg_diag_presel2),
    .reg_diag_presel1(                  reg_diag_presel1),
    .reg_diag_presel0(                  reg_diag_presel0),
    .reg_diag_trigger(                  reg_diag_trigger),
    .reg_diag_mpif_mask_en(             reg_diag_mpif_mask_en),
    .reg_diag_mpif_hdr_nbr(             reg_diag_mpif_hdr_nbr),
    .diag_value(                        diag_value),
    
    /***************************************************************************
    * gpio 
    ***************************************************************************/
    .gpio_in(                           gpio_in),
    .gpio_out(                          gpio_out),
    .gpio_oen(                          gpio_oen)
  );


  /*****************************************************************************
  * interrupt controller
  *****************************************************************************/
  int_cntl int_cntl_0
  (
    /***************************************************************************
    * System
    ***************************************************************************/
    .clk(                          plf_clk),
    .rst_n(                        plf_rst_n),
  
    /***************************************************************************
    * AHB interface
    ***************************************************************************/
    .hready_in(                    periph_hready),
    .hsel(                         periph_hsel_intctrl),
    .haddr(                        periph_haddr[7:0]),
    .htrans(                       periph_htrans), 
    .hwrite(                       periph_hwrite),
    .hrdata(                       periph_hrdata_intctrl),
    .hwdata(                       periph_hwdata),
    .hready(                       periph_hready_intctrl),
    .hresp(                        periph_hresp_intctrl),

    /***************************************************************************
    * Interrupt interface
    ***************************************************************************/
    .irq_source(                  irq_source),
    .irq_n(                       cpu_single_irq_n)
    );

  assign cpu_single_irq = !cpu_single_irq_n;


  /*****************************************************************************
  * ipc
  *****************************************************************************/
  ipc ipc_0
  (
    /***************************************************************************
    * System
    ***************************************************************************/
    .clk(                          plf_clk),
    .rst_n(                        plf_rst_n),

    /***************************************************************************
    * AHB interface
    ***************************************************************************/
    .hready_in(                    periph_hready),
    .hsel(                         periph_hsel_ipc),
    .haddr(                        periph_haddr[8:0]),
    .htrans(                       periph_htrans), 
    .hwrite(                       periph_hwrite),
    .hrdata(                       periph_hrdata_ipc),
    .hwdata(                       periph_hwdata),
    .hready(                       periph_hready_ipc),
    .hresp(                        periph_hresp_ipc),

    /***************************************************************************
    * Interrupt lines
    ***************************************************************************/
    .app2emb_irq(                  ipc_irq),
    .emb2app_irq(                  host_irq)
  );

  /*****************************************************************************
  * dma instance
  *****************************************************************************/
  rw_host_dma rw_host_dma_0
  (
    /***************************************************************************
    * System
    ***************************************************************************/
    .clk(                          plf_clk),
    .rst_n(                        plf_rst_n),

    /***************************************************************************
    * interrupts
    ***************************************************************************/
    .lli_irq(                      dma_lli_irq),
    .channel_irq(                  dma_channel_irq),
    .error_irq(                    dma_error_irq),

    /***************************************************************************
    * AHB slave (control registers)
    ***************************************************************************/
    .hready_in_regb(               proc_hready_in),
    .hsel_regb(                    proc_hsel_dma),
    .haddr_regb(                   proc_haddr[7:0]),
    .htrans_regb(                  proc_htrans),
    .hwrite_regb(                  proc_hwrite),
    .hrdata_regb(                  proc_hrdata_dma),
    .hwdata_regb(                  proc_hwdata),
    .hresp_regb(                   proc_hresp_dma),
    .hready_regb(                  proc_hready_dma),

    /***************************************************************************
    * AHB master (embeded sram)
    ***************************************************************************/
    .hready_lli(                   lli_hready),
    .haddr_lli(                    lli_haddr),
    .htrans_lli(                   lli_htrans),
    .hwrite_lli(                   ),
    .hrdata_lli(                   lli_hrdata),
    .hresp_lli(                    2'b00),

    /***************************************************************************
    * Dini interfaces
    ***************************************************************************/
    /* upstream interface */ 
    .dma0_awid(                    dma0_awid),
    .dma0_awaddr(                  dma0_awaddr),
    .dma0_awlen(                   dma0_awlen),
    .dma0_awsize(                  dma0_awsize),
    .dma0_awburst(                 dma0_awburst),
    .dma0_awuser(                  dma0_awuser),
    .dma0_awvalid(                 dma0_awvalid),
    .dma0_awready(                 dma0_awready),

    .dma0_wid(                     dma0_wid),
    .dma0_wdata(                   dma0_wdata),
    .dma0_wstrb(                   dma0_wstrb),
    .dma0_wlast(                   dma0_wlast),
    .dma0_wvalid(                  dma0_wvalid),
    .dma0_wready(                  dma0_wready),

    .dma0_bid(                     dma0_bid),
    .dma0_bresp(                   dma0_bresp),
    .dma0_bvalid(                  dma0_bvalid),
    .dma0_bready(                  dma0_bready),
    
    /* downstream interface */ 
    .dma1_arid(                    dma1_arid),
    .dma1_araddr(                  dma1_araddr),
    .dma1_arlen(                   dma1_arlen),
    .dma1_arsize(                  dma1_arsize),
    .dma1_arburst(                 dma1_arburst),
    .dma1_arvalid(                 dma1_arvalid),
    .dma1_arready(                 dma1_arready),

    .dma1_rid(                     dma1_rid),
    .dma1_rdata(                   dma1_rdata),
    .dma1_rresp(                   dma1_rresp),
    .dma1_rlast(                   dma1_rlast),
    .dma1_rvalid(                  dma1_rvalid),
    .dma1_rready(                  dma1_rready),
  
    /***************************************************************************
    * AHB master (AHB memory map)
    ***************************************************************************/
    .dma_haddr(                   dma_haddr),
    .dma_htrans(                  dma_htrans),
    .dma_hwrite(                  dma_hwrite),
    .dma_hsize(                   dma_hsize),
    .dma_hwdata(                  dma_hwdata),
    .dma_hrdata(                  dma_hrdata),
    .dma_hresp(                   dma_hresp),
    .dma_hready(                  dma_hready),
    
    /***************************************************************************
    * Bus interfaces
    ***************************************************************************/
    /* upstream */
    .dma0_ready(                  dma0_ready),
    .dma0_addr(                   dma0_addr),
    .dma0_trans(                  dma0_trans),
    .dma0_rdata(                  dma0_rdata),

    /* downstream */
    .dma1_ready(                  dma1_ready),
    .dma1_addr(                   dma1_addr),
    .dma1_trans(                  dma1_trans),
    .dma1_we(                     dma1_we),
    .dma1_wdata(                  dma1_wdata),

    /* midstream read */
    .dma2_ready(                  dma2_ready),
    .dma2_addr(                   dma2_addr),
    .dma2_trans(                  dma2_trans),
    .dma2_rdata(                  dma2_rdata),

    /* midstream write */
    .dma3_ready(                  dma3_ready),
    .dma3_addr(                   dma3_addr),
    .dma3_trans(                  dma3_trans),
    .dma3_we(                     dma3_we),
    .dma3_wdata(                  dma3_wdata),

    /***************************************************************************
    * Debug interface
    ***************************************************************************/
    .diag_port_top(               diag_dma_top),
    .diag_port_downstream_axi0(   diag_dma_downstream_axi0),
    .diag_port_downstream_axi1(   diag_dma_downstream_axi1),
    .diag_port_downstream_axi2(   diag_dma_downstream_axi2)
  );

  /*****************************************************************************
  * sram multiport-arbiter
  *****************************************************************************/
  sram_mpa 
  #(
    /*****************************************************************************
    * AHB addres bus length (byte address)
    *****************************************************************************/
    .g_addr_width(                 `RW_SHARED_RAM_ADDR_WIDTH)
  )
  sram_mpa_0
  (
    /*****************************************************************************
    * System
    *****************************************************************************/
    .clk(                          plf_clk),
    .rst_n(                        plf_rst_n),

    /*****************************************************************************
    * Processor AHB bus 
    *****************************************************************************/
    .proc_hready_in(               proc_hready_in),
    .proc_hsel(                    proc_hsel_ram),
    .proc_haddr(                   proc_haddr[`RW_SHARED_RAM_ADDR_WIDTH-1:0]),
    .proc_htrans(                  proc_htrans),
    .proc_hwrite(                  proc_hwrite),
    .proc_hsize(                   proc_hsize),      
    .proc_hrdata(                  proc_hrdata_ram),
    .proc_hwdata(                  proc_hwdata),
    .proc_hresp(                   proc_hresp_ram),
    .proc_hready(                  proc_hready_ram),
 
    /*****************************************************************************
    * MAC AHB bus 
    *****************************************************************************/
    .mac_hready_in(                mac_hmready),
    .mac_hsel(                     1'b1),
    .mac_haddr(                    mac_hmaddr[`RW_SHARED_RAM_ADDR_WIDTH-1:0]),
    .mac_htrans(                   mac_hmtrans),
    .mac_hwrite(                   mac_hmwrite),
    .mac_hsize(                    mac_hmsize[1:0]),     
    .mac_hrdata(                   mac_hmrdata),
    .mac_hwdata(                   mac_hmwdata),
    .mac_hresp(                    mac_hmresp),
    .mac_hready(                   mac_hmready),
  
    /*****************************************************************************
    * LLI AHB bus interface
    *****************************************************************************/
    .lli_haddr(                    lli_haddr[`RW_SHARED_RAM_ADDR_WIDTH-1:0]),
    .lli_htrans(                   lli_htrans),
    .lli_hrdata(                   lli_hrdata),
    .lli_hready(                   lli_hready),

    /*****************************************************************************
    * UPSTREAM bus interface
    *****************************************************************************/
    .dma0_addr(                    dma0_addr[`RW_SHARED_RAM_ADDR_WIDTH-1:0]),
    .dma0_trans(                   dma0_trans),
    .dma0_write(                   1'b0),
    .dma0_rdata(                   dma0_rdata),
    .dma0_wdata(                   64'b0),
    .dma0_we(                       8'b0),
    .dma0_ready(                   dma0_ready),

    /*****************************************************************************
    * DOWN bus interface
    *****************************************************************************/
    .dma1_addr(                    dma1_addr[`RW_SHARED_RAM_ADDR_WIDTH-1:0]),
    .dma1_trans(                   dma1_trans),
    .dma1_write(                   1'b1),
    .dma1_rdata(                   ),
    .dma1_we(                      dma1_we),
    .dma1_wdata(                   dma1_wdata),
    .dma1_ready(                   dma1_ready),
      
    /*****************************************************************************
    * DMA2 bus interface
    *****************************************************************************/
    .dma2_addr(                    dma2_addr[`RW_SHARED_RAM_ADDR_WIDTH-1:0]),
    .dma2_trans(                   dma2_trans),
    .dma2_write(                   1'b0),
    .dma2_rdata(                   dma2_rdata),
    .dma2_we(                      8'b0),
    .dma2_wdata(                   64'h0),
    .dma2_ready(                   dma2_ready),
      
    /*****************************************************************************
    * DMA3 bus interface
    *****************************************************************************/
    .dma3_addr(                    dma3_addr[`RW_SHARED_RAM_ADDR_WIDTH-1:0]),
    .dma3_trans(                   dma3_trans),
    .dma3_write(                   1'b1),
    .dma3_rdata(                   /*Open*/),
    .dma3_we(                      dma3_we),
    .dma3_wdata(                   dma3_wdata),
    .dma3_ready(                   dma3_ready),
      
    /*****************************************************************************
    * HSU AHB bus interface
    *****************************************************************************/
    .hsu_hready_in(                hsu_hready),
    .hsu_hsel(                     1'b1),
    .hsu_haddr(                    hsu_haddr[`RW_SHARED_RAM_ADDR_WIDTH-1:0]),
    .hsu_htrans(                   hsu_htrans),
    .hsu_hwrite(                   hsu_hwrite),
    .hsu_hsize(                    hsu_hsize[1:0]),     
    .hsu_hrdata(                   hsu_hrdata),
    .hsu_hwdata(                   hsu_hwdata),
    .hsu_hresp(                    hsu_hresp),
    .hsu_hready(                   hsu_hready),

    /*****************************************************************************
    * 64 bits sram interface
    *****************************************************************************/
    .ram_cs(                       shared_ram_en),
    .ram_a(                        shared_ram_addr),
    .ram_we(                       shared_ram_wr_en),
    .ram_d(                        shared_ram_wr_data),
    .ram_q(                        shared_ram_rd_data)
  );

  /*****************************************************************************
  * AHB Peripheral bridge
  *****************************************************************************/
  ahb_bridge ahb_bridge_0(
    // Clock and reset
    .clk(                          plf_clk),
    .rst_n(                        plf_rst_n),
    
    // AHB slave
    .s_hreadyin(                   proc_hready_in),
    .s_hsel(                       proc_hsel_periph),
    .s_haddr(                      {4'h0,proc_haddr}),
    .s_htrans(                     proc_htrans),
    .s_hwrite(                     proc_hwrite),
    .s_hsize(                      {1'b0,proc_hsize}),
    .s_hwdata(                     proc_hwdata),
    .s_hrdata(                     proc_hrdata_periph),
    .s_hresp(                      proc_hresp_periph),
    .s_hready(                     proc_hready_periph),
    
    // AHB Master
    .m_haddr(                      periph_haddr),
    .m_htrans(                     periph_htrans),
    .m_hwrite(                     periph_hwrite),
    .m_hsize(                      periph_hsize),
    .m_hwdata(                     periph_hwdata),
    .m_hrdata(                     periph_hrdata),
    .m_hresp(                      periph_hresp),
    .m_hready(                     periph_hready)
);

  /*****************************************************************************
  * MAC core (place holder)
  *****************************************************************************/


  // Instanciation of rwWlanNxMACHW
  // Name of the instance : u_rwWlanNxMACHW
  // Name of the file containing this module : rwWlanNxMACHW.v
  rwWlanNxMACHW u_rwWlanNxMACHW (
    // Reset Interfaces
		.macPIClkHardRst_n      (plf_rst_n),
		.macCoreClkHardRst_n    (mac_core_rst_n),
		.macWTClkHardRst_n      (mac_wt_rst_n),
		.mpIFClkHardRst_n       (mpif_rst_n),
    // Clock Interfaces
		.macPIClk               (mac_pi_clk),
		.macPITxClk             (mac_pi_tx_clk),
		.macPIRxClk             (mac_pi_rx_clk),
		.macPISlaveClk          (plf_clk),
		.macCoreClk             (mac_core_clk),
		.macCoreTxClk           (mac_core_tx_clk),
		.macCoreRxClk           (mac_core_rx_clk),
		.macCryptClk            (mac_crypt_clk),
		.macLPClk               (mac_lp_clk),
		.macWTClk               (mac_wt_clk),
		.mpIFClk                (mpif_clk),
`ifdef RW_MUMIMO_SEC_USER1_EN
    .secU1MacPITxClk        (sec_u1_mac_pi_tx_clk),
    .secU1MacCoreTxClk      (sec_u1_mac_core_tx_clk),
    .secU1MacCryptClk       (sec_u1_mac_crypt_clk),
    .secU1MpIFClk           (sec_u1_mpif_clk),
`endif // RW_MUMIMO_SEC_USER1_EN
`ifdef RW_MUMIMO_SEC_USER2_EN
    .secU2MacPITxClk        (sec_u2_mac_pi_tx_clk),
    .secU2MacCoreTxClk      (sec_u2_mac_core_tx_clk),
    .secU2MacCryptClk       (sec_u2_mac_crypt_clk),
    .secU2MpIFClk           (sec_u2_mpif_clk),
`endif // RW_MUMIMO_SEC_USER2_EN
`ifdef RW_MUMIMO_SEC_USER3_EN
    .secU3MacPITxClk        (sec_u3_mac_pi_tx_clk),
    .secU3MacCoreTxClk      (sec_u3_mac_core_tx_clk),
    .secU3MacCryptClk       (sec_u3_mac_crypt_clk),
    .secU3MpIFClk           (sec_u3_mpif_clk),
`endif // RW_MUMIMO_SEC_USER3_EN
    // Clock Enable Interfaces
		.macPriClkEn            (mac_pri_clken_i),
		.platformWakeUp         (platform_wake_up),
		.macPITxClkEn           (mac_pi_tx_clken_i),
		.macPIRxClkEn           (mac_pi_rx_clken_i),
		.macCoreTxClkEn         (mac_core_tx_clken_i),
		.macCoreRxClkEn         (mac_core_rx_clken_i),
		.macCryptClkEn          (mac_crypt_clken_i),
		.macLPClkSwitch         (mac_lp_clkswitch),
		.macWTClkEn             (mac_wt_clken_i),
		.mpIFClkEn              (mpif_clken_i),
`ifdef RW_MUMIMO_SEC_USER1_EN
    .secU1MacPITxClkEn      (sec_u1_mac_pi_tx_clken_i),
    .secU1MacCoreTxClkEn    (sec_u1_mac_core_tx_clken_i),
    .secU1MacCryptClkEn     (sec_u1_mac_crypt_clken_i),
    .secU1MpIFClkEn         (sec_u1_mpif_clken_i),
`endif // RW_MUMIMO_SEC_USER1_EN
`ifdef RW_MUMIMO_SEC_USER2_EN
    .secU2MacPITxClkEn      (sec_u2_mac_pi_tx_clken_i),
    .secU2MacCoreTxClkEn    (sec_u2_mac_core_tx_clken_i),
    .secU2MacCryptClkEn     (sec_u2_mac_crypt_clken_i),
    .secU2MpIFClkEn         (sec_u2_mpif_clken_i),
`endif // RW_MUMIMO_SEC_USER2_EN
`ifdef RW_MUMIMO_SEC_USER3_EN
    .secU3MacPITxClkEn      (sec_u3_mac_pi_tx_clken_i),
    .secU3MacCoreTxClkEn    (sec_u3_mac_core_tx_clken_i),
    .secU3MacCryptClkEn     (sec_u3_mac_crypt_clken_i),
    .secU3MpIFClkEn         (sec_u3_mpif_clken_i),
`endif // RW_MUMIMO_SEC_USER3_EN
    // Interrupts Interfaces
		.intGen_n               (mac_int_gen_n),
		.intProtTrigger_n       (mac_int_prot_trigger_n),
		.intTxTrigger_n         (mac_int_tx_trigger_n),
		.intRxTrigger_n         (mac_int_rx_trigger_n),
		.intTxRxMisc_n          (mac_int_tx_rx_misc_n),
		.intTxRxTimer_n         (mac_int_tx_rx_timer_n),
		.internalError          (mac_internal_error),
    // Debug Interfaces
		.debugPort0             (mac_diag0),
		.debugPort1             (mac_diag1),
		.debugPort2             (mac_diag2),
		.debugPort3             (mac_diag3),
		.debugPort4             (mac_diag4),
		.debugPort5             (mac_diag5),
		.debugPort6             (mac_diag6),
		.debugPort7             (mac_diag7),
		.debugPort8             (mac_diag8),
		.debugPort9             (mac_diag9),
		.debugPort10            (mac_diag10),
		.debugPort11            (mac_diag11),
		.debugPort12            (mac_diag12),
		.debugPort13            (mac_diag13),
		.debugPort14            (mac_diag14),
		.debugPort15            (mac_diag15),
		.debugPort16            (mac_diag16),
		.debugPort17            (mac_diag17),
		.debugPort18            (mac_diag18),
		.debugPort19            (mac_diag19),
		.debugPort20            (mac_diag20),
		.debugPort21            (mac_diag21),
		.debugPort22            (mac_diag22),
		.debugPort23            (mac_diag23),
		.debugPort24            (mac_diag24),
		.debugPort25            (mac_diag25),
		.debugPort26            (mac_diag26),
		.debugPort27            (mac_diag27),
		.debugPort28            (mac_diag28),
		.debugPort29            (mac_diag29),
		.debugPort30            (mac_diag30),
		.debugPort31            (mac_diag31),
		.debugPort32            (mac_diag32),
		.debugPort33            (mac_diag33),
		.debugPort34            (mac_diag34),
		.debugPort35            (mac_diag35),
		.debugPort36            (mac_diag36),
		.debugPort37            (mac_diag37),
		.debugPort38            (mac_diag38),
		.debugPort39            (mac_diag39),
		.debugPort40            (mac_diag40),
		.debugPort41            (mac_diag41),
		.debugPort42            (mac_diag42),
		.debugPort43            (mac_diag43),
		.debugPort44            (mac_diag44),
		.debugPort45            (mac_diag45),
		.debugPort46            (mac_diag46),
		.debugPort47            (mac_diag47),
		.debugPort48            (mac_diag48),
		.debugPort49            (mac_diag49),
		.debugPort50            (mac_diag50),
		.debugPort51            (mac_diag51),
		.debugPort52            (mac_diag52),
		.debugPort53            (mac_diag53),
		.debugPort54            (mac_diag54),
		.debugPort55            (mac_diag55),
		.debugPort56            (mac_diag56),
		.debugPort57            (mac_diag57),
		.debugPort58            (mac_diag58),
		.debugPort59            (mac_diag59),
		.debugPort60            (mac_diag60),
		.debugPort61            (mac_diag61),
		.debugKSR               (mac_debug_ksr),
  `ifdef RW_SWPROF_DEBUG_PORT
		.swProfDebugPort        (diag_mac_sw),
  `endif // RW_SWPROF_DEBUG_PORT
    
    // AHB Slave interface
		.hSAddr                 (proc_haddr[15:0]),
		.hSTrans                (proc_htrans),
		.hSWrite                (proc_hwrite),
		.hSSize                 ({1'b0,proc_hsize}),
		.hSBurst                (3'b0),
		.hSProt                 (4'b0),
		.hSWData                (proc_hwdata),
		.hSSel                  (proc_hsel_mac),
		.hSReadyIn              (proc_hready_in),
		.hSRData                (proc_hrdata_mac),
		.hSReadyOut             (proc_hready_mac),
		.hSResp                 (proc_hresp_mac),
    // AHB Master interface
		.hMBusReq               (),
		.hMLock                 (),
		.hMGrant                (1'b1),
		.hMAddr                 (mac_hmaddr),
		.hMTrans                (mac_hmtrans),
		.hMWrite                (mac_hmwrite),
		.hMSize                 (mac_hmsize),
		.hMBurst                (),
		.hMProt                 (),
		.hMWData                (mac_hmwdata),
		.hMRData                (mac_hmrdata),
		.hMReady                (mac_hmready),
		.hMResp                 (mac_hmresp),
    // MAC-PHY interface
 		.phyRdy                 (mpif_phyrdy),
		.txEnd_p                (mpif_txend_p),
		.rxData                 (mpif_rxdata),
		.CCAPrimary20           (mpif_cca_pri20),
		.CCASecondary20         (mpif_cca_sec20),
		.CCASecondary40         (mpif_cca_sec40),
		.CCASecondary80         (1'b0),	
		.rxEndForTiming_p       (mpif_rxendfortiming_p),
		.rxErr_p                (mpif_rxerr_p),
		.rxEnd_p                (mpif_rxend_p),
		.phyErr_p               (mpif_phyerr_p),
		.rifsRxDetected         (mpif_rifsrxdetected),
		.txReq                  (mpif_txreq),
		.rxReq                  (mpif_rxreq),
		.txData                 (mpif_txdata),
		.macDataValid           (mpif_macdatavalid),
		.mimoCmdValid           (mpif_mimocmdvalid),
		.keepRFOn               (mpif_keeprfon),
`ifdef RW_MUMIMO_SEC_USER1_EN
		.txDataU1               (mpif_txdata_u1),
		.macDataValidU1         (mpif_macdatavalid_u1),
 		.phyRdyU1               (mpif_phyrdy_u1),
`endif // RW_MUMIMO_SEC_USER1_EN
`ifdef RW_MUMIMO_SEC_USER2_EN
		.txDataU2               (mpif_txdata_u2),
		.macDataValidU2         (mpif_macdatavalid_u2),
 		.phyRdyU2               (mpif_phyrdy_u2),
`endif // RW_MUMIMO_SEC_USER2_EN
`ifdef RW_MUMIMO_SEC_USER3_EN
		.txDataU3               (mpif_txdata_u3),
		.macDataValidU3         (mpif_macdatavalid_u3),
 		.phyRdyU3               (mpif_phyrdy_u3),
`endif // RW_MUMIMO_SEC_USER3_EN

 		// Coex Interface
  `ifdef RW_WLAN_COEX_EN
    .coexWlanTx             (coex_wlan_tx),
    .coexWlanRx             (coex_wlan_rx),
    .coexWlanTxAbort        (coex_wlan_tx_abort),
    .coexWlanRxAbort        (coex_wlan_rx_abort),
    .coexWlanPTI            (coex_wlan_pti),
    .coexWlanPTIToggle      (coex_wlan_pti_tog),
    .coexWlanChanBw         (coex_wlan_chan_bw),
    .coexWlanChanFreq       (coex_wlan_chan_freq),
    .coexWlanChanOffset     (coex_wlan_chan_offset),
  `endif // RW_WLAN_COEX_EN
`ifdef RW_BFMEE_EN
    // BFR HW Accelerator Interface
    .bfrStart               (bfr_start),
    .bfrDone                (bfr_done),
    .bfrChBW                (bfr_ch_bw),
    .bfrGrouping            (bfr_grouping),
    .bfrCodebook            (bfr_codebook),
    .bfrFeedbackType        (bfr_feedback_type),
    .bfrNr                  (bfr_nr),
    .bfrNc                  (bfr_nc),
    .bfrHE                  (bfr_he),
    .bfrRUStartIndex        (bfr_he_rustartidx),
    .bfrRUEndIndex          (bfr_he_ruendidx),
    .bfrData                (bfr_data),
    .bfrDataValid           (bfr_data_valid),
    .bfrDataReady           (bfr_data_ready),
`endif //RW_BFMEE_EN
    // Memories Interfaces
		.txFIFOReadEn           (tx_fifo_rd_en),
		.txFIFOReadAddr         (tx_fifo_rd_addr),
		.txFIFOReadData         (tx_fifo_rd_data),
		.txFIFOWriteEn          (tx_fifo_wr_en),
		.txFIFOWriteAddr        (tx_fifo_wr_addr),
		.txFIFOWriteData        (tx_fifo_wr_data),
`ifdef  RW_MUMIMO_SEC_USER1_EN
    .secU1TxFIFOReadEn      (sec_u1_tx_fifo_rd_en),
    .secU1TxFIFOReadAddr    (sec_u1_tx_fifo_rd_addr),
    .secU1TxFIFOReadData    (sec_u1_tx_fifo_rd_data),
    .secU1TxFIFOWriteEn     (sec_u1_tx_fifo_wr_en),
    .secU1TxFIFOWriteAddr   (sec_u1_tx_fifo_wr_addr),
    .secU1TxFIFOWriteData   (sec_u1_tx_fifo_wr_data),
`endif//RW_MUMIMO_SEC_USER1_EN
`ifdef  RW_MUMIMO_SEC_USER2_EN
    .secU2TxFIFOReadEn      (sec_u2_tx_fifo_rd_en),
    .secU2TxFIFOReadAddr    (sec_u2_tx_fifo_rd_addr),
    .secU2TxFIFOReadData    (sec_u2_tx_fifo_rd_data),
    .secU2TxFIFOWriteEn     (sec_u2_tx_fifo_wr_en),
    .secU2TxFIFOWriteAddr   (sec_u2_tx_fifo_wr_addr),
    .secU2TxFIFOWriteData   (sec_u2_tx_fifo_wr_data),  
`endif//RW_MUMIMO_SEC_USER2_EN
`ifdef  RW_MUMIMO_SEC_USER3_EN
    .secU3TxFIFOReadEn      (sec_u3_tx_fifo_rd_en),
    .secU3TxFIFOReadAddr    (sec_u3_tx_fifo_rd_addr),
    .secU3TxFIFOReadData    (sec_u3_tx_fifo_rd_data),
    .secU3TxFIFOWriteEn     (sec_u3_tx_fifo_wr_en),
    .secU3TxFIFOWriteAddr   (sec_u3_tx_fifo_wr_addr),
    .secU3TxFIFOWriteData   (sec_u3_tx_fifo_wr_data),
`endif//RW_MUMIMO_SEC_USER3_EN
		.rxFIFOReadEn           (rx_fifo_rd_en),
		.rxFIFOReadAddr         (rx_fifo_rd_addr),
		.rxFIFOReadData         (rx_fifo_rd_data),
		.rxFIFOWriteEn          (rx_fifo_wr_en),
		.rxFIFOWriteAddr        (rx_fifo_wr_addr),
		.rxFIFOWriteData        (rx_fifo_wr_data),
		.keyStorageEn           (keystorage_en),
		.keyStorageWriteEn      (keystorage_wr_en),
		.keyStorageAddr         (keystorage_addr),
		.keyStorageReadData     (keystorage_rd_data),
		.keyStorageWriteData    (keystorage_wr_data),
		.sboxMemRdAddr          (sbox_mem_raddr),          
		.sboxMemRdData          (sbox_mem_rdata),          
		.sboxMemWrAddr          (sbox_mem_waddr),          
		.sboxMemRdEn            (sbox_mem_ren),            
		.sboxMemWrEn            (sbox_mem_wen),            
		.sboxMemWrData          (sbox_mem_wdata),      
		.mpIFTxFIFOReadEn       (mpif_tx_fifo_rd_en),
		.mpIFTxFIFOReadAddr     (mpif_tx_fifo_rd_addr),
		.mpIFTxFIFOReadData     (mpif_tx_fifo_rd_data),
		.mpIFTxFIFOWriteEn      (mpif_tx_fifo_wr_en),
		.mpIFTxFIFOWriteAddr    (mpif_tx_fifo_wr_addr),
		.mpIFTxFIFOWriteData    (mpif_tx_fifo_wr_data),
		.mpIFRxFIFOReadEn       (mpif_rx_fifo_rd_en),
		.mpIFRxFIFOReadAddr     (mpif_rx_fifo_rd_addr),
		.mpIFRxFIFOReadData     (mpif_rx_fifo_rd_data),
		.mpIFRxFIFOWriteEn      (mpif_rx_fifo_wr_en),
		.mpIFRxFIFOWriteAddr    (mpif_rx_fifo_wr_addr),
		.mpIFRxFIFOWriteData    (mpif_rx_fifo_wr_data),
`ifdef  RW_MUMIMO_SEC_USER1_EN
    .secU1MpIFTxFIFOReadEn    (sec_u1_mpif_tx_fifo_rd_en),
    .secU1MpIFTxFIFOReadAddr  (sec_u1_mpif_tx_fifo_rd_addr),
    .secU1MpIFTxFIFOReadData  (sec_u1_mpif_tx_fifo_rd_data),
    .secU1MpIFTxFIFOWriteEn   (sec_u1_mpif_tx_fifo_wr_en),
    .secU1MpIFTxFIFOWriteAddr (sec_u1_mpif_tx_fifo_wr_addr),
    .secU1MpIFTxFIFOWriteData (sec_u1_mpif_tx_fifo_wr_data),
`endif//RW_MUMIMO_SEC_USER1_EN
`ifdef  RW_MUMIMO_SEC_USER2_EN
    .secU2MpIFTxFIFOReadEn    (sec_u2_mpif_tx_fifo_rd_en),
    .secU2MpIFTxFIFOReadAddr  (sec_u2_mpif_tx_fifo_rd_addr),
    .secU2MpIFTxFIFOReadData  (sec_u2_mpif_tx_fifo_rd_data),
    .secU2MpIFTxFIFOWriteEn   (sec_u2_mpif_tx_fifo_wr_en),
    .secU2MpIFTxFIFOWriteAddr (sec_u2_mpif_tx_fifo_wr_addr),
    .secU2MpIFTxFIFOWriteData (sec_u2_mpif_tx_fifo_wr_data),
`endif//RW_MUMIMO_SEC_USER2_EN
`ifdef  RW_MUMIMO_SEC_USER3_EN
    .secU3MpIFTxFIFOReadEn    (sec_u3_mpif_tx_fifo_rd_en),
    .secU3MpIFTxFIFOReadAddr  (sec_u3_mpif_tx_fifo_rd_addr),
    .secU3MpIFTxFIFOReadData  (sec_u3_mpif_tx_fifo_rd_data),
    .secU3MpIFTxFIFOWriteEn   (sec_u3_mpif_tx_fifo_wr_en),
    .secU3MpIFTxFIFOWriteAddr (sec_u3_mpif_tx_fifo_wr_addr),
    .secU3MpIFTxFIFOWriteData (sec_u3_mpif_tx_fifo_wr_data),
`endif//RW_MUMIMO_SEC_USER3_EN
		.mibTableEn             (mib_table_en),
		.mibTableWriteEn        (mib_table_wr_en),
		.mibTableAddr           (mib_table_addr),
		.mibTableReadData       (mib_table_rd_data),
		.mibTableWriteData      (mib_table_wr_data)
		);

  assign mpif_rfshutdown = 1'b0; //$todo

`ifndef RW_SWPROF_DEBUG_PORT
  assign diag_mac_sw = 64'b0;
`endif // RW_SWPROF_DEBUG_PORT

  /*****************************************************************************
  * PHY slave (place golder)
  *****************************************************************************/
//   assign phy_haddr           =  proc_haddr;
//   assign phy_htrans          =  proc_htrans;
//   assign phy_hwrite          =  proc_hwrite;
//   assign phy_hsize           =  proc_hsize;
//   assign phy_hwdata          =  proc_hwdata;
//   assign proc_hrdata_phy     =  phy_hrdata;
//   assign proc_hresp_phy      =  phy_hresp;
//   assign proc_hready_phy     =  phy_hready;

// Instanciation of ahb_mpa
// Name of the instance : u_ahb_mpa
// Name of the file containing this module : ahb_mpa.v
ahb_mpa #(.g_addr_width (28)) u_ahb_mpa_phy  (
		.clk                    (plf_clk),
		.rst_n                  (plf_rst_n),
		.s0_hready_in           (proc_hready_in),
		.s0_hsel                (proc_hsel_phy | proc_hsel_laphy),
		.s0_haddr               (proc_haddr),
		.s0_htrans              (proc_htrans),
		.s0_hwrite              (proc_hwrite),
		.s0_hsize               (proc_hsize),
		.s0_hwdata              (proc_hwdata),
		.s0_hrdata              (proc_hrdata_phy),
		.s0_hresp               (proc_hresp_phy),
		.s0_hready              (proc_hready_phy),
    
		.s1_hready_in           (dma_hready),
`ifdef RW_EMBEDDED_LA
		.s1_hsel                (dma_hsel_phy | dma_hsel_laphy),
`else
		.s1_hsel                (dma_hsel_phy),
`endif // RW_EMBEDDED_LA
		.s1_haddr               (dma_haddr[27:0]),
		.s1_htrans              (dma_htrans),
		.s1_hwrite              (dma_hwrite),
		.s1_hsize               (dma_hsize),
		.s1_hwdata              (dma_hwdata),
		.s1_hrdata              (dma_hrdata_phy),
		.s1_hresp               (dma_hresp_phy),
		.s1_hready              (dma_hready_phy),
    
		.m_hready_in            (phy_hready_in),
		.m_hsel                 (phy_hsel),
		.m_haddr                (phy_haddr),
		.m_htrans               (phy_htrans),
		.m_hwrite               (phy_hwrite),
		.m_hsize                (phy_hsize),
		.m_hwdata               (phy_hwdata),
		.m_hrdata               (phy_hrdata),
		.m_hresp                (phy_hresp),
		.m_hready               (phy_hready)
		);
  
  /*****************************************************************************
  * diags
  *****************************************************************************/
  //assign diag_platform0      = 32'b0;
  assign diag_platform0 = {
`ifdef  RW_MUMIMO_SEC_USER1_EN
                           mpif_macdatavalid_u1,
                           mpif_phyrdy_u1,
`else //RW_MUMIMO_SEC_USER1_EN
                           1'b0,
                           1'b0,
`endif//RW_MUMIMO_SEC_USER1_EN
                           mpif_rfshutdown,
                           mpif_txreq,           
                           mpif_txdata,          
                           mpif_macdatavalid, 
                           mpif_phyrdy,    
                           mpif_txend_p,         
                           mpif_rxreq,           
                           mpif_rxdata,          
                           mpif_cca_pri20,       
                           mpif_cca_sec20,       
                           mpif_rxendfortiming_p,
                           mpif_rxerr_p,         
                           mpif_rxend_p,  
                           mpif_phyerr_p,        
                           mpif_keeprfon,        
                           mpif_rifsrxdetected};
  assign diag_platform1 = 32'b0;
  assign diag_platform2 = 32'b0;


`ifdef RW_EMBEDDED_LA
  /*****************************************************************************
  * Logic Analyzer (place holder)
  *****************************************************************************/
//    assign la_hready_in       =  la_hready;
//    assign la_hsel            =  proc_hsel_la || dma_hsel_la;
//   assign la_haddr           =  proc_haddr[20:0];
//   assign la_htrans          =  proc_htrans;
//   assign la_hwrite          =  proc_hwrite;
//   assign la_hsize           =  proc_hsize;
//   assign la_hwdata          =  proc_hwdata;
//   assign proc_hrdata_la     =  la_hrdata;
//   assign proc_hresp_la      =  la_hresp;
//   assign proc_hready_la     =  la_hready;

// Instanciation of ahb_mpa
// Name of the instance : u_ahb_mpa
// Name of the file containing this module : ahb_mpa.v
ahb_mpa #(.g_addr_width (21)) u_ahb_mpa_la  (
		.clk                    (plf_clk),
		.rst_n                  (plf_rst_n),
		.s0_hready_in           (periph_hready),
		.s0_hsel                (periph_hsel_la),
		.s0_haddr               (periph_haddr[20:0]),
		.s0_htrans              (periph_htrans),
		.s0_hwrite              (periph_hwrite),
		.s0_hsize               (periph_hsize[1:0]),
		.s0_hwdata              (periph_hwdata),
		.s0_hrdata              (periph_hrdata_la),
		.s0_hresp               (periph_hresp_la),
		.s0_hready              (periph_hready_la),

		.s1_hready_in           (dma_hready),
		.s1_hsel                (dma_hsel_la),
		.s1_haddr               (dma_haddr[20:0]),
		.s1_htrans              (dma_htrans),
		.s1_hwrite              (dma_hwrite),
		.s1_hsize               (dma_hsize),
		.s1_hwdata              (dma_hwdata),
		.s1_hrdata              (dma_hrdata_la),
		.s1_hresp               (dma_hresp_la),
		.s1_hready              (dma_hready_la),

		.m_hready_in            (la_hready_in),
		.m_hsel                 (la_hsel),
		.m_haddr                (la_haddr),
		.m_htrans               (la_htrans),
		.m_hwrite               (la_hwrite),
		.m_hsize                (la_hsize),
		.m_hwdata               (la_hwdata),
		.m_hrdata               (la_hrdata),
		.m_hresp                (la_hresp),
		.m_hready               (la_hready)
		);
`else
  assign periph_hrdata_la     =  32'hdeaddead;
  assign periph_hresp_la      =  2'b00;
  assign periph_hready_la     =  1'b1;
`endif // RW_EMBEDDED_LA

`ifdef RW_WLAN_COEX_EN
  /*****************************************************************************
  * packet traffic arbiter
  *****************************************************************************/
  rw_pta u_rw_pta(
    /***************************************************************************
    * Clock And Reset
    ***************************************************************************/
    .pta_nrst                (plf_rst_n               ),
    .pta_clk                 (plf_clk                 ),
    .ahb_nrst                (plf_rst_n               ),
    .ahb_clk                 (plf_clk                 ),
    /***************************************************************************
    * WLAN Coexistence Interface
    ***************************************************************************/
    .coex_wlan_tx            (coex_wlan_tx            ),
    .coex_wlan_rx            (coex_wlan_rx            ),
    .coex_wlan_tx_abort      (coex_wlan_tx_abort      ),
    .coex_wlan_rx_abort      (coex_wlan_rx_abort      ),
    .coex_wlan_pti           (coex_wlan_pti           ),
    .coex_wlan_pti_tog       (coex_wlan_pti_tog       ),
    .coex_wlan_chan_freq     (coex_wlan_chan_freq     ),
    .coex_wlan_chan_bw       (coex_wlan_chan_bw       ),
    .coex_wlan_chan_offset   (coex_wlan_chan_offset   ),
    /***************************************************************************
    * Bluetooth Coexistence Interface
    ***************************************************************************/
    .coex_bt_tx              (coex_bt_tx              ),
    .coex_bt_rx              (coex_bt_rx              ),
    .coex_bt_event           (coex_bt_event           ),
    .coex_bt_tx_abort        (coex_bt_tx_abort        ),
    .coex_bt_rx_abort        (coex_bt_rx_abort        ),
    .coex_bt_pti             (coex_bt_pti             ),
    .coex_bt_channel         (coex_bt_channel         ),
    .coex_bt_bw              (coex_bt_bw              ),
    /***************************************************************************
    * Slave AHB interface
    ***************************************************************************/
    .hready_in               (periph_hready           ),
    .hsel                    (periph_hsel_pta         ),
    .haddr                   (periph_haddr[8:0]       ),
    .htrans                  (periph_htrans           ),
    .hwrite                  (periph_hwrite           ),
    .hwdata                  (periph_hwdata           ),
    .hrdata                  (periph_hrdata_pta       ),
    .hresp                   (periph_hresp_pta        ),
    .hready                  (periph_hready_pta       )
  );
  // Temporary generation of PTI TOG signal
  //    Will be removed when provided by the MAC
  //reg coex_wlan_pti_ff1;
  //reg coex_wlan_pti_tog_ff1;
  //always @(posedge mac_core_clk or negedge mac_core_rst_n)
  //begin
  //   if (mac_core_rst_n == 1'b0)
  //   begin
  //      coex_wlan_pti_ff1     <= 1'b0;
  //      coex_wlan_pti_tog_ff1 <= 1'b0;
  //   end
  //   else
  //   begin
  //      coex_wlan_pti_ff1     <= coex_wlan_pti;
  //      coex_wlan_pti_tog_ff1 <= coex_wlan_pti_tog;
  //   end
  //end
  //assign coex_wlan_pti_tog = (coex_wlan_pti_ff1 == coex_wlan_pti) ? coex_wlan_pti_tog_ff1:
  //                                                                 ~coex_wlan_pti_tog_ff1;

  // Radio Controller Abort
  assign rc_tx_abort = coex_wlan_tx_abort;
  assign rc_rx_abort = coex_wlan_rx_abort;

  // Diagnostic Port
  assign diag_coex = {4'h0                       ,
                      coex_bt_bw                 ,
                      coex_bt_channel[6:0]       ,
                      coex_bt_pti[3:0]           ,
                      coex_bt_rx_abort           ,
                      coex_bt_tx_abort           ,
                      coex_bt_event              ,
                      coex_bt_rx                 ,
                      coex_bt_tx                 ,
                      coex_wlan_chan_offset      ,
                      coex_wlan_chan_bw          ,
                    //coex_wlan_chan_freq[6:0]   , // Static
                      coex_wlan_pti_tog          ,
                      coex_wlan_pti[3:0]         ,
                      coex_wlan_rx_abort         ,
                      coex_wlan_tx_abort         ,
                      coex_wlan_rx               ,
                      coex_wlan_tx               };

`else
  // Radio Controller Abort
  assign rc_tx_abort        = 1'b0;
  assign rc_rx_abort        = 1'b0;

  // Diagnostic Port
  assign diag_coex          = 32'h0;

  // PTA AHB
  assign periph_hrdata_pta  = 32'hdeaddead;
  assign periph_hresp_pta   = 2'b00;
  assign periph_hready_pta  = 1'b1;

`endif // RW_WLAN_COEX_EN

  /*****************************************************************************
  * hardware security unit
  *****************************************************************************/
  rw_hsu u_rw_hsu( 
    /***************************************************************************
    * Clock and reset
    ***************************************************************************/
    .clk         (plf_clk            ),
    .rst_n       (plf_rst_n          ),
    /***************************************************************************
    * Master AHB interface
    ***************************************************************************/
    .m_haddr     (hsu_haddr          ),
    .m_htrans    (hsu_htrans         ),
    .m_hwrite    (hsu_hwrite         ),
    .m_hsize     (hsu_hsize          ),
    .m_hwdata    (hsu_hwdata         ),
    .m_hrdata    (hsu_hrdata         ),
    .m_hresp     (hsu_hresp          ),
    .m_hready    (hsu_hready         ),
    /***************************************************************************
    * Slave AHB interface
    ***************************************************************************/
    .s_hready_in (periph_hready      ),
    .s_hsel      (periph_hsel_hsu    ),
    .s_haddr     (periph_haddr[31:0] ),
    .s_htrans    (periph_htrans      ),
    .s_hwrite    (periph_hwrite      ),
    .s_hsize     (periph_hsize[1:0]  ),
    .s_hwdata    (periph_hwdata      ),
    .s_hrdata    (periph_hrdata_hsu  ),
    .s_hresp     (periph_hresp_hsu   ),
    .s_hready    (periph_hready_hsu  ),
    /***************************************************************************
    * RSA SRAM Interface
    ***************************************************************************/
`ifdef  RW_HSU_RSA_EN
    .sram_addr   (rsa_sram_addr      ),
    .sram_din    (rsa_sram_din       ),
    .sram_rd_en  (rsa_sram_rd_en     ),
    .sram_wr_en  (rsa_sram_wr_en     ),
    .sram_dout   (rsa_sram_dout      ),
`endif//RW_HSU_RSA_EN
    /***************************************************************************
    * Interrupt
    ***************************************************************************/
    .done_irq    (hsu_irq            ),
    /***************************************************************************
    * Debug Port
    ***************************************************************************/
    .debug       (diag_hsu           )
  );

`ifdef  RW_HSU_RSA_EN
assign rsa_sram_en = (|rsa_sram_wr_en) | rsa_sram_rd_en;
`endif//RW_HSU_RSA_EN

`ifdef RW_FPGA_AHB
  /*****************************************************************************
  * AHB to FPGA
  *****************************************************************************/
  assign fpga_hready_in     = periph_hready;
  assign fpga_hsel          = periph_hsel_fpga;
  assign fpga_haddr         = periph_haddr[19:0];
  assign fpga_htrans        = periph_htrans;
  assign fpga_hwrite        = periph_hwrite;
  assign fpga_hwdata        = periph_hwdata;
  assign periph_hrdata_fpga = fpga_hrdata;
  assign periph_hresp_fpga  = fpga_hresp;
  assign periph_hready_fpga = fpga_hready;
`else
  assign periph_hrdata_fpga =  32'hdeaddead;
  assign periph_hresp_fpga  =  2'b00;
  assign periph_hready_fpga =  1'b1;
`endif // RW_FPGA_AHB

  /*****************************************************************************
  * AHB to CRM
  *****************************************************************************/
  assign crm_hready_in     = periph_hready;
  assign crm_hsel          = periph_hsel_crm;
  assign crm_haddr         = periph_haddr[9:0];
  assign crm_htrans        = periph_htrans;
  assign crm_hwrite        = periph_hwrite;
  assign crm_hwdata        = periph_hwdata;
  assign periph_hrdata_crm = crm_hrdata;
  assign periph_hresp_crm  = crm_hresp;
  assign periph_hready_crm = crm_hready;

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
