//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : system controller module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module system_ctrl
( 
  /*****************************************************************************
  * Ssytem
  *****************************************************************************/
  input  wire                  clk,
  input  wire                  rst_n,
  
  /***************************************************************************
  * AHB slave interface
  ***************************************************************************/
  input  wire                  hready_in,
  input  wire                  hsel,
  input  wire [ 9:0]           haddr,
  input  wire [ 1:0]           htrans,
  input  wire                  hwrite,
  input  wire [31:0]           hwdata,
  output reg  [31:0]           hrdata,
  output wire [ 1:0]           hresp,
  output wire                  hready,

  /***************************************************************************
  * registers
  ***************************************************************************/
  input  wire                  nmb_io_busy,
  
  output reg                   reg_bootrom_enable,
  output reg                   reg_diag_sel_en,
  output reg                   reg_diag_mux,
  output reg   [1:0]           reg_diag_sel6,
  output reg   [1:0]           reg_diag_sel5,
  output reg   [1:0]           reg_diag_sel4,
  output reg   [1:0]           reg_diag_sel3,
  output reg   [1:0]           reg_diag_sel2,
  output reg   [1:0]           reg_diag_sel1,
  output reg   [1:0]           reg_diag_sel0,
  output reg   [5:0]           reg_diag_presel6,
  output reg   [5:0]           reg_diag_presel5,
  output reg   [5:0]           reg_diag_presel4,
  output reg   [5:0]           reg_diag_presel3,
  output reg   [5:0]           reg_diag_presel2,
  output reg   [5:0]           reg_diag_presel1,
  output reg   [5:0]           reg_diag_presel0,
  output reg                   reg_diag_trigger,
  output reg                   reg_diag_mpif_mask_en,
  output reg   [5:0]           reg_diag_mpif_hdr_nbr,
  input  wire [31:0]           diag_value,
  output reg                   reg_fpgaa_reset_req,
  output reg                   reg_fpgab_reset_req,
  output reg                   tick_timer_irq,
  output reg                   soft_irq,

  /***************************************************************************
  * Clock Controller
  ***************************************************************************/
  output reg                   reg_sec_mac_pi_tx_clk_gating_en,   // secondary path gating enable
  output reg                   reg_sec_mac_crypt_clk_gating_en,   // secondary path gating enable
  output reg                   reg_sec_mac_core_tx_clk_gating_en, // secondary path gating enable
  output reg                   reg_sec_mpif_clk_gating_en,        // secondary path gating enable
  output reg                   reg_mac_pi_clk_gating_en,          // mac_pi_clk Interface gating enable 
  output reg                   reg_mac_pi_tx_clk_gating_en,       // mac_pi_clk Interface gating enable 
  output reg                   reg_mac_pi_rx_clk_gating_en,       // mac_pi_clk Interface gating enable 
  output reg                   reg_mac_core_clk_gating_en,        // mac_core_clk Interface gating enable 
  output reg                   reg_mac_crypt_clk_gating_en,       // mac_core_clk Interface gating enable 
  output reg                   reg_mac_core_rx_clk_gating_en,     // mac_core_clk Interface gating enable 
  output reg                   reg_mac_core_tx_clk_gating_en,     // mac_core_clk Interface gating enable 
  output reg                   reg_mac_wt_clk_gating_en,          // mac_wt_clk Interface gating enable 
  output reg                   reg_mpif_clk_gating_en,            // mpif_clk Interface gating enable 

  /***************************************************************************
  * gpio
  ***************************************************************************/
  input  wire [31:0]           gpio_in,
  output reg  [31:0]           gpio_out,
  output reg  [31:0]           gpio_oen
);

  /*****************************************************************************
  * Declarations
  *****************************************************************************/
  reg   [31:0]                 gpio_in_1t_resync;
  reg   [31:0]                 gpio_in_2t;
  reg                          pending_write;
  reg   [5:0]                  pending_addr;
  reg   [31:0]                 reserved0;
  reg   [31:0]                 reserved1;
  reg   [31:0]                 current_cycle;
      
  reg                          reg_tick_timer_en;
  reg                          reg_tick_timer_irq_en;
  reg                          reg_tick_timer_irq_set;
  reg                          reg_tick_timer_irq_clr;
  reg   [31:0]                 tick_timer_cnt;
  reg   [31:0]                 reg_tick_timer_duration;
  reg                          reg_soft_irq_set;
  reg                          reg_soft_irq_clr;
  

`ifndef RW_FPGA_SIGNATURE
  `define RW_FPGA_SIGNATURE 32'hc0ffee00
`endif
`ifndef RW_FPGA_DATE
  `define RW_FPGA_DATE 32'h20000101
`endif
`ifndef RW_FPGA_TIME
  `define RW_FPGA_TIME 32'h00000000
`endif
`ifndef RW_FPGA_SVNREV
  `define RW_FPGA_SVNREV 32'h00000000
`endif
`ifndef RW_MAC_SVNREV
  `define RW_MAC_SVNREV 32'h00000000
`endif



  assign hresp  = 2'b00;
  assign hready = 1'b1;
  
  /*****************************************************************************
  * Permanently clocked registers
  *****************************************************************************/
  always @(posedge clk, negedge rst_n)
  begin
  
    if(rst_n==1'b0)
    begin
    
      gpio_out                  <= 32'd0;
      gpio_oen                  <= 32'd0;
      //
      gpio_in_1t_resync         <= 32'd0;
      gpio_in_2t                <= 32'd0;
      //
      hrdata                    <= 32'd0;
      //
      pending_write             <= 1'b0;
      pending_addr              <= 6'd0;
      //
      reserved0                 <= 32'd0;
      reserved1                 <= 32'd0;
      //
      current_cycle             <= 32'd0; 
      
      reg_diag_presel1          <= 6'd33;
      reg_diag_sel1             <= 2'd0;
      reg_diag_presel0          <= 6'd32;
      reg_diag_sel0             <= 2'd0;
      reg_diag_sel_en           <= 1'b0;
      reg_diag_presel3          <= 6'd37;
      reg_diag_sel3             <= 2'd1;
      reg_diag_mux              <= 1'b0;
      reg_diag_presel2          <= 6'd28;
      reg_diag_sel2             <= 2'd1;
      reg_diag_presel5          <= 6'd31;
      reg_diag_sel5             <= 2'd1;
      reg_diag_presel4          <= 6'd30;
      reg_diag_sel4             <= 2'd1;
      reg_diag_presel6          <= 6'd38;
      reg_diag_sel6             <= 2'd0;
      reg_diag_trigger          <= 1'b0;
      reg_diag_mpif_mask_en     <= 1'b0;
      reg_diag_mpif_hdr_nbr     <= 6'd0;
      //
      reg_fpgaa_reset_req       <= 1'b0;
      reg_fpgab_reset_req       <= 1'b1;
      reg_bootrom_enable        <= 1'b0;

      reg_sec_mac_pi_tx_clk_gating_en   <= 1'b0;
      reg_sec_mac_crypt_clk_gating_en   <= 1'b0;
      reg_sec_mac_core_tx_clk_gating_en <= 1'b0;
      reg_sec_mpif_clk_gating_en        <= 1'b0;
      reg_mac_pi_clk_gating_en          <= 1'b0; 
      reg_mac_pi_tx_clk_gating_en       <= 1'b0; 
      reg_mac_pi_rx_clk_gating_en       <= 1'b0; 
      reg_mac_core_clk_gating_en        <= 1'b0; 
      reg_mac_crypt_clk_gating_en       <= 1'b0; 
      reg_mac_core_tx_clk_gating_en     <= 1'b0; 
      reg_mac_core_rx_clk_gating_en     <= 1'b0; 
      reg_mac_wt_clk_gating_en          <= 1'b0; 
      reg_mpif_clk_gating_en            <= 1'b0;  
      
      reg_tick_timer_en                 <= 1'b0;  
      reg_tick_timer_irq_en             <= 1'b0;  
      reg_tick_timer_irq_set            <= 1'b0;  
      reg_tick_timer_irq_clr            <= 1'b0;  
      tick_timer_irq                    <= 1'b0;  
      tick_timer_cnt                    <= 32'b0;  
      reg_tick_timer_duration           <= 32'b0;  

      reg_soft_irq_set            <= 1'b0;  
      reg_soft_irq_clr            <= 1'b0;  
      soft_irq                    <= 1'b0;  
    end
    else
    begin
    
      // current cycle
      current_cycle <= current_cycle + 32'd1;

      if (reg_tick_timer_irq_set)
        tick_timer_irq <= 1'b1;
      else if (reg_tick_timer_irq_clr)
        tick_timer_irq <= 1'b0;

      if (reg_soft_irq_set)
        soft_irq <= 1'b1;
      else if (reg_soft_irq_clr)
        soft_irq <= 1'b0;

      if (reg_tick_timer_en)
      begin
        if (tick_timer_cnt == 32'b0)
        begin
          tick_timer_irq <= reg_tick_timer_irq_en;
          tick_timer_cnt <= reg_tick_timer_duration;
        end  
        else
          tick_timer_cnt <= tick_timer_cnt - 32'b1;
      end    


      reg_tick_timer_irq_set    <= 1'b0;
      reg_tick_timer_irq_clr    <= 1'b0;
      reg_soft_irq_set          <= 1'b0;
      reg_soft_irq_clr          <= 1'b0;

      // resynchronization
      gpio_in_1t_resync         <= gpio_in;
      gpio_in_2t                <= gpio_in_1t_resync;
      
      if(hready_in==1'd1)
      begin
      
        if(pending_write==1'd1)
        begin
        
          pending_write <= 1'd0;
        
          case(pending_addr)
        
            /*******************************************************************
            * current cycle
            *******************************************************************/
            6'b010000: current_cycle    <= hwdata;
                     
            /*******************************************************************
            * tick_timer current counter
            *******************************************************************/
            6'b010001: tick_timer_cnt         <= hwdata;
                     
            /*******************************************************************
            * tick_timer current counter
            *******************************************************************/
            6'b010010: reg_tick_timer_duration <= hwdata;
                     
            /*******************************************************************
            * tick_timer interrupt Set
            *******************************************************************/
            6'b010011: reg_tick_timer_irq_set <= hwdata[0];
                     
            /*******************************************************************
            * tick_timer interrupt Clear
            *******************************************************************/
            6'b010100: reg_tick_timer_irq_clr <= hwdata[0];
                     
            /*******************************************************************
            * tick_timer control
            *******************************************************************/
            6'b010101: {reg_tick_timer_en,reg_tick_timer_irq_en} <= hwdata[1:0];
                     
            /*******************************************************************
            * soft interrupt Set
            *******************************************************************/
            6'b010110: reg_soft_irq_set <= hwdata[0];
                     
            /*******************************************************************
            * soft interrupt Clear
            *******************************************************************/
            6'b010111: reg_soft_irq_clr <= hwdata[0];
                     
            /*******************************************************************
            * Diagport selection
            *******************************************************************/
            6'b011001: 
            begin
               reg_diag_presel1      <= hwdata[29:24];
               reg_diag_sel1         <= hwdata[17:16];
               reg_diag_presel0      <= hwdata[13: 8];
               reg_diag_sel0         <= hwdata[ 1: 0];
            end
            6'b011010: 
            begin
               reg_diag_sel_en       <= hwdata[31];
               reg_diag_presel3      <= hwdata[29:24];
               reg_diag_sel3         <= hwdata[17:16];
               reg_diag_mux          <= hwdata[15];
               reg_diag_presel2      <= hwdata[13: 8];
               reg_diag_sel2         <= hwdata[ 1: 0];
            end
            6'b011100:
            begin
               reg_diag_trigger      <= hwdata[0];
            end
            6'b011101: 
            begin
               reg_diag_presel5      <= hwdata[29:24];
               reg_diag_sel5         <= hwdata[17:16];
               reg_diag_presel4      <= hwdata[13: 8];
               reg_diag_sel4         <= hwdata[ 1: 0];
            end
            6'b011110: 
            begin
               reg_diag_presel6      <= hwdata[13: 8];
               reg_diag_sel6         <= hwdata[ 1: 0];
            end
            6'b011111: 
            begin
               reg_diag_mpif_hdr_nbr <= hwdata[9:4];
               reg_diag_mpif_mask_en <= hwdata[0];
            end
            
            /*******************************************************************
            * GPIO
            *******************************************************************/
            6'b100000: gpio_oen         <= hwdata;
            6'b100001: gpio_out         <= hwdata;

            /*********************************************************************
            * Misc control
            *********************************************************************/
            6'b111000: 
            begin
              
              reg_bootrom_enable                <= hwdata[4];
              reg_fpgab_reset_req               <= hwdata[1];
              reg_fpgaa_reset_req               <= hwdata[0];

              reg_sec_mac_pi_tx_clk_gating_en   <= hwdata[20];
              reg_sec_mac_crypt_clk_gating_en   <= hwdata[19];
              reg_sec_mac_core_tx_clk_gating_en <= hwdata[18];
              reg_sec_mpif_clk_gating_en        <= hwdata[17];
              reg_mac_pi_clk_gating_en          <= hwdata[16]; 
              reg_mac_pi_tx_clk_gating_en       <= hwdata[15]; 
              reg_mac_pi_rx_clk_gating_en       <= hwdata[14]; 
              reg_mac_core_clk_gating_en        <= hwdata[13];
              reg_mac_crypt_clk_gating_en       <= hwdata[12];
              reg_mac_core_tx_clk_gating_en     <= hwdata[11];
              reg_mac_core_rx_clk_gating_en     <= hwdata[10];
              reg_mac_wt_clk_gating_en          <= hwdata[9];
              reg_mpif_clk_gating_en            <= hwdata[8];

             end
           
            /*******************************************************************
            * Reserved
            *******************************************************************/
            6'b111100: reserved0 <= hwdata;
            6'b111101: reserved1 <= hwdata;
            
            default  : ;
            
          endcase
          
        end
      
      end
      
      if(hready_in==1'd1 && hsel==1'd1 && htrans[1]==1'd1)
      begin
      
        if(hwrite==1'd1)
        begin
        
          pending_addr  <= haddr[7:2];
          pending_write <= 1'd1;
          
        end
        else
        begin
        
          hrdata <= 32'd0;
          
          case(haddr[7:2])                                                        
                                                                                  
            /*******************************************************************
            * FPGA signature
            *******************************************************************/
            6'b000000: hrdata    <= `RW_FPGA_SIGNATURE;

            /*******************************************************************
            * FPGA date
            *******************************************************************/
            6'b000001: hrdata    <= `RW_FPGA_DATE;

            /*******************************************************************
            * FPGA time
            *******************************************************************/
            6'b000010: hrdata    <= `RW_FPGA_TIME;

            /*******************************************************************
            * FPGA svnrev
            *******************************************************************/
            6'b000011: hrdata    <= `RW_FPGA_SVNREV;

            /*******************************************************************
            * MAC fpgarev
            *******************************************************************/
            6'b000100: hrdata    <= `RW_MAC_SVNREV;

            /*******************************************************************
            * current cycle
            ********************************************************************/
            6'b010000: hrdata    <= current_cycle;
           
            /*******************************************************************
            * tick_timer current value
            ********************************************************************/
            6'b010001: hrdata    <= tick_timer_cnt;

            /*******************************************************************
            * tick_timer programmed value
            ********************************************************************/
            6'b010010: hrdata    <= reg_tick_timer_duration;

            /*******************************************************************
            * tick_timer interrupt
            ********************************************************************/
            6'b010011: hrdata[0] <= tick_timer_irq;

            /*******************************************************************
            * tick_timer interrupt Clear
            *******************************************************************/

            /*******************************************************************
            * tick_timer control
            *******************************************************************/
            6'b010101: hrdata[1:0] <= {reg_tick_timer_en,reg_tick_timer_irq_en};
                     
            /*******************************************************************
            * soft interrupt
            ********************************************************************/
            6'b010110: hrdata[0] <= soft_irq;

            /*******************************************************************
            * soft interrupt Clear
            *******************************************************************/

            /*********************************************************************
            * Diagport selection                                                  
            *********************************************************************/
            6'b011001:
            begin
               hrdata[29:24] <= reg_diag_presel1;
               hrdata[17:16] <= reg_diag_sel1;
               hrdata[13: 8] <= reg_diag_presel0;
               hrdata[ 1: 0] <= reg_diag_sel0;
            end
            6'b011010: 
            begin
               hrdata[31]    <= reg_diag_sel_en;
               hrdata[29:24] <= reg_diag_presel3;
               hrdata[17:16] <= reg_diag_sel3;
               hrdata[15]    <= reg_diag_mux;
               hrdata[13: 8] <= reg_diag_presel2;
               hrdata[ 1: 0] <= reg_diag_sel2;
            end                     
            6'b011011:
            begin
               hrdata        <= diag_value;
            end                     
            6'b011100: 
            begin
               hrdata[0]     <= reg_diag_trigger;
            end                     
            6'b011101:
            begin
               hrdata[29:24] <= reg_diag_presel5;
               hrdata[17:16] <= reg_diag_sel5;
               hrdata[13: 8] <= reg_diag_presel4;
               hrdata[ 1: 0] <= reg_diag_sel4;
            end
            6'b011110: 
            begin
               hrdata[13: 8] <= reg_diag_presel6;
               hrdata[ 1: 0] <= reg_diag_sel6;
            end
            6'b011111: 
            begin
               hrdata[9:4]   <= reg_diag_mpif_hdr_nbr;
               hrdata[0]     <= reg_diag_mpif_mask_en;
            end
                                                                                  
            /*********************************************************************
            * GPIO                                                                
            *********************************************************************/
            6'b100000: hrdata        <= gpio_oen;                           
            6'b100001: hrdata        <= gpio_out;                           
            6'b100010: hrdata        <= gpio_in_2t;                           
 
            /*********************************************************************
            * Clock control
            *********************************************************************/
            6'b111000:
            begin
               
               hrdata[31] <= nmb_io_busy;
               hrdata[4]  <= reg_bootrom_enable;
               hrdata[1]  <= reg_fpgab_reset_req;
               hrdata[0]  <= reg_fpgaa_reset_req;

               hrdata[20] <= reg_sec_mac_pi_tx_clk_gating_en;
               hrdata[19] <= reg_sec_mac_crypt_clk_gating_en;
               hrdata[18] <= reg_sec_mac_core_tx_clk_gating_en;
               hrdata[17] <= reg_sec_mpif_clk_gating_en;
               hrdata[16] <= reg_mac_pi_clk_gating_en; 
               hrdata[15] <= reg_mac_pi_tx_clk_gating_en; 
               hrdata[14] <= reg_mac_pi_rx_clk_gating_en; 
               hrdata[13] <= reg_mac_core_clk_gating_en; 
               hrdata[12] <= reg_mac_crypt_clk_gating_en; 
               hrdata[11] <= reg_mac_core_tx_clk_gating_en; 
               hrdata[10] <= reg_mac_core_rx_clk_gating_en;
               hrdata[9]  <= reg_mac_wt_clk_gating_en;
               hrdata[8]  <= reg_mpif_clk_gating_en;

            end
            
            /*********************************************************************
            * Reserved0
            *
            * For simulation only
            * [0]  : end of simulation
            * [1]  : enable concurrent NMB accesses from Host
            * [2]  : enable concurrent JTAG accesses
            * [4]  : load frame buffers
            * [8]  : ADC A playback enable
            * [9]  : ADC B playback enable
            * [10] : ADC C playback enable
            *
            *********************************************************************/
            6'b111100: hrdata <= reserved0;
           
            /*********************************************************************
            * Reserved1
            *********************************************************************/
            6'b111101: hrdata <= reserved1;
            
            default:   ;                                                          
                                                                                  
          endcase                                                                 
        
        end
      
      end
    
    end
  
  end



endmodule


