//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission 
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : rw_pta Bit Resynchronisation Block
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module rw_pta_bit_resync(
   ////////////////////////////////
   //$port_g Clock And Reset
   ////////////////////////////////
   input  wire dst_clk,       // Destination Clock
   input  wire dst_nrst,      // Asynchronous Reset (Active Low)
   ////////////////////////////////
   //$port_g Resync Interface
   ////////////////////////////////
   input  wire src_bit,       // Bit To Synchronise
   output wire dst_bit        // Resynchronised Bit
);


//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
reg bit_ff1_resync; // 1st synchronisation register
reg bit_ff2_resync; // 2nd synchronisation register


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////
// Synchronisation Registers
always @(posedge dst_clk or negedge dst_nrst)
begin
   // Asynchronous Reset
   if (dst_nrst == 1'b0)
   begin
      bit_ff1_resync <= 1'b0;
      bit_ff2_resync <= 1'b0;
   end
   //
   else 
   begin
      bit_ff1_resync <= src_bit;
      bit_ff2_resync <= bit_ff1_resync;
   end
end

// Output assignment
assign dst_bit = bit_ff2_resync;

endmodule
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
