//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission 
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : RW PTA WLAN Coexistence Interface Resynchronisation Block
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module rw_pta_coex_wlan_resync(
   ////////////////////////////////
   //$port_g Clock And Reset
   ////////////////////////////////
   input  wire           pta_nrst,                     // Asynchronous Reset (Active Low)
   input  wire           pta_clk,                      // PTA and AHB Clock
   ////////////////////////////////
   //$port_g WLAN Coexistence Input
   ////////////////////////////////
   input  wire           coex_wlan_tx,                 // WLAN Transmission On-going
   input  wire           coex_wlan_rx,                 // WLAN Reception    On-going
   input  wire     [3:0] coex_wlan_pti,                // WLAN Packet Traffic Information
   input  wire           coex_wlan_pti_tog,            // WLAN Packet Traffic Information Qualifier
   input  wire     [6:0] coex_wlan_chan_freq,          // WLAN Primary Channel Center Frequency (12-84MHz)
   input  wire           coex_wlan_chan_bw,            // WLAN Channel Bandwidth (0:20MHz, 1:40MHz)
   input  wire           coex_wlan_chan_offset,        // WLAN Secondary Channel Offset (0:Lower, 1:Upper)
   ////////////////////////////////
   //$port_g WLAN Coexistence Resynchronized
   ////////////////////////////////
   output wire           coex_wlan_tx_sync,            // WLAN Transmission On-going
   output wire           coex_wlan_rx_sync,            // WLAN Reception    On-going
   output reg      [3:0] coex_wlan_pti_sync,           // WLAN Packet Traffic Information
   output wire     [6:0] coex_wlan_chan_freq_sync,     // WLAN Primary Channel Center Frequency (12-84MHz)
   output wire           coex_wlan_chan_bw_sync,       // WLAN Channel Bandwidth (0:20MHz, 1:40MHz)
   output wire           coex_wlan_chan_offset_sync    // WLAN Secondary Channel Offset (0:Lower, 1:Upper)
);


//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
// Resynchronized Signals (after 2nd resync flop)
wire coex_wlan_tx_ff2;      
wire coex_wlan_rx_ff2;      
wire coex_wlan_chan_bw_ff2; 
wire coex_wlan_pti_tog_ff2; 
// Resynchronized Signals (after 3rd flop)
reg  coex_wlan_tx_ff3;      
reg  coex_wlan_rx_ff3;      
reg  coex_wlan_chan_bw_ff3; 
reg  coex_wlan_pti_tog_ff3;

wire coex_wlan_pti_tog_edge; // WLAN PTI Qualifier Edge Detection


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
// Output Assignment
//////////////////////////////////////////////////////////////////////////////
assign coex_wlan_tx_sync      = coex_wlan_tx_ff3;
assign coex_wlan_rx_sync      = coex_wlan_rx_ff3;
assign coex_wlan_chan_bw_sync = coex_wlan_chan_bw_ff3;


//////////////////////////////////////////////////////////////////////////////
// Double Resynchronisation Flop
//////////////////////////////////////////////////////////////////////////////
rw_pta_bit_resync u_coex_wlan_tx_resync(
   .dst_clk  (pta_clk                    ),
   .dst_nrst (pta_nrst                   ),
   .src_bit  (coex_wlan_tx               ),
   .dst_bit  (coex_wlan_tx_ff2           )
);

rw_pta_bit_resync u_coex_wlan_rx_resync(
   .dst_clk  (pta_clk                    ),
   .dst_nrst (pta_nrst                   ),
   .src_bit  (coex_wlan_rx               ),
   .dst_bit  (coex_wlan_rx_ff2           )
);

rw_pta_bit_resync u_coex_wlan_pti_tog_resync(
   .dst_clk  (pta_clk                    ),
   .dst_nrst (pta_nrst                   ),
   .src_bit  (coex_wlan_pti_tog          ),
   .dst_bit  (coex_wlan_pti_tog_ff2      )
);

// coex_wlan_chan_freq Are Not Resynchronised, It should changed when PTA is disabled only.
assign coex_wlan_chan_freq_sync = coex_wlan_chan_freq;

rw_pta_bit_resync u_coex_wlan_chan_bw_resync(
   .dst_clk  (pta_clk                    ),
   .dst_nrst (pta_nrst                   ),
   .src_bit  (coex_wlan_chan_bw          ),
   .dst_bit  (coex_wlan_chan_bw_ff2      )
);

// coex_wlan_chan_offset Are Not Resynchronised, It should changed when PTA is disabled only.
assign coex_wlan_chan_offset_sync = coex_wlan_chan_offset;


//////////////////////////////////////////////////////////////////////////////
// 3rd Synchronization flop
//    Used to aligne signal with the PTI & Channel Information resynchronized
//////////////////////////////////////////////////////////////////////////////
always @(posedge pta_clk or negedge pta_nrst)
begin
   // Asynchronous Reset
   if (pta_nrst == 1'b0)
   begin
      coex_wlan_tx_ff3      <= 1'b0;
      coex_wlan_rx_ff3      <= 1'b0;
      coex_wlan_chan_bw_ff3 <= 1'b0;
      coex_wlan_pti_tog_ff3 <= 1'b0;
   end
   //
   else
   begin
      coex_wlan_tx_ff3      <= coex_wlan_tx_ff2;
      coex_wlan_rx_ff3      <= coex_wlan_rx_ff2;
      coex_wlan_chan_bw_ff3 <= coex_wlan_chan_bw_ff2;
      coex_wlan_pti_tog_ff3 <= coex_wlan_pti_tog_ff2;
   end
end


//////////////////////////////////////////////////////////////////////////////
// PTI Qualifier Edge Detection
//////////////////////////////////////////////////////////////////////////////
assign coex_wlan_pti_tog_edge = coex_wlan_pti_tog_ff3 ^ coex_wlan_pti_tog_ff2;


//////////////////////////////////////////////////////////////////////////////
// PTI Resynchronisation
//    Latch PTI On Qualifier Edge
//////////////////////////////////////////////////////////////////////////////
always @(posedge pta_clk or negedge pta_nrst)
begin
   // Asynchronous Reset
   if (pta_nrst == 1'b0)
   begin
      coex_wlan_pti_sync <= 4'h0;
   end
   //
   else
   begin
      if (coex_wlan_pti_tog_edge == 1'b1)
      begin
         coex_wlan_pti_sync <= coex_wlan_pti;
      end
   end
end

endmodule
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
