//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : RW PTA registers
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
// 
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module rw_pta_reg (
    ////////////////////////////////////////////
    //$port_g Clock and reset
    ////////////////////////////////////////////
    input wire            ahb_nrst,  // AHB Hard Reset
    input wire            ahb_clk,   // AHB clock

    ////////////////////////////////////////////
    // Registers
    ////////////////////////////////////////////
    //$port_g REVISION register.
    input wire [31 : 0] revision               ,// in
    //$port_g STAT_BT_TX register.
    input wire [31 : 0] stat_bt_tx_in,// in
    input wire  stat_bt_tx_in_valid,// in
    //$port_g STAT_BT_TX_ABORT register.
    input wire [31 : 0] stat_bt_tx_abort_in,// in
    input wire  stat_bt_tx_abort_in_valid,// in
    //$port_g STAT_BT_RX register.
    input wire [31 : 0] stat_bt_rx_in,// in
    input wire  stat_bt_rx_in_valid,// in
    //$port_g STAT_BT_RX_ABORT register.
    input wire [31 : 0] stat_bt_rx_abort_in,// in
    input wire  stat_bt_rx_abort_in_valid,// in
    //$port_g STAT_WLAN_TX register.
    input wire [31 : 0] stat_wlan_tx_in,// in
    input wire  stat_wlan_tx_in_valid,// in
    //$port_g STAT_WLAN_TX_ABORT register.
    input wire [31 : 0] stat_wlan_tx_abort_in,// in
    input wire  stat_wlan_tx_abort_in_valid,// in
    //$port_g STAT_WLAN_RX register.
    input wire [31 : 0] stat_wlan_rx_in,// in
    input wire  stat_wlan_rx_in_valid,// in
    //$port_g STAT_WLAN_RX_ABORT register.
    input wire [31 : 0] stat_wlan_rx_abort_in,// in
    input wire  stat_wlan_rx_abort_in_valid,// in
    //
    //$port_g CONFIG register.
    output wire         abortrx_when_tx    ,// out
    output wire         sw_wlan_rx_abort   ,// out
    output wire         sw_wlan_tx_abort   ,// out
    output wire         sw_bt_rx_abort     ,// out
    output wire         sw_bt_tx_abort     ,// out
    output wire [5 : 0] chan_margin        ,// out
    output wire         wlan_pti_mode      ,// out
    output wire         bt_event_mask      ,// out
    output wire         chan_enable        ,// out
    output wire         pti_enable         ,// out
    output wire         no_sim_rx          ,// out
    output wire         no_sim_tx          ,// out
    output wire         basic_priority     ,// out
    output wire         pta_enable         ,// out
    output wire [31 : 0] stat_bt_tx         ,// out
    output wire [31 : 0] stat_bt_tx_abort   ,// out
    output wire [31 : 0] stat_bt_rx         ,// out
    output wire [31 : 0] stat_bt_rx_abort   ,// out
    output wire [31 : 0] stat_wlan_tx       ,// out
    output wire [31 : 0] stat_wlan_tx_abort ,// out
    output wire [31 : 0] stat_wlan_rx       ,// out
    output wire [31 : 0] stat_wlan_rx_abort ,// out

    ////////////////////////////////////////////
    //$port_g Bus interface
    ////////////////////////////////////////////
    input  wire            hready_in,
    input  wire            hsel,
    input  wire [ 8:0]     haddr,
    input  wire [ 1:0]     htrans,
    input  wire            hwrite,
    input  wire [31:0]     hwdata,
    output wire [31:0]     hrdata,
    output wire [ 1:0]     hresp,
    output wire            hready
    );
  
////////////////////////////////////////////////////////////////////////////////
// Port Declaration 
////////////////////////////////////////////////////////////////////////////////

  //////////////////////////////////////////////////////////////////////////////
  // Constants for registers addresses
  //////////////////////////////////////////////////////////////////////////////
  // Register configuration
  

  // Constants for register addresses.
  localparam RW_PTA_REVISION_ADDR_CT            = 7'b0000000;
  localparam RW_PTA_CONFIG_ADDR_CT              = 7'b0000001;
  localparam RW_PTA_STAT_BT_TX_ADDR_CT          = 7'b0000010;
  localparam RW_PTA_STAT_BT_TX_ABORT_ADDR_CT    = 7'b0000011;
  localparam RW_PTA_STAT_BT_RX_ADDR_CT          = 7'b0000100;
  localparam RW_PTA_STAT_BT_RX_ABORT_ADDR_CT    = 7'b0000101;
  localparam RW_PTA_STAT_WLAN_TX_ADDR_CT        = 7'b0000110;
  localparam RW_PTA_STAT_WLAN_TX_ABORT_ADDR_CT  = 7'b0000111;
  localparam RW_PTA_STAT_WLAN_RX_ADDR_CT        = 7'b0001000;
  localparam RW_PTA_STAT_WLAN_RX_ABORT_ADDR_CT  = 7'b0001001;
 
  //////////////////////////////////////////////////////////////////////////////
  // Signals
  //////////////////////////////////////////////////////////////////////////////
  reg  [31: 0] int_reg_dr;
  wire [31: 0] int_reg_dw;
  reg          int_reg_rdy;
  reg          pending_write;
  reg          pending_read;
  reg   [6:0]  pending_addr;

  // CONFIG register.
  reg         int_abortrx_when_tx    ;
  reg         int_sw_wlan_rx_abort   ;
  reg         int_sw_wlan_tx_abort   ;
  reg         int_sw_bt_rx_abort     ;
  reg         int_sw_bt_tx_abort     ;
  reg [5 : 0] int_chan_margin        ;
  reg         int_wlan_pti_mode      ;
  reg         int_bt_event_mask      ;
  reg         int_chan_enable        ;
  reg         int_pti_enable         ;
  reg         int_no_sim_rx          ;
  reg         int_no_sim_tx          ;
  reg         int_basic_priority     ;
  reg         int_pta_enable         ;
  // STAT_BT_TX register.
  reg [31 : 0] int_stat_bt_tx         ;
  // STAT_BT_TX_ABORT register.
  reg [31 : 0] int_stat_bt_tx_abort   ;
  // STAT_BT_RX register.
  reg [31 : 0] int_stat_bt_rx         ;
  // STAT_BT_RX_ABORT register.
  reg [31 : 0] int_stat_bt_rx_abort   ;
  // STAT_WLAN_TX register.
  reg [31 : 0] int_stat_wlan_tx       ;
  // STAT_WLAN_TX_ABORT register.
  reg [31 : 0] int_stat_wlan_tx_abort ;
  // STAT_WLAN_RX register.
  reg [31 : 0] int_stat_wlan_rx       ;
  // STAT_WLAN_RX_ABORT register.
  reg [31 : 0] int_stat_wlan_rx_abort ;


  //////////////////////////////////////////////////////////////////////////////
  // Ouput linkage
  //////////////////////////////////////////////////////////////////////////////
  assign abortrx_when_tx    = int_abortrx_when_tx   ;
  assign sw_wlan_rx_abort   = int_sw_wlan_rx_abort   ;
  assign sw_wlan_tx_abort   = int_sw_wlan_tx_abort   ;
  assign sw_bt_rx_abort     = int_sw_bt_rx_abort     ;
  assign sw_bt_tx_abort     = int_sw_bt_tx_abort     ;
  assign chan_margin        = int_chan_margin        ;
  assign wlan_pti_mode      = int_wlan_pti_mode      ;
  assign bt_event_mask      = int_bt_event_mask      ;
  assign chan_enable        = int_chan_enable        ;
  assign pti_enable         = int_pti_enable         ;
  assign no_sim_rx          = int_no_sim_rx          ;
  assign no_sim_tx          = int_no_sim_tx          ;
  assign basic_priority     = int_basic_priority     ;
  assign pta_enable         = int_pta_enable         ;
  assign stat_bt_tx         = int_stat_bt_tx         ;
  assign stat_bt_tx_abort   = int_stat_bt_tx_abort   ;
  assign stat_bt_rx         = int_stat_bt_rx         ;
  assign stat_bt_rx_abort   = int_stat_bt_rx_abort   ;
  assign stat_wlan_tx       = int_stat_wlan_tx       ;
  assign stat_wlan_tx_abort = int_stat_wlan_tx_abort ;
  assign stat_wlan_rx       = int_stat_wlan_rx       ;
  assign stat_wlan_rx_abort = int_stat_wlan_rx_abort ;


  //////////////////////////////////////////////////////////////////////////////
  // Register write
  //////////////////////////////////////////////////////////////////////////////
  always @(posedge ahb_clk or negedge ahb_nrst)
  begin
    if (!ahb_nrst) 
    begin
      pending_write             <= 1'b0;
      pending_read              <= 1'b0;
      pending_addr              <= 7'b0;
      int_reg_dr                <= 32'b0;
      int_reg_rdy               <= 1'b1;
      // CONFIG register.
      int_abortrx_when_tx     <= 1'b0;
      int_sw_wlan_rx_abort    <= 1'b0;
      int_sw_wlan_tx_abort    <= 1'b0;
      int_sw_bt_rx_abort      <= 1'b0;
      int_sw_bt_tx_abort      <= 1'b0;
      int_chan_margin         <= 6'b000000;
      int_wlan_pti_mode       <= 1'b0;
      int_bt_event_mask       <= 1'b0;
      int_chan_enable         <= 1'b0;
      int_pti_enable          <= 1'b0;
      int_no_sim_rx           <= 1'b0;
      int_no_sim_tx           <= 1'b0;
      int_basic_priority      <= 1'b0;
      int_pta_enable          <= 1'b0;
      // STAT_BT_TX register.
      int_stat_bt_tx          <= 32'b00000000000000000000000000000000;
      // STAT_BT_TX_ABORT register.
      int_stat_bt_tx_abort    <= 32'b00000000000000000000000000000000;
      // STAT_BT_RX register.
      int_stat_bt_rx          <= 32'b00000000000000000000000000000000;
      // STAT_BT_RX_ABORT register.
      int_stat_bt_rx_abort    <= 32'b00000000000000000000000000000000;
      // STAT_WLAN_TX register.
      int_stat_wlan_tx        <= 32'b00000000000000000000000000000000;
      // STAT_WLAN_TX_ABORT register.
      int_stat_wlan_tx_abort  <= 32'b00000000000000000000000000000000;
      // STAT_WLAN_RX register.
      int_stat_wlan_rx        <= 32'b00000000000000000000000000000000;
      // STAT_WLAN_RX_ABORT register.
      int_stat_wlan_rx_abort  <= 32'b00000000000000000000000000000000;
    end
    else
    begin
      int_reg_rdy <= 1'b1;

      if (pending_write==1'b1)
      begin
        
        pending_write <= 1'b0;
        
        case(pending_addr)

          // Write CONFIG register.
          RW_PTA_CONFIG_ADDR_CT :
          begin
              int_abortrx_when_tx     <= int_reg_dw[20];
              int_sw_wlan_rx_abort    <= int_reg_dw[19];
              int_sw_wlan_tx_abort    <= int_reg_dw[18];
              int_sw_bt_rx_abort      <= int_reg_dw[17];
              int_sw_bt_tx_abort      <= int_reg_dw[16];
              int_chan_margin         <= int_reg_dw[13 : 8];
              int_wlan_pti_mode       <= int_reg_dw[7];
              int_bt_event_mask       <= int_reg_dw[6];
              int_chan_enable         <= int_reg_dw[5];
              int_pti_enable          <= int_reg_dw[4];
              int_no_sim_rx           <= int_reg_dw[3];
              int_no_sim_tx           <= int_reg_dw[2];
              int_basic_priority      <= int_reg_dw[1];
              int_pta_enable          <= int_reg_dw[0];
          end

          // Write STAT_BT_TX register.
          RW_PTA_STAT_BT_TX_ADDR_CT :
          begin
              int_stat_bt_tx          <= int_reg_dw[31 : 0];
          end

          // Write STAT_BT_TX_ABORT register.
          RW_PTA_STAT_BT_TX_ABORT_ADDR_CT :
          begin
              int_stat_bt_tx_abort    <= int_reg_dw[31 : 0];
          end

          // Write STAT_BT_RX register.
          RW_PTA_STAT_BT_RX_ADDR_CT :
          begin
              int_stat_bt_rx          <= int_reg_dw[31 : 0];
          end

          // Write STAT_BT_RX_ABORT register.
          RW_PTA_STAT_BT_RX_ABORT_ADDR_CT :
          begin
              int_stat_bt_rx_abort    <= int_reg_dw[31 : 0];
          end

          // Write STAT_WLAN_TX register.
          RW_PTA_STAT_WLAN_TX_ADDR_CT :
          begin
              int_stat_wlan_tx        <= int_reg_dw[31 : 0];
          end

          // Write STAT_WLAN_TX_ABORT register.
          RW_PTA_STAT_WLAN_TX_ABORT_ADDR_CT :
          begin
              int_stat_wlan_tx_abort  <= int_reg_dw[31 : 0];
          end

          // Write STAT_WLAN_RX register.
          RW_PTA_STAT_WLAN_RX_ADDR_CT :
          begin
              int_stat_wlan_rx        <= int_reg_dw[31 : 0];
          end

          // Write STAT_WLAN_RX_ABORT register.
          RW_PTA_STAT_WLAN_RX_ABORT_ADDR_CT :
          begin
              int_stat_wlan_rx_abort  <= int_reg_dw[31 : 0];
          end
        
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : 
          begin
          end
          // pragma coverage block = on 

        endcase
      end

      if (pending_read==1'b1)
      begin
        
        pending_read <= 1'b0;
        int_reg_dr   <= 32'b0;
        
        case(pending_addr)

        // Read REVISION register.
        RW_PTA_REVISION_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= revision;
        end

        // Read CONFIG register.
        RW_PTA_CONFIG_ADDR_CT :
        begin
          int_reg_dr[20]            <= abortrx_when_tx;
          int_reg_dr[19]            <= sw_wlan_rx_abort;
          int_reg_dr[18]            <= sw_wlan_tx_abort;
          int_reg_dr[17]            <= sw_bt_rx_abort;
          int_reg_dr[16]            <= sw_bt_tx_abort;
          int_reg_dr[13 : 8]        <= chan_margin;
          int_reg_dr[7]             <= wlan_pti_mode;
          int_reg_dr[6]             <= bt_event_mask;
          int_reg_dr[5]             <= chan_enable;
          int_reg_dr[4]             <= pti_enable;
          int_reg_dr[3]             <= no_sim_rx;
          int_reg_dr[2]             <= no_sim_tx;
          int_reg_dr[1]             <= basic_priority;
          int_reg_dr[0]             <= pta_enable;
        end

        // Read STAT_BT_TX register.
        RW_PTA_STAT_BT_TX_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= stat_bt_tx;
        end

        // Read STAT_BT_TX_ABORT register.
        RW_PTA_STAT_BT_TX_ABORT_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= stat_bt_tx_abort;
        end

        // Read STAT_BT_RX register.
        RW_PTA_STAT_BT_RX_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= stat_bt_rx;
        end

        // Read STAT_BT_RX_ABORT register.
        RW_PTA_STAT_BT_RX_ABORT_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= stat_bt_rx_abort;
        end

        // Read STAT_WLAN_TX register.
        RW_PTA_STAT_WLAN_TX_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= stat_wlan_tx;
        end

        // Read STAT_WLAN_TX_ABORT register.
        RW_PTA_STAT_WLAN_TX_ABORT_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= stat_wlan_tx_abort;
        end

        // Read STAT_WLAN_RX register.
        RW_PTA_STAT_WLAN_RX_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= stat_wlan_rx;
        end

        // Read STAT_WLAN_RX_ABORT register.
        RW_PTA_STAT_WLAN_RX_ABORT_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= stat_wlan_rx_abort;
        end
        
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : int_reg_dr <= 32'b0;
          // pragma coverage block = on 

        endcase
      end

      // Pulse generation
      // Hardware update
        if (stat_bt_tx_in_valid)
          int_stat_bt_tx          <= stat_bt_tx_in;
        if (stat_bt_tx_abort_in_valid)
          int_stat_bt_tx_abort    <= stat_bt_tx_abort_in;
        if (stat_bt_rx_in_valid)
          int_stat_bt_rx          <= stat_bt_rx_in;
        if (stat_bt_rx_abort_in_valid)
          int_stat_bt_rx_abort    <= stat_bt_rx_abort_in;
        if (stat_wlan_tx_in_valid)
          int_stat_wlan_tx        <= stat_wlan_tx_in;
        if (stat_wlan_tx_abort_in_valid)
          int_stat_wlan_tx_abort  <= stat_wlan_tx_abort_in;
        if (stat_wlan_rx_in_valid)
          int_stat_wlan_rx        <= stat_wlan_rx_in;
        if (stat_wlan_rx_abort_in_valid)
          int_stat_wlan_rx_abort  <= stat_wlan_rx_abort_in;

      if(hready_in==1'b1 && hsel==1'b1 && htrans[1]==1'b1)
      begin
        if(hwrite==1'b1)
        begin
          pending_addr  <= haddr[8:2];
          pending_write <= 1'b1;
        end
        else
        begin
          pending_addr  <= haddr[8:2];
          pending_read  <= 1'b1;
          int_reg_rdy   <= 1'b0;
        end
      end
    end
  end




  //////////////////////////////////////////////////////////////////////////////
  // Read data 
  //////////////////////////////////////////////////////////////////////////////
  assign  hrdata     = int_reg_dr;

  //////////////////////////////////////////////////////////////////////////////
  // Write data 
  //////////////////////////////////////////////////////////////////////////////
  assign  int_reg_dw = hwdata;

  assign  hready = int_reg_rdy;
  assign  hresp  = 2'b0;

`ifdef RW_ASSERT_ON

//$rw_sva Checks no write is fired while read is active
property enable_and_select_prop; 
@(posedge hclk)
  disable iff(hreset_n==0)
  reg_enable |-> reg_sel;
endproperty
enable_and_select: assert property (enable_and_select_prop);

`endif // RW_ASSERT_ON
  
endmodule

////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////

