//  Copyright (C) by CEVA.
//  This module is a confidential and proprietary property of CEVA
//  and a possession or use of this module requires written permission 
//  from CEVA.
//----------------------------------------------------------------------------
// $Author: $
// Company          : CEVA
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : This block . 
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none


module eigen (
      ///////////////////////////////////////////////
      //$port_g Modem clock inputs
      ///////////////////////////////////////////////
      input  wire                 BFRModemClk,
      input  wire                 nBFRModemRst,
      

      ///////////////////////////////////////////////
      //$port_g Inputs from  hermitian matrix.
      ///////////////////////////////////////////////
      input wire        [11:0]    hM11,
      input wire        [11:0]    hM22,
      input wire signed [12:0]    hMRe12,
      input wire signed [12:0]    hMIm12,
      input wire                  hMVld,
	    input wire        [3:0]     hMScale,
	    
	    ///////////////////////////////////////////////
            //$port_g Outputs
            ///////////////////////////////////////////////
	    output reg        [23:0]   eigenDelta2Data,
	    output reg        [12:0]   eigenBtildeData,
	    output reg                 eigenDelta2Valid,
	    output reg        [3:0]    eigenMscale
       
            );
	    
	    
reg [12:0]  addM11M22;
reg [12:0]  bTilde; 
reg [23:0]  multiM11M22;
reg [25:0]  multiMRe12MRe12;   
reg [25:0]  multiMIm12MIm12;
reg [24:0]  bTilde2;	

reg [1:0]   cnt;
reg [23:0]  multiM11M22Reg;
reg [25:0]  multiMRe12MRe12Reg;   
reg [25:0]  multiMIm12MIm12Reg;
reg [25:0]  cTilde;
reg [24:0]  bTilde2Reg;
reg [25:0]  delta2;



always @(posedge BFRModemClk or negedge nBFRModemRst)
begin
  if (nBFRModemRst == 1'b0)
  begin
       cnt <= 2'b0;
  end
  else if ( hMVld == 1'b1 && cnt == 2'b0)
  begin   
       cnt <= 2'b1;
  end 
  else if ( cnt != 2'b0 )
  begin   
       cnt <= cnt + 2'd1;
  end  
  else 
  begin   
       cnt <= 2'd0;
  end  
end

///////////////////////////////////////////////
// Adder Stage
///////////////////////////////////////////////
always @(posedge BFRModemClk or negedge nBFRModemRst)
begin
  if (nBFRModemRst == 1'b0)
   begin   
      eigenDelta2Valid   <= 1'b0;
      eigenDelta2Data    <= 24'h0;
      cTilde             <= 26'h0;
      delta2             <= 26'h0;
   end
 else 
  begin
      case (cnt)
      2'h0: begin
          eigenDelta2Valid <= 1'b0;
        end
      2'h1: begin
         cTilde <= (  -(multiMRe12MRe12Reg + multiMIm12MIm12Reg) + {2'd0,multiM11M22Reg});
        end
      2'h2: begin
          delta2 <=  {1'b0,bTilde2Reg} - cTilde;
        end
      default: begin // 2'h3
          eigenDelta2Valid <= 1'b1;
          eigenDelta2Data <= delta2[23:0];
        end
      endcase
  end
end           


///////////////////////////////////////////////
// Register multiplier & adder outputs
///////////////////////////////////////////////
always @(posedge BFRModemClk or negedge nBFRModemRst)
begin
  if (nBFRModemRst == 1'b0)
  begin
      eigenBtildeData    <= 13'h0;
      multiM11M22Reg     <= 24'h0;
      multiMRe12MRe12Reg <= 26'h0;   
      multiMIm12MIm12Reg <= 26'h0;
      bTilde2Reg         <= 25'h0;
      eigenMscale        <= 4'h0;
  end
  else if ((hMVld == 1'b1) && (cnt == 2'b0))
  begin
      eigenBtildeData    <= bTilde;
      multiM11M22Reg     <= multiM11M22;
      multiMRe12MRe12Reg <= multiMRe12MRe12;   
      multiMIm12MIm12Reg <= multiMIm12MIm12;
      eigenMscale        <= hMScale;
  end
  else if (cnt == 2'd1)
  begin
     bTilde2Reg          <= bTilde2;
  end
end    
///////////////////////////////////////////////
// Adder 
///////////////////////////////////////////////

always @* 
begin
	addM11M22     =  {1'b0,hM11} + {1'b0,hM22};
  //divide by two and round.
  bTilde        = {1'b0,addM11M22[12:1]} + {12'd0,addM11M22[0]};
end

///////////////////////////////////////////////
// multiplier 
///////////////////////////////////////////////

always @* 
begin
	multiM11M22     =  {12'd0,hM11}*{12'd0,hM22};
end

always @* 
begin
	multiMRe12MRe12 =  {{13{hMRe12[12]}},hMRe12}*{{13{hMRe12[12]}},hMRe12};	
end

always @* 
begin
	multiMIm12MIm12 =  {{13{hMIm12[12]}},hMIm12}*{{13{hMIm12[12]}},hMIm12};
end

always @* 
begin
	bTilde2 =  {12'd0,eigenBtildeData}*{12'd0,eigenBtildeData};
end

	    	    
endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////	    
	    
