//  Copyright (C) by CEVA.
//  This module is a confidential and proprietary property of CEVA
//  and a possession or use of this module requires written permission 
//  from CEVA.
//----------------------------------------------------------------------------
// $Author: $
// Company          : CEVA
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : This block scales the hermitian matrix M and provides
//                    a parallel output. 
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none


module hermitianBlock (
            ///////////////////////////////////////////////
            //$port_g Modem clock inputs
            ///////////////////////////////////////////////
            input  wire           BFRModemClk,
            input  wire           nBFRModemRst,
            
            ///////////////////////////////////////////////
            //$port_g H memory input
            ///////////////////////////////////////////////
            input  wire   [12:0]  HMemIFRdDataRe11,
            input  wire   [12:0]  HMemIFRdDataIm11,
            input  wire   [12:0]  HMemIFRdDataRe12,
            input  wire   [12:0]  HMemIFRdDataIm12,
`ifdef RW_TXRX_2X2
            input  wire   [12:0]  HMemIFRdDataRe21,
            input  wire   [12:0]  HMemIFRdDataIm21,
            input  wire   [12:0]  HMemIFRdDataRe22,
            input  wire   [12:0]  HMemIFRdDataIm22,
`endif // RW_TXRX_2X2
//`ifdef RW_MUMIMO_RX_EN
            input  wire   [12:0]  HMemIFRdDataRe13,
            input  wire   [12:0]  HMemIFRdDataIm13,
            input  wire   [12:0]  HMemIFRdDataRe14,
            input  wire   [12:0]  HMemIFRdDataIm14,
`ifdef RW_TXRX_2X2
            input  wire   [12:0]  HMemIFRdDataRe23,
            input  wire   [12:0]  HMemIFRdDataIm23,
            input  wire   [12:0]  HMemIFRdDataRe24,
            input  wire   [12:0]  HMemIFRdDataIm24,
`endif // RW_TXRX_2X2
//`endif // RW_MUMIMO_RX_EN
            input  wire           HMemRdDataVld,
            
            ///////////////////////////////////////////////
            //$port_g H control input
            ///////////////////////////////////////////////
            input  wire [1:0]     HNrSel,

            ///////////////////////////////////////////////
            //$port_g Scaled hermitian matrix output.
            ///////////////////////////////////////////////
            output wire [11:0]    M11,
`ifdef RW_TXRX_2X2
            output wire [11:0]    M22,
            output wire [12:0]    MRe12,
            output wire [12:0]    MIm12,
`endif // RW_TXRX_2X2
            output wire [3:0]     MScale
            );

wire [26:0]     Mxy;
wire            MxyVld;
wire [1:0]      MxyId;


hermitianMatrix i_hermitianMatrix(
            ///////////////////////////////////////////////
            //$port_g Modem clock inputs
            ///////////////////////////////////////////////
            .BFRModemClk   (BFRModemClk),
            .nBFRModemRst  (nBFRModemRst),
            
            ///////////////////////////////////////////////
            //$port_g H memory input
            ///////////////////////////////////////////////
            .HRe11          (HMemIFRdDataRe11),    
            .HIm11          (HMemIFRdDataIm11),
            .HRe12          (HMemIFRdDataRe12),
            .HIm12          (HMemIFRdDataIm12),
`ifdef RW_TXRX_2X2
            .HRe22          (HMemIFRdDataRe22),
            .HIm22          (HMemIFRdDataIm22),
            .HRe21          (HMemIFRdDataRe21),
            .HIm21          (HMemIFRdDataIm21),
`endif //  RW_TXRX_2X2
//`ifdef RW_MUMIMO_RX_EN
            .HRe14          (HMemIFRdDataRe14),
            .HIm14          (HMemIFRdDataIm14),
            .HRe13          (HMemIFRdDataRe13),
            .HIm13          (HMemIFRdDataIm13),
`ifdef RW_TXRX_2X2
            .HRe24          (HMemIFRdDataRe24),
            .HIm24          (HMemIFRdDataIm24),
            .HRe23          (HMemIFRdDataRe23),
            .HIm23          (HMemIFRdDataIm23),
`endif //  RW_TXRX_2X2
//`endif // RW_MUMIMO_RX_EN
            .HMemRdDataVld  (HMemRdDataVld),

            ///////////////////////////////////////////////
            //$port_g H control input
            ///////////////////////////////////////////////
            .HNrSel        (HNrSel),

            ///////////////////////////////////////////////
            //$port_g Full adder output
            ///////////////////////////////////////////////
            .Mxy           (Mxy),
            .MxyVld        (MxyVld),
            .MxyId         (MxyId)
            
            );

hermitianScale i_hermitianScale(
            ///////////////////////////////////////////////
            //$port_g Modem clock inputs
            ///////////////////////////////////////////////
            .BFRModemClk   (BFRModemClk),
            .nBFRModemRst  (nBFRModemRst),
            
            ///////////////////////////////////////////////
            //$port_g Sub-carrier matrix input
            ///////////////////////////////////////////////
            .Mxy     (Mxy),
            .MxyVld  (MxyVld),
            .MxyId   (MxyId),

            ///////////////////////////////////////////////
            //$port_g Scaled hermitian matrix output.
            ///////////////////////////////////////////////
            .M11     (M11),
`ifdef RW_TXRX_2X2
            .M22     (M22),
            .MRe12   (MRe12),
            .MIm12   (MIm12),
`endif //  RW_TXRX_2X2
            .MScale  (MScale)
            );

endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////



