//  Copyright (C) by CEVA.
//  This module is a confidential and proprietary property of CEVA
//  and a possession or use of this module requires written permission 
//  from CEVA.
//----------------------------------------------------------------------------
// $Author: $
// Company          : CEVA
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : 
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none


module hermitianMatrix (
            ///////////////////////////////////////////////
            //$port_g Modem clock inputs
            ///////////////////////////////////////////////
            input  wire           BFRModemClk,
            input  wire           nBFRModemRst,
            
            ///////////////////////////////////////////////
            //$port_g H memory input
            ///////////////////////////////////////////////
            input  wire    [12:0] HRe11,
            input  wire    [12:0] HIm11,
            input  wire    [12:0] HRe12,
            input  wire    [12:0] HIm12,
`ifdef RW_TXRX_2X2
            input  wire    [12:0] HRe21,
            input  wire    [12:0] HIm21,
            input  wire    [12:0] HRe22,
            input  wire    [12:0] HIm22,
`endif // RW_TXRX_2X2
//`ifdef RW_MUMIMO_RX_EN
            input  wire    [12:0] HRe13,
            input  wire    [12:0] HIm13,
            input  wire    [12:0] HRe14,
            input  wire    [12:0] HIm14,
`ifdef RW_TXRX_2X2
            input  wire    [12:0] HRe23,
            input  wire    [12:0] HIm23,
            input  wire    [12:0] HRe24,
            input  wire    [12:0] HIm24,
`endif // RW_TXRX_2X2
//`endif // RW_MUMIMO_RX_EN
            input  wire           HMemRdDataVld,

            ///////////////////////////////////////////////
            //$port_g H control input
            ///////////////////////////////////////////////
            input  wire [1:0]     HNrSel,

            ///////////////////////////////////////////////
            //$port_g Sub-carrier matrix input
            ///////////////////////////////////////////////
            output reg [26:0]     Mxy,
            output reg            MxyVld,
            output reg [1:0]      MxyId
            
            );

localparam NR_UNSUPPORTED = 2'd0, NR2 = 2'd1, NR3 = 2'd2, NR4 = 2'd3; // Nr index = Nr-1

reg [12:0]      multAInA; 
reg [12:0]      multAInB; 
reg [12:0]      multBInA; 
reg [12:0]      multBInB; 
reg [12:0]      multCInA; 
reg [12:0]      multCInB; 
reg [12:0]      multDInA; 
reg [12:0]      multDInB; 

wire [25:0]     multAOut;
wire [25:0]     multBOut;
wire [25:0]     multCOut;
wire [25:0]     multDOut;

reg  [25:0]     multAOutReg;
reg  [25:0]     multBOutReg;
reg  [25:0]     multCOutReg;
reg  [25:0]     multDOutReg;

//`ifdef RW_MUMIMO_RX_EN
reg [12:0]      multEInA; 
reg [12:0]      multEInB; 
reg [12:0]      multFInA; 
reg [12:0]      multFInB; 
reg [12:0]      multGInA; 
reg [12:0]      multGInB; 
reg [12:0]      multHInA; 
reg [12:0]      multHInB; 

wire [25:0]     multEOut;
wire [25:0]     multFOut;
wire [25:0]     multGOut;
wire [25:0]     multHOut;

reg  [25:0]     multEOutReg;
reg  [25:0]     multFOutReg;
reg  [25:0]     multGOutReg;
reg  [25:0]     multHOutReg;
//`endif

reg           multMxyVld;
reg           multMxyVldInt;
reg [1:0]     multMxyId;
reg           addMxyVld;
reg [1:0]     addMxyId;


///////////////////////////////////////////////
// Control logic
///////////////////////////////////////////////
always @(posedge BFRModemClk or negedge nBFRModemRst)
begin
  if (nBFRModemRst == 1'b0)
  begin
      multMxyVldInt <= 1'b0;
      multMxyId     <= 2'h0;
  end
  else if (HMemRdDataVld == 1'b1)
  begin
      multMxyVldInt <= 1'b1;
      multMxyId     <= 2'h1;
  end
  // elaborate control for arbitrary H matrix size here. 
  // Increase bit width of xMxyId to match all scenarios
  else if (multMxyId != 2'h0)
  begin
      if (multMxyId == 2'h3)
          multMxyVldInt <= 1'b0;
      else
          multMxyVldInt <= 1'b1;
      
      multMxyId     <= multMxyId + 2'd1;
  end
  else
  begin
      multMxyVldInt <= 1'b0;
  end
end

always @*
begin
    multMxyVld = multMxyVldInt | HMemRdDataVld;
end

///////////////////////////////////////////////
// Generate multiplier input
///////////////////////////////////////////////
always @* 
begin
    multAInA  = 13'h0;
    multAInB  = 13'h0;
    multBInA  = 13'h0;
    multBInB  = 13'h0;
    multCInA  = 13'h0;
    multCInB  = 13'h0;
    multDInA  = 13'h0;
    multDInB  = 13'h0;
//`ifdef RW_MUMIMO_RX_EN
    multEInA  = 13'h0;
    multEInB  = 13'h0;
    multFInA  = 13'h0;
    multFInB  = 13'h0;
    multGInA  = 13'h0;
    multGInB  = 13'h0;
    multHInA  = 13'h0;
    multHInB  = 13'h0;
//`endif
  case (multMxyId)
  default: begin // 2'h0
      multAInA  = HRe11;
      multAInB  = HRe11;
      multBInA  = HIm11;
      multBInB  = HIm11;
      if (HNrSel >= NR2) begin
          multCInA  = HRe12;
          multCInB  = HRe12;
          multDInA  = HIm12;
          multDInB  = HIm12;
      end
//`ifdef RW_MUMIMO_RX_EN
      if (HNrSel >= NR3) begin
          multEInA  = HRe13;
          multEInB  = HRe13;
          multFInA  = HIm13;
          multFInB  = HIm13;
      end
      if (HNrSel == NR4) begin
          multGInA  = HRe14;
          multGInB  = HRe14;
          multHInA  = HIm14;
          multHInB  = HIm14;
      end
//`endif      
    end
`ifdef RW_TXRX_2X2
  2'h1: begin
      multAInA  = HRe21;
      multAInB  = HRe21;
      multBInA  = HIm21;
      multBInB  = HIm21;
      if (HNrSel >= NR2) begin
          multCInA  = HRe22;
          multCInB  = HRe22;
          multDInA  = HIm22;
          multDInB  = HIm22;
      end
//`ifdef RW_MUMIMO_RX_EN
      if (HNrSel >= NR3) begin
          multEInA  = HRe23;
          multEInB  = HRe23;
          multFInA  = HIm23;
          multFInB  = HIm23;
      end
      if (HNrSel == NR4) begin
          multGInA  = HRe24;
          multGInB  = HRe24;
          multHInA  = HIm24;
          multHInB  = HIm24;
      end
//`endif
    end
  2'h2: begin
      multAInA  = HRe11;
      multAInB  = HRe21;
      multBInA  = HIm11;
      multBInB  = HIm21;
      if (HNrSel >= NR2) begin
          multCInA  = HRe12;
          multCInB  = HRe22;
          multDInA  = HIm12;
          multDInB  = HIm22;
      end
//`ifdef RW_MUMIMO_RX_EN
      if (HNrSel >= NR3) begin
          multEInA  = HRe13;
          multEInB  = HRe23;
          multFInA  = HIm13;
          multFInB  = HIm23;
      end
      if (HNrSel == NR4) begin
          multGInA  = HRe14;
          multGInB  = HRe24;
          multHInA  = HIm14;
          multHInB  = HIm24;
      end
//`endif
    end
  2'h3: begin
      multAInA  = HIm11;
      multAInB  = HRe21;
      multBInA  = HRe11;
      multBInB  = HIm21;
      if (HNrSel >= NR2) begin
          multCInA  = HIm12;
          multCInB  = HRe22;
          multDInA  = HRe12;
          multDInB  = HIm22;
      end
//`ifdef RW_MUMIMO_RX_EN
      if (HNrSel >= NR3) begin
          multEInA  = HIm13;
          multEInB  = HRe23;
          multFInA  = HRe13;
          multFInB  = HIm23;
      end
      if (HNrSel == NR4) begin
          multGInA  = HIm14;
          multGInB  = HRe24;
          multHInA  = HRe14;
          multHInB  = HIm24;
      end
//`endif
    end
`endif    
  endcase
end


///////////////////////////////////////////////
// Register multiplier outputs
///////////////////////////////////////////////
always @(posedge BFRModemClk or negedge nBFRModemRst)
begin
  if (nBFRModemRst == 1'b0)
  begin
      multAOutReg <= 26'h0;
      multBOutReg <= 26'h0;
      multCOutReg <= 26'h0;
      multDOutReg <= 26'h0;
//`ifdef RW_MUMIMO_RX_EN
      multEOutReg <= 26'h0;
      multFOutReg <= 26'h0;
      multGOutReg <= 26'h0;
      multHOutReg <= 26'h0;
//`endif      
      addMxyVld   <= 1'b0;
      addMxyId    <= 2'h0;
  end
  else if (multMxyVld == 1'b1)
  begin
      multAOutReg <= multAOut;
      multBOutReg <= multBOut;
      multCOutReg <= multCOut;
      multDOutReg <= multDOut;
//`ifdef RW_MUMIMO_RX_EN
      multEOutReg <= multEOut;
      multFOutReg <= multFOut;
      multGOutReg <= multGOut;
      multHOutReg <= multHOut;
//`endif      
      addMxyVld   <= 1'b1;
      addMxyId    <= multMxyId;
  end
  else
  begin
      addMxyVld   <= 1'b0;
  end
end


///////////////////////////////////////////////
// Adder Stage
///////////////////////////////////////////////
always @(posedge BFRModemClk or negedge nBFRModemRst)
begin
  if (nBFRModemRst == 1'b0)
  begin
      Mxy      <= 27'h0;
      MxyVld   <= 1'b0;
      MxyId    <= 2'h0;
  end
  else if (addMxyVld == 1'b1)
  begin
      case (addMxyId)
      2'h0: begin
          Mxy <= {multAOutReg[25],multAOutReg} + {multBOutReg[25],multBOutReg} + {multCOutReg[25],multCOutReg} + {multDOutReg[25],multDOutReg}
//`ifdef RW_MUMIMO_RX_EN
               + {multEOutReg[25],multEOutReg} + {multFOutReg[25],multFOutReg} + {multGOutReg[25],multGOutReg} + {multHOutReg[25],multHOutReg}
//`endif      
               ;
        end
      2'h1: begin
          Mxy <= {multAOutReg[25],multAOutReg} + {multBOutReg[25],multBOutReg} + {multCOutReg[25],multCOutReg} + {multDOutReg[25],multDOutReg}
//`ifdef RW_MUMIMO_RX_EN
               + {multEOutReg[25],multEOutReg} + {multFOutReg[25],multFOutReg} + {multGOutReg[25],multGOutReg} + {multHOutReg[25],multHOutReg}
//`endif      
               ;
        end
      2'h2: begin
          Mxy <= {multAOutReg[25],multAOutReg} + {multBOutReg[25],multBOutReg} + {multCOutReg[25],multCOutReg} + {multDOutReg[25],multDOutReg}
//`ifdef RW_MUMIMO_RX_EN
               + {multEOutReg[25],multEOutReg} + {multFOutReg[25],multFOutReg} + {multGOutReg[25],multGOutReg} + {multHOutReg[25],multHOutReg}
//`endif      
               ;
        end
      default: begin // 2'h3
          Mxy <= {multAOutReg[25],multAOutReg} - {multBOutReg[25],multBOutReg} + {multCOutReg[25],multCOutReg} - {multDOutReg[25],multDOutReg}
//`ifdef RW_MUMIMO_RX_EN
               + {multEOutReg[25],multEOutReg} - {multFOutReg[25],multFOutReg} + {multGOutReg[25],multGOutReg} - {multHOutReg[25],multHOutReg}
//`endif      
               ;
        end
      endcase
      MxyVld   <= 1'b1;
      MxyId    <= addMxyId;
  end
  else
  begin
      MxyVld   <= 1'b0;
  end
end


///////////////////////////////////////////////
// multiplier block instantiations
///////////////////////////////////////////////
mult13x13 multA(
            .dataA(multAInA),
            .dataB(multAInB),

            .product(multAOut)
            );

mult13x13 multB(
            .dataA(multBInA),
            .dataB(multBInB),

            .product(multBOut)
            );

mult13x13 multC(
            .dataA(multCInA),
            .dataB(multCInB),

            .product(multCOut)
            );

mult13x13 multD(
            .dataA(multDInA),
            .dataB(multDInB),

            .product(multDOut)
            );

//`ifdef RW_MUMIMO_RX_EN
mult13x13 multE(
            .dataA(multEInA),
            .dataB(multEInB),

            .product(multEOut)
            );

mult13x13 multF(
            .dataA(multFInA),
            .dataB(multFInB),

            .product(multFOut)
            );

mult13x13 multG(
            .dataA(multGInA),
            .dataB(multGInB),

            .product(multGOut)
            );

mult13x13 multH(
            .dataA(multHInA),
            .dataB(multHInB),

            .product(multHOut)
            );
//`endif
endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////



