//  Copyright (C) by CEVA.
//  This module is a confidential and proprietary property of CEVA
//  and a possession or use of this module requires written permission 
//  from CEVA.
//----------------------------------------------------------------------------
// $Author: $
// Company          : CEVA
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : This block multiplies two signed 13 bit numbers.
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

 
module mult13x13 (
            ///////////////////////////////////////////////
            //$port_g Multiplier inputs
            ///////////////////////////////////////////////
            input wire signed [12:0]   dataA,
            input wire signed [12:0]   dataB,

            ///////////////////////////////////////////////
            //$port_g Multiplier output
            ///////////////////////////////////////////////
            output wire signed [25:0]   product
            );
  
  assign product = {{13{dataA[12]}},dataA} * {{13{dataB[12]}},dataB};
  
endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////



