//  Copyright (C) by CEVA.
//  This module is a confidential and proprietary property of CEVA
//  and a possession or use of this module requires written permission 
//  from CEVA.
//----------------------------------------------------------------------------
// $Author: $
// Company          : CEVA
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :  
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none


module hmemif # (parameter HAWIDTH = 10) (
        ///////////////////////////////////////////////
        //$port_g Modem clock inputs
        ///////////////////////////////////////////////
        input  wire                BFRModemClk,
        input  wire                nBFRModemRst,
            
        ///////////////////////////////////////////////
        //$port_g Inputs 
        ///////////////////////////////////////////////
        input wire        [1:0]    cfgNg,
        input wire        [1:0]    cfgChBw,
        input wire        [1:0]    cfgNr,
        input wire                 cfgHe,
        input  wire       [5:0]    cfgHeRUStartIndex,
        input  wire       [5:0]    cfgHeRUEndIndex,

//`ifdef RW_MUMIMO_RX_EN
  `ifdef RW_TXRX_2X2
        input wire [207:0]         HMemRdData, // RW_MUMIMO_RX_EN and RW_TXRX_2X2 
  `else
        input wire [103:0]         HMemRdData, // RW_MUMIMO_RX_EN and not RW_TXRX_2X2
  `endif // RW_TXRX_2X2
//`else
//        input wire [103:0]         HMemRdData, // not RW_MUMIMO_RX_EN (and RW_TXRX_2X2)
//`endif // RW_MUMIMO_RX_EN  
        input wire                 HMemRDataVld,
        input wire                 HMemActive,
        input wire                 tctlAdvance,           //Input from the Hermitian Matrix block
        input wire                 tctlStart,             // Start processing.
        input wire                 tctlStop,
        
        ///////////////////////////////////////////////
        //$port_g Outputs
        ///////////////////////////////////////////////
        output reg  [HAWIDTH-1:0]  HMemRAddr,
        output reg                 HMemREn,            
        output reg                 HMemIfRdDataVld,   
        output reg                 HMemDone,
        output reg           [7:0] HMemNs,
//`ifdef RW_MUMIMO_RX_EN
        output reg         [12:0]  HMemIFRdDataRe13,
        output reg         [12:0]  HMemIFRdDataIm13,
        output reg         [12:0]  HMemIFRdDataRe14,
        output reg         [12:0]  HMemIFRdDataIm14,
//`endif // RW_MUMIMO_RX_EN
`ifdef RW_TXRX_2X2
        output reg         [12:0]  HMemIFRdDataRe21,
        output reg         [12:0]  HMemIFRdDataIm21,
        output reg         [12:0]  HMemIFRdDataRe22,
        output reg         [12:0]  HMemIFRdDataIm22,
`endif // RW_TXRX_2X2
//`ifdef RW_MUMIMO_RX_EN
`ifdef RW_TXRX_2X2
        output reg         [12:0]  HMemIFRdDataRe23,
        output reg         [12:0]  HMemIFRdDataIm23,
        output reg         [12:0]  HMemIFRdDataRe24,
        output reg         [12:0]  HMemIFRdDataIm24,
`endif // RW_TXRX_2X2
//`endif // RW_MUMIMO_RX_EN
        output reg         [12:0]  HMemIFRdDataRe11,
        output reg         [12:0]  HMemIFRdDataIm11,
        output reg         [12:0]  HMemIFRdDataRe12,
        output reg         [12:0]  HMemIFRdDataIm12
        );


localparam BW20 = 2'd0, BW40 = 2'd1, BW80 = 2'd2, BW_UNSUPP = 2'd3;
localparam GR1 = 2'd0, GR2 = 2'd1, GR4 = 2'd2, GR_INVALID = 2'd3;
localparam NR_UNSUPPORTED = 2'd0, NR2 = 2'd1, NR3 = 2'd2, NR4 = 2'd3; // Nr index = Nr-1

// Constants to adjust to HAWIDTH
localparam [9:0] W10_MINUS122 = -10'd122;
localparam [9:0] W10_MINUS120 = -10'd120;
localparam [9:0] W10_MINUS116 = -10'd116;
localparam [9:0] W10_MINUS102 = -10'd102;
localparam [9:0] W10_MINUS84  = -10'd84;
localparam [9:0] W10_MINUS74  = -10'd74;
localparam [9:0] W10_MINUS68  = -10'd68;
localparam [9:0] W10_MINUS58  = -10'd58;
localparam [9:0] W10_MINUS52  = -10'd52;
localparam [9:0] W10_MINUS38  = -10'd38;
localparam [9:0] W10_MINUS28  = -10'd28;
localparam [9:0] W10_MINUS24  = -10'd24;
localparam [9:0] W10_MINUS20  = -10'd20;
localparam [9:0] W10_MINUS10  = -10'd10;
localparam [9:0] W10_MINUS6   = -10'd6;
localparam [9:0] W10_MINUS4   = -10'd4;
localparam [9:0] W10_MINUS2   = -10'd2;
localparam [9:0] W10_MINUS1   = -10'd1;
localparam [9:0] W10_ZERO     =  10'd0;
localparam [9:0] W10_PLUS1    =  10'd1;
localparam [9:0] W10_PLUS2    =  10'd2;
localparam [9:0] W10_PLUS4    =  10'd4;
localparam [9:0] W10_PLUS8    =  10'd8;
localparam [9:0] W10_PLUS12   =  10'd12;
localparam [9:0] W10_PLUS16   =  10'd16;
localparam [9:0] W10_PLUS22   =  10'd22;
localparam [9:0] W10_PLUS26   =  10'd26;
localparam [9:0] W10_PLUS40   =  10'd40;
localparam [9:0] W10_PLUS36   =  10'd36;
localparam [9:0] W10_PLUS54   =  10'd54;
localparam [9:0] W10_PLUS68   =  10'd68;
localparam [9:0] W10_PLUS76   =  10'd76;
localparam [9:0] W10_PLUS104  =  10'd104;
localparam [9:0] W10_PLUS122  =  10'd122;


// Wires to decode H memory mapping
wire  [12:0]  HMemDecRdDataRe11;
wire  [12:0]  HMemDecRdDataIm11;
wire  [12:0]  HMemDecRdDataRe12;
wire  [12:0]  HMemDecRdDataIm12;
//`ifdef RW_MUMIMO_RX_EN  
wire  [12:0]  HMemDecRdDataRe13;
wire  [12:0]  HMemDecRdDataIm13;
wire  [12:0]  HMemDecRdDataRe14;
wire  [12:0]  HMemDecRdDataIm14;
//`endif // RW_MUMIMO_RX_EN  
`ifdef RW_TXRX_2X2
wire  [12:0]  HMemDecRdDataRe21;
wire  [12:0]  HMemDecRdDataIm21;
wire  [12:0]  HMemDecRdDataRe22;
wire  [12:0]  HMemDecRdDataIm22;
//`ifdef RW_MUMIMO_RX_EN  
wire  [12:0]  HMemDecRdDataRe23;
wire  [12:0]  HMemDecRdDataIm23;
wire  [12:0]  HMemDecRdDataRe24;
wire  [12:0]  HMemDecRdDataIm24;
//`endif // RW_MUMIMO_RX_EN  
`endif // RW_TXRX_2X2


reg [HAWIDTH-1:0] subCarrierCntNext;
reg               rdEn;

reg [HAWIDTH-1:0] NextEndAddr;
reg [HAWIDTH-1:0] EndAddr;
reg [7:0]         HMemNsNext;

// Arrays for HE start address depending on BW, Grouping and RU index
wire   [9:0] start_index_mhz20_he[0:1][0:15];
// BW 20, grouping by 4
assign start_index_mhz20_he[0][0]  = -10'd122;
assign start_index_mhz20_he[0][1]  = -10'd96;
assign start_index_mhz20_he[0][2]  = -10'd68;
assign start_index_mhz20_he[0][3]  = -10'd44;
assign start_index_mhz20_he[0][4]  = -10'd16;
assign start_index_mhz20_he[0][5]  =  10'd16;
assign start_index_mhz20_he[0][6]  =  10'd40;
assign start_index_mhz20_he[0][7]  =  10'd68;
assign start_index_mhz20_he[0][8]  =  10'd96;
assign start_index_mhz20_he[0][9]  =  10'd0;
assign start_index_mhz20_he[0][10] =  10'd0;
assign start_index_mhz20_he[0][11] =  10'd0;
assign start_index_mhz20_he[0][12] =  10'd0;
assign start_index_mhz20_he[0][13] =  10'd0;
assign start_index_mhz20_he[0][14] =  10'd0;
assign start_index_mhz20_he[0][15] =  10'd0;
// BW 20, grouping by 16
assign start_index_mhz20_he[1][0]  = -10'd122;
assign start_index_mhz20_he[1][1]  = -10'd96;
assign start_index_mhz20_he[1][2]  = -10'd80;
assign start_index_mhz20_he[1][3]  = -10'd52;
assign start_index_mhz20_he[1][4]  = -10'd20;
assign start_index_mhz20_he[1][5]  =  10'd4;
assign start_index_mhz20_he[1][6]  =  10'd32;
assign start_index_mhz20_he[1][7]  =  10'd64;
assign start_index_mhz20_he[1][8]  =  10'd84;
assign start_index_mhz20_he[1][9]  =  10'd0;
assign start_index_mhz20_he[1][10] =  10'd0;
assign start_index_mhz20_he[1][11] =  10'd0;
assign start_index_mhz20_he[1][12] =  10'd0;
assign start_index_mhz20_he[1][13] =  10'd0;
assign start_index_mhz20_he[1][14] =  10'd0;
assign start_index_mhz20_he[1][15] =  10'd0;

wire   [9:0] start_index_mhz40_he[0:1][0:31];
// BW 40, grouping by 4
assign start_index_mhz40_he[0][0]  = -10'd244;
assign start_index_mhz40_he[0][1]  = -10'd220;
assign start_index_mhz40_he[0][2]  = -10'd192;
assign start_index_mhz40_he[0][3]  = -10'd164;
assign start_index_mhz40_he[0][4]  = -10'd136;
assign start_index_mhz40_he[0][5]  = -10'd112;
assign start_index_mhz40_he[0][6]  = -10'd84; 
assign start_index_mhz40_he[0][7]  = -10'd56; 
assign start_index_mhz40_he[0][8]  = -10'd32; 
assign start_index_mhz40_he[0][9]  =  10'd4;  
assign start_index_mhz40_he[0][10] =  10'd28;
assign start_index_mhz40_he[0][11] =  10'd56; 
assign start_index_mhz40_he[0][12] =  10'd84; 
assign start_index_mhz40_he[0][13] =  10'd108;
assign start_index_mhz40_he[0][14] =  10'd136;
assign start_index_mhz40_he[0][15] =  10'd164;
assign start_index_mhz40_he[0][16] =  10'd192;
assign start_index_mhz40_he[0][17] =  10'd216;
assign start_index_mhz40_he[0][18] =  10'd0;
assign start_index_mhz40_he[0][19] =  10'd0;
assign start_index_mhz40_he[0][20] =  10'd0;
assign start_index_mhz40_he[0][21] =  10'd0;
assign start_index_mhz40_he[0][22] =  10'd0;
assign start_index_mhz40_he[0][23] =  10'd0;
assign start_index_mhz40_he[0][24] =  10'd0;
assign start_index_mhz40_he[0][25] =  10'd0;
assign start_index_mhz40_he[0][26] =  10'd0;
assign start_index_mhz40_he[0][27] =  10'd0;
assign start_index_mhz40_he[0][28] =  10'd0;
assign start_index_mhz40_he[0][29] =  10'd0;
assign start_index_mhz40_he[0][30] =  10'd0;
assign start_index_mhz40_he[0][31] =  10'd0;
// BW 40, grouping by 16
assign start_index_mhz40_he[1][0]  = -10'd244;
assign start_index_mhz40_he[1][1]  = -10'd228;
assign start_index_mhz40_he[1][2]  = -10'd196;
assign start_index_mhz40_he[1][3]  = -10'd164;
assign start_index_mhz40_he[1][4]  = -10'd148;
assign start_index_mhz40_he[1][5]  = -10'd116;
assign start_index_mhz40_he[1][6]  = -10'd84; 
assign start_index_mhz40_he[1][7]  = -10'd68; 
assign start_index_mhz40_he[1][8]  = -10'd36; 
assign start_index_mhz40_he[1][9]  =  10'd4;  
assign start_index_mhz40_he[1][10] =  10'd20;
assign start_index_mhz40_he[1][11] =  10'd52; 
assign start_index_mhz40_he[1][12] =  10'd84; 
assign start_index_mhz40_he[1][13] =  10'd100;
assign start_index_mhz40_he[1][14] =  10'd132;
assign start_index_mhz40_he[1][15] =  10'd164;
assign start_index_mhz40_he[1][16] =  10'd180;
assign start_index_mhz40_he[1][17] =  10'd212;
assign start_index_mhz40_he[1][18] =  10'd0;
assign start_index_mhz40_he[1][19] =  10'd0;
assign start_index_mhz40_he[1][20] =  10'd0;
assign start_index_mhz40_he[1][21] =  10'd0;
assign start_index_mhz40_he[1][22] =  10'd0;
assign start_index_mhz40_he[1][23] =  10'd0;
assign start_index_mhz40_he[1][24] =  10'd0;
assign start_index_mhz40_he[1][25] =  10'd0;
assign start_index_mhz40_he[1][26] =  10'd0;
assign start_index_mhz40_he[1][27] =  10'd0;
assign start_index_mhz40_he[1][28] =  10'd0;
assign start_index_mhz40_he[1][29] =  10'd0;
assign start_index_mhz40_he[1][30] =  10'd0;
assign start_index_mhz40_he[1][31] =  10'd0;

wire   [9:0] start_index_mhz80_he[0:1][0:63];
// BW 80, grouping by 4
assign start_index_mhz80_he[0][0]  = -10'd500;
assign start_index_mhz80_he[0][1]  = -10'd476;
assign start_index_mhz80_he[0][2]  = -10'd448;
assign start_index_mhz80_he[0][3]  = -10'd420;
assign start_index_mhz80_he[0][4]  = -10'd392;
assign start_index_mhz80_he[0][5]  = -10'd368;
assign start_index_mhz80_he[0][6]  = -10'd340;
assign start_index_mhz80_he[0][7]  = -10'd312;
assign start_index_mhz80_he[0][8]  = -10'd288;
assign start_index_mhz80_he[0][9]  = -10'd260;
assign start_index_mhz80_he[0][10] = -10'd232;
assign start_index_mhz80_he[0][11] = -10'd204;
assign start_index_mhz80_he[0][12] = -10'd180;
assign start_index_mhz80_he[0][13] = -10'd152;
assign start_index_mhz80_he[0][14] = -10'd124;
assign start_index_mhz80_he[0][15] = -10'd100;
assign start_index_mhz80_he[0][16] = -10'd72;
assign start_index_mhz80_he[0][17] = -10'd44;
assign start_index_mhz80_he[0][18] = -10'd16;
assign start_index_mhz80_he[0][19] =  10'd16;
assign start_index_mhz80_he[0][20] =  10'd44;
assign start_index_mhz80_he[0][21] =  10'd72;
assign start_index_mhz80_he[0][22] =  10'd96;
assign start_index_mhz80_he[0][23] =  10'd124;
assign start_index_mhz80_he[0][24] =  10'd152;
assign start_index_mhz80_he[0][25] =  10'd176;
assign start_index_mhz80_he[0][26] =  10'd204;
assign start_index_mhz80_he[0][27] =  10'd232;
assign start_index_mhz80_he[0][28] =  10'd260;
assign start_index_mhz80_he[0][29] =  10'd284;
assign start_index_mhz80_he[0][30] =  10'd312;
assign start_index_mhz80_he[0][31] =  10'd340;
assign start_index_mhz80_he[0][32] =  10'd364;
assign start_index_mhz80_he[0][33] =  10'd392;
assign start_index_mhz80_he[0][34] =  10'd420;
assign start_index_mhz80_he[0][35] =  10'd448;
assign start_index_mhz80_he[0][36] =  10'd472;
assign start_index_mhz80_he[0][37] =  10'd0;
assign start_index_mhz80_he[0][38] =  10'd0;
assign start_index_mhz80_he[0][39] =  10'd0;
assign start_index_mhz80_he[0][40] =  10'd0;
assign start_index_mhz80_he[0][41] =  10'd0;
assign start_index_mhz80_he[0][42] =  10'd0;
assign start_index_mhz80_he[0][43] =  10'd0;
assign start_index_mhz80_he[0][44] =  10'd0;
assign start_index_mhz80_he[0][45] =  10'd0;
assign start_index_mhz80_he[0][46] =  10'd0;
assign start_index_mhz80_he[0][47] =  10'd0;
assign start_index_mhz80_he[0][48] =  10'd0;
assign start_index_mhz80_he[0][49] =  10'd0;
assign start_index_mhz80_he[0][50] =  10'd0;
assign start_index_mhz80_he[0][51] =  10'd0;
assign start_index_mhz80_he[0][52] =  10'd0;
assign start_index_mhz80_he[0][53] =  10'd0;
assign start_index_mhz80_he[0][54] =  10'd0;
assign start_index_mhz80_he[0][55] =  10'd0;
assign start_index_mhz80_he[0][56] =  10'd0;
assign start_index_mhz80_he[0][57] =  10'd0;
assign start_index_mhz80_he[0][58] =  10'd0;
assign start_index_mhz80_he[0][59] =  10'd0;
assign start_index_mhz80_he[0][60] =  10'd0;
assign start_index_mhz80_he[0][61] =  10'd0;
assign start_index_mhz80_he[0][62] =  10'd0;
assign start_index_mhz80_he[0][63] =  10'd0;
// BW 80, grouping by 16
assign start_index_mhz80_he[1][0]  = -10'd500;
assign start_index_mhz80_he[1][1]  = -10'd484;
assign start_index_mhz80_he[1][2]  = -10'd452;
assign start_index_mhz80_he[1][3]  = -10'd420;
assign start_index_mhz80_he[1][4]  = -10'd404;
assign start_index_mhz80_he[1][5]  = -10'd372;
assign start_index_mhz80_he[1][6]  = -10'd340;
assign start_index_mhz80_he[1][7]  = -10'd324;
assign start_index_mhz80_he[1][8]  = -10'd292;
assign start_index_mhz80_he[1][9]  = -10'd260;
assign start_index_mhz80_he[1][10] = -10'd244;
assign start_index_mhz80_he[1][11] = -10'd212;
assign start_index_mhz80_he[1][12] = -10'd180;
assign start_index_mhz80_he[1][13] = -10'd164;
assign start_index_mhz80_he[1][14] = -10'd132;
assign start_index_mhz80_he[1][15] = -10'd100;
assign start_index_mhz80_he[1][16] = -10'd84;
assign start_index_mhz80_he[1][17] = -10'd52;
assign start_index_mhz80_he[1][18] = -10'd20;
assign start_index_mhz80_he[1][19] =  10'd4;
assign start_index_mhz80_he[1][20] =  10'd36;
assign start_index_mhz80_he[1][21] =  10'd68;
assign start_index_mhz80_he[1][22] =  10'd84;
assign start_index_mhz80_he[1][23] =  10'd116;
assign start_index_mhz80_he[1][24] =  10'd148;
assign start_index_mhz80_he[1][25] =  10'd164;
assign start_index_mhz80_he[1][26] =  10'd196;
assign start_index_mhz80_he[1][27] =  10'd228;
assign start_index_mhz80_he[1][28] =  10'd260;
assign start_index_mhz80_he[1][29] =  10'd276;
assign start_index_mhz80_he[1][30] =  10'd308;
assign start_index_mhz80_he[1][31] =  10'd340;
assign start_index_mhz80_he[1][32] =  10'd356;
assign start_index_mhz80_he[1][33] =  10'd388;
assign start_index_mhz80_he[1][34] =  10'd420;
assign start_index_mhz80_he[1][35] =  10'd436;
assign start_index_mhz80_he[1][36] =  10'd468;
assign start_index_mhz80_he[1][37] =  10'd0;
assign start_index_mhz80_he[1][38] =  10'd0;
assign start_index_mhz80_he[1][39] =  10'd0;
assign start_index_mhz80_he[1][40] =  10'd0;
assign start_index_mhz80_he[1][41] =  10'd0;
assign start_index_mhz80_he[1][42] =  10'd0;
assign start_index_mhz80_he[1][43] =  10'd0;
assign start_index_mhz80_he[1][44] =  10'd0;
assign start_index_mhz80_he[1][45] =  10'd0;
assign start_index_mhz80_he[1][46] =  10'd0;
assign start_index_mhz80_he[1][47] =  10'd0;
assign start_index_mhz80_he[1][48] =  10'd0;
assign start_index_mhz80_he[1][49] =  10'd0;
assign start_index_mhz80_he[1][50] =  10'd0;
assign start_index_mhz80_he[1][51] =  10'd0;
assign start_index_mhz80_he[1][52] =  10'd0;
assign start_index_mhz80_he[1][53] =  10'd0;
assign start_index_mhz80_he[1][54] =  10'd0;
assign start_index_mhz80_he[1][55] =  10'd0;
assign start_index_mhz80_he[1][56] =  10'd0;
assign start_index_mhz80_he[1][57] =  10'd0;
assign start_index_mhz80_he[1][58] =  10'd0;
assign start_index_mhz80_he[1][59] =  10'd0;
assign start_index_mhz80_he[1][60] =  10'd0;
assign start_index_mhz80_he[1][61] =  10'd0;
assign start_index_mhz80_he[1][62] =  10'd0;
assign start_index_mhz80_he[1][63] =  10'd0;

// Arrays for HE end address depending on BW, Grouping and RU index
wire   [9:0] end_index_mhz20_he[0:1][0:15];
// BW 20, grouping by 4
assign end_index_mhz20_he[0][0]  = -10'd96;
assign end_index_mhz20_he[0][1]  = -10'd68;
assign end_index_mhz20_he[0][2]  = -10'd40;
assign end_index_mhz20_he[0][3]  = -10'd16;
assign end_index_mhz20_he[0][4]  =  10'd16;
assign end_index_mhz20_he[0][5]  =  10'd44;
assign end_index_mhz20_he[0][6]  =  10'd68;
assign end_index_mhz20_he[0][7]  =  10'd96;
assign end_index_mhz20_he[0][8]  =  10'd122;
assign end_index_mhz20_he[0][9]  =  10'd0;
assign end_index_mhz20_he[0][10] =  10'd0;
assign end_index_mhz20_he[0][11] =  10'd0;
assign end_index_mhz20_he[0][12] =  10'd0;
assign end_index_mhz20_he[0][13] =  10'd0;
assign end_index_mhz20_he[0][14] =  10'd0;
assign end_index_mhz20_he[0][15] =  10'd0;
// BW 20, grouping by 16
assign end_index_mhz20_he[1][0]  = -10'd84;
assign end_index_mhz20_he[1][1]  = -10'd64;
assign end_index_mhz20_he[1][2]  = -10'd32;
assign end_index_mhz20_he[1][3]  = -10'd4;
assign end_index_mhz20_he[1][4]  =  10'd20;
assign end_index_mhz20_he[1][5]  =  10'd52;
assign end_index_mhz20_he[1][6]  =  10'd80;
assign end_index_mhz20_he[1][7]  =  10'd96;
assign end_index_mhz20_he[1][8]  =  10'd122;
assign end_index_mhz20_he[1][9]  =  10'd0;
assign end_index_mhz20_he[1][10] =  10'd0;
assign end_index_mhz20_he[1][11] =  10'd0;
assign end_index_mhz20_he[1][12] =  10'd0;
assign end_index_mhz20_he[1][13] =  10'd0;
assign end_index_mhz20_he[1][14] =  10'd0;
assign end_index_mhz20_he[1][15] =  10'd0;

wire   [9:0] end_index_mhz40_he[0:1][0:31];
// BW 40, grouping by 4
assign end_index_mhz40_he[0][0]  = -10'd216;
assign end_index_mhz40_he[0][1]  = -10'd192;
assign end_index_mhz40_he[0][2]  = -10'd164;
assign end_index_mhz40_he[0][3]  = -10'd136;
assign end_index_mhz40_he[0][4]  = -10'd108;
assign end_index_mhz40_he[0][5]  = -10'd84;
assign end_index_mhz40_he[0][6]  = -10'd56;
assign end_index_mhz40_he[0][7]  = -10'd28;
assign end_index_mhz40_he[0][8]  = -10'd4;
assign end_index_mhz40_he[0][9]  =  10'd32;
assign end_index_mhz40_he[0][10] =  10'd56;
assign end_index_mhz40_he[0][11] =  10'd84;
assign end_index_mhz40_he[0][12] =  10'd112;
assign end_index_mhz40_he[0][13] =  10'd136;
assign end_index_mhz40_he[0][14] =  10'd164;
assign end_index_mhz40_he[0][15] =  10'd192;
assign end_index_mhz40_he[0][16] =  10'd220;
assign end_index_mhz40_he[0][17] =  10'd244;
assign end_index_mhz40_he[0][18] =  10'd0;
assign end_index_mhz40_he[0][19] =  10'd0;
assign end_index_mhz40_he[0][20] =  10'd0;
assign end_index_mhz40_he[0][21] =  10'd0;
assign end_index_mhz40_he[0][22] =  10'd0;
assign end_index_mhz40_he[0][23] =  10'd0;
assign end_index_mhz40_he[0][24] =  10'd0;
assign end_index_mhz40_he[0][25] =  10'd0;
assign end_index_mhz40_he[0][26] =  10'd0;
assign end_index_mhz40_he[0][27] =  10'd0;
assign end_index_mhz40_he[0][28] =  10'd0;
assign end_index_mhz40_he[0][29] =  10'd0;
assign end_index_mhz40_he[0][30] =  10'd0;
assign end_index_mhz40_he[0][31] =  10'd0;
// BW 40, grouping by 16
assign end_index_mhz40_he[1][0]  = -10'd212;
assign end_index_mhz40_he[1][1]  = -10'd180;
assign end_index_mhz40_he[1][2]  = -10'd164;
assign end_index_mhz40_he[1][3]  = -10'd132;
assign end_index_mhz40_he[1][4]  = -10'd100;
assign end_index_mhz40_he[1][5]  = -10'd84;
assign end_index_mhz40_he[1][6]  = -10'd52;
assign end_index_mhz40_he[1][7]  = -10'd20;
assign end_index_mhz40_he[1][8]  = -10'd4; 
assign end_index_mhz40_he[1][9]  =  10'd36;
assign end_index_mhz40_he[1][10] =  10'd68;
assign end_index_mhz40_he[1][11] =  10'd84;
assign end_index_mhz40_he[1][12] =  10'd116;
assign end_index_mhz40_he[1][13] =  10'd148;
assign end_index_mhz40_he[1][14] =  10'd164;
assign end_index_mhz40_he[1][15] =  10'd196;
assign end_index_mhz40_he[1][16] =  10'd228;
assign end_index_mhz40_he[1][17] =  10'd244;
assign end_index_mhz40_he[1][18] =  10'd0;
assign end_index_mhz40_he[1][19] =  10'd0;
assign end_index_mhz40_he[1][20] =  10'd0;
assign end_index_mhz40_he[1][21] =  10'd0;
assign end_index_mhz40_he[1][22] =  10'd0;
assign end_index_mhz40_he[1][23] =  10'd0;
assign end_index_mhz40_he[1][24] =  10'd0;
assign end_index_mhz40_he[1][25] =  10'd0;
assign end_index_mhz40_he[1][26] =  10'd0;
assign end_index_mhz40_he[1][27] =  10'd0;
assign end_index_mhz40_he[1][28] =  10'd0;
assign end_index_mhz40_he[1][29] =  10'd0;
assign end_index_mhz40_he[1][30] =  10'd0;
assign end_index_mhz40_he[1][31] =  10'd0;

wire   [9:0] end_index_mhz80_he[0:1][0:63];
// BW 80, grouping by 4
assign end_index_mhz80_he[0][0]  = -10'd472;
assign end_index_mhz80_he[0][1]  = -10'd448;
assign end_index_mhz80_he[0][2]  = -10'd420;
assign end_index_mhz80_he[0][3]  = -10'd392;
assign end_index_mhz80_he[0][4]  = -10'd364;
assign end_index_mhz80_he[0][5]  = -10'd340;
assign end_index_mhz80_he[0][6]  = -10'd312;
assign end_index_mhz80_he[0][7]  = -10'd284;
assign end_index_mhz80_he[0][8]  = -10'd260;
assign end_index_mhz80_he[0][9]  = -10'd232;
assign end_index_mhz80_he[0][10] = -10'd204;
assign end_index_mhz80_he[0][11] = -10'd176;
assign end_index_mhz80_he[0][12] = -10'd152;
assign end_index_mhz80_he[0][13] = -10'd124;
assign end_index_mhz80_he[0][14] = -10'd96;
assign end_index_mhz80_he[0][15] = -10'd72;
assign end_index_mhz80_he[0][16] = -10'd44;
assign end_index_mhz80_he[0][17] = -10'd16;
assign end_index_mhz80_he[0][18] =  10'd16;
assign end_index_mhz80_he[0][19] =  10'd44;
assign end_index_mhz80_he[0][20] =  10'd72;
assign end_index_mhz80_he[0][21] =  10'd100;
assign end_index_mhz80_he[0][22] =  10'd124;
assign end_index_mhz80_he[0][23] =  10'd152;
assign end_index_mhz80_he[0][24] =  10'd180;
assign end_index_mhz80_he[0][25] =  10'd204;
assign end_index_mhz80_he[0][26] =  10'd232;
assign end_index_mhz80_he[0][27] =  10'd260;
assign end_index_mhz80_he[0][28] =  10'd288;
assign end_index_mhz80_he[0][29] =  10'd312;
assign end_index_mhz80_he[0][30] =  10'd340;
assign end_index_mhz80_he[0][31] =  10'd368;
assign end_index_mhz80_he[0][32] =  10'd392;
assign end_index_mhz80_he[0][33] =  10'd420;
assign end_index_mhz80_he[0][34] =  10'd448;
assign end_index_mhz80_he[0][35] =  10'd476;
assign end_index_mhz80_he[0][36] =  10'd500;
assign end_index_mhz80_he[0][37] =  10'd0;
assign end_index_mhz80_he[0][38] =  10'd0;
assign end_index_mhz80_he[0][39] =  10'd0;
assign end_index_mhz80_he[0][40] =  10'd0;
assign end_index_mhz80_he[0][41] =  10'd0;
assign end_index_mhz80_he[0][42] =  10'd0;
assign end_index_mhz80_he[0][43] =  10'd0;
assign end_index_mhz80_he[0][44] =  10'd0;
assign end_index_mhz80_he[0][45] =  10'd0;
assign end_index_mhz80_he[0][46] =  10'd0;
assign end_index_mhz80_he[0][47] =  10'd0;
assign end_index_mhz80_he[0][48] =  10'd0;
assign end_index_mhz80_he[0][49] =  10'd0;
assign end_index_mhz80_he[0][50] =  10'd0;
assign end_index_mhz80_he[0][51] =  10'd0;
assign end_index_mhz80_he[0][52] =  10'd0;
assign end_index_mhz80_he[0][53] =  10'd0;
assign end_index_mhz80_he[0][54] =  10'd0;
assign end_index_mhz80_he[0][55] =  10'd0;
assign end_index_mhz80_he[0][56] =  10'd0;
assign end_index_mhz80_he[0][57] =  10'd0;
assign end_index_mhz80_he[0][58] =  10'd0;
assign end_index_mhz80_he[0][59] =  10'd0;
assign end_index_mhz80_he[0][60] =  10'd0;
assign end_index_mhz80_he[0][61] =  10'd0;
assign end_index_mhz80_he[0][62] =  10'd0;
assign end_index_mhz80_he[0][63] =  10'd0;
// BW 80, grouping by 16
assign end_index_mhz80_he[1][0]  = -10'd468;
assign end_index_mhz80_he[1][1]  = -10'd436;
assign end_index_mhz80_he[1][2]  = -10'd420;
assign end_index_mhz80_he[1][3]  = -10'd388;
assign end_index_mhz80_he[1][4]  = -10'd356;
assign end_index_mhz80_he[1][5]  = -10'd340;
assign end_index_mhz80_he[1][6]  = -10'd308;
assign end_index_mhz80_he[1][7]  = -10'd276;
assign end_index_mhz80_he[1][8]  = -10'd260;
assign end_index_mhz80_he[1][9]  = -10'd228;
assign end_index_mhz80_he[1][10] = -10'd196;
assign end_index_mhz80_he[1][11] = -10'd164;
assign end_index_mhz80_he[1][12] = -10'd148;
assign end_index_mhz80_he[1][13] = -10'd116;
assign end_index_mhz80_he[1][14] = -10'd84;
assign end_index_mhz80_he[1][15] = -10'd68;
assign end_index_mhz80_he[1][16] = -10'd36;
assign end_index_mhz80_he[1][17] = -10'd4;
assign end_index_mhz80_he[1][18] =  10'd20;
assign end_index_mhz80_he[1][19] =  10'd52;
assign end_index_mhz80_he[1][20] =  10'd84;
assign end_index_mhz80_he[1][21] =  10'd100;
assign end_index_mhz80_he[1][22] =  10'd132;
assign end_index_mhz80_he[1][23] =  10'd164;
assign end_index_mhz80_he[1][24] =  10'd180;
assign end_index_mhz80_he[1][25] =  10'd212;
assign end_index_mhz80_he[1][26] =  10'd244;
assign end_index_mhz80_he[1][27] =  10'd260;
assign end_index_mhz80_he[1][28] =  10'd292;
assign end_index_mhz80_he[1][29] =  10'd324;
assign end_index_mhz80_he[1][30] =  10'd340;
assign end_index_mhz80_he[1][31] =  10'd372;
assign end_index_mhz80_he[1][32] =  10'd404;
assign end_index_mhz80_he[1][33] =  10'd420;
assign end_index_mhz80_he[1][34] =  10'd452;
assign end_index_mhz80_he[1][35] =  10'd484;
assign end_index_mhz80_he[1][36] =  10'd500;
assign end_index_mhz80_he[1][37] =  10'd0;
assign end_index_mhz80_he[1][38] =  10'd0;
assign end_index_mhz80_he[1][39] =  10'd0;
assign end_index_mhz80_he[1][40] =  10'd0;
assign end_index_mhz80_he[1][41] =  10'd0;
assign end_index_mhz80_he[1][42] =  10'd0;
assign end_index_mhz80_he[1][43] =  10'd0;
assign end_index_mhz80_he[1][44] =  10'd0;
assign end_index_mhz80_he[1][45] =  10'd0;
assign end_index_mhz80_he[1][46] =  10'd0;
assign end_index_mhz80_he[1][47] =  10'd0;
assign end_index_mhz80_he[1][48] =  10'd0;
assign end_index_mhz80_he[1][49] =  10'd0;
assign end_index_mhz80_he[1][50] =  10'd0;
assign end_index_mhz80_he[1][51] =  10'd0;
assign end_index_mhz80_he[1][52] =  10'd0;
assign end_index_mhz80_he[1][53] =  10'd0;
assign end_index_mhz80_he[1][54] =  10'd0;
assign end_index_mhz80_he[1][55] =  10'd0;
assign end_index_mhz80_he[1][56] =  10'd0;
assign end_index_mhz80_he[1][57] =  10'd0;
assign end_index_mhz80_he[1][58] =  10'd0;
assign end_index_mhz80_he[1][59] =  10'd0;
assign end_index_mhz80_he[1][60] =  10'd0;
assign end_index_mhz80_he[1][61] =  10'd0;
assign end_index_mhz80_he[1][62] =  10'd0;
assign end_index_mhz80_he[1][63] =  10'd0;

///////////////////////////////////////////////
// Generate next subCarrier Cnt
///////////////////////////////////////////////

  always @(*)
    begin

      // Initial loading
      if (tctlStart == 1'b1) begin
        rdEn = 1'b1;
        HMemNsNext = 8'd1;
        if (cfgHe == 1'b1) begin // 20Mhz HE
          case (cfgChBw)
            BW20    : subCarrierCntNext = start_index_mhz20_he[cfgNg[0]][cfgHeRUStartIndex[3:0]][HAWIDTH-1:0];
            BW40    : subCarrierCntNext = start_index_mhz40_he[cfgNg[0]][cfgHeRUStartIndex[4:0]][HAWIDTH-1:0];
            default : subCarrierCntNext = start_index_mhz80_he[cfgNg[0]][cfgHeRUStartIndex][HAWIDTH-1:0];
          endcase
        end else begin
          case(cfgChBw)
            BW20    : subCarrierCntNext = W10_MINUS28[HAWIDTH-1:0];  //20Mhz starting at subcarrier -28  
            BW40    : subCarrierCntNext = W10_MINUS58[HAWIDTH-1:0];  //40Mhz starting at subcarrier -58  
            default : subCarrierCntNext = W10_MINUS122[HAWIDTH-1:0]; //80Mhz starting at subcarrier -122
          endcase
        end
      end // tctlStart

      // Incremental step HE
      else if(tctlAdvance == 1'b1 && cfgHe == 1'b1 && HMemActive == 1'b1) begin // HE
        rdEn = 1'b1;
        HMemNsNext = HMemNs + 8'd1;
        if (cfgChBw==BW20) begin // HE 20 MHz
          if (cfgNg == GR1) begin // means Grouping by 4 in HE
            case(HMemRAddr[7:0])
              8'h86:    subCarrierCntNext = W10_MINUS120[HAWIDTH-1:0]; //-122 => -120
              8'hfc:    subCarrierCntNext = W10_MINUS2[HAWIDTH-1:0];   //  -4 =>   -2
              8'h02:    subCarrierCntNext = W10_PLUS4[HAWIDTH-1:0];    //   2 =>    4
              8'h78:    subCarrierCntNext = W10_PLUS122[HAWIDTH-1:0];  // 120 =>  122
              default:  subCarrierCntNext = HMemRAddr + W10_PLUS4[HAWIDTH-1:0];
            endcase 
          end else begin // cfgNg==GR2, means Grouping by 16 in HE
            case(HMemRAddr[7:0])
              8'h86:    subCarrierCntNext = W10_MINUS116[HAWIDTH-1:0]; //-122 => -116
              8'ha0:    subCarrierCntNext = W10_MINUS84[HAWIDTH-1:0];  // -96 =>  -84 when start RU index = 1
              8'hb0:    subCarrierCntNext = W10_MINUS68[HAWIDTH-1:0];  // -80 =>  -68 when start RU index = 2
              8'hfc:    subCarrierCntNext = W10_MINUS2[HAWIDTH-1:0];   //  -4 =>   -2
              8'hfe:    subCarrierCntNext = W10_PLUS2[HAWIDTH-1:0];    //  -2 =>    2
              8'h02:    subCarrierCntNext = W10_PLUS4[HAWIDTH-1:0];    //   2 =>    4
              8'h20:    subCarrierCntNext = W10_PLUS36[HAWIDTH-1:0];   //  32 =>   36 when start RU index = 6
              8'h40:    subCarrierCntNext = W10_PLUS68[HAWIDTH-1:0];   //  64 =>   68 when start RU index = 7
              8'h74:    subCarrierCntNext = W10_PLUS122[HAWIDTH-1:0];  // 116 =>  122
              default:  subCarrierCntNext = HMemRAddr + W10_PLUS16[HAWIDTH-1:0];
            endcase 
          end

        end else begin // 40 or 80 MHz HE
          if (HMemRAddr==W10_MINUS4[HAWIDTH-1:0]) begin
            subCarrierCntNext = W10_PLUS4[HAWIDTH-1:0];
          end else begin
            if (cfgNg==GR1)
              subCarrierCntNext = HMemRAddr + W10_PLUS4[HAWIDTH-1:0];
            else
              subCarrierCntNext = HMemRAddr + W10_PLUS16[HAWIDTH-1:0];
          end
        end

        // Override with EndAddress in case End address for this RU sel is not part of table 9-76e
        if ($signed(subCarrierCntNext)>$signed(NextEndAddr))
          subCarrierCntNext = NextEndAddr;
      end // Incremental step HE

      // Incremental steps non HE: 20, 40, 80 MHz
      else if(tctlAdvance == 1'b1 && cfgChBw == BW20 && HMemActive == 1'b1) begin // Non HE 20Mhz
        rdEn = 1'b1;
        HMemNsNext = HMemNs + 8'd1;
        if (cfgNg == GR1)
          begin
            case(HMemRAddr[7:0])
              8'hea:    subCarrierCntNext = W10_MINUS20[HAWIDTH-1:0]; //-20
              8'hf8:    subCarrierCntNext = W10_MINUS6[HAWIDTH-1:0];  //-6
              8'hff:    subCarrierCntNext = W10_PLUS1[HAWIDTH-1:0];   //1
              8'h6:     subCarrierCntNext = W10_PLUS8[HAWIDTH-1:0];   //8
              8'h14:    subCarrierCntNext = W10_PLUS22[HAWIDTH-1:0];  //22
              default:  subCarrierCntNext = HMemRAddr + W10_PLUS1[HAWIDTH-1:0];
            endcase 
          end 
        else if ( cfgNg == GR2 )
          begin
            case(HMemRAddr[7:0])
              8'hfe:    subCarrierCntNext = W10_MINUS1[HAWIDTH-1:0]; //-1
              8'hff:    subCarrierCntNext = W10_PLUS1[HAWIDTH-1:0];  // 1
              8'h01:    subCarrierCntNext = W10_PLUS2[HAWIDTH-1:0];  // 2
              default:  subCarrierCntNext = HMemRAddr + W10_PLUS2[HAWIDTH-1:0];
            endcase
          end 
        else //if ( cfgNg == 2'b10 )
          begin
            case(HMemRAddr[7:0])
              8'hfc:    subCarrierCntNext = W10_MINUS1[HAWIDTH-1:0]; //-1
              8'hff:    subCarrierCntNext = W10_PLUS1[HAWIDTH-1:0];  //1
              8'h01:    subCarrierCntNext = W10_PLUS4[HAWIDTH-1:0];  //4
              default:  subCarrierCntNext = HMemRAddr + W10_PLUS4[HAWIDTH-1:0];
            endcase 
          end     
      end //20Mhz
        
    else if(tctlAdvance == 1'b1 && cfgChBw == BW40 && HMemActive == 1'b1) begin // Non HE 40Mhz
      rdEn = 1'b1;
      HMemNsNext = HMemNs + 8'd1;
      if ( cfgNg == GR1) begin
        case(HMemRAddr[7:0])
          8'hca:    subCarrierCntNext = W10_MINUS52[HAWIDTH-1:0]; //-52
          8'he6:    subCarrierCntNext = W10_MINUS24[HAWIDTH-1:0]; //-24
          8'hf4:    subCarrierCntNext = W10_MINUS10[HAWIDTH-1:0]; //-10
          8'hfe:    subCarrierCntNext = W10_PLUS2[HAWIDTH-1:0];   //2
          8'h0a:    subCarrierCntNext = W10_PLUS12[HAWIDTH-1:0];  //12
          8'h18:    subCarrierCntNext = W10_PLUS26[HAWIDTH-1:0];  //26
          8'h34:    subCarrierCntNext = W10_PLUS54[HAWIDTH-1:0];  //54
          default:  subCarrierCntNext = HMemRAddr + W10_PLUS1[HAWIDTH-1:0];
        endcase 
      end else begin
        case(HMemRAddr[7:0])
          8'hfe:    subCarrierCntNext = W10_PLUS2[HAWIDTH-1:0];
          default: begin
            if (cfgNg == GR2)
              subCarrierCntNext = HMemRAddr + W10_PLUS2[HAWIDTH-1:0];
            else
              subCarrierCntNext = HMemRAddr + W10_PLUS4[HAWIDTH-1:0];
          end                                   
        endcase 
      end 
    
    end //40Mhz
        
    else if(tctlAdvance == 1'b1 && cfgChBw == BW80 && HMemActive == 1'b1) // Non HE 80Mhz
      begin
        rdEn = 1'b1;
        HMemNsNext = HMemNs + 8'd1;
        if ( cfgNg == GR1) begin
          case(HMemRAddr[7:0])
            8'h98:    subCarrierCntNext = W10_MINUS102[HAWIDTH-1:0]; // 8'h9a;
            8'hb4:    subCarrierCntNext = W10_MINUS74[HAWIDTH-1:0];  // 8'hb6;
            8'hd8:    subCarrierCntNext = W10_MINUS38[HAWIDTH-1:0];  // 8'hda;
            8'hf4:    subCarrierCntNext = W10_MINUS10[HAWIDTH-1:0];  // 8'hf6;
            8'hfe:    subCarrierCntNext = W10_PLUS2[HAWIDTH-1:0];    // 8'h02;
            8'h0a:    subCarrierCntNext = W10_PLUS12[HAWIDTH-1:0];   // 8'h0c;
            8'h26:    subCarrierCntNext = W10_PLUS40[HAWIDTH-1:0];   // 8'h28;
            8'h4a:    subCarrierCntNext = W10_PLUS76[HAWIDTH-1:0];   // 8'h4c;
            8'h66:    subCarrierCntNext = W10_PLUS104[HAWIDTH-1:0];  // 8'h68;
            default:  subCarrierCntNext = HMemRAddr + W10_PLUS1[HAWIDTH-1:0];
          endcase 
        end else begin
          case(HMemRAddr[7:0])
            8'hfe:    subCarrierCntNext = W10_PLUS2[HAWIDTH-1:0];
            default: begin
              if (cfgNg == GR2)
                subCarrierCntNext = HMemRAddr + W10_PLUS2[HAWIDTH-1:0];
              else
                subCarrierCntNext = HMemRAddr + W10_PLUS4[HAWIDTH-1:0];
            end              
          endcase 
        end   
      end //80MHz
    else if (HMemActive == 1'b0) begin
      rdEn              = 1'b0;
      subCarrierCntNext = W10_ZERO[HAWIDTH-1:0];
      HMemNsNext        = HMemNs;
    end else begin
      rdEn              = 1'b0;
      subCarrierCntNext = HMemRAddr;
      HMemNsNext        = HMemNs;
    end   
  end

/////////////////////////////////////////////////////////////////////////////
// Assert HMemDone when memory is no more needed.
//////////////////////////////////////////////////////////////////////////////   

// For HE, find last address based on RU End index
always @(*)
begin
  case (cfgChBw)
    BW20    : NextEndAddr = end_index_mhz20_he[cfgNg[0]][cfgHeRUEndIndex[3:0]][HAWIDTH-1:0];
    BW40    : NextEndAddr = end_index_mhz40_he[cfgNg[0]][cfgHeRUEndIndex[4:0]][HAWIDTH-1:0];
    default : NextEndAddr = end_index_mhz80_he[cfgNg[0]][cfgHeRUEndIndex][HAWIDTH-1:0];
  endcase
end

always @(posedge BFRModemClk or negedge nBFRModemRst)
begin
  if (nBFRModemRst == 1'b0) begin
    HMemDone      <= 1'b0;
    EndAddr       <= W10_ZERO[HAWIDTH-1:0];
  end else begin
    HMemDone      <= 1'b0; // RTZ
    EndAddr       <= NextEndAddr;
    
    if (cfgHe == 1'b1) begin
      if(HMemRAddr == EndAddr && HMemIfRdDataVld==1'b1)      // HE 20Mhz
        HMemDone   <= 1'b1;
    end else begin
      if (cfgChBw == BW20 && HMemRAddr[7:0] == 8'h1c && HMemIfRdDataVld==1'b1) // 20Mhz
        HMemDone   <= 1'b1;
      else if (cfgChBw == BW40 && HMemRAddr[7:0] == 8'h3a && HMemIfRdDataVld==1'b1) // 40Mhz
        HMemDone   <= 1'b1;
      else if (cfgChBw == BW80 && HMemRAddr[7:0] == 8'h7a && HMemIfRdDataVld==1'b1) // 80Mhz
        HMemDone   <= 1'b1;
    end
  end
end

///////////////////////////////////////////////
// Register 
///////////////////////////////////////////////
always @(posedge BFRModemClk or negedge nBFRModemRst)
begin
  if (nBFRModemRst == 1'b0)
    begin
      HMemRAddr        <= W10_ZERO[HAWIDTH-1:0];
      HMemREn          <= 1'b0;
      HMemNs           <= 8'd0;
    end
  else 
    begin
      HMemRAddr        <= subCarrierCntNext;
      HMemNs           <= HMemNsNext;
      if (HMemActive==1'b0)
        HMemREn          <= 1'b0;
      else
        HMemREn          <= rdEn;
    end
end

///////////////////////////////////////////////
// Hmemory mapping decoding
///////////////////////////////////////////////
// SVD Config1 : Hmem width = 104 bits, contains h11 h12 h13 h14
//`ifdef RW_MUMIMO_RX_EN
`ifndef RW_TXRX_2X2
  assign { HMemDecRdDataIm11, HMemDecRdDataRe11,
           HMemDecRdDataIm12, HMemDecRdDataRe12,
           HMemDecRdDataIm13, HMemDecRdDataRe13,
           HMemDecRdDataIm14, HMemDecRdDataRe14 } =  HMemRdData; // [103:0]
`endif // RW_TXRX_2X2
//`endif // RW_MUMIMO_RX_EN  

// SVD Config2 : Hmem width = 208 bits, contains h21 h22 h23 h24 h11 h12 h13 h14
//`ifdef RW_MUMIMO_RX_EN
`ifdef RW_TXRX_2X2
  assign { HMemDecRdDataIm21, HMemDecRdDataRe21,
           HMemDecRdDataIm22, HMemDecRdDataRe22,
           HMemDecRdDataIm23, HMemDecRdDataRe23,
           HMemDecRdDataIm24, HMemDecRdDataRe24,
           HMemDecRdDataIm11, HMemDecRdDataRe11,
           HMemDecRdDataIm12, HMemDecRdDataRe12,
           HMemDecRdDataIm13, HMemDecRdDataRe13,
           HMemDecRdDataIm14, HMemDecRdDataRe14 } =  HMemRdData; // [207:0]
`endif // RW_TXRX_2X2
//`endif // RW_MUMIMO_RX_EN  


// SVD Config3 : Hmem width = 104 bits, contains h21 h22 h11 h12
//`ifndef RW_MUMIMO_RX_EN
//`ifdef RW_TXRX_2X2
//  assign { HMemDecRdDataIm21, HMemDecRdDataRe21,
//           HMemDecRdDataIm22, HMemDecRdDataRe22,
//           HMemDecRdDataIm11, HMemDecRdDataRe11,
//           HMemDecRdDataIm12, HMemDecRdDataRe12 } =  HMemRdData; // [103:0]
//`endif // RW_TXRX_2X2
//`endif // RW_MUMIMO_RX_EN  


///////////////////////////////////////////////
// RdData
///////////////////////////////////////////////

always @(posedge BFRModemClk or negedge nBFRModemRst)
begin
  if (nBFRModemRst == 1'b0)
    begin
      HMemIfRdDataVld     <= 1'b0;
      HMemIFRdDataRe11    <= 13'd0;    
      HMemIFRdDataIm11    <= 13'd0;     
      HMemIFRdDataRe12    <= 13'd0;
      HMemIFRdDataIm12    <= 13'd0;
`ifdef RW_TXRX_2X2          
      HMemIFRdDataRe21    <= 13'd0;
      HMemIFRdDataIm21    <= 13'd0;  
      HMemIFRdDataRe22    <= 13'd0;
      HMemIFRdDataIm22    <= 13'd0;
`endif // RW_TXRX_2X2   
//`ifdef RW_MUMIMO_RX_EN
      HMemIFRdDataRe13    <= 13'd0;
      HMemIFRdDataIm13    <= 13'd0;
      HMemIFRdDataRe14    <= 13'd0;
      HMemIFRdDataIm14    <= 13'd0;
`ifdef RW_TXRX_2X2          
      HMemIFRdDataRe23    <= 13'd0;
      HMemIFRdDataIm23    <= 13'd0;
      HMemIFRdDataRe24    <= 13'd0;
      HMemIFRdDataIm24    <= 13'd0;
`endif // RW_TXRX_2X2
//`endif // RW_MUMIMO_RX_EN
    end
  else
    begin
      if (tctlStop)
        begin
          HMemIfRdDataVld     <= 1'b0;
        end   
      else if (HMemRDataVld) 
        begin
          HMemIfRdDataVld     <= 1'b1;
          HMemIFRdDataRe12    <= HMemDecRdDataRe12;
          HMemIFRdDataIm12    <= HMemDecRdDataIm12;
          HMemIFRdDataRe11    <= HMemDecRdDataRe11;    
          HMemIFRdDataIm11    <= HMemDecRdDataIm11;
`ifdef RW_TXRX_2X2          
          HMemIFRdDataRe22    <= HMemDecRdDataRe22;
          HMemIFRdDataIm22    <= HMemDecRdDataIm22;
          HMemIFRdDataRe21    <= HMemDecRdDataRe21;
          HMemIFRdDataIm21    <= HMemDecRdDataIm21;
`endif // RW_TXRX_2X2   

//`ifdef RW_MUMIMO_RX_EN
          // If H does not contain valid data for this Nr, force to zero.
          case(cfgNr)
            default : begin// Nr<3
              HMemIFRdDataRe13    <= 13'd0;
              HMemIFRdDataIm13    <= 13'd0;
              HMemIFRdDataRe14    <= 13'd0;
              HMemIFRdDataIm14    <= 13'd0;
`ifdef RW_TXRX_2X2          
              HMemIFRdDataRe23    <= 13'd0;
              HMemIFRdDataIm23    <= 13'd0;
              HMemIFRdDataRe24    <= 13'd0;
              HMemIFRdDataIm24    <= 13'd0;
`endif // RW_TXRX_2X2
            end
            NR3     : begin
              HMemIFRdDataRe13    <= HMemDecRdDataRe13;
              HMemIFRdDataIm13    <= HMemDecRdDataIm13;
              HMemIFRdDataRe14    <= 13'd0;
              HMemIFRdDataIm14    <= 13'd0;
`ifdef RW_TXRX_2X2          
              HMemIFRdDataRe23    <= HMemDecRdDataRe23;
              HMemIFRdDataIm23    <= HMemDecRdDataIm23;
              HMemIFRdDataRe24    <= 13'd0;
              HMemIFRdDataIm24    <= 13'd0;
`endif // RW_TXRX_2X2
            end
            NR4     : begin
              HMemIFRdDataRe13    <= HMemDecRdDataRe13;
              HMemIFRdDataIm13    <= HMemDecRdDataIm13;
              HMemIFRdDataRe14    <= HMemDecRdDataRe14;
              HMemIFRdDataIm14    <= HMemDecRdDataIm14;
`ifdef RW_TXRX_2X2          
              HMemIFRdDataRe23    <= HMemDecRdDataRe23;
              HMemIFRdDataIm23    <= HMemDecRdDataIm23;
              HMemIFRdDataRe24    <= HMemDecRdDataRe24;
              HMemIFRdDataIm24    <= HMemDecRdDataIm24;
`endif // RW_TXRX_2X2
            end
          endcase

//`endif // RW_MUMIMO_RX_EN
        end
      else 
        begin
          HMemIfRdDataVld     <= 1'b0;
        end
    end 
end
 

endmodule
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////        
