//
// Take a 13 bit signed number in and return a 12 bit saturated signed number.
//
`default_nettype none

module OverflowSgn12 (
  ///////////////////////////////////////////////
  //$port_g inputs.
  ///////////////////////////////////////////////
  input  wire signed [12:0]    I,
  ///////////////////////////////////////////////
  //$port_g inputs.
  ///////////////////////////////////////////////
  output  wire signed [11:0]    O
  );

  wire [13:0] x;
  
  //
  // Quick version of this function, optimise later.
  // 
  // Add 2048
  // Take bottom 12 bits.
  // Subtract 2048
  
  assign x = I + 13'd2048;
  assign O = x[11:0] - 12'd2048;
  
endmodule
