//
// Take a 15 bit signed number in and return a 13 bit saturated signed number.
//
`default_nettype none

module OverflowSgn13 (
  ///////////////////////////////////////////////
  //$port_g inputs.
  ///////////////////////////////////////////////
  input  wire signed [14:0]    I,
  ///////////////////////////////////////////////
  //$port_g inputs.
  ///////////////////////////////////////////////
  output  wire signed [12:0]    O
  );

  wire [15:0] x;
  
  //
  // Quick version of this function, optimise later.
  // 
  // Add 4096
  // Take bottom 13 bits.
  // Subtract 4096
  
  assign x = I + 15'd4096;
  assign O = x[12:0] - 13'd4096;
  
endmodule
