//
// Block to emulate the cordic pre processor. See CordicPhaseprePost in the Matalab code and only
// consider pre mode.
//
`default_nettype none

module cordicpre (
  ///////////////////////////////////////////////
  //$port_g inputs.
  ///////////////////////////////////////////////
  input  wire signed [12:0]    InRe,
  input  wire signed [12:0]    InIm,
  ///////////////////////////////////////////////
  //$port_g outputs
  ///////////////////////////////////////////////
  output reg  signed [12:0]    R,
  output reg  signed [12:0]    I
  );

  reg  signed [12:0] minusRe; // -InRe
  reg  signed [12:0] minusIm; // -InIm
  
  //
  // Map R so that it's always positive.
  //
  always @(*)
    begin
      if (InRe[12])    // ie (InRe < 0)
        begin
          R = minusRe;
          I = minusIm;
        end
      else
        begin
          R = InRe;
          I = InIm;
        end
    end
    
    //
    // Reduce the positive saturation of R and I by 1.
    // 
    always @(*)
      begin
        if (InRe == -13'd4096)
          begin
            minusRe = 13'd4095;
          end
        else
          begin
            minusRe = -InRe;
          end
      end
      
    always @(*)
      begin
        if (InIm == -13'd4096)
          begin
            minusIm = 13'd4095;
          end
        else
          begin
            minusIm = -InIm;
          end
      end
endmodule
