//
// Register A to Z to match multc13 pipeline stage
//

`default_nettype none

module delay (
  ///////////////////////////////////////////////
  //$port_g clock and reset.
  ///////////////////////////////////////////////
  input  wire                 BFRModemClk,          // BFR Modem Clock
  input  wire                 nBFRModemRst,         // Active Low Reset(Modem Domain)

  ///////////////////////////////////////////////
  //$port_g Configuration and control
  ///////////////////////////////////////////////
  input wire                 tctlAdvance,  
  ///////////////////////////////////////////////
  //$port_g complex inputs.
  ///////////////////////////////////////////////
  input wire signed [12:0]    ARe,
  input wire signed [12:0]    AIm,
  ///////////////////////////////////////////////
  //$port_g complex outputs.
  ///////////////////////////////////////////////
  output reg   signed [27:0]   ZRe,
  output reg   signed [27:0]   ZIm
  );

  reg                 dtctlAdvance; 
  
  //
  // Latch A in Z at tctladvance
  //
  always @(posedge BFRModemClk or negedge nBFRModemRst)
    begin
	  if (!nBFRModemRst)
        begin
          ZRe          <= 28'd0;
          ZIm          <= 28'd0;
          dtctlAdvance <= 1'b0;
        end
      else
        begin
          dtctlAdvance <= tctlAdvance;
          if (dtctlAdvance)
            begin
              ZRe <= {{15{ARe[12]}}, ARe};
              ZIm <= {{15{AIm[12]}}, AIm};
            end
        end
    end  
endmodule
