//////////////////////////////////////////////////////////////////////////
//
//     Module           : log2floor
//     Full Module Name : Log2 calculation block that always rounds down.
//     Architecture     : rtl
//     Block Name       : 
//     Project          : 
//     Designer(s)      : Aedan Coffey aedan.coffey@ceva-dsp.com
//     Current Version  : $Revision: 1.2 $
//     Current Date     : $Date: 2010-02-03 20:39:26+02 $
//     Simulator        : 
//     Synthesiser      : 
//     Coding Standard  : 
//
//     Description      : Calculates the log to the base 2 of the input value,
//                      : Output is not rounded, as per the Matlab floor(log2(....)) code.
//                      : Simplified version of the log2 code in the snr block.
//
///////////////////////////////////////////////////////////////////////////
//
//            Copyright (c) Ceva Inc.
//
// This code is confidential and proprietary product of Ceva.
// Any unauthorized use, reproduction or transfer of this 
// code is strictly prohibited.
//
//////////////////////////////////////////////////////////////////////////

`default_nettype none

module log2floor # (
    parameter WIDTH = 28
) (
  input  wire [WIDTH-1:0] log2in,      // Input value, unsigned.
  output wire [4:0]       result       // Log2 of the input value.
  );	
	
	reg [4:0] FSB; 			// Position of first set bit that is set in the input vector.
	integer i;		    	// Loop counter.

	//
	// First calculate the position of the most significant '1' in the input vector.
	//
	always @(*) // Version using for loop.
		begin
			FSB = 5'd0;
			for (i=WIDTH-1; i>0; i=i-1)
				begin
					if ((log2in[i] == 1'b1) && (FSB == 5'd0))
						begin
							FSB = i;
						end
				end
		end

	//
	// Add both parts to make the final result.
	// result = 16*log2(log2in).
	//
	assign result  = FSB;	
	
endmodule											
