//
// A block to get the max abs value of eight numbers. If cfgNRx = 2'b00 then
// only the first two numbers are considered.
//

`default_nettype none

module maxabs # (
    parameter WIDTH = 28
) (
  ///////////////////////////////////////////////
  //$port_g clock and reset.
  ///////////////////////////////////////////////
  input  wire                 BFRModemClk,          // BFR Modem Clock
  input  wire                 nBFRModemRst,         // Active Low Reset(Modem Domain)
  
  ///////////////////////////////////////////////
  //$port_ginputs.
  ///////////////////////////////////////////////
  input  wire signed [WIDTH-1:0]    I1,
  input  wire signed [WIDTH-1:0]    I2,
  input  wire signed [WIDTH-1:0]    I3,
  input  wire signed [WIDTH-1:0]    I4,
//`ifdef RW_MUMIMO_RX_EN   
  input  wire signed [WIDTH-1:0]    I5,
  input  wire signed [WIDTH-1:0]    I6,
  input  wire signed [WIDTH-1:0]    I7,
  input  wire signed [WIDTH-1:0]    I8,
//`endif
  ///////////////////////////////////////////////
  //$port_g output
  ///////////////////////////////////////////////
  output wire        [WIDTH-1:0]    Z
  );
  
  reg signed [WIDTH-1:0] AbsI1;
  reg signed [WIDTH-1:0] AbsI2;
  reg signed [WIDTH-1:0] AbsI3;
  reg signed [WIDTH-1:0] AbsI4;
  reg signed [WIDTH-1:0] X12;
  reg signed [WIDTH-1:0] X34;
  reg signed [WIDTH-1:0] X1234;
//`ifdef RW_MUMIMO_RX_EN   
  reg signed [WIDTH-1:0] AbsI5;
  reg signed [WIDTH-1:0] AbsI6;
  reg signed [WIDTH-1:0] AbsI7;
  reg signed [WIDTH-1:0] AbsI8;
  reg signed [WIDTH-1:0] X56;
  reg signed [WIDTH-1:0] X78;
  reg signed [WIDTH-1:0] X5678;
  reg        [WIDTH-1:0] ZMu;  
//`endif
  
  //
  // Get the absolute value of each input. If the top bit is set then negate it.
  //
  always @(*)
    begin
      //
      if (I1[WIDTH-1]) 	// Negative number
        begin
          AbsI1 = -I1;
        end
      else
        begin
          AbsI1 = I1;
        end
      //
      if (I2[WIDTH-1]) 	// Negative number
        begin
          AbsI2 = -I2;
        end
      else
        begin
          AbsI2 = I2;
        end
      //
      if (I3[WIDTH-1]) 	// Negative number
        begin
          AbsI3 = -I3;
        end
      else
        begin
          AbsI3 = I3;
        end
      //
      if (I4[WIDTH-1]) 	// Negative number
        begin
          AbsI4 = -I4;
        end
      else
        begin
          AbsI4 = I4;
        end
//`ifdef RW_MUMIMO_RX_EN   
      //
      if (I5[WIDTH-1]) 	// Negative number
        begin
          AbsI5 = -I5;
        end
      else
        begin
          AbsI5 = I5;
        end
      //
      if (I6[WIDTH-1]) 	// Negative number
        begin
          AbsI6 = -I6;
        end
      else
        begin
          AbsI6 = I6;
        end
      //
      if (I7[WIDTH-1]) 	// Negative number
        begin
          AbsI7 = -I7;
        end
      else
        begin
          AbsI7 = I7;
        end
      //
      if (I8[WIDTH-1]) 	// Negative number
        begin
          AbsI8 = -I8;
        end
      else
        begin
          AbsI8 = I8;
        end
//`endif
    end
    
    //
    // Find the maximum value. Compare AbsI1 and AbsI2 into X12, AbsI3 and AbsI4 into X34, 
    // AbsI5 and AbsI6 into X56 and AbsI7 and AbsI8 into X78.
    // Then compare X12 and X34 to get X1234 and compare X56 and X78 to get X5678.
    //
    always @(*)
      begin
        //
        if (AbsI1 >= AbsI2)
          begin
            X12 = AbsI1;
          end
        else
          begin
            X12 = AbsI2;
          end
        //
        if (AbsI3 >= AbsI4)
          begin
            X34 = AbsI3;
          end
        else
          begin
            X34 = AbsI4;
          end
//`ifdef RW_MUMIMO_RX_EN   
        //
        if (AbsI5 >= AbsI6)
          begin
            X56 = AbsI5;
          end
        else
          begin
            X56 = AbsI6;
          end
        //
        if (AbsI7 >= AbsI8)
          begin
            X78 = AbsI7;
          end
        else
          begin
            X78 = AbsI8;
          end
//`endif
        //
      end
               
    //
    // Register the results of the X1234 and X5678 calculations to help meet timing.
    //
    always @(posedge BFRModemClk or negedge nBFRModemRst)
      begin
	    if (!nBFRModemRst)
	      begin
	        X1234 <= {WIDTH{1'b0}};
//`ifdef RW_MUMIMO_RX_EN   
	        X5678 <= {WIDTH{1'b0}};
//`endif
	      end
	    else
	      begin
            //
            if (X12 >= X34)
              begin
                X1234 <= X12;
              end
            else
              begin
                X1234 <= X34;
              end
            //
//`ifdef RW_MUMIMO_RX_EN   
            if (X56 >= X78)
              begin
                X5678 <= X56;
              end
            else
              begin
                X5678 <= X78;
              end
//`endif
          end
       end
 
//`ifdef RW_MUMIMO_RX_EN   
    //
    // Finally compare X1234 and X5678 and put the larger one on Z.
    //
    always @(*)
      begin
        if (X1234 >= X5678)
          begin
            ZMu = X1234;
          end
        else
          begin
            ZMu = X5678;
          end
	  end
    
    assign Z = ZMu;

//`else
//    assign Z = X1234;
//`endif
      
endmodule    
