//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by CEVA.
//  This module is a confidential and proprietary property of CEVA
//  and a possession or use of this module requires written permission
//  from CEVA.
//----------------------------------------------------------------------------
// $Author: $
// Company          : CEVA
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : 
// Description      : 
//     This block generates the square Root value. Computes 2 Iterations per clock cycle
// 
// Simulation Notes : 
// Synthesis Notes  : 
// Application Note : 
// Simulator        : 
// Parameters       : 
// Terms & concepts : 
// Bugs             : 
// Open issues and future enhancements : 
// References       : 
// Revision History : 
// ---------------------------------------------------------------------------
// 
// 
// 
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module sqr (
        ///////////////////////////////////////////////
        //$port_g Clock and reset
        ///////////////////////////////////////////////
        input  wire           BFRModemClk,             // BFR Modem Clock
        input  wire           nBFRModemRst,            // Active Low Reset(Modem Domain)

        input  wire  [23:0]   eigenDelta2Data,         // Input Data
        input  wire           eigenDelta2Valid,        // Input Valid   
        
        input  wire  [12:0]   eigenBtildeData,         // Data
        input  wire  [3:0]    eigenMscale,             // Scale
        
        output reg   [11:0]   sqrDelta,                // Output Data
        
        output reg  [12:0]    sqrBtildeData,           // Registered Data
        output reg  [3:0]     sqrMscale                // Registered Scale

);

//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////
 reg[23:0]  startbit;
 reg[23:0]  bitReg;
 reg[23:0]  bitShiftTwo;
 reg[23:0]  bitShiftFour;
 
 reg[23:0]  result;
 reg[23:0]  resultReg;
 reg[23:0]  resultShiftOne;
 reg[23:0]  eData;
 reg[23:0]  eDataReg;
 reg [2:0]  sqrFSMCs;
 reg [2:0]  sqrFSMNs;       
 
 
 

 
 
 localparam 
           IDLEs        = 3'd0,
           ITER2s       = 3'd1,
           ITER3s       = 3'd2,
           ITER4s       = 3'd3,
           ITER5s       = 3'd4,
           ITER6s       = 3'd5;

          


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

always @*
begin
   if ((eigenDelta2Valid == 1'b1) && (sqrFSMCs == IDLEs)) //Initial 2 Iteration
     begin      
       if (eigenDelta2Data >= 24'h40_0000)
         begin       
           startbit   = 24'h40_0000;
         end            
       else if (eigenDelta2Data >= 24'h10_0000)           
         begin       
           startbit   = 24'h10_0000; 
         end            
       else if (eigenDelta2Data >= 24'h04_0000)           
         begin       
           startbit   = 24'h04_0000;     
         end            
       else if (eigenDelta2Data >= 24'h01_0000)           
         begin       
           startbit   = 24'h01_0000; 
         end            
       else if (eigenDelta2Data >= 24'h00_4000)           
         begin       
           startbit   = 24'h00_4000; 
         end            
       else if (eigenDelta2Data >= 24'h00_1000)           
         begin       
           startbit   = 24'h00_1000; 
         end            
       else if (eigenDelta2Data >= 24'h00_0400)           
         begin       
           startbit   = 24'h00_0400;     
         end            
       else if (eigenDelta2Data >= 24'h00_0100)           
         begin       
           startbit   = 24'h00_0100; 
         end            
       else if (eigenDelta2Data >= 24'h00_0040)           
         begin       
           startbit   = 24'h00_0040;
         end            
       else if (eigenDelta2Data >= 24'h00_0010)           
         begin       
           startbit   = 24'h00_0010; 
         end            
       else if (eigenDelta2Data >= 24'h00_0004)           
         begin       
           startbit   = 24'h00_0004;
         end            
       else if (eigenDelta2Data >= 24'h00_0001)           
         begin       
           startbit   = 24'h00_0001;                                                    
         end            
       else       
         begin       
           startbit   = 24'h00_0000;
         end
     end    
   else
     begin
       startbit        = 24'h00_0000; 
     end           
end

always @(*)
   begin
     if(eigenDelta2Valid == 1'b1 && sqrFSMCs == IDLEs) //Initial 2 Iteration
       begin
         bitShiftTwo      = (startbit >> 2);
         bitShiftFour     = (startbit >> 4);
       end
     else
       begin
         bitShiftTwo      = (bitReg >> 2);
         bitShiftFour     = (bitReg >> 4);
       end
   end
       
     
      
always @(*)     
   begin
     resultShiftOne   = ((resultReg >> 1) + bitReg);
     if(eigenDelta2Valid == 1'b1 && sqrFSMCs == IDLEs) //Initial 2 Iteration
       begin
         if (startbit !=  24'h00_0000)    
           begin
             if (startbit ==  24'h00_0001 && eigenDelta2Data <= 24'h00_0003)
               begin
                 eData   = ((eigenDelta2Data - startbit));
                 result  =  24'h00_0001;
               end 
             else if ( (eigenDelta2Data - startbit) == 24'h00_0000)
               begin          
                 eData   = ( eigenDelta2Data - startbit );
                 result  =  ( startbit >>1 ) ; 
               end 
             else if ( (eigenDelta2Data - startbit) >= (startbit + bitShiftTwo ))
               begin          
                 eData   = ( (eigenDelta2Data - startbit) - (startbit + bitShiftTwo) );
                 result  = ( (startbit >>1 ) + bitShiftTwo ); 
               end
             else 
               begin
                 eData   = ((eigenDelta2Data - startbit));
                 result  = ( startbit >>1 );
               end                
           end
         else
           begin
            eData   = 24'h00_0000;
            result  = 24'h00_0000;
           end
       end // if(eigenDelta2Valid == 1'b1 && sqrFSMCs == IDLEs) //Initial 2 Iteration

         
     else if ( sqrFSMCs != IDLEs && bitReg != 24'h00_0000 ) //Subsequent 2 Iteration
       begin
         if ( (eDataReg > (resultReg + bitReg))  && (eDataReg - (resultReg + bitReg)) >= (resultShiftOne + bitShiftTwo )  &&  bitShiftTwo != 24'h00_0000 ) //eDataReg greater on both iterations
           begin          
             eData   = ( eDataReg - ((resultReg + bitReg) + (resultShiftOne + bitShiftTwo)) );
             result  = ( (resultShiftOne >> 1) + bitShiftTwo );    
           end
         else if ( eDataReg >= (resultReg + bitReg)) //eDataReg greater on first iteration not the second
           begin
             eData   = ( eDataReg - (resultReg + bitReg) );
             if (bitShiftTwo != 24'h00_0000)
               result  = ( resultShiftOne >> 1 );
             else
               result  =  resultShiftOne; 
           end 
         else if ( eDataReg >= ((resultReg >> 1) + bitShiftTwo) &&  bitShiftTwo != 24'h00_0000 ) //eDataReg greater on second iteration not the first
           begin
             eData   = ( eDataReg - ((resultReg >>1) + bitShiftTwo) );
             result  = ((resultReg >> 2) + bitShiftTwo); 
           end 
         else if ( bitShiftTwo != 24'h00_0000 )
           begin
             eData   = eDataReg;
             result  = (resultReg >> 2);
           end
         else 
           begin
             eData   = eDataReg;
             result  = (resultReg >> 1);
           end      
         end
   
     else 
       begin
         eData           = 24'h00_0000;
         result          = 24'h00_0000; 
       end         
         
 end                    
      
   
        
        
//////////////////////////////////////////////////////////////////////////////
// State Machine
//////////////////////////////////////////////////////////////////////////////   




// sqrFSM FSM next state logic
///////////////////////////////////////
always @* 
begin
  case(sqrFSMCs)

    IDLEs:
      //$fsm_s In IDLEs state, fsm waits for dataValid to be set
      //if (eigenDelta2Valid == 1'b1  && bitShiftFour != 24'h00_0000)
      if (bitShiftFour != 24'h00_0000 )
      begin
        //$fsm_t 
        sqrFSMNs = ITER2s;    
      end
      else
      begin
        //$fsm_t 
        sqrFSMNs = IDLEs;
      end

    ITER2s:
      //$fsm_s In ITER2s
      if (bitShiftFour != 24'h00_0000 )
      begin
        //$fsm_t 
        sqrFSMNs = ITER3s; 
      end
      else 
      begin
        //$fsm_t 
        sqrFSMNs = IDLEs;
      end
     
    ITER3s:
      //$fsm_s 
      if (bitShiftFour != 24'h00_0000 )
      begin
        //$fsm_t 
        sqrFSMNs = ITER4s; 
      end
      else 
      begin
        //$fsm_t 
        sqrFSMNs = IDLEs;
      end
     
    ITER4s:
       //$fsm_s 
      if (bitShiftFour != 24'h00_0000 )
      begin
        //$fsm_t 
        sqrFSMNs = ITER5s; 
      end
      else 
      begin
        //$fsm_t 
        sqrFSMNs = IDLEs;
      end


    ITER5s:
       //$fsm_s 
      if (bitShiftFour != 24'h00_0000 )
      begin
        //$fsm_t 
        sqrFSMNs = ITER6s; 
      end
      else 
      begin
        //$fsm_t 
        sqrFSMNs = IDLEs;
      end

    ITER6s:
       //$fsm_s 
      begin
        //$fsm_t 
        sqrFSMNs = IDLEs;
      end

    // Disable case default state for block coverage
    // pragma coverage block = off
    default:
      begin
        sqrFSMNs = IDLEs;
      end
    // pragma coverage block = on

  endcase

end

// sqr FSM
//////////////////////////////////////////////////////////////////////////////

// wpiCcmFSM FSM current state logic 
///////////////////////////////////////
always @(posedge BFRModemClk or negedge nBFRModemRst) 
begin
  if (nBFRModemRst == 1'b0)  // Asynchronous Reset
  begin
    sqrFSMCs <= IDLEs; 
  end
  else
  begin
    sqrFSMCs <= sqrFSMNs; 
  end
end


always @(posedge BFRModemClk or negedge nBFRModemRst) 
begin
  if (nBFRModemRst == 1'b0)  // Asynchronous Reset
    begin
      bitReg         <= 24'h00_0000;
      resultReg       <= 24'h00_0000;
      eDataReg        <= 24'h00_0000;   
      sqrDelta        <= 12'h000;
    end 
    else if ((eigenDelta2Valid == 1'b1)  && (bitShiftFour == 24'h00_0000) && (sqrFSMCs == IDLEs))
    begin
      bitReg         <= 24'h00_0000;
      resultReg        <= 24'h00_0000;
      eDataReg         <= 24'h00_0000;
      sqrDelta         <= result[11:0];  
    end
  else if ((sqrFSMNs != IDLEs)  && (bitShiftFour != 24'h00_0000) && (sqrFSMCs == IDLEs))
    begin
      bitReg          <= bitShiftFour;
      resultReg        <= result;
      eDataReg         <= eData;
      sqrDelta         <= sqrDelta;
    end
  else if ((sqrFSMCs != IDLEs) && (sqrFSMNs != IDLEs ))
    begin
      bitReg          <= bitShiftFour;
      resultReg        <= result;
      eDataReg         <= eData; 
      sqrDelta         <= sqrDelta;
    end 
  else if ((sqrFSMCs != IDLEs) && (sqrFSMNs == IDLEs ))
    begin
      bitReg         <= 24'h00_0000;
      resultReg        <= 24'h00_0000;
      eDataReg         <= 24'h00_0000;
      sqrDelta         <= result[11:0];  
    end     
  else 
    begin
      bitReg         <= 24'h00_0000;
      resultReg       <= 24'h00_0000;
      eDataReg        <= 24'h00_0000; 
      sqrDelta        <= sqrDelta;  
   end
end

  //
  // Store the Btilde and Mscale values and pass them on for pipelining.
  //
  always @(posedge BFRModemClk or negedge nBFRModemRst) 
    begin
      if (nBFRModemRst == 1'b0)  // Asynchronous Reset
        begin
          sqrBtildeData   <= 13'h0000;
          sqrMscale       <= 4'h0;           
        end
      else
        begin
          if (eigenDelta2Valid)
            begin
              sqrBtildeData <= eigenBtildeData;
              sqrMscale     <= eigenMscale;
            end
        end
    end

endmodule
