/*
 * Create binary file for LDPC RAM init
 */
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>

/*
 * FUNCTION DEFINITIONS
 *****************************************************************************************
 */
static ssize_t readline(char **lineptr, FILE *fp)
{
    *lineptr = NULL;
    char *line;
    size_t len = 0;
    ssize_t read;
    int i;

    read = getline(lineptr, &len, fp);

    if (read <= 0)
        return read;

    line = *lineptr;

    // Remove the end of line character
    if (line[read - 1] == '\n')
        line[read - 1] = '\0';

    // Keep only the characters up to a * or a [
    for (i = 0; i < strlen(line); i++)
    {
        if ((line[i] == '*') || (line[i] == '['))
        {
            line[i] = '\0';
            break;
        }
    }

    return strlen(line);
}


/*
 *****************************************************************************************
 * @brief Main entry point of the application.
 *
 * @param argc   usual parameter counter
 * @param argv   usual parameter values
 *****************************************************************************************
 */
int main(int argc,char **argv)
{
  FILE *file;
  FILE *file_out;
  int i;
  int mem_size;
  int status= 0;
  
  if (argc != 4)
  {
      printf("error: wrong arguments provided !\n");
      printf("syntax: %s input_file output_file mem_size\n",argv[0]);
      exit(-1);
  }

  file = fopen(argv[1],"r");
  if(!file)
  {
    printf("error: can't open input file %s !\n",argv[1]);
    exit(-1);
  }

  file_out = fopen(argv[2],"wb");
  if(!file_out)
  {
    printf("error: can't open output file %s !\n",argv[2]);
    exit(-1);
  }
  
  mem_size=atoi(argv[3]);
  printf("Creating binary file %s with %d first words of %s file.\n",argv[2],mem_size,argv[1]);

  /* upload samples */
  for(i=0; i<mem_size; i++)
  {
        char *line;
        ssize_t read;
        uint32_t binval;
        read = readline(&line, file);

        if (read <= 0)
            break;

        if (sscanf(line, "%08x", &binval) != 1) {
            status = -1;
            break;
        }

        fwrite(&binval, sizeof(binval), 1, file_out);

        free(line);
  }

//  if (!feof(file)) 
//  {
//    printf("error:Input file does not fit in the RAM !\n");
//  }
  
  fclose(file);
  fclose(file_out);

  return 0;
}

                                                                                                                                                                                                                                                        
