// This block allows the decoder's programmable registers to be replaced
// by look up tables. A verbose format with nested case/if structures is used
// due to limitations in Verilog.

// Author: Blue Rum Consulting Ltd. Auto-generated on 17-Jun-2015.

`ifdef LDEC_SV
`include "ldpcDec.svh"
`else
`include "ldpcDec.vh"
`endif

module ldpcDecLuStbc (       
input  [2:0]         qamEnum,  // 0:4 is BPSK, QPSK, 16QAM, 64QAM, 256QAM
input  [1:0]         sizeEnum, // zEnum
input  [1:0]         rateEnum, // rEnum
input                ac,       // 0:11n 1:11ac
input  [1:0]         bw,       // 0:3 is 20/40/80/160MHz
input  [6:0]         mcs,      // 0-9 for 11ac, 0-72 for 11n
input  [1:0]         nssLess1, // e.g. NSS=4 is specified as a 3.
input  [`LDEC_B_BITS-1:0] nCw,      // packetLen in LDPC blocks
input  [1:0]         nSym,     // num OFDM symbols. clip this to 3.

output reg [7:0]                            rxMean,
output reg [`LDEC_CHK_BITS-2:0]             llrUnityReg,
output reg [`LDEC_VAR_BITS-1+7:0]           targetLevel,
output reg [numBits(`LDEC_K_MAX)-1:0]       parityThresh,
output reg [numBits(8*`LDEC_MAX_ITER)-1:0]  nomIterations,
output reg [numBits(`LDEC_MAX_ITER)-1:0]    earlyTestIterations,
output reg [numBits(8*`LDEC_MAX_ITER)-1:0]  maxRunningCount,
output reg [numBits(8*`LDEC_MAX_ITER)-1:0]  endRunningCount);

`ifdef LDEC_SV
`include "ldpcDecFuncs.svh"
`else
`include "ldpcDecFuncs.vh"
`endif

localparam DRI_BITS = 3;
localparam BK_BITS = 3;
reg [BK_BITS-1:0]  bucketIdx; // selects a range of packet lengths
reg [DRI_BITS-1:0] dataRateIdx; // selects iteration settings according to datarates

// RX_MEAN is for demapper scaling and is not used in the decoder.
// It is the empirically selected optimal mean value of the LLRs.
// Higher QAM needs higher RX_MEAN to give visibility to inner constellation
// points. Stronger coding rates need lower RX_MEAN to give headroom
// for internal processing gain during each iteration. Your demapper
// may need different scaling compared to the Blue Rum model, however
// these two factors will always apply.
//
// llrUnity is the integer that represents a floating point LLR of 1.0.
// It is a function of rxMean and SNR: llrUnity = rxMean * qamCorr / (2*snr). 
// The snr needed for good performance of any QAM/rate combination
// is known in advance, therefore we can work out default llrUnity values.
//
// TARGET_LEVEL_DATA is to control scale-backs between iterations.
always @(qamEnum, sizeEnum, rateEnum)
  case (qamEnum)
    3'd0: 
      case (sizeEnum)
        2'd0: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd15; llrUnityReg = 8'd3; targetLevel = 16'd5190; end
            2'd1: begin rxMean = 8'd15; llrUnityReg = 8'd2; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd14; llrUnityReg = 8'd1; targetLevel = 16'd6170; end
            default: begin rxMean = 8'd14; llrUnityReg = 8'd1; targetLevel = 16'd0; end
          endcase
        2'd1: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd14; llrUnityReg = 8'd4; targetLevel = 16'd5650; end
            2'd1: begin rxMean = 8'd14; llrUnityReg = 8'd2; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd14; llrUnityReg = 8'd2; targetLevel = 16'd5870; end
            default: begin rxMean = 8'd14; llrUnityReg = 8'd1; targetLevel = 16'd0; end
          endcase
        default: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd12; llrUnityReg = 8'd3; targetLevel = 16'd4860; end
            2'd1: begin rxMean = 8'd12; llrUnityReg = 8'd2; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd13; llrUnityReg = 8'd2; targetLevel = 16'd3670; end
            default: begin rxMean = 8'd13; llrUnityReg = 8'd1; targetLevel = 16'd0; end
          endcase
      endcase
    3'd1: 
      case (sizeEnum)
        2'd0: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd15; llrUnityReg = 8'd3; targetLevel = 16'd5190; end
            2'd1: begin rxMean = 8'd15; llrUnityReg = 8'd2; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd14; llrUnityReg = 8'd1; targetLevel = 16'd6170; end
            default: begin rxMean = 8'd14; llrUnityReg = 8'd1; targetLevel = 16'd0; end
          endcase
        2'd1: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd14; llrUnityReg = 8'd4; targetLevel = 16'd5650; end
            2'd1: begin rxMean = 8'd14; llrUnityReg = 8'd2; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd14; llrUnityReg = 8'd2; targetLevel = 16'd5870; end
            default: begin rxMean = 8'd14; llrUnityReg = 8'd1; targetLevel = 16'd0; end
          endcase
        default: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd12; llrUnityReg = 8'd3; targetLevel = 16'd4860; end
            2'd1: begin rxMean = 8'd12; llrUnityReg = 8'd2; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd13; llrUnityReg = 8'd2; targetLevel = 16'd3670; end
            default: begin rxMean = 8'd13; llrUnityReg = 8'd1; targetLevel = 16'd0; end
          endcase
      endcase
    3'd2: 
      case (sizeEnum)
        2'd0: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd20; llrUnityReg = 8'd3; targetLevel = 16'd3200; end
            2'd1: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd21; llrUnityReg = 8'd1; targetLevel = 16'd5200; end
            default: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
          endcase
        2'd1: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd16; llrUnityReg = 8'd3; targetLevel = 16'd4800; end
            2'd1: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd20; llrUnityReg = 8'd1; targetLevel = 16'd6600; end
            default: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
          endcase
        default: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd17; llrUnityReg = 8'd3; targetLevel = 16'd3800; end
            2'd1: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd20; llrUnityReg = 8'd1; targetLevel = 16'd5200; end
            default: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
          endcase
      endcase
    3'd3: 
      case (sizeEnum)
        2'd0: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd20; llrUnityReg = 8'd2; targetLevel = 16'd3200; end
            2'd1: begin rxMean = 8'd36; llrUnityReg = 8'd2; targetLevel = 16'd6310; end
            2'd2: begin rxMean = 8'd42; llrUnityReg = 8'd2; targetLevel = 16'd5870; end
            default: begin rxMean = 8'd54; llrUnityReg = 8'd1; targetLevel = 16'd3990; end
          endcase
        2'd1: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd16; llrUnityReg = 8'd2; targetLevel = 16'd4800; end
            2'd1: begin rxMean = 8'd32; llrUnityReg = 8'd2; targetLevel = 16'd1970; end
            2'd2: begin rxMean = 8'd36; llrUnityReg = 8'd2; targetLevel = 16'd6280; end
            default: begin rxMean = 8'd41; llrUnityReg = 8'd1; targetLevel = 16'd5920; end
          endcase
        default: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd17; llrUnityReg = 8'd2; targetLevel = 16'd3800; end
            2'd1: begin rxMean = 8'd25; llrUnityReg = 8'd2; targetLevel = 16'd2690; end
            2'd2: begin rxMean = 8'd32; llrUnityReg = 8'd1; targetLevel = 16'd3690; end
            default: begin rxMean = 8'd39; llrUnityReg = 8'd1; targetLevel = 16'd6700; end
          endcase
      endcase
    default: 
      case (sizeEnum)
        2'd0: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd1: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd88; llrUnityReg = 8'd2; targetLevel = 16'd6200; end
            default: begin rxMean = 8'd126; llrUnityReg = 8'd2; targetLevel = 16'd5200; end
          endcase
        2'd1: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd1: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd78; llrUnityReg = 8'd2; targetLevel = 16'd3630; end
            default: begin rxMean = 8'd96; llrUnityReg = 8'd2; targetLevel = 16'd4900; end
          endcase
        default: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd1: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd74; llrUnityReg = 8'd2; targetLevel = 16'd6400; end
            default: begin rxMean = 8'd82; llrUnityReg = 8'd1; targetLevel = 16'd6800; end
          endcase
      endcase
  endcase

// Early termination control register. Used in conjunction with EARLY_TEST_ITERATIONS.
always @(sizeEnum, rateEnum)
  if (sizeEnum == 2'd2) begin
    case (rateEnum)
        2'd0: parityThresh = 16'd100; 2'd1: parityThresh = 16'd80; 2'd2: parityThresh = 16'd45; default: parityThresh = 16'd40; 
    endcase
  end else begin
    parityThresh = 16'd255;
  end

// Define the nCw that marks the start of the next NOM_ITERATIONS bucket.
always @(sizeEnum, rateEnum, nCw, nSym) begin
  if (sizeEnum != 2'd2)
    bucketIdx = 0;
  else
    case (rateEnum)
      2'd0 : bucketIdx = (nSym < 2) ? 3'd0 :
             (nCw < 12) ? 3'd1 :
             (nCw < 33) ? 3'd2 : 3'd3;
      2'd1 : bucketIdx = (nSym < 2) ? 3'd0 :
             (nCw < 9) ? 3'd1 :
             (nCw < 25) ? 3'd2 : 3'd3;
      2'd2 : bucketIdx = (nSym < 2) ? 3'd0 :
             (nCw < 8) ? 3'd1 :
             (nCw < 22) ? 3'd2 : 3'd3;
      default : bucketIdx = (nSym < 2) ? 3'd0 :
             (nCw < 7) ? 3'd1 :
             (nCw < 20) ? 3'd2 : 3'd3;
    endcase
end

// Iteration control registers determine throughput and latency during and at the
// end of the packet. The following tables provide pre-calculated register settings
// based on Bandwidth and MCS.

// Find the index into the iteration tables (according to bw/mcs/ac/nss).
always @(ac, rateEnum, bw, mcs, nssLess1) begin
  case (rateEnum)
    2'd0 : 
      dataRateIdx = 
        ((bw==2'd0) && (mcs==7'd11) && (ac==1'b0) || // mcs_n20x2_em 11
         (bw==2'd0) && (mcs==7'd3) && (ac==1'b1) && (nssLess1==2'd1)) ? 3'd1 : // mcs_20x2 3
        3'd0;
    2'd1 : 
      dataRateIdx = 
        ((bw==2'd0) && (mcs==7'd13) && (ac==1'b0) || // mcs_n20x2_em 13
         (bw==2'd0) && (mcs==7'd5) && (ac==1'b1) && (nssLess1==2'd1)) ? 3'd1 : // mcs_20x2 5
        3'd0;
    2'd2 : 
      dataRateIdx = 
        ((bw==2'd0) && (mcs==7'd8) && (ac==1'b1) && (nssLess1==2'd1)) ? 3'd4 : // mcs_20x2 8
        ((bw==2'd0) && (mcs==7'd14) && (ac==1'b0) || // mcs_n20x2_em 14
         (bw==2'd0) && (mcs==7'd6) && (ac==1'b1) && (nssLess1==2'd1)) ? 3'd3 : // mcs_20x2 6
        ((bw==2'd0) && (mcs==7'd12) && (ac==1'b0) || // mcs_n20x2_em 12
         (bw==2'd0) && (mcs==7'd8) && (ac==1'b1) && (nssLess1==2'd0) || // mcs_20x1 8
         (bw==2'd0) && (mcs==7'd4) && (ac==1'b1) && (nssLess1==2'd1)) ? 3'd2 : // mcs_20x2 4
        ((bw==2'd0) && (mcs==7'd6) && (ac==1'b0) || // mcs_n20x1 6
         (bw==2'd0) && (mcs==7'd6) && (ac==1'b1) && (nssLess1==2'd0)) ? 3'd1 : // mcs_20x1 6
        3'd0;
    default : 
      dataRateIdx = 
        ((bw==2'd0) && (mcs==7'd15) && (ac==1'b0) || // mcs_n20x2_em 15
         (bw==2'd0) && (mcs==7'd7) && (ac==1'b1) && (nssLess1==2'd1)) ? 3'd1 : // mcs_20x2 7
        3'd0;
  endcase
end // always

// Lookup iteration settings according to dataRate
always @(sizeEnum, rateEnum, dataRateIdx, bucketIdx) begin
  case (rateEnum)
    2'd0 : 
      if (dataRateIdx == 3'd0) begin // 29Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd40; endRunningCount = 8'd40; nomIterations = 8'd40;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd35; endRunningCount = 8'd35; nomIterations = 8'd35;
        end else begin
          earlyTestIterations = 5'd8; maxRunningCount = 8'd80;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd64; endRunningCount = 8'd30;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd80; endRunningCount = 8'd30;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd80; endRunningCount = 8'd30;
          end else begin
            nomIterations = 8'd80; endRunningCount = 8'd30;
          end // if bucketIdx
        end // if sizeEnum
      end else begin // 58Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd50; endRunningCount = 8'd50; nomIterations = 8'd50;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd43; endRunningCount = 8'd43; nomIterations = 8'd43;
        end else begin
          earlyTestIterations = 5'd9; maxRunningCount = 8'd88;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd64; endRunningCount = 8'd38;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd64; endRunningCount = 8'd38;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd88; endRunningCount = 8'd38;
          end else begin
            nomIterations = 8'd88; endRunningCount = 8'd38;
          end // if bucketIdx
        end // if sizeEnum
      end // dataRateIdx
    2'd1 : 
      if (dataRateIdx == 3'd0) begin // 58Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd42; endRunningCount = 8'd42; nomIterations = 8'd42;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd35; endRunningCount = 8'd35; nomIterations = 8'd35;
        end else begin
          earlyTestIterations = 5'd9; maxRunningCount = 8'd87;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd70; endRunningCount = 8'd27;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd70; endRunningCount = 8'd27;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd87; endRunningCount = 8'd27;
          end else begin
            nomIterations = 8'd87; endRunningCount = 8'd27;
          end // if bucketIdx
        end // if sizeEnum
      end else begin // 116Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd52; endRunningCount = 8'd52; nomIterations = 8'd52;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd37; endRunningCount = 8'd37; nomIterations = 8'd37;
        end else begin
          earlyTestIterations = 5'd7; maxRunningCount = 8'd89;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd70; endRunningCount = 8'd29;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd70; endRunningCount = 8'd29;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd70; endRunningCount = 8'd29;
          end else begin
            nomIterations = 8'd70; endRunningCount = 8'd29;
          end // if bucketIdx
        end // if sizeEnum
      end // dataRateIdx
    2'd2 : 
      if (dataRateIdx == 3'd0) begin // 44Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd43; endRunningCount = 8'd43; nomIterations = 8'd43;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd34; endRunningCount = 8'd34; nomIterations = 8'd34;
        end else begin
          earlyTestIterations = 5'd10; maxRunningCount = 8'd94;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd75; endRunningCount = 8'd26;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd94; endRunningCount = 8'd26;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd94; endRunningCount = 8'd26;
          end else begin
            nomIterations = 8'd94; endRunningCount = 8'd26;
          end // if bucketIdx
        end // if sizeEnum
      end else if (dataRateIdx == 3'd1) begin // 65Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd53; endRunningCount = 8'd53; nomIterations = 8'd53;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd44; endRunningCount = 8'd44; nomIterations = 8'd44;
        end else begin
          earlyTestIterations = 5'd11; maxRunningCount = 8'd105;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd75; endRunningCount = 8'd36;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd75; endRunningCount = 8'd35;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd105; endRunningCount = 8'd36;
          end else begin
            nomIterations = 8'd105; endRunningCount = 8'd36;
          end // if bucketIdx
        end // if sizeEnum
      end else if (dataRateIdx == 3'd2) begin // 87Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd55; endRunningCount = 8'd55; nomIterations = 8'd55;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd44; endRunningCount = 8'd44; nomIterations = 8'd44;
        end else begin
          earlyTestIterations = 5'd11; maxRunningCount = 8'd105;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd75; endRunningCount = 8'd36;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd75; endRunningCount = 8'd35;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd105; endRunningCount = 8'd36;
          end else begin
            nomIterations = 8'd105; endRunningCount = 8'd36;
          end // if bucketIdx
        end // if sizeEnum
      end else if (dataRateIdx == 3'd3) begin // 130Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd53; endRunningCount = 8'd53; nomIterations = 8'd53;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd36; endRunningCount = 8'd36; nomIterations = 8'd36;
        end else begin
          earlyTestIterations = 5'd7; maxRunningCount = 8'd96;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd75; endRunningCount = 8'd28;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd75; endRunningCount = 8'd27;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd75; endRunningCount = 8'd27;
          end else begin
            nomIterations = 8'd75; endRunningCount = 8'd28;
          end // if bucketIdx
        end // if sizeEnum
      end else begin // 174Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd55; endRunningCount = 8'd55; nomIterations = 8'd55;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd14; endRunningCount = 8'd14; nomIterations = 8'd14;
        end else begin
          earlyTestIterations = 5'd7; maxRunningCount = 8'd96;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd75; endRunningCount = 8'd28;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd75; endRunningCount = 8'd28;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd75; endRunningCount = 8'd27;
          end else begin
            nomIterations = 8'd75; endRunningCount = 8'd28;
          end // if bucketIdx
        end // if sizeEnum
      end // dataRateIdx
    default : 
      if (dataRateIdx == 3'd0) begin // 73Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd44; endRunningCount = 8'd44; nomIterations = 8'd44;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd34; endRunningCount = 8'd34; nomIterations = 8'd34;
        end else begin
          earlyTestIterations = 5'd11; maxRunningCount = 8'd106;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd85; endRunningCount = 8'd25;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd85; endRunningCount = 8'd25;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd106; endRunningCount = 8'd25;
          end else begin
            nomIterations = 8'd106; endRunningCount = 8'd25;
          end // if bucketIdx
        end // if sizeEnum
      end else begin // 145Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd55; endRunningCount = 8'd55; nomIterations = 8'd55;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd37; endRunningCount = 8'd37; nomIterations = 8'd37;
        end else begin
          earlyTestIterations = 5'd9; maxRunningCount = 8'd108;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd85; endRunningCount = 8'd28;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd85; endRunningCount = 8'd27;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd85; endRunningCount = 8'd27;
          end else begin
            nomIterations = 8'd85; endRunningCount = 8'd27;
          end // if bucketIdx
        end // if sizeEnum
      end // dataRateIdx
  endcase
end // always
endmodule
