// This block allows the decoder's programmable registers to be replaced
// by look up tables. A verbose format with nested case/if structures is used
// due to limitations in Verilog.

// Author: Blue Rum Consulting Ltd. Auto-generated on 17-Jun-2015.
`ifdef RW_TXRX_2X2

`ifdef LDEC_SV
`include "ldpcDec.svh"
`else
`include "ldpcDec.vh"
`endif

module ldpcDecLu (       
input  [2:0]         qamEnum,  // 0:4 is BPSK, QPSK, 16QAM, 64QAM, 256QAM
input  [1:0]         sizeEnum, // zEnum
input  [1:0]         rateEnum, // rEnum
input                ac,       // 0:11n 1:11ac
input  [1:0]         bw,       // 0:3 is 20/40/80/160MHz
input  [6:0]         mcs,      // 0-9 for 11ac, 0-72 for 11n
input  [1:0]         nssLess1, // e.g. NSS=4 is specified as a 3.
input  [`LDEC_B_BITS-1:0] nCw,      // packetLen in LDPC blocks
input  [1:0]         nSym,     // num OFDM symbols. clip this to 3.

output reg [7:0]                            rxMean,
output reg [`LDEC_CHK_BITS-2:0]             llrUnityReg,
output reg [`LDEC_VAR_BITS-1+7:0]           targetLevel,
output reg [numBits(`LDEC_K_MAX)-1:0]       parityThresh,
output reg [numBits(8*`LDEC_MAX_ITER)-1:0]  nomIterations,
output reg [numBits(`LDEC_MAX_ITER)-1:0]    earlyTestIterations,
output reg [numBits(8*`LDEC_MAX_ITER)-1:0]  maxRunningCount,
output reg [numBits(8*`LDEC_MAX_ITER)-1:0]  endRunningCount);

`ifdef LDEC_SV
`include "ldpcDecFuncs.svh"
`else
`include "ldpcDecFuncs.vh"
`endif

localparam DRI_BITS = 3;
localparam BK_BITS = 3;
reg [BK_BITS-1:0]  bucketIdx; // selects a range of packet lengths
reg [DRI_BITS-1:0] dataRateIdx; // selects iteration settings according to datarates

// RX_MEAN is for demapper scaling and is not used in the decoder.
// It is the empirically selected optimal mean value of the LLRs.
// Higher QAM needs higher RX_MEAN to give visibility to inner constellation
// points. Stronger coding rates need lower RX_MEAN to give headroom
// for internal processing gain during each iteration. Your demapper
// may need different scaling compared to the Blue Rum model, however
// these two factors will always apply.
//
// llrUnity is the integer that represents a floating point LLR of 1.0.
// It is a function of rxMean and SNR: llrUnity = rxMean * qamCorr / (2*snr). 
// The snr needed for good performance of any QAM/rate combination
// is known in advance, therefore we can work out default llrUnity values.
//
// TARGET_LEVEL_DATA is to control scale-backs between iterations.
always @(qamEnum, sizeEnum, rateEnum)
  case (qamEnum)
    3'd0: 
      case (sizeEnum)
        2'd0: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd15; llrUnityReg = 8'd3; targetLevel = 16'd5190; end
            2'd1: begin rxMean = 8'd15; llrUnityReg = 8'd2; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd14; llrUnityReg = 8'd1; targetLevel = 16'd6170; end
            default: begin rxMean = 8'd14; llrUnityReg = 8'd1; targetLevel = 16'd0; end
          endcase
        2'd1: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd14; llrUnityReg = 8'd4; targetLevel = 16'd5650; end
            2'd1: begin rxMean = 8'd14; llrUnityReg = 8'd2; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd14; llrUnityReg = 8'd2; targetLevel = 16'd5870; end
            default: begin rxMean = 8'd14; llrUnityReg = 8'd1; targetLevel = 16'd0; end
          endcase
        default: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd12; llrUnityReg = 8'd3; targetLevel = 16'd4860; end
            2'd1: begin rxMean = 8'd12; llrUnityReg = 8'd2; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd13; llrUnityReg = 8'd2; targetLevel = 16'd3670; end
            default: begin rxMean = 8'd13; llrUnityReg = 8'd1; targetLevel = 16'd0; end
          endcase
      endcase
    3'd1: 
      case (sizeEnum)
        2'd0: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd15; llrUnityReg = 8'd3; targetLevel = 16'd5190; end
            2'd1: begin rxMean = 8'd15; llrUnityReg = 8'd2; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd14; llrUnityReg = 8'd1; targetLevel = 16'd6170; end
            default: begin rxMean = 8'd14; llrUnityReg = 8'd1; targetLevel = 16'd0; end
          endcase
        2'd1: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd14; llrUnityReg = 8'd4; targetLevel = 16'd5650; end
            2'd1: begin rxMean = 8'd14; llrUnityReg = 8'd2; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd14; llrUnityReg = 8'd2; targetLevel = 16'd5870; end
            default: begin rxMean = 8'd14; llrUnityReg = 8'd1; targetLevel = 16'd0; end
          endcase
        default: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd12; llrUnityReg = 8'd3; targetLevel = 16'd4860; end
            2'd1: begin rxMean = 8'd12; llrUnityReg = 8'd2; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd13; llrUnityReg = 8'd2; targetLevel = 16'd3670; end
            default: begin rxMean = 8'd13; llrUnityReg = 8'd1; targetLevel = 16'd0; end
          endcase
      endcase
    3'd2: 
      case (sizeEnum)
        2'd0: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd20; llrUnityReg = 8'd3; targetLevel = 16'd3200; end
            2'd1: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd21; llrUnityReg = 8'd1; targetLevel = 16'd5200; end
            default: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
          endcase
        2'd1: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd16; llrUnityReg = 8'd3; targetLevel = 16'd4800; end
            2'd1: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd20; llrUnityReg = 8'd1; targetLevel = 16'd6600; end
            default: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
          endcase
        default: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd17; llrUnityReg = 8'd3; targetLevel = 16'd3800; end
            2'd1: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd20; llrUnityReg = 8'd1; targetLevel = 16'd5200; end
            default: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
          endcase
      endcase
    3'd3: 
      case (sizeEnum)
        2'd0: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd20; llrUnityReg = 8'd2; targetLevel = 16'd3200; end
            2'd1: begin rxMean = 8'd36; llrUnityReg = 8'd2; targetLevel = 16'd6310; end
            2'd2: begin rxMean = 8'd42; llrUnityReg = 8'd2; targetLevel = 16'd5870; end
            default: begin rxMean = 8'd54; llrUnityReg = 8'd1; targetLevel = 16'd3990; end
          endcase
        2'd1: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd16; llrUnityReg = 8'd2; targetLevel = 16'd4800; end
            2'd1: begin rxMean = 8'd32; llrUnityReg = 8'd2; targetLevel = 16'd1970; end
            2'd2: begin rxMean = 8'd36; llrUnityReg = 8'd2; targetLevel = 16'd6280; end
            default: begin rxMean = 8'd41; llrUnityReg = 8'd1; targetLevel = 16'd5920; end
          endcase
        default: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd17; llrUnityReg = 8'd2; targetLevel = 16'd3800; end
            2'd1: begin rxMean = 8'd25; llrUnityReg = 8'd2; targetLevel = 16'd2690; end
            2'd2: begin rxMean = 8'd32; llrUnityReg = 8'd1; targetLevel = 16'd3690; end
            default: begin rxMean = 8'd39; llrUnityReg = 8'd1; targetLevel = 16'd6700; end
          endcase
      endcase
    default: 
      case (sizeEnum)
        2'd0: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd1: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd88; llrUnityReg = 8'd2; targetLevel = 16'd6200; end
            default: begin rxMean = 8'd126; llrUnityReg = 8'd2; targetLevel = 16'd5200; end
          endcase
        2'd1: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd1: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd78; llrUnityReg = 8'd2; targetLevel = 16'd3630; end
            default: begin rxMean = 8'd96; llrUnityReg = 8'd2; targetLevel = 16'd4900; end
          endcase
        default: 
          case (rateEnum)
            2'd0: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd1: begin rxMean = 8'd0; llrUnityReg = 8'd0; targetLevel = 16'd0; end
            2'd2: begin rxMean = 8'd74; llrUnityReg = 8'd2; targetLevel = 16'd6400; end
            default: begin rxMean = 8'd82; llrUnityReg = 8'd1; targetLevel = 16'd6800; end
          endcase
      endcase
  endcase

// Early termination control register. Used in conjunction with EARLY_TEST_ITERATIONS.
always @(sizeEnum, rateEnum)
  if (sizeEnum == 2'd2) begin
    case (rateEnum)
        2'd0: parityThresh = 16'd100; 2'd1: parityThresh = 16'd80; 2'd2: parityThresh = 16'd45; default: parityThresh = 16'd40; 
    endcase
  end else begin
    parityThresh = 16'd255;
  end

// Define the nCw that marks the start of the next NOM_ITERATIONS bucket.
always @(sizeEnum, rateEnum, nCw, nSym) begin
  if (sizeEnum != 2'd2)
    bucketIdx = 0;
  else
    case (rateEnum)
      2'd0 : bucketIdx = (nSym < 2) ? 3'd0 :
             (nCw < 12) ? 3'd1 :
             (nCw < 33) ? 3'd2 : 3'd3;
      2'd1 : bucketIdx = (nSym < 2) ? 3'd0 :
             (nCw < 9) ? 3'd1 :
             (nCw < 25) ? 3'd2 : 3'd3;
      2'd2 : bucketIdx = (nSym < 2) ? 3'd0 :
             (nCw < 8) ? 3'd1 :
             (nCw < 22) ? 3'd2 : 3'd3;
      default : bucketIdx = (nSym < 2) ? 3'd0 :
             (nCw < 7) ? 3'd1 :
             (nCw < 20) ? 3'd2 : 3'd3;
    endcase
end

// Iteration control registers determine throughput and latency during and at the
// end of the packet. The following tables provide pre-calculated register settings
// based on Bandwidth and MCS.

// Find the index into the iteration tables (according to bw/mcs/ac/nss).
always @(ac, rateEnum, bw, mcs, nssLess1) begin
  case (rateEnum)
    2'd0 : 
      dataRateIdx = 
        ((bw==2'd2) && (mcs==7'd3) && (ac==1'b1) && (nssLess1==2'd1)) ? 3'd4 : // mcs_80x2 3
        ((bw==2'd1) && (mcs==7'd35) && (ac==1'b0)) ? 3'd3 : // mcs_n40x2 35
        ((bw==2'd1) && (mcs==7'd11) && (ac==1'b0) || // mcs_n40x2 11
         (bw==2'd1) && (mcs==7'd34) && (ac==1'b0) || // mcs_n40x2 34
         (bw==2'd1) && (mcs==7'd3) && (ac==1'b1) && (nssLess1==2'd1) || // mcs_40x2 3
         (bw==2'd2) && (mcs==7'd3) && (ac==1'b1) && (nssLess1==2'd0) || // mcs_80x1 3
         (bw==2'd2) && (mcs==7'd1) && (ac==1'b1) && (nssLess1==2'd1)) ? 3'd2 : // mcs_80x2 1
        ((bw==2'd1) && (mcs==7'd33) && (ac==1'b0)) ? 3'd1 : // mcs_n40x2 33
        3'd0;
    2'd1 : 
      dataRateIdx = 
        ((bw==2'd2) && (mcs==7'd5) && (ac==1'b1) && (nssLess1==2'd1)) ? 3'd2 : // mcs_80x2 5
        ((bw==2'd1) && (mcs==7'd13) && (ac==1'b0) || // mcs_n40x2 13
         (bw==2'd1) && (mcs==7'd5) && (ac==1'b1) && (nssLess1==2'd1) || // mcs_40x2 5
         (bw==2'd2) && (mcs==7'd5) && (ac==1'b1) && (nssLess1==2'd0)) ? 3'd1 : // mcs_80x1 5
        3'd0;
    2'd2 : 
      dataRateIdx = 
        ((bw==2'd2) && (mcs==7'd8) && (ac==1'b1) && (nssLess1==2'd1)) ? 3'd4 : // mcs_80x2 8
        ((bw==2'd2) && (mcs==7'd6) && (ac==1'b1) && (nssLess1==2'd1)) ? 3'd3 : // mcs_80x2 6
        ((bw==2'd1) && (mcs==7'd8) && (ac==1'b1) && (nssLess1==2'd1) || // mcs_40x2 8
         (bw==2'd2) && (mcs==7'd8) && (ac==1'b1) && (nssLess1==2'd0) || // mcs_80x1 8
         (bw==2'd2) && (mcs==7'd4) && (ac==1'b1) && (nssLess1==2'd1)) ? 3'd2 : // mcs_80x2 4
        ((bw==2'd1) && (mcs==7'd14) && (ac==1'b0) || // mcs_n40x2 14
         (bw==2'd1) && (mcs==7'd6) && (ac==1'b1) && (nssLess1==2'd1) || // mcs_40x2 6
         (bw==2'd2) && (mcs==7'd6) && (ac==1'b1) && (nssLess1==2'd0)) ? 3'd1 : // mcs_80x1 6
        3'd0;
    default : 
      dataRateIdx = 
        ((bw==2'd2) && (mcs==7'd9) && (ac==1'b1) && (nssLess1==2'd1)) ? 3'd4 : // mcs_80x2 9
        ((bw==2'd2) && (mcs==7'd7) && (ac==1'b1) && (nssLess1==2'd1)) ? 3'd3 : // mcs_80x2 7
        ((bw==2'd1) && (mcs==7'd9) && (ac==1'b1) && (nssLess1==2'd1) || // mcs_40x2 9
         (bw==2'd2) && (mcs==7'd9) && (ac==1'b1) && (nssLess1==2'd0)) ? 3'd2 : // mcs_80x1 9
        ((bw==2'd1) && (mcs==7'd15) && (ac==1'b0) || // mcs_n40x2 15
         (bw==2'd1) && (mcs==7'd7) && (ac==1'b1) && (nssLess1==2'd1) || // mcs_40x2 7
         (bw==2'd2) && (mcs==7'd7) && (ac==1'b1) && (nssLess1==2'd0)) ? 3'd1 : // mcs_80x1 7
        3'd0;
  endcase
end // always

// Lookup iteration settings according to dataRate
always @(sizeEnum, rateEnum, dataRateIdx, bucketIdx) begin
  case (rateEnum)
    2'd0 : 
      if (dataRateIdx == 3'd0) begin // 73Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd120; endRunningCount = 8'd120; nomIterations = 8'd120;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd116; endRunningCount = 8'd116; nomIterations = 8'd73;
        end else begin
          earlyTestIterations = 5'd17; maxRunningCount = 8'd248;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd73; endRunningCount = 8'd112;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd73; endRunningCount = 8'd119;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd148; endRunningCount = 8'd119;
          end else begin
            nomIterations = 8'd148; endRunningCount = 8'd119;
          end // if bucketIdx
        end // if sizeEnum
      end else if (dataRateIdx == 3'd1) begin // 90Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd128; endRunningCount = 8'd128; nomIterations = 8'd128;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd125; endRunningCount = 8'd125; nomIterations = 8'd73;
        end else begin
          earlyTestIterations = 5'd17; maxRunningCount = 8'd248;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd73; endRunningCount = 8'd121;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd73; endRunningCount = 8'd120;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd148; endRunningCount = 8'd120;
          end else begin
            nomIterations = 8'd148; endRunningCount = 8'd120;
          end // if bucketIdx
        end // if sizeEnum
      end else if (dataRateIdx == 3'd2) begin // 130Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd125; endRunningCount = 8'd125; nomIterations = 8'd125;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd116; endRunningCount = 8'd116; nomIterations = 8'd73;
        end else begin
          earlyTestIterations = 5'd17; maxRunningCount = 8'd209;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd73; endRunningCount = 8'd112;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd73; endRunningCount = 8'd112;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd148; endRunningCount = 8'd111;
          end else begin
            nomIterations = 8'd148; endRunningCount = 8'd112;
          end // if bucketIdx
        end // if sizeEnum
      end else if (dataRateIdx == 3'd3) begin // 150Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd127; endRunningCount = 8'd127; nomIterations = 8'd127;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd117; endRunningCount = 8'd117; nomIterations = 8'd73;
        end else begin
          earlyTestIterations = 5'd7; maxRunningCount = 8'd155;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd73; endRunningCount = 8'd111;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd73; endRunningCount = 8'd112;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd73; endRunningCount = 8'd113;
          end else begin
            nomIterations = 8'd73; endRunningCount = 8'd113;
          end // if bucketIdx
        end // if sizeEnum
      end else begin // 260Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd130; endRunningCount = 8'd130; nomIterations = 8'd130;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd84; endRunningCount = 8'd84; nomIterations = 8'd36;
        end else begin
          earlyTestIterations = 5'd7; maxRunningCount = 8'd155;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd73; endRunningCount = 8'd111;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd73; endRunningCount = 8'd111;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd73; endRunningCount = 8'd111;
          end else begin
            nomIterations = 8'd73; endRunningCount = 8'd111;
          end // if bucketIdx
        end // if sizeEnum
      end // dataRateIdx
    2'd1 : 
      if (dataRateIdx == 3'd0) begin // 120Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd132; endRunningCount = 8'd132; nomIterations = 8'd132;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd124; endRunningCount = 8'd124; nomIterations = 8'd81;
        end else begin
          earlyTestIterations = 5'd18; maxRunningCount = 8'd248;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd81; endRunningCount = 8'd117;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd81; endRunningCount = 8'd126;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd163; endRunningCount = 8'd125;
          end else begin
            nomIterations = 8'd163; endRunningCount = 8'd125;
          end // if bucketIdx
        end // if sizeEnum
      end else if (dataRateIdx == 3'd1) begin // 260Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd141; endRunningCount = 8'd141; nomIterations = 8'd141;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd85; endRunningCount = 8'd85; nomIterations = 8'd39;
        end else begin
          earlyTestIterations = 5'd8; maxRunningCount = 8'd170;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd81; endRunningCount = 8'd116;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd81; endRunningCount = 8'd116;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd81; endRunningCount = 8'd116;
          end else begin
            nomIterations = 8'd81; endRunningCount = 8'd116;
          end // if bucketIdx
        end // if sizeEnum
      end else begin // 520Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd141; endRunningCount = 8'd141; nomIterations = 8'd141;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd85; endRunningCount = 8'd85; nomIterations = 8'd39;
        end else begin
          earlyTestIterations = 5'd7; maxRunningCount = 8'd133;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd39; endRunningCount = 8'd71;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd39; endRunningCount = 8'd81;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd39; endRunningCount = 8'd81;
          end else begin
            nomIterations = 8'd53; endRunningCount = 8'd57;
          end // if bucketIdx
        end // if sizeEnum
      end // dataRateIdx
    2'd2 : 
      if (dataRateIdx == 3'd0) begin // 225Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd136; endRunningCount = 8'd136; nomIterations = 8'd136;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd127; endRunningCount = 8'd127; nomIterations = 8'd84;
        end else begin
          earlyTestIterations = 5'd9; maxRunningCount = 8'd170;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd86; endRunningCount = 8'd123;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd86; endRunningCount = 8'd123;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd86; endRunningCount = 8'd124;
          end else begin
            nomIterations = 8'd86; endRunningCount = 8'd124;
          end // if bucketIdx
        end // if sizeEnum
      end else if (dataRateIdx == 3'd1) begin // 293Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd146; endRunningCount = 8'd146; nomIterations = 8'd146;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd86; endRunningCount = 8'd86; nomIterations = 8'd41;
        end else begin
          earlyTestIterations = 5'd9; maxRunningCount = 8'd183;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd86; endRunningCount = 8'd122;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd86; endRunningCount = 8'd122;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd86; endRunningCount = 8'd122;
          end else begin
            nomIterations = 8'd86; endRunningCount = 8'd122;
          end // if bucketIdx
        end // if sizeEnum
      end else if (dataRateIdx == 3'd2) begin // 390Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd148; endRunningCount = 8'd148; nomIterations = 8'd148;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd90; endRunningCount = 8'd90; nomIterations = 8'd41;
        end else begin
          earlyTestIterations = 5'd9; maxRunningCount = 8'd183;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd86; endRunningCount = 8'd122;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd86; endRunningCount = 8'd122;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd86; endRunningCount = 8'd122;
          end else begin
            nomIterations = 8'd86; endRunningCount = 8'd122;
          end // if bucketIdx
        end // if sizeEnum
      end else if (dataRateIdx == 3'd3) begin // 585Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd146; endRunningCount = 8'd146; nomIterations = 8'd146;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd86; endRunningCount = 8'd86; nomIterations = 8'd41;
        end else begin
          earlyTestIterations = 5'd5; maxRunningCount = 8'd148;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd42; endRunningCount = 8'd72;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd42; endRunningCount = 8'd85;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd42; endRunningCount = 8'd83;
          end else begin
            nomIterations = 8'd57; endRunningCount = 8'd57;
          end // if bucketIdx
        end // if sizeEnum
      end else begin // 780Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd148; endRunningCount = 8'd148; nomIterations = 8'd148;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd90; endRunningCount = 8'd90; nomIterations = 8'd41;
        end else begin
          earlyTestIterations = 5'd5; maxRunningCount = 8'd125;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd42; endRunningCount = 8'd78;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd42; endRunningCount = 8'd78;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd42; endRunningCount = 8'd78;
          end else begin
            nomIterations = 8'd42; endRunningCount = 8'd78;
          end // if bucketIdx
        end // if sizeEnum
      end // dataRateIdx
    default : 
      if (dataRateIdx == 3'd0) begin // 200Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd145; endRunningCount = 8'd145; nomIterations = 8'd145;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd137; endRunningCount = 8'd137; nomIterations = 8'd91;
        end else begin
          earlyTestIterations = 5'd23; maxRunningCount = 8'd248;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd97; endRunningCount = 8'd135;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd97; endRunningCount = 8'd146;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd198; endRunningCount = 8'd145;
          end else begin
            nomIterations = 8'd198; endRunningCount = 8'd145;
          end // if bucketIdx
        end // if sizeEnum
      end else if (dataRateIdx == 3'd1) begin // 325Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd155; endRunningCount = 8'd155; nomIterations = 8'd155;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd92; endRunningCount = 8'd92; nomIterations = 8'd44;
        end else begin
          earlyTestIterations = 5'd10; maxRunningCount = 8'd207;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd97; endRunningCount = 8'd134;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd97; endRunningCount = 8'd134;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd97; endRunningCount = 8'd134;
          end else begin
            nomIterations = 8'd97; endRunningCount = 8'd134;
          end // if bucketIdx
        end // if sizeEnum
      end else if (dataRateIdx == 3'd2) begin // 434Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd157; endRunningCount = 8'd157; nomIterations = 8'd157;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd96; endRunningCount = 8'd96; nomIterations = 8'd44;
        end else begin
          earlyTestIterations = 5'd10; maxRunningCount = 8'd207;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd97; endRunningCount = 8'd134;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd97; endRunningCount = 8'd134;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd97; endRunningCount = 8'd134;
          end else begin
            nomIterations = 8'd97; endRunningCount = 8'd134;
          end // if bucketIdx
        end // if sizeEnum
      end else if (dataRateIdx == 3'd3) begin // 650Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd155; endRunningCount = 8'd155; nomIterations = 8'd155;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd92; endRunningCount = 8'd92; nomIterations = 8'd44;
        end else begin
          earlyTestIterations = 5'd6; maxRunningCount = 8'd167;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd47; endRunningCount = 8'd78;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd47; endRunningCount = 8'd93;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd47; endRunningCount = 8'd91;
          end else begin
            nomIterations = 8'd64; endRunningCount = 8'd60;
          end // if bucketIdx
        end // if sizeEnum
      end else begin // 867Mbps
        if (sizeEnum == 2'd0) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd157; endRunningCount = 8'd157; nomIterations = 8'd157;
        end else if (sizeEnum == 2'd1) begin
          earlyTestIterations = 5'd31; maxRunningCount = 8'd96; endRunningCount = 8'd96; nomIterations = 8'd44;
        end else begin
          earlyTestIterations = 5'd6; maxRunningCount = 8'd141;
          if (bucketIdx == 3'd0) begin
            nomIterations = 8'd47; endRunningCount = 8'd85;
          end else if (bucketIdx == 3'd1) begin
            nomIterations = 8'd47; endRunningCount = 8'd85;
          end else if (bucketIdx == 3'd2) begin
            nomIterations = 8'd47; endRunningCount = 8'd85;
          end else begin
            nomIterations = 8'd47; endRunningCount = 8'd85;
          end // if bucketIdx
        end // if sizeEnum
      end // dataRateIdx
  endcase
end // always
endmodule
`endif // RW_TXRX_2X2
