// This block allows the decoder's programmable registers to be replaced
// by look up tables.

// Auto-generated on 21-Feb-2019.

module HeLdpcDecLu (       
  // Clock and reset
  input  wire          clk,
  input  wire          rst_n,
  // Packet parameters
  input  wire [2:0]    qamEnum,  // 0:5 is BPSK, QPSK, 16QAM, 64QAM, 256QAM, 1024QAM
  input  wire [1:0]    sizeEnum, // zEnum
  input  wire [1:0]    rateEnum, // rEnum
  input  wire [2:0]    RuType,   // 0:4 is RU 26/52/106/242/484
  input  wire [6:0]    mcs,      // 0-9 for 11ac, 0-72 for 11n
  input  wire [1:0]    nssLess1, // e.g. NSS=4 is specified as a 3.
  input  wire          dcm,
  input  wire [13:0]   nCw,      // packetLen in LDPC blocks
  // Output parameters not depending on data rate, only on packet size and modulation
  // Address in config RAM to read packet configuration
  output reg  [10:0] CfgAddr
  );

  // RU type
  localparam [2:0] RU26  = 3'd0,
                   RU52  = 3'd1,
                   RU106 = 3'd2,
                   RU242 = 3'd3,
                   RU484 = 3'd4,
                   RU996 = 3'd5;

reg  [1:0]     bucketIdx;   // selects a range of packet lengths
reg  [1:0]     nbucketIdx;
reg  [5:0]     dataRateIdx; // selects iteration settings according to datarates
reg  [5:0]     ndataRateIdx;

reg  [10:0]    nCfgAddr;

// Define the nCw that marks the start of the next NOM_ITERATIONS bucket.
always @(*) begin
  if (sizeEnum != 2'd2)
    nbucketIdx = 2'd0;
  else
    case (rateEnum)
      2'd0 : nbucketIdx = 
             (nCw < 2'd2) ? 2'd0 :
             (nCw < 14'd12) ? 2'd1 :
             (nCw < 14'd33) ? 2'd2 : 2'd3;
      2'd1 : nbucketIdx = 
             (nCw < 2'd2) ? 2'd0 :
             (nCw < 14'd9) ? 2'd1 :
             (nCw < 14'd25) ? 2'd2 : 2'd3;
      2'd2 : nbucketIdx = 
             (nCw < 2'd2) ? 2'd0 :
             (nCw < 14'd8) ? 2'd1 :
             (nCw < 14'd22) ? 2'd2 : 2'd3;
      default : nbucketIdx = 
             (nCw < 2'd2) ? 2'd0 :
             (nCw < 14'd7) ? 2'd1 :
             (nCw < 14'd20) ? 2'd2 : 2'd3;
    endcase
end

// Iteration control registers (stored in the configuration RAM) determine throughput and
// latency during and at the end of the packet. Decode frame parameters into the datarate index
// used to address the RAM.

// Find the index into the iteration tables.
always @(*) begin
  case ({nssLess1,rateEnum,RuType,mcs,dcm})
    // Coding Rate 1/2
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU996, 7'd3, 1'd0} : ndataRateIdx = 6'd21; // RU996 Nss 2 MCS 3, 288.2 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd0, RU996, 7'd3, 1'd0} : ndataRateIdx = 6'd20; // RU996 Nss 1 MCS 3, 144.1 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU996, 7'd1, 1'd0} : ndataRateIdx = 6'd20; // RU996 Nss 2 MCS 1, 144.1 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU996, 7'd3, 1'd1} : ndataRateIdx = 6'd20; // RU996 Nss 2 MCS 3 with DCM, 144.1 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU484, 7'd3, 1'd0} : ndataRateIdx = 6'd19; // RU484 Nss 2 MCS 3, 137.6 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd0, RU996, 7'd1, 1'd0} : ndataRateIdx = 6'd18; // RU996 Nss 1 MCS 1, 72.1 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd0, RU996, 7'd3, 1'd1} : ndataRateIdx = 6'd18; // RU996 Nss 1 MCS 3 with DCM, 72.1 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU996, 7'd0, 1'd0} : ndataRateIdx = 6'd18; // RU996 Nss 2 MCS 0, 72.1 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU996, 7'd1, 1'd1} : ndataRateIdx = 6'd18; // RU996 Nss 2 MCS 1 with DCM, 72.1 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd0, RU484, 7'd3, 1'd0} : ndataRateIdx = 6'd17; // RU484 Nss 1 MCS 3, 68.8 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU242, 7'd3, 1'd0} : ndataRateIdx = 6'd17; // RU242 Nss 2 MCS 3, 68.8 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU484, 7'd1, 1'd0} : ndataRateIdx = 6'd17; // RU484 Nss 2 MCS 1, 68.8 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU484, 7'd3, 1'd1} : ndataRateIdx = 6'd17; // RU484 Nss 2 MCS 3 with DCM, 68.8 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd0, RU996, 7'd0, 1'd0} : ndataRateIdx = 6'd16; // RU996 Nss 1 MCS 0, 36.0 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd0, RU996, 7'd1, 1'd1} : ndataRateIdx = 6'd16; // RU996 Nss 1 MCS 1 with DCM, 36.0 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU996, 7'd0, 1'd1} : ndataRateIdx = 6'd16; // RU996 Nss 2 MCS 0 with DCM, 36.0 Mbps
`endif 
    {2'd0, 2'd0, RU242, 7'd3, 1'd0} : ndataRateIdx = 6'd15; // RU242 Nss 1 MCS 3, 34.4 Mbps
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd0, RU484, 7'd1, 1'd0} : ndataRateIdx = 6'd15; // RU484 Nss 1 MCS 1, 34.4 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd0, RU484, 7'd3, 1'd1} : ndataRateIdx = 6'd15; // RU484 Nss 1 MCS 3 with DCM, 34.4 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU242, 7'd1, 1'd0} : ndataRateIdx = 6'd15; // RU242 Nss 2 MCS 1, 34.4 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU242, 7'd3, 1'd1} : ndataRateIdx = 6'd15; // RU242 Nss 2 MCS 3 with DCM, 34.4 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU484, 7'd0, 1'd0} : ndataRateIdx = 6'd15; // RU484 Nss 2 MCS 0, 34.4 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU484, 7'd1, 1'd1} : ndataRateIdx = 6'd15; // RU484 Nss 2 MCS 1 with DCM, 34.4 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU106, 7'd3, 1'd0} : ndataRateIdx = 6'd14; // RU106 Nss 2 MCS 3, 30.0 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd0, RU996, 7'd0, 1'd1} : ndataRateIdx = 6'd13; // RU996 Nss 1 MCS 0 with DCM, 18.0 Mbps
`endif 
    {2'd0, 2'd0, RU242, 7'd1, 1'd0} : ndataRateIdx = 6'd12; // RU242 Nss 1 MCS 1, 17.2 Mbps
    {2'd0, 2'd0, RU242, 7'd3, 1'd1} : ndataRateIdx = 6'd12; // RU242 Nss 1 MCS 3 with DCM, 17.2 Mbps
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd0, RU484, 7'd0, 1'd0} : ndataRateIdx = 6'd12; // RU484 Nss 1 MCS 0, 17.2 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd0, RU484, 7'd1, 1'd1} : ndataRateIdx = 6'd12; // RU484 Nss 1 MCS 1 with DCM, 17.2 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU242, 7'd0, 1'd0} : ndataRateIdx = 6'd12; // RU242 Nss 2 MCS 0, 17.2 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU242, 7'd1, 1'd1} : ndataRateIdx = 6'd12; // RU242 Nss 2 MCS 1 with DCM, 17.2 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU484, 7'd0, 1'd1} : ndataRateIdx = 6'd12; // RU484 Nss 2 MCS 0 with DCM, 17.2 Mbps
`endif 
    {2'd0, 2'd0, RU106, 7'd3, 1'd0} : ndataRateIdx = 6'd11; // RU106 Nss 1 MCS 3, 15.0 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU106, 7'd1, 1'd0} : ndataRateIdx = 6'd11; // RU106 Nss 2 MCS 1, 15.0 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU106, 7'd3, 1'd1} : ndataRateIdx = 6'd11; // RU106 Nss 2 MCS 3 with DCM, 15.0 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU52, 7'd3, 1'd0} : ndataRateIdx = 6'd10; // RU52 Nss 2 MCS 3, 14.1 Mbps
`endif 
    {2'd0, 2'd0, RU242, 7'd0, 1'd0} : ndataRateIdx = 6'd9; // RU242 Nss 1 MCS 0, 8.6 Mbps
    {2'd0, 2'd0, RU242, 7'd1, 1'd1} : ndataRateIdx = 6'd9; // RU242 Nss 1 MCS 1 with DCM, 8.6 Mbps
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd0, RU484, 7'd0, 1'd1} : ndataRateIdx = 6'd9; // RU484 Nss 1 MCS 0 with DCM, 8.6 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU242, 7'd0, 1'd1} : ndataRateIdx = 6'd9; // RU242 Nss 2 MCS 0 with DCM, 8.6 Mbps
`endif 
    {2'd0, 2'd0, RU106, 7'd1, 1'd0} : ndataRateIdx = 6'd8; // RU106 Nss 1 MCS 1, 7.5 Mbps
    {2'd0, 2'd0, RU106, 7'd3, 1'd1} : ndataRateIdx = 6'd8; // RU106 Nss 1 MCS 3 with DCM, 7.5 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU106, 7'd0, 1'd0} : ndataRateIdx = 6'd8; // RU106 Nss 2 MCS 0, 7.5 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU106, 7'd1, 1'd1} : ndataRateIdx = 6'd8; // RU106 Nss 2 MCS 1 with DCM, 7.5 Mbps
`endif 
    {2'd0, 2'd0, RU52, 7'd3, 1'd0} : ndataRateIdx = 6'd7; // RU52 Nss 1 MCS 3, 7.1 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU26, 7'd3, 1'd0} : ndataRateIdx = 6'd7; // RU26 Nss 2 MCS 3, 7.1 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU52, 7'd1, 1'd0} : ndataRateIdx = 6'd7; // RU52 Nss 2 MCS 1, 7.1 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU52, 7'd3, 1'd1} : ndataRateIdx = 6'd7; // RU52 Nss 2 MCS 3 with DCM, 7.1 Mbps
`endif 
    {2'd0, 2'd0, RU242, 7'd0, 1'd1} : ndataRateIdx = 6'd6; // RU242 Nss 1 MCS 0 with DCM, 4.3 Mbps
    {2'd0, 2'd0, RU106, 7'd0, 1'd0} : ndataRateIdx = 6'd5; // RU106 Nss 1 MCS 0, 3.7 Mbps
    {2'd0, 2'd0, RU106, 7'd1, 1'd1} : ndataRateIdx = 6'd5; // RU106 Nss 1 MCS 1 with DCM, 3.7 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU106, 7'd0, 1'd1} : ndataRateIdx = 6'd5; // RU106 Nss 2 MCS 0 with DCM, 3.7 Mbps
`endif 
    {2'd0, 2'd0, RU26, 7'd3, 1'd0} : ndataRateIdx = 6'd4; // RU26 Nss 1 MCS 3, 3.5 Mbps
    {2'd0, 2'd0, RU52, 7'd1, 1'd0} : ndataRateIdx = 6'd4; // RU52 Nss 1 MCS 1, 3.5 Mbps
    {2'd0, 2'd0, RU52, 7'd3, 1'd1} : ndataRateIdx = 6'd4; // RU52 Nss 1 MCS 3 with DCM, 3.5 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU26, 7'd1, 1'd0} : ndataRateIdx = 6'd4; // RU26 Nss 2 MCS 1, 3.5 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU26, 7'd3, 1'd1} : ndataRateIdx = 6'd4; // RU26 Nss 2 MCS 3 with DCM, 3.5 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU52, 7'd0, 1'd0} : ndataRateIdx = 6'd4; // RU52 Nss 2 MCS 0, 3.5 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU52, 7'd1, 1'd1} : ndataRateIdx = 6'd4; // RU52 Nss 2 MCS 1 with DCM, 3.5 Mbps
`endif 
    {2'd0, 2'd0, RU106, 7'd0, 1'd1} : ndataRateIdx = 6'd3; // RU106 Nss 1 MCS 0 with DCM, 1.9 Mbps
    {2'd0, 2'd0, RU26, 7'd1, 1'd0} : ndataRateIdx = 6'd2; // RU26 Nss 1 MCS 1, 1.8 Mbps
    {2'd0, 2'd0, RU26, 7'd3, 1'd1} : ndataRateIdx = 6'd2; // RU26 Nss 1 MCS 3 with DCM, 1.8 Mbps
    {2'd0, 2'd0, RU52, 7'd0, 1'd0} : ndataRateIdx = 6'd2; // RU52 Nss 1 MCS 0, 1.8 Mbps
    {2'd0, 2'd0, RU52, 7'd1, 1'd1} : ndataRateIdx = 6'd2; // RU52 Nss 1 MCS 1 with DCM, 1.8 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU26, 7'd0, 1'd0} : ndataRateIdx = 6'd2; // RU26 Nss 2 MCS 0, 1.8 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU26, 7'd1, 1'd1} : ndataRateIdx = 6'd2; // RU26 Nss 2 MCS 1 with DCM, 1.8 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU52, 7'd0, 1'd1} : ndataRateIdx = 6'd2; // RU52 Nss 2 MCS 0 with DCM, 1.8 Mbps
`endif 
    {2'd0, 2'd0, RU26, 7'd0, 1'd0} : ndataRateIdx = 6'd1; // RU26 Nss 1 MCS 0, 0.9 Mbps
    {2'd0, 2'd0, RU26, 7'd1, 1'd1} : ndataRateIdx = 6'd1; // RU26 Nss 1 MCS 1 with DCM, 0.9 Mbps
    {2'd0, 2'd0, RU52, 7'd0, 1'd1} : ndataRateIdx = 6'd1; // RU52 Nss 1 MCS 0 with DCM, 0.9 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd0, RU26, 7'd0, 1'd1} : ndataRateIdx = 6'd1; // RU26 Nss 2 MCS 0 with DCM, 0.9 Mbps
`endif 
    {2'd0, 2'd0, RU26, 7'd0, 1'd1} : ndataRateIdx = 6'd0; // RU26 Nss 1 MCS 0 with DCM, 0.4 Mbps
    // Coding Rate 2/3
`ifdef RW_TXRX_2X2
    {2'd1, 2'd1, RU996, 7'd5, 1'd0} : ndataRateIdx = 6'd9; // RU996 Nss 2 MCS 5, 576.5 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd1, RU996, 7'd5, 1'd0} : ndataRateIdx = 6'd8; // RU996 Nss 1 MCS 5, 288.2 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd1, RU484, 7'd5, 1'd0} : ndataRateIdx = 6'd7; // RU484 Nss 2 MCS 5, 275.3 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd1, RU484, 7'd5, 1'd0} : ndataRateIdx = 6'd6; // RU484 Nss 1 MCS 5, 137.6 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd1, RU242, 7'd5, 1'd0} : ndataRateIdx = 6'd6; // RU242 Nss 2 MCS 5, 137.6 Mbps
`endif 
    {2'd0, 2'd1, RU242, 7'd5, 1'd0} : ndataRateIdx = 6'd5; // RU242 Nss 1 MCS 5, 68.8 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd1, RU106, 7'd5, 1'd0} : ndataRateIdx = 6'd4; // RU106 Nss 2 MCS 5, 60.0 Mbps
`endif 
    {2'd0, 2'd1, RU106, 7'd5, 1'd0} : ndataRateIdx = 6'd3; // RU106 Nss 1 MCS 5, 30.0 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd1, RU52, 7'd5, 1'd0} : ndataRateIdx = 6'd2; // RU52 Nss 2 MCS 5, 28.2 Mbps
`endif 
    {2'd0, 2'd1, RU52, 7'd5, 1'd0} : ndataRateIdx = 6'd1; // RU52 Nss 1 MCS 5, 14.1 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd1, RU26, 7'd5, 1'd0} : ndataRateIdx = 6'd1; // RU26 Nss 2 MCS 5, 14.1 Mbps
`endif 
    {2'd0, 2'd1, RU26, 7'd5, 1'd0} : ndataRateIdx = 6'd0; // RU26 Nss 1 MCS 5, 7.1 Mbps
    // Coding Rate 3/4
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU996, 7'd10, 1'd0} : ndataRateIdx = 6'd32; // RU996 Nss 2 MCS 10, 1080.9 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU996, 7'd8, 1'd0} : ndataRateIdx = 6'd31; // RU996 Nss 2 MCS 8, 864.7 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU996, 7'd6, 1'd0} : ndataRateIdx = 6'd30; // RU996 Nss 2 MCS 6, 648.5 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd2, RU996, 7'd10, 1'd0} : ndataRateIdx = 6'd29; // RU996 Nss 1 MCS 10, 540.4 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU484, 7'd10, 1'd0} : ndataRateIdx = 6'd28; // RU484 Nss 2 MCS 10, 516.2 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd2, RU996, 7'd8, 1'd0} : ndataRateIdx = 6'd27; // RU996 Nss 1 MCS 8, 432.4 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU996, 7'd4, 1'd0} : ndataRateIdx = 6'd27; // RU996 Nss 2 MCS 4, 432.4 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU484, 7'd8, 1'd0} : ndataRateIdx = 6'd26; // RU484 Nss 2 MCS 8, 412.9 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd2, RU996, 7'd6, 1'd0} : ndataRateIdx = 6'd25; // RU996 Nss 1 MCS 6, 324.3 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU484, 7'd6, 1'd0} : ndataRateIdx = 6'd24; // RU484 Nss 2 MCS 6, 309.7 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd2, RU484, 7'd10, 1'd0} : ndataRateIdx = 6'd23; // RU484 Nss 1 MCS 10, 258.1 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU242, 7'd10, 1'd0} : ndataRateIdx = 6'd23; // RU242 Nss 2 MCS 10, 258.1 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd2, RU996, 7'd4, 1'd0} : ndataRateIdx = 6'd22; // RU996 Nss 1 MCS 4, 216.2 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU996, 7'd2, 1'd0} : ndataRateIdx = 6'd22; // RU996 Nss 2 MCS 2, 216.2 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU996, 7'd4, 1'd1} : ndataRateIdx = 6'd22; // RU996 Nss 2 MCS 4 with DCM, 216.2 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd2, RU484, 7'd8, 1'd0} : ndataRateIdx = 6'd21; // RU484 Nss 1 MCS 8, 206.5 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU242, 7'd8, 1'd0} : ndataRateIdx = 6'd21; // RU242 Nss 2 MCS 8, 206.5 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU484, 7'd4, 1'd0} : ndataRateIdx = 6'd21; // RU484 Nss 2 MCS 4, 206.5 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd2, RU484, 7'd6, 1'd0} : ndataRateIdx = 6'd20; // RU484 Nss 1 MCS 6, 154.9 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU242, 7'd6, 1'd0} : ndataRateIdx = 6'd20; // RU242 Nss 2 MCS 6, 154.9 Mbps
`endif 
    {2'd0, 2'd2, RU242, 7'd10, 1'd0} : ndataRateIdx = 6'd19; // RU242 Nss 1 MCS 10, 129.0 Mbps
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd2, RU996, 7'd2, 1'd0} : ndataRateIdx = 6'd18; // RU996 Nss 1 MCS 2, 108.1 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd2, RU996, 7'd4, 1'd1} : ndataRateIdx = 6'd18; // RU996 Nss 1 MCS 4 with DCM, 108.1 Mbps
`endif 
    {2'd0, 2'd2, RU242, 7'd8, 1'd0} : ndataRateIdx = 6'd17; // RU242 Nss 1 MCS 8, 103.2 Mbps
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd2, RU484, 7'd4, 1'd0} : ndataRateIdx = 6'd17; // RU484 Nss 1 MCS 4, 103.2 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU242, 7'd4, 1'd0} : ndataRateIdx = 6'd17; // RU242 Nss 2 MCS 4, 103.2 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU484, 7'd2, 1'd0} : ndataRateIdx = 6'd17; // RU484 Nss 2 MCS 2, 103.2 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU484, 7'd4, 1'd1} : ndataRateIdx = 6'd17; // RU484 Nss 2 MCS 4 with DCM, 103.2 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU106, 7'd8, 1'd0} : ndataRateIdx = 6'd16; // RU106 Nss 2 MCS 8, 90.0 Mbps
`endif 
    {2'd0, 2'd2, RU242, 7'd6, 1'd0} : ndataRateIdx = 6'd15; // RU242 Nss 1 MCS 6, 77.4 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU106, 7'd6, 1'd0} : ndataRateIdx = 6'd14; // RU106 Nss 2 MCS 6, 67.5 Mbps
`endif 
    {2'd0, 2'd2, RU242, 7'd4, 1'd0} : ndataRateIdx = 6'd13; // RU242 Nss 1 MCS 4, 51.6 Mbps
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd2, RU484, 7'd2, 1'd0} : ndataRateIdx = 6'd13; // RU484 Nss 1 MCS 2, 51.6 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd2, RU484, 7'd4, 1'd1} : ndataRateIdx = 6'd13; // RU484 Nss 1 MCS 4 with DCM, 51.6 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU242, 7'd2, 1'd0} : ndataRateIdx = 6'd13; // RU242 Nss 2 MCS 2, 51.6 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU242, 7'd4, 1'd1} : ndataRateIdx = 6'd13; // RU242 Nss 2 MCS 4 with DCM, 51.6 Mbps
`endif 
    {2'd0, 2'd2, RU106, 7'd8, 1'd0} : ndataRateIdx = 6'd12; // RU106 Nss 1 MCS 8, 45.0 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU106, 7'd4, 1'd0} : ndataRateIdx = 6'd12; // RU106 Nss 2 MCS 4, 45.0 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU52, 7'd8, 1'd0} : ndataRateIdx = 6'd11; // RU52 Nss 2 MCS 8, 42.4 Mbps
`endif 
    {2'd0, 2'd2, RU106, 7'd6, 1'd0} : ndataRateIdx = 6'd10; // RU106 Nss 1 MCS 6, 33.8 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU52, 7'd6, 1'd0} : ndataRateIdx = 6'd9; // RU52 Nss 2 MCS 6, 31.8 Mbps
`endif 
    {2'd0, 2'd2, RU242, 7'd2, 1'd0} : ndataRateIdx = 6'd8; // RU242 Nss 1 MCS 2, 25.8 Mbps
    {2'd0, 2'd2, RU242, 7'd4, 1'd1} : ndataRateIdx = 6'd8; // RU242 Nss 1 MCS 4 with DCM, 25.8 Mbps
    {2'd0, 2'd2, RU106, 7'd4, 1'd0} : ndataRateIdx = 6'd7; // RU106 Nss 1 MCS 4, 22.5 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU106, 7'd2, 1'd0} : ndataRateIdx = 6'd7; // RU106 Nss 2 MCS 2, 22.5 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU106, 7'd4, 1'd1} : ndataRateIdx = 6'd7; // RU106 Nss 2 MCS 4 with DCM, 22.5 Mbps
`endif 
    {2'd0, 2'd2, RU52, 7'd8, 1'd0} : ndataRateIdx = 6'd6; // RU52 Nss 1 MCS 8, 21.2 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU26, 7'd8, 1'd0} : ndataRateIdx = 6'd6; // RU26 Nss 2 MCS 8, 21.2 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU52, 7'd4, 1'd0} : ndataRateIdx = 6'd6; // RU52 Nss 2 MCS 4, 21.2 Mbps
`endif 
    {2'd0, 2'd2, RU52, 7'd6, 1'd0} : ndataRateIdx = 6'd5; // RU52 Nss 1 MCS 6, 15.9 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU26, 7'd6, 1'd0} : ndataRateIdx = 6'd5; // RU26 Nss 2 MCS 6, 15.9 Mbps
`endif 
    {2'd0, 2'd2, RU106, 7'd2, 1'd0} : ndataRateIdx = 6'd4; // RU106 Nss 1 MCS 2, 11.2 Mbps
    {2'd0, 2'd2, RU106, 7'd4, 1'd1} : ndataRateIdx = 6'd4; // RU106 Nss 1 MCS 4 with DCM, 11.2 Mbps
    {2'd0, 2'd2, RU26, 7'd8, 1'd0} : ndataRateIdx = 6'd3; // RU26 Nss 1 MCS 8, 10.6 Mbps
    {2'd0, 2'd2, RU52, 7'd4, 1'd0} : ndataRateIdx = 6'd3; // RU52 Nss 1 MCS 4, 10.6 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU26, 7'd4, 1'd0} : ndataRateIdx = 6'd3; // RU26 Nss 2 MCS 4, 10.6 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU52, 7'd2, 1'd0} : ndataRateIdx = 6'd3; // RU52 Nss 2 MCS 2, 10.6 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU52, 7'd4, 1'd1} : ndataRateIdx = 6'd3; // RU52 Nss 2 MCS 4 with DCM, 10.6 Mbps
`endif 
    {2'd0, 2'd2, RU26, 7'd6, 1'd0} : ndataRateIdx = 6'd2; // RU26 Nss 1 MCS 6, 7.9 Mbps
    {2'd0, 2'd2, RU26, 7'd4, 1'd0} : ndataRateIdx = 6'd1; // RU26 Nss 1 MCS 4, 5.3 Mbps
    {2'd0, 2'd2, RU52, 7'd2, 1'd0} : ndataRateIdx = 6'd1; // RU52 Nss 1 MCS 2, 5.3 Mbps
    {2'd0, 2'd2, RU52, 7'd4, 1'd1} : ndataRateIdx = 6'd1; // RU52 Nss 1 MCS 4 with DCM, 5.3 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU26, 7'd2, 1'd0} : ndataRateIdx = 6'd1; // RU26 Nss 2 MCS 2, 5.3 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd2, RU26, 7'd4, 1'd1} : ndataRateIdx = 6'd1; // RU26 Nss 2 MCS 4 with DCM, 5.3 Mbps
`endif 
    {2'd0, 2'd2, RU26, 7'd2, 1'd0} : ndataRateIdx = 6'd0; // RU26 Nss 1 MCS 2, 2.6 Mbps
    {2'd0, 2'd2, RU26, 7'd4, 1'd1} : ndataRateIdx = 6'd0; // RU26 Nss 1 MCS 4 with DCM, 2.6 Mbps
    // Coding Rate 5/6
`ifdef RW_TXRX_2X2
    {2'd1, 2'd3, RU996, 7'd11, 1'd0} : ndataRateIdx = 6'd24; // RU996 Nss 2 MCS 11, 1201.0 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd3, RU996, 7'd9, 1'd0} : ndataRateIdx = 6'd23; // RU996 Nss 2 MCS 9, 960.8 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd3, RU996, 7'd7, 1'd0} : ndataRateIdx = 6'd22; // RU996 Nss 2 MCS 7, 720.6 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd3, RU996, 7'd11, 1'd0} : ndataRateIdx = 6'd21; // RU996 Nss 1 MCS 11, 600.5 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd3, RU484, 7'd11, 1'd0} : ndataRateIdx = 6'd20; // RU484 Nss 2 MCS 11, 573.5 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd3, RU996, 7'd9, 1'd0} : ndataRateIdx = 6'd19; // RU996 Nss 1 MCS 9, 480.4 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd3, RU484, 7'd9, 1'd0} : ndataRateIdx = 6'd18; // RU484 Nss 2 MCS 9, 458.8 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd3, RU996, 7'd7, 1'd0} : ndataRateIdx = 6'd17; // RU996 Nss 1 MCS 7, 360.3 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd3, RU484, 7'd7, 1'd0} : ndataRateIdx = 6'd16; // RU484 Nss 2 MCS 7, 344.1 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd3, RU484, 7'd11, 1'd0} : ndataRateIdx = 6'd15; // RU484 Nss 1 MCS 11, 286.8 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd3, RU242, 7'd11, 1'd0} : ndataRateIdx = 6'd15; // RU242 Nss 2 MCS 11, 286.8 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd3, RU484, 7'd9, 1'd0} : ndataRateIdx = 6'd14; // RU484 Nss 1 MCS 9, 229.4 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd3, RU242, 7'd9, 1'd0} : ndataRateIdx = 6'd14; // RU242 Nss 2 MCS 9, 229.4 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
    {2'd0, 2'd3, RU484, 7'd7, 1'd0} : ndataRateIdx = 6'd13; // RU484 Nss 1 MCS 7, 172.1 Mbps
`endif 
`ifdef RW_TXRX_2X2
    {2'd1, 2'd3, RU242, 7'd7, 1'd0} : ndataRateIdx = 6'd13; // RU242 Nss 2 MCS 7, 172.1 Mbps
`endif 
    {2'd0, 2'd3, RU242, 7'd11, 1'd0} : ndataRateIdx = 6'd12; // RU242 Nss 1 MCS 11, 143.4 Mbps
    {2'd0, 2'd3, RU242, 7'd9, 1'd0} : ndataRateIdx = 6'd11; // RU242 Nss 1 MCS 9, 114.7 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd3, RU106, 7'd9, 1'd0} : ndataRateIdx = 6'd10; // RU106 Nss 2 MCS 9, 100.0 Mbps
`endif 
    {2'd0, 2'd3, RU242, 7'd7, 1'd0} : ndataRateIdx = 6'd9; // RU242 Nss 1 MCS 7, 86.0 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd3, RU106, 7'd7, 1'd0} : ndataRateIdx = 6'd8; // RU106 Nss 2 MCS 7, 75.0 Mbps
`endif 
    {2'd0, 2'd3, RU106, 7'd9, 1'd0} : ndataRateIdx = 6'd7; // RU106 Nss 1 MCS 9, 50.0 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd3, RU52, 7'd9, 1'd0} : ndataRateIdx = 6'd6; // RU52 Nss 2 MCS 9, 47.1 Mbps
`endif 
    {2'd0, 2'd3, RU106, 7'd7, 1'd0} : ndataRateIdx = 6'd5; // RU106 Nss 1 MCS 7, 37.5 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd3, RU52, 7'd7, 1'd0} : ndataRateIdx = 6'd4; // RU52 Nss 2 MCS 7, 35.3 Mbps
`endif 
    {2'd0, 2'd3, RU52, 7'd9, 1'd0} : ndataRateIdx = 6'd3; // RU52 Nss 1 MCS 9, 23.5 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd3, RU26, 7'd9, 1'd0} : ndataRateIdx = 6'd3; // RU26 Nss 2 MCS 9, 23.5 Mbps
`endif 
    {2'd0, 2'd3, RU52, 7'd7, 1'd0} : ndataRateIdx = 6'd2; // RU52 Nss 1 MCS 7, 17.6 Mbps
`ifdef RW_TXRX_2X2
    {2'd1, 2'd3, RU26, 7'd7, 1'd0} : ndataRateIdx = 6'd2; // RU26 Nss 2 MCS 7, 17.6 Mbps
`endif 
    {2'd0, 2'd3, RU26, 7'd9, 1'd0} : ndataRateIdx = 6'd1; // RU26 Nss 1 MCS 9, 11.8 Mbps
    {2'd0, 2'd3, RU26, 7'd7, 1'd0} : ndataRateIdx = 6'd0; // RU26 Nss 1 MCS 7, 8.8 Mbps
    default: ndataRateIdx = 6'd0;
  endcase
end // always

// Create RAM address based on data rate index
always @(*) begin
  case (rateEnum)

    // Coding Rate 1/2
    2'd0 : 
      case (dataRateIdx)
        default : begin // 0.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd45; // BaseAddr=9
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd46;
              2'd1    : nCfgAddr = 11'd47;
              2'd2    : nCfgAddr = 11'd48;
              default : nCfgAddr = 11'd49;
            endcase
          end // if sizeEnum
        end
        6'd1 : begin // 0.9 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd50; // BaseAddr=10
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd51;
              2'd1    : nCfgAddr = 11'd52;
              2'd2    : nCfgAddr = 11'd53;
              default : nCfgAddr = 11'd54;
            endcase
          end // if sizeEnum
        end
        6'd2 : begin // 1.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd55; // BaseAddr=11
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd56;
              2'd1    : nCfgAddr = 11'd57;
              2'd2    : nCfgAddr = 11'd58;
              default : nCfgAddr = 11'd59;
            endcase
          end // if sizeEnum
        end
        6'd3 : begin // 1.9 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd60; // BaseAddr=12
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd61;
              2'd1    : nCfgAddr = 11'd62;
              2'd2    : nCfgAddr = 11'd63;
              default : nCfgAddr = 11'd64;
            endcase
          end // if sizeEnum
        end
        6'd4 : begin // 3.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd65; // BaseAddr=13
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd66;
              2'd1    : nCfgAddr = 11'd67;
              2'd2    : nCfgAddr = 11'd68;
              default : nCfgAddr = 11'd69;
            endcase
          end // if sizeEnum
        end
        6'd5 : begin // 3.7 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd70; // BaseAddr=14
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd71;
              2'd1    : nCfgAddr = 11'd72;
              2'd2    : nCfgAddr = 11'd73;
              default : nCfgAddr = 11'd74;
            endcase
          end // if sizeEnum
        end
        6'd6 : begin // 4.3 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd75; // BaseAddr=15
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd76;
              2'd1    : nCfgAddr = 11'd77;
              2'd2    : nCfgAddr = 11'd78;
              default : nCfgAddr = 11'd79;
            endcase
          end // if sizeEnum
        end
        6'd7 : begin // 7.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd80; // BaseAddr=16
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd81;
              2'd1    : nCfgAddr = 11'd82;
              2'd2    : nCfgAddr = 11'd83;
              default : nCfgAddr = 11'd84;
            endcase
          end // if sizeEnum
        end
        6'd8 : begin // 7.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd85; // BaseAddr=17
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd86;
              2'd1    : nCfgAddr = 11'd87;
              2'd2    : nCfgAddr = 11'd88;
              default : nCfgAddr = 11'd89;
            endcase
          end // if sizeEnum
        end
        6'd9 : begin // 8.6 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd90; // BaseAddr=18
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd91;
              2'd1    : nCfgAddr = 11'd92;
              2'd2    : nCfgAddr = 11'd93;
              default : nCfgAddr = 11'd94;
            endcase
          end // if sizeEnum
        end
`ifdef RW_TXRX_2X2
        6'd10 : begin // 14.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd985; // BaseAddr=197
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd986;
              2'd1    : nCfgAddr = 11'd987;
              2'd2    : nCfgAddr = 11'd988;
              default : nCfgAddr = 11'd989;
            endcase
          end // if sizeEnum
        end
`endif 
        6'd11 : begin // 15.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd95; // BaseAddr=19
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd96;
              2'd1    : nCfgAddr = 11'd97;
              2'd2    : nCfgAddr = 11'd98;
              default : nCfgAddr = 11'd99;
            endcase
          end // if sizeEnum
        end
        6'd12 : begin // 17.2 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd100; // BaseAddr=20
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd101;
              2'd1    : nCfgAddr = 11'd102;
              2'd2    : nCfgAddr = 11'd103;
              default : nCfgAddr = 11'd104;
            endcase
          end // if sizeEnum
        end
`ifdef RW_NX_DERIV_CHBW804020ONLY
        6'd13 : begin // 18.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd720; // BaseAddr=144
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd721;
              2'd1    : nCfgAddr = 11'd722;
              2'd2    : nCfgAddr = 11'd723;
              default : nCfgAddr = 11'd724;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd14 : begin // 30.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd990; // BaseAddr=198
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd991;
              2'd1    : nCfgAddr = 11'd992;
              2'd2    : nCfgAddr = 11'd993;
              default : nCfgAddr = 11'd994;
            endcase
          end // if sizeEnum
        end
`endif 
        6'd15 : begin // 34.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd105; // BaseAddr=21
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd106;
              2'd1    : nCfgAddr = 11'd107;
              2'd2    : nCfgAddr = 11'd108;
              default : nCfgAddr = 11'd109;
            endcase
          end // if sizeEnum
        end
`ifdef RW_NX_DERIV_CHBW804020ONLY
        6'd16 : begin // 36.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd725; // BaseAddr=145
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd726;
              2'd1    : nCfgAddr = 11'd727;
              2'd2    : nCfgAddr = 11'd728;
              default : nCfgAddr = 11'd729;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
        6'd17 : begin // 68.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd295; // BaseAddr=59
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd296;
              2'd1    : nCfgAddr = 11'd297;
              2'd2    : nCfgAddr = 11'd298;
              default : nCfgAddr = 11'd299;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
        6'd18 : begin // 72.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd730; // BaseAddr=146
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd731;
              2'd1    : nCfgAddr = 11'd732;
              2'd2    : nCfgAddr = 11'd733;
              default : nCfgAddr = 11'd734;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd19 : begin // 137.6 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd995; // BaseAddr=199
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd996;
              2'd1    : nCfgAddr = 11'd997;
              2'd2    : nCfgAddr = 11'd998;
              default : nCfgAddr = 11'd999;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
        6'd20 : begin // 144.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd735; // BaseAddr=147
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd736;
              2'd1    : nCfgAddr = 11'd737;
              2'd2    : nCfgAddr = 11'd738;
              default : nCfgAddr = 11'd739;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd21 : begin // 288.2 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1000; // BaseAddr=200
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1001;
              2'd1    : nCfgAddr = 11'd1002;
              2'd2    : nCfgAddr = 11'd1003;
              default : nCfgAddr = 11'd1004;
            endcase
          end // if sizeEnum
        end
`endif 
      endcase // dataRateIdx

    // Coding Rate 2/3
    2'd1 : 
      case (dataRateIdx)
        default : begin // 7.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd110; // BaseAddr=22
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd111;
              2'd1    : nCfgAddr = 11'd112;
              2'd2    : nCfgAddr = 11'd113;
              default : nCfgAddr = 11'd114;
            endcase
          end // if sizeEnum
        end
        6'd1 : begin // 14.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd115; // BaseAddr=23
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd116;
              2'd1    : nCfgAddr = 11'd117;
              2'd2    : nCfgAddr = 11'd118;
              default : nCfgAddr = 11'd119;
            endcase
          end // if sizeEnum
        end
`ifdef RW_TXRX_2X2
        6'd2 : begin // 28.2 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1005; // BaseAddr=201
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1006;
              2'd1    : nCfgAddr = 11'd1007;
              2'd2    : nCfgAddr = 11'd1008;
              default : nCfgAddr = 11'd1009;
            endcase
          end // if sizeEnum
        end
`endif 
        6'd3 : begin // 30.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd120; // BaseAddr=24
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd121;
              2'd1    : nCfgAddr = 11'd122;
              2'd2    : nCfgAddr = 11'd123;
              default : nCfgAddr = 11'd124;
            endcase
          end // if sizeEnum
        end
`ifdef RW_TXRX_2X2
        6'd4 : begin // 60.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1010; // BaseAddr=202
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1011;
              2'd1    : nCfgAddr = 11'd1012;
              2'd2    : nCfgAddr = 11'd1013;
              default : nCfgAddr = 11'd1014;
            endcase
          end // if sizeEnum
        end
`endif 
        6'd5 : begin // 68.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd125; // BaseAddr=25
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd126;
              2'd1    : nCfgAddr = 11'd127;
              2'd2    : nCfgAddr = 11'd128;
              default : nCfgAddr = 11'd129;
            endcase
          end // if sizeEnum
        end
`ifdef RW_NX_DERIV_CHBW4020ONLY
        6'd6 : begin // 137.6 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd300; // BaseAddr=60
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd301;
              2'd1    : nCfgAddr = 11'd302;
              2'd2    : nCfgAddr = 11'd303;
              default : nCfgAddr = 11'd304;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd7 : begin // 275.3 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1015; // BaseAddr=203
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1016;
              2'd1    : nCfgAddr = 11'd1017;
              2'd2    : nCfgAddr = 11'd1018;
              default : nCfgAddr = 11'd1019;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
        6'd8 : begin // 288.2 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd740; // BaseAddr=148
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd741;
              2'd1    : nCfgAddr = 11'd742;
              2'd2    : nCfgAddr = 11'd743;
              default : nCfgAddr = 11'd744;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd9 : begin // 576.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1020; // BaseAddr=204
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1021;
              2'd1    : nCfgAddr = 11'd1022;
              2'd2    : nCfgAddr = 11'd1023;
              default : nCfgAddr = 11'd1024;
            endcase
          end // if sizeEnum
        end
`endif 
      endcase // dataRateIdx

    // Coding Rate 3/4
    2'd2 : 
      case (dataRateIdx)
        default : begin // 2.6 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd130; // BaseAddr=26
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd131;
              2'd1    : nCfgAddr = 11'd132;
              2'd2    : nCfgAddr = 11'd133;
              default : nCfgAddr = 11'd134;
            endcase
          end // if sizeEnum
        end
        6'd1 : begin // 5.3 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd135; // BaseAddr=27
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd136;
              2'd1    : nCfgAddr = 11'd137;
              2'd2    : nCfgAddr = 11'd138;
              default : nCfgAddr = 11'd139;
            endcase
          end // if sizeEnum
        end
        6'd2 : begin // 7.9 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd140; // BaseAddr=28
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd141;
              2'd1    : nCfgAddr = 11'd142;
              2'd2    : nCfgAddr = 11'd143;
              default : nCfgAddr = 11'd144;
            endcase
          end // if sizeEnum
        end
        6'd3 : begin // 10.6 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd145; // BaseAddr=29
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd146;
              2'd1    : nCfgAddr = 11'd147;
              2'd2    : nCfgAddr = 11'd148;
              default : nCfgAddr = 11'd149;
            endcase
          end // if sizeEnum
        end
        6'd4 : begin // 11.2 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd150; // BaseAddr=30
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd151;
              2'd1    : nCfgAddr = 11'd152;
              2'd2    : nCfgAddr = 11'd153;
              default : nCfgAddr = 11'd154;
            endcase
          end // if sizeEnum
        end
        6'd5 : begin // 15.9 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd155; // BaseAddr=31
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd156;
              2'd1    : nCfgAddr = 11'd157;
              2'd2    : nCfgAddr = 11'd158;
              default : nCfgAddr = 11'd159;
            endcase
          end // if sizeEnum
        end
        6'd6 : begin // 21.2 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd160; // BaseAddr=32
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd161;
              2'd1    : nCfgAddr = 11'd162;
              2'd2    : nCfgAddr = 11'd163;
              default : nCfgAddr = 11'd164;
            endcase
          end // if sizeEnum
        end
        6'd7 : begin // 22.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd165; // BaseAddr=33
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd166;
              2'd1    : nCfgAddr = 11'd167;
              2'd2    : nCfgAddr = 11'd168;
              default : nCfgAddr = 11'd169;
            endcase
          end // if sizeEnum
        end
        6'd8 : begin // 25.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd170; // BaseAddr=34
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd171;
              2'd1    : nCfgAddr = 11'd172;
              2'd2    : nCfgAddr = 11'd173;
              default : nCfgAddr = 11'd174;
            endcase
          end // if sizeEnum
        end
`ifdef RW_TXRX_2X2
        6'd9 : begin // 31.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1025; // BaseAddr=205
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1026;
              2'd1    : nCfgAddr = 11'd1027;
              2'd2    : nCfgAddr = 11'd1028;
              default : nCfgAddr = 11'd1029;
            endcase
          end // if sizeEnum
        end
`endif 
        6'd10 : begin // 33.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd175; // BaseAddr=35
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd176;
              2'd1    : nCfgAddr = 11'd177;
              2'd2    : nCfgAddr = 11'd178;
              default : nCfgAddr = 11'd179;
            endcase
          end // if sizeEnum
        end
`ifdef RW_TXRX_2X2
        6'd11 : begin // 42.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1030; // BaseAddr=206
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1031;
              2'd1    : nCfgAddr = 11'd1032;
              2'd2    : nCfgAddr = 11'd1033;
              default : nCfgAddr = 11'd1034;
            endcase
          end // if sizeEnum
        end
`endif 
        6'd12 : begin // 45.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd180; // BaseAddr=36
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd181;
              2'd1    : nCfgAddr = 11'd182;
              2'd2    : nCfgAddr = 11'd183;
              default : nCfgAddr = 11'd184;
            endcase
          end // if sizeEnum
        end
        6'd13 : begin // 51.6 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd185; // BaseAddr=37
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd186;
              2'd1    : nCfgAddr = 11'd187;
              2'd2    : nCfgAddr = 11'd188;
              default : nCfgAddr = 11'd189;
            endcase
          end // if sizeEnum
        end
`ifdef RW_TXRX_2X2
        6'd14 : begin // 67.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1035; // BaseAddr=207
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1036;
              2'd1    : nCfgAddr = 11'd1037;
              2'd2    : nCfgAddr = 11'd1038;
              default : nCfgAddr = 11'd1039;
            endcase
          end // if sizeEnum
        end
`endif 
        6'd15 : begin // 77.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd190; // BaseAddr=38
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd191;
              2'd1    : nCfgAddr = 11'd192;
              2'd2    : nCfgAddr = 11'd193;
              default : nCfgAddr = 11'd194;
            endcase
          end // if sizeEnum
        end
`ifdef RW_TXRX_2X2
        6'd16 : begin // 90.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1040; // BaseAddr=208
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1041;
              2'd1    : nCfgAddr = 11'd1042;
              2'd2    : nCfgAddr = 11'd1043;
              default : nCfgAddr = 11'd1044;
            endcase
          end // if sizeEnum
        end
`endif 
        6'd17 : begin // 103.2 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd195; // BaseAddr=39
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd196;
              2'd1    : nCfgAddr = 11'd197;
              2'd2    : nCfgAddr = 11'd198;
              default : nCfgAddr = 11'd199;
            endcase
          end // if sizeEnum
        end
`ifdef RW_NX_DERIV_CHBW804020ONLY
        6'd18 : begin // 108.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd745; // BaseAddr=149
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd746;
              2'd1    : nCfgAddr = 11'd747;
              2'd2    : nCfgAddr = 11'd748;
              default : nCfgAddr = 11'd749;
            endcase
          end // if sizeEnum
        end
`endif 
        6'd19 : begin // 129.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd200; // BaseAddr=40
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd201;
              2'd1    : nCfgAddr = 11'd202;
              2'd2    : nCfgAddr = 11'd203;
              default : nCfgAddr = 11'd204;
            endcase
          end // if sizeEnum
        end
`ifdef RW_NX_DERIV_CHBW4020ONLY
        6'd20 : begin // 154.9 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd305; // BaseAddr=61
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd306;
              2'd1    : nCfgAddr = 11'd307;
              2'd2    : nCfgAddr = 11'd308;
              default : nCfgAddr = 11'd309;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
        6'd21 : begin // 206.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd310; // BaseAddr=62
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd311;
              2'd1    : nCfgAddr = 11'd312;
              2'd2    : nCfgAddr = 11'd313;
              default : nCfgAddr = 11'd314;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
        6'd22 : begin // 216.2 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd750; // BaseAddr=150
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd751;
              2'd1    : nCfgAddr = 11'd752;
              2'd2    : nCfgAddr = 11'd753;
              default : nCfgAddr = 11'd754;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
        6'd23 : begin // 258.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd315; // BaseAddr=63
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd316;
              2'd1    : nCfgAddr = 11'd317;
              2'd2    : nCfgAddr = 11'd318;
              default : nCfgAddr = 11'd319;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd24 : begin // 309.7 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1045; // BaseAddr=209
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1046;
              2'd1    : nCfgAddr = 11'd1047;
              2'd2    : nCfgAddr = 11'd1048;
              default : nCfgAddr = 11'd1049;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
        6'd25 : begin // 324.3 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd755; // BaseAddr=151
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd756;
              2'd1    : nCfgAddr = 11'd757;
              2'd2    : nCfgAddr = 11'd758;
              default : nCfgAddr = 11'd759;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd26 : begin // 412.9 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1050; // BaseAddr=210
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1051;
              2'd1    : nCfgAddr = 11'd1052;
              2'd2    : nCfgAddr = 11'd1053;
              default : nCfgAddr = 11'd1054;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
        6'd27 : begin // 432.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd760; // BaseAddr=152
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd761;
              2'd1    : nCfgAddr = 11'd762;
              2'd2    : nCfgAddr = 11'd763;
              default : nCfgAddr = 11'd764;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd28 : begin // 516.2 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1055; // BaseAddr=211
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1056;
              2'd1    : nCfgAddr = 11'd1057;
              2'd2    : nCfgAddr = 11'd1058;
              default : nCfgAddr = 11'd1059;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
        6'd29 : begin // 540.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd765; // BaseAddr=153
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd766;
              2'd1    : nCfgAddr = 11'd767;
              2'd2    : nCfgAddr = 11'd768;
              default : nCfgAddr = 11'd769;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd30 : begin // 648.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1060; // BaseAddr=212
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1061;
              2'd1    : nCfgAddr = 11'd1062;
              2'd2    : nCfgAddr = 11'd1063;
              default : nCfgAddr = 11'd1064;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd31 : begin // 864.7 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1065; // BaseAddr=213
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1066;
              2'd1    : nCfgAddr = 11'd1067;
              2'd2    : nCfgAddr = 11'd1068;
              default : nCfgAddr = 11'd1069;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd32 : begin // 1080.9 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1070; // BaseAddr=214
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1071;
              2'd1    : nCfgAddr = 11'd1072;
              2'd2    : nCfgAddr = 11'd1073;
              default : nCfgAddr = 11'd1074;
            endcase
          end // if sizeEnum
        end
`endif 
      endcase // dataRateIdx

    // Coding Rate 5/6
    default : 
      case (dataRateIdx)
        default : begin // 8.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd205; // BaseAddr=41
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd206;
              2'd1    : nCfgAddr = 11'd207;
              2'd2    : nCfgAddr = 11'd208;
              default : nCfgAddr = 11'd209;
            endcase
          end // if sizeEnum
        end
        6'd1 : begin // 11.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd210; // BaseAddr=42
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd211;
              2'd1    : nCfgAddr = 11'd212;
              2'd2    : nCfgAddr = 11'd213;
              default : nCfgAddr = 11'd214;
            endcase
          end // if sizeEnum
        end
        6'd2 : begin // 17.6 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd215; // BaseAddr=43
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd216;
              2'd1    : nCfgAddr = 11'd217;
              2'd2    : nCfgAddr = 11'd218;
              default : nCfgAddr = 11'd219;
            endcase
          end // if sizeEnum
        end
        6'd3 : begin // 23.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd220; // BaseAddr=44
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd221;
              2'd1    : nCfgAddr = 11'd222;
              2'd2    : nCfgAddr = 11'd223;
              default : nCfgAddr = 11'd224;
            endcase
          end // if sizeEnum
        end
`ifdef RW_TXRX_2X2
        6'd4 : begin // 35.3 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1075; // BaseAddr=215
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1076;
              2'd1    : nCfgAddr = 11'd1077;
              2'd2    : nCfgAddr = 11'd1078;
              default : nCfgAddr = 11'd1079;
            endcase
          end // if sizeEnum
        end
`endif 
        6'd5 : begin // 37.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd225; // BaseAddr=45
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd226;
              2'd1    : nCfgAddr = 11'd227;
              2'd2    : nCfgAddr = 11'd228;
              default : nCfgAddr = 11'd229;
            endcase
          end // if sizeEnum
        end
`ifdef RW_TXRX_2X2
        6'd6 : begin // 47.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1080; // BaseAddr=216
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1081;
              2'd1    : nCfgAddr = 11'd1082;
              2'd2    : nCfgAddr = 11'd1083;
              default : nCfgAddr = 11'd1084;
            endcase
          end // if sizeEnum
        end
`endif 
        6'd7 : begin // 50.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd230; // BaseAddr=46
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd231;
              2'd1    : nCfgAddr = 11'd232;
              2'd2    : nCfgAddr = 11'd233;
              default : nCfgAddr = 11'd234;
            endcase
          end // if sizeEnum
        end
`ifdef RW_TXRX_2X2
        6'd8 : begin // 75.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1085; // BaseAddr=217
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1086;
              2'd1    : nCfgAddr = 11'd1087;
              2'd2    : nCfgAddr = 11'd1088;
              default : nCfgAddr = 11'd1089;
            endcase
          end // if sizeEnum
        end
`endif 
        6'd9 : begin // 86.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd235; // BaseAddr=47
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd236;
              2'd1    : nCfgAddr = 11'd237;
              2'd2    : nCfgAddr = 11'd238;
              default : nCfgAddr = 11'd239;
            endcase
          end // if sizeEnum
        end
`ifdef RW_TXRX_2X2
        6'd10 : begin // 100.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1090; // BaseAddr=218
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1091;
              2'd1    : nCfgAddr = 11'd1092;
              2'd2    : nCfgAddr = 11'd1093;
              default : nCfgAddr = 11'd1094;
            endcase
          end // if sizeEnum
        end
`endif 
        6'd11 : begin // 114.7 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd240; // BaseAddr=48
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd241;
              2'd1    : nCfgAddr = 11'd242;
              2'd2    : nCfgAddr = 11'd243;
              default : nCfgAddr = 11'd244;
            endcase
          end // if sizeEnum
        end
        6'd12 : begin // 143.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd245; // BaseAddr=49
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd246;
              2'd1    : nCfgAddr = 11'd247;
              2'd2    : nCfgAddr = 11'd248;
              default : nCfgAddr = 11'd249;
            endcase
          end // if sizeEnum
        end
`ifdef RW_NX_DERIV_CHBW4020ONLY
        6'd13 : begin // 172.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd320; // BaseAddr=64
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd321;
              2'd1    : nCfgAddr = 11'd322;
              2'd2    : nCfgAddr = 11'd323;
              default : nCfgAddr = 11'd324;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
        6'd14 : begin // 229.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd325; // BaseAddr=65
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd326;
              2'd1    : nCfgAddr = 11'd327;
              2'd2    : nCfgAddr = 11'd328;
              default : nCfgAddr = 11'd329;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW4020ONLY
        6'd15 : begin // 286.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd330; // BaseAddr=66
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd331;
              2'd1    : nCfgAddr = 11'd332;
              2'd2    : nCfgAddr = 11'd333;
              default : nCfgAddr = 11'd334;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd16 : begin // 344.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1095; // BaseAddr=219
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1096;
              2'd1    : nCfgAddr = 11'd1097;
              2'd2    : nCfgAddr = 11'd1098;
              default : nCfgAddr = 11'd1099;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
        6'd17 : begin // 360.3 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd770; // BaseAddr=154
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd771;
              2'd1    : nCfgAddr = 11'd772;
              2'd2    : nCfgAddr = 11'd773;
              default : nCfgAddr = 11'd774;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd18 : begin // 458.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1100; // BaseAddr=220
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1101;
              2'd1    : nCfgAddr = 11'd1102;
              2'd2    : nCfgAddr = 11'd1103;
              default : nCfgAddr = 11'd1104;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
        6'd19 : begin // 480.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd775; // BaseAddr=155
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd776;
              2'd1    : nCfgAddr = 11'd777;
              2'd2    : nCfgAddr = 11'd778;
              default : nCfgAddr = 11'd779;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd20 : begin // 573.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1105; // BaseAddr=221
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1106;
              2'd1    : nCfgAddr = 11'd1107;
              2'd2    : nCfgAddr = 11'd1108;
              default : nCfgAddr = 11'd1109;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
        6'd21 : begin // 600.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd780; // BaseAddr=156
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd781;
              2'd1    : nCfgAddr = 11'd782;
              2'd2    : nCfgAddr = 11'd783;
              default : nCfgAddr = 11'd784;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd22 : begin // 720.6 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1110; // BaseAddr=222
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1111;
              2'd1    : nCfgAddr = 11'd1112;
              2'd2    : nCfgAddr = 11'd1113;
              default : nCfgAddr = 11'd1114;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd23 : begin // 960.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1115; // BaseAddr=223
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1116;
              2'd1    : nCfgAddr = 11'd1117;
              2'd2    : nCfgAddr = 11'd1118;
              default : nCfgAddr = 11'd1119;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_TXRX_2X2
        6'd24 : begin // 1201.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd1120; // BaseAddr=224
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd1121;
              2'd1    : nCfgAddr = 11'd1122;
              2'd2    : nCfgAddr = 11'd1123;
              default : nCfgAddr = 11'd1124;
            endcase
          end // if sizeEnum
        end
`endif 
      endcase // dataRateIdx
  endcase
end // always

  always @(posedge clk, negedge rst_n)
    if(!rst_n) begin
      CfgAddr             <= 11'd0;
      dataRateIdx         <= 6'd0;
      bucketIdx           <= 2'd0;
    end else begin
      CfgAddr             <= nCfgAddr;
      dataRateIdx         <= ndataRateIdx;
      bucketIdx           <= nbucketIdx;
    end

endmodule
