// This block allows the decoder's programmable registers to be replaced
// by look up tables.

// Auto-generated on 21-Feb-2019.

module HeLdpcDecLuStbc (       
  // Clock and reset
  input  wire          clk,
  input  wire          rst_n,
  // Packet parameters
  input  wire [2:0]    qamEnum,  // 0:5 is BPSK, QPSK, 16QAM, 64QAM, 256QAM, 1024QAM
  input  wire [1:0]    sizeEnum, // zEnum
  input  wire [1:0]    rateEnum, // rEnum
  input  wire [2:0]    RuType,   // 0:4 is RU 26/52/106/242/484
  input  wire [6:0]    mcs,      // 0-9 for 11ac, 0-72 for 11n
  input  wire [1:0]    nssLess1, // e.g. NSS=4 is specified as a 3.
  input  wire          dcm,
  input  wire [13:0]   nCw,      // packetLen in LDPC blocks
  // Output parameters not depending on data rate, only on packet size and modulation
  // Address in config RAM to read packet configuration
  output reg  [10:0] CfgAddr
  );

  // RU type
  localparam [2:0] RU26  = 3'd0,
                   RU52  = 3'd1,
                   RU106 = 3'd2,
                   RU242 = 3'd3,
                   RU484 = 3'd4,
                   RU996 = 3'd5;

reg  [1:0]     bucketIdx;   // selects a range of packet lengths
reg  [1:0]     nbucketIdx;
reg  [4:0]     dataRateIdx; // selects iteration settings according to datarates
reg  [4:0]     ndataRateIdx;

reg  [10:0]    nCfgAddr;

// Define the nCw that marks the start of the next NOM_ITERATIONS bucket.
always @(*) begin
  if (sizeEnum != 2'd2)
    nbucketIdx = 2'd0;
  else
    case (rateEnum)
      2'd0 : nbucketIdx = 
             (nCw < 2'd2) ? 2'd0 :
             (nCw < 14'd12) ? 2'd1 :
             (nCw < 14'd33) ? 2'd2 : 2'd3;
      2'd1 : nbucketIdx = 
             (nCw < 2'd2) ? 2'd0 :
             (nCw < 14'd9) ? 2'd1 :
             (nCw < 14'd25) ? 2'd2 : 2'd3;
      2'd2 : nbucketIdx = 
             (nCw < 2'd2) ? 2'd0 :
             (nCw < 14'd8) ? 2'd1 :
             (nCw < 14'd22) ? 2'd2 : 2'd3;
      default : nbucketIdx = 
             (nCw < 2'd2) ? 2'd0 :
             (nCw < 14'd7) ? 2'd1 :
             (nCw < 14'd20) ? 2'd2 : 2'd3;
    endcase
end

// Iteration control registers (stored in the configuration RAM) determine throughput and
// latency during and at the end of the packet. Decode frame parameters into the datarate index
// used to address the RAM.

// Find the index into the iteration tables.
always @(*) begin
  case ({nssLess1,rateEnum,RuType,mcs,dcm})
    // Coding Rate 1/2
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd0, RU996, 7'd3, 1'd0} : ndataRateIdx = 5'd17; // RU996 Nss 1 MCS 3, 144.1 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd0, RU996, 7'd1, 1'd0} : ndataRateIdx = 5'd16; // RU996 Nss 1 MCS 1, 72.1 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd0, RU996, 7'd3, 1'd1} : ndataRateIdx = 5'd16; // RU996 Nss 1 MCS 3 with DCM, 72.1 Mbps
`endif 
    {2'd0, 2'd0, RU484, 7'd3, 1'd0} : ndataRateIdx = 5'd15; // RU484 Nss 1 MCS 3, 68.8 Mbps
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd0, RU996, 7'd0, 1'd0} : ndataRateIdx = 5'd14; // RU996 Nss 1 MCS 0, 36.0 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd0, RU996, 7'd1, 1'd1} : ndataRateIdx = 5'd14; // RU996 Nss 1 MCS 1 with DCM, 36.0 Mbps
`endif 
    {2'd0, 2'd0, RU242, 7'd3, 1'd0} : ndataRateIdx = 5'd13; // RU242 Nss 1 MCS 3, 34.4 Mbps
    {2'd0, 2'd0, RU484, 7'd1, 1'd0} : ndataRateIdx = 5'd13; // RU484 Nss 1 MCS 1, 34.4 Mbps
    {2'd0, 2'd0, RU484, 7'd3, 1'd1} : ndataRateIdx = 5'd13; // RU484 Nss 1 MCS 3 with DCM, 34.4 Mbps
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd0, RU996, 7'd0, 1'd1} : ndataRateIdx = 5'd12; // RU996 Nss 1 MCS 0 with DCM, 18.0 Mbps
`endif 
    {2'd0, 2'd0, RU242, 7'd1, 1'd0} : ndataRateIdx = 5'd11; // RU242 Nss 1 MCS 1, 17.2 Mbps
    {2'd0, 2'd0, RU242, 7'd3, 1'd1} : ndataRateIdx = 5'd11; // RU242 Nss 1 MCS 3 with DCM, 17.2 Mbps
    {2'd0, 2'd0, RU484, 7'd0, 1'd0} : ndataRateIdx = 5'd11; // RU484 Nss 1 MCS 0, 17.2 Mbps
    {2'd0, 2'd0, RU484, 7'd1, 1'd1} : ndataRateIdx = 5'd11; // RU484 Nss 1 MCS 1 with DCM, 17.2 Mbps
    {2'd0, 2'd0, RU106, 7'd3, 1'd0} : ndataRateIdx = 5'd10; // RU106 Nss 1 MCS 3, 15.0 Mbps
    {2'd0, 2'd0, RU242, 7'd0, 1'd0} : ndataRateIdx = 5'd9; // RU242 Nss 1 MCS 0, 8.6 Mbps
    {2'd0, 2'd0, RU242, 7'd1, 1'd1} : ndataRateIdx = 5'd9; // RU242 Nss 1 MCS 1 with DCM, 8.6 Mbps
    {2'd0, 2'd0, RU484, 7'd0, 1'd1} : ndataRateIdx = 5'd9; // RU484 Nss 1 MCS 0 with DCM, 8.6 Mbps
    {2'd0, 2'd0, RU106, 7'd1, 1'd0} : ndataRateIdx = 5'd8; // RU106 Nss 1 MCS 1, 7.5 Mbps
    {2'd0, 2'd0, RU106, 7'd3, 1'd1} : ndataRateIdx = 5'd8; // RU106 Nss 1 MCS 3 with DCM, 7.5 Mbps
    {2'd0, 2'd0, RU52, 7'd3, 1'd0} : ndataRateIdx = 5'd7; // RU52 Nss 1 MCS 3, 7.1 Mbps
    {2'd0, 2'd0, RU242, 7'd0, 1'd1} : ndataRateIdx = 5'd6; // RU242 Nss 1 MCS 0 with DCM, 4.3 Mbps
    {2'd0, 2'd0, RU106, 7'd0, 1'd0} : ndataRateIdx = 5'd5; // RU106 Nss 1 MCS 0, 3.7 Mbps
    {2'd0, 2'd0, RU106, 7'd1, 1'd1} : ndataRateIdx = 5'd5; // RU106 Nss 1 MCS 1 with DCM, 3.7 Mbps
    {2'd0, 2'd0, RU26, 7'd3, 1'd0} : ndataRateIdx = 5'd4; // RU26 Nss 1 MCS 3, 3.5 Mbps
    {2'd0, 2'd0, RU52, 7'd1, 1'd0} : ndataRateIdx = 5'd4; // RU52 Nss 1 MCS 1, 3.5 Mbps
    {2'd0, 2'd0, RU52, 7'd3, 1'd1} : ndataRateIdx = 5'd4; // RU52 Nss 1 MCS 3 with DCM, 3.5 Mbps
    {2'd0, 2'd0, RU106, 7'd0, 1'd1} : ndataRateIdx = 5'd3; // RU106 Nss 1 MCS 0 with DCM, 1.9 Mbps
    {2'd0, 2'd0, RU26, 7'd1, 1'd0} : ndataRateIdx = 5'd2; // RU26 Nss 1 MCS 1, 1.8 Mbps
    {2'd0, 2'd0, RU26, 7'd3, 1'd1} : ndataRateIdx = 5'd2; // RU26 Nss 1 MCS 3 with DCM, 1.8 Mbps
    {2'd0, 2'd0, RU52, 7'd0, 1'd0} : ndataRateIdx = 5'd2; // RU52 Nss 1 MCS 0, 1.8 Mbps
    {2'd0, 2'd0, RU52, 7'd1, 1'd1} : ndataRateIdx = 5'd2; // RU52 Nss 1 MCS 1 with DCM, 1.8 Mbps
    {2'd0, 2'd0, RU26, 7'd0, 1'd0} : ndataRateIdx = 5'd1; // RU26 Nss 1 MCS 0, 0.9 Mbps
    {2'd0, 2'd0, RU26, 7'd1, 1'd1} : ndataRateIdx = 5'd1; // RU26 Nss 1 MCS 1 with DCM, 0.9 Mbps
    {2'd0, 2'd0, RU52, 7'd0, 1'd1} : ndataRateIdx = 5'd1; // RU52 Nss 1 MCS 0 with DCM, 0.9 Mbps
    {2'd0, 2'd0, RU26, 7'd0, 1'd1} : ndataRateIdx = 5'd0; // RU26 Nss 1 MCS 0 with DCM, 0.4 Mbps
    // Coding Rate 2/3
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd1, RU996, 7'd5, 1'd0} : ndataRateIdx = 5'd5; // RU996 Nss 1 MCS 5, 288.2 Mbps
`endif 
    {2'd0, 2'd1, RU484, 7'd5, 1'd0} : ndataRateIdx = 5'd4; // RU484 Nss 1 MCS 5, 137.6 Mbps
    {2'd0, 2'd1, RU242, 7'd5, 1'd0} : ndataRateIdx = 5'd3; // RU242 Nss 1 MCS 5, 68.8 Mbps
    {2'd0, 2'd1, RU106, 7'd5, 1'd0} : ndataRateIdx = 5'd2; // RU106 Nss 1 MCS 5, 30.0 Mbps
    {2'd0, 2'd1, RU52, 7'd5, 1'd0} : ndataRateIdx = 5'd1; // RU52 Nss 1 MCS 5, 14.1 Mbps
    {2'd0, 2'd1, RU26, 7'd5, 1'd0} : ndataRateIdx = 5'd0; // RU26 Nss 1 MCS 5, 7.1 Mbps
    // Coding Rate 3/4
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd2, RU996, 7'd10, 1'd0} : ndataRateIdx = 5'd22; // RU996 Nss 1 MCS 10, 540.4 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd2, RU996, 7'd8, 1'd0} : ndataRateIdx = 5'd21; // RU996 Nss 1 MCS 8, 432.4 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd2, RU996, 7'd6, 1'd0} : ndataRateIdx = 5'd20; // RU996 Nss 1 MCS 6, 324.3 Mbps
`endif 
    {2'd0, 2'd2, RU484, 7'd10, 1'd0} : ndataRateIdx = 5'd19; // RU484 Nss 1 MCS 10, 258.1 Mbps
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd2, RU996, 7'd4, 1'd0} : ndataRateIdx = 5'd18; // RU996 Nss 1 MCS 4, 216.2 Mbps
`endif 
    {2'd0, 2'd2, RU484, 7'd8, 1'd0} : ndataRateIdx = 5'd17; // RU484 Nss 1 MCS 8, 206.5 Mbps
    {2'd0, 2'd2, RU484, 7'd6, 1'd0} : ndataRateIdx = 5'd16; // RU484 Nss 1 MCS 6, 154.9 Mbps
    {2'd0, 2'd2, RU242, 7'd10, 1'd0} : ndataRateIdx = 5'd15; // RU242 Nss 1 MCS 10, 129.0 Mbps
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd2, RU996, 7'd2, 1'd0} : ndataRateIdx = 5'd14; // RU996 Nss 1 MCS 2, 108.1 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd2, RU996, 7'd4, 1'd1} : ndataRateIdx = 5'd14; // RU996 Nss 1 MCS 4 with DCM, 108.1 Mbps
`endif 
    {2'd0, 2'd2, RU242, 7'd8, 1'd0} : ndataRateIdx = 5'd13; // RU242 Nss 1 MCS 8, 103.2 Mbps
    {2'd0, 2'd2, RU484, 7'd4, 1'd0} : ndataRateIdx = 5'd13; // RU484 Nss 1 MCS 4, 103.2 Mbps
    {2'd0, 2'd2, RU242, 7'd6, 1'd0} : ndataRateIdx = 5'd12; // RU242 Nss 1 MCS 6, 77.4 Mbps
    {2'd0, 2'd2, RU242, 7'd4, 1'd0} : ndataRateIdx = 5'd11; // RU242 Nss 1 MCS 4, 51.6 Mbps
    {2'd0, 2'd2, RU484, 7'd2, 1'd0} : ndataRateIdx = 5'd11; // RU484 Nss 1 MCS 2, 51.6 Mbps
    {2'd0, 2'd2, RU484, 7'd4, 1'd1} : ndataRateIdx = 5'd11; // RU484 Nss 1 MCS 4 with DCM, 51.6 Mbps
    {2'd0, 2'd2, RU106, 7'd8, 1'd0} : ndataRateIdx = 5'd10; // RU106 Nss 1 MCS 8, 45.0 Mbps
    {2'd0, 2'd2, RU106, 7'd6, 1'd0} : ndataRateIdx = 5'd9; // RU106 Nss 1 MCS 6, 33.8 Mbps
    {2'd0, 2'd2, RU242, 7'd2, 1'd0} : ndataRateIdx = 5'd8; // RU242 Nss 1 MCS 2, 25.8 Mbps
    {2'd0, 2'd2, RU242, 7'd4, 1'd1} : ndataRateIdx = 5'd8; // RU242 Nss 1 MCS 4 with DCM, 25.8 Mbps
    {2'd0, 2'd2, RU106, 7'd4, 1'd0} : ndataRateIdx = 5'd7; // RU106 Nss 1 MCS 4, 22.5 Mbps
    {2'd0, 2'd2, RU52, 7'd8, 1'd0} : ndataRateIdx = 5'd6; // RU52 Nss 1 MCS 8, 21.2 Mbps
    {2'd0, 2'd2, RU52, 7'd6, 1'd0} : ndataRateIdx = 5'd5; // RU52 Nss 1 MCS 6, 15.9 Mbps
    {2'd0, 2'd2, RU106, 7'd2, 1'd0} : ndataRateIdx = 5'd4; // RU106 Nss 1 MCS 2, 11.2 Mbps
    {2'd0, 2'd2, RU106, 7'd4, 1'd1} : ndataRateIdx = 5'd4; // RU106 Nss 1 MCS 4 with DCM, 11.2 Mbps
    {2'd0, 2'd2, RU26, 7'd8, 1'd0} : ndataRateIdx = 5'd3; // RU26 Nss 1 MCS 8, 10.6 Mbps
    {2'd0, 2'd2, RU52, 7'd4, 1'd0} : ndataRateIdx = 5'd3; // RU52 Nss 1 MCS 4, 10.6 Mbps
    {2'd0, 2'd2, RU26, 7'd6, 1'd0} : ndataRateIdx = 5'd2; // RU26 Nss 1 MCS 6, 7.9 Mbps
    {2'd0, 2'd2, RU26, 7'd4, 1'd0} : ndataRateIdx = 5'd1; // RU26 Nss 1 MCS 4, 5.3 Mbps
    {2'd0, 2'd2, RU52, 7'd2, 1'd0} : ndataRateIdx = 5'd1; // RU52 Nss 1 MCS 2, 5.3 Mbps
    {2'd0, 2'd2, RU52, 7'd4, 1'd1} : ndataRateIdx = 5'd1; // RU52 Nss 1 MCS 4 with DCM, 5.3 Mbps
    {2'd0, 2'd2, RU26, 7'd2, 1'd0} : ndataRateIdx = 5'd0; // RU26 Nss 1 MCS 2, 2.6 Mbps
    {2'd0, 2'd2, RU26, 7'd4, 1'd1} : ndataRateIdx = 5'd0; // RU26 Nss 1 MCS 4 with DCM, 2.6 Mbps
    // Coding Rate 5/6
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd3, RU996, 7'd11, 1'd0} : ndataRateIdx = 5'd14; // RU996 Nss 1 MCS 11, 600.5 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd3, RU996, 7'd9, 1'd0} : ndataRateIdx = 5'd13; // RU996 Nss 1 MCS 9, 480.4 Mbps
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
    {2'd0, 2'd3, RU996, 7'd7, 1'd0} : ndataRateIdx = 5'd12; // RU996 Nss 1 MCS 7, 360.3 Mbps
`endif 
    {2'd0, 2'd3, RU484, 7'd11, 1'd0} : ndataRateIdx = 5'd11; // RU484 Nss 1 MCS 11, 286.8 Mbps
    {2'd0, 2'd3, RU484, 7'd9, 1'd0} : ndataRateIdx = 5'd10; // RU484 Nss 1 MCS 9, 229.4 Mbps
    {2'd0, 2'd3, RU484, 7'd7, 1'd0} : ndataRateIdx = 5'd9; // RU484 Nss 1 MCS 7, 172.1 Mbps
    {2'd0, 2'd3, RU242, 7'd11, 1'd0} : ndataRateIdx = 5'd8; // RU242 Nss 1 MCS 11, 143.4 Mbps
    {2'd0, 2'd3, RU242, 7'd9, 1'd0} : ndataRateIdx = 5'd7; // RU242 Nss 1 MCS 9, 114.7 Mbps
    {2'd0, 2'd3, RU242, 7'd7, 1'd0} : ndataRateIdx = 5'd6; // RU242 Nss 1 MCS 7, 86.0 Mbps
    {2'd0, 2'd3, RU106, 7'd9, 1'd0} : ndataRateIdx = 5'd5; // RU106 Nss 1 MCS 9, 50.0 Mbps
    {2'd0, 2'd3, RU106, 7'd7, 1'd0} : ndataRateIdx = 5'd4; // RU106 Nss 1 MCS 7, 37.5 Mbps
    {2'd0, 2'd3, RU52, 7'd9, 1'd0} : ndataRateIdx = 5'd3; // RU52 Nss 1 MCS 9, 23.5 Mbps
    {2'd0, 2'd3, RU52, 7'd7, 1'd0} : ndataRateIdx = 5'd2; // RU52 Nss 1 MCS 7, 17.6 Mbps
    {2'd0, 2'd3, RU26, 7'd9, 1'd0} : ndataRateIdx = 5'd1; // RU26 Nss 1 MCS 9, 11.8 Mbps
    {2'd0, 2'd3, RU26, 7'd7, 1'd0} : ndataRateIdx = 5'd0; // RU26 Nss 1 MCS 7, 8.8 Mbps
    default: ndataRateIdx = 5'd0;
  endcase
end // always

// Create RAM address based on data rate index
always @(*) begin
  case (rateEnum)

    // Coding Rate 1/2
    2'd0 : 
      case (dataRateIdx)
        default : begin // 0.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd380; // BaseAddr=76
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd381;
              2'd1    : nCfgAddr = 11'd382;
              2'd2    : nCfgAddr = 11'd383;
              default : nCfgAddr = 11'd384;
            endcase
          end // if sizeEnum
        end
        5'd1 : begin // 0.9 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd385; // BaseAddr=77
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd386;
              2'd1    : nCfgAddr = 11'd387;
              2'd2    : nCfgAddr = 11'd388;
              default : nCfgAddr = 11'd389;
            endcase
          end // if sizeEnum
        end
        5'd2 : begin // 1.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd390; // BaseAddr=78
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd391;
              2'd1    : nCfgAddr = 11'd392;
              2'd2    : nCfgAddr = 11'd393;
              default : nCfgAddr = 11'd394;
            endcase
          end // if sizeEnum
        end
        5'd3 : begin // 1.9 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd395; // BaseAddr=79
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd396;
              2'd1    : nCfgAddr = 11'd397;
              2'd2    : nCfgAddr = 11'd398;
              default : nCfgAddr = 11'd399;
            endcase
          end // if sizeEnum
        end
        5'd4 : begin // 3.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd400; // BaseAddr=80
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd401;
              2'd1    : nCfgAddr = 11'd402;
              2'd2    : nCfgAddr = 11'd403;
              default : nCfgAddr = 11'd404;
            endcase
          end // if sizeEnum
        end
        5'd5 : begin // 3.7 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd405; // BaseAddr=81
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd406;
              2'd1    : nCfgAddr = 11'd407;
              2'd2    : nCfgAddr = 11'd408;
              default : nCfgAddr = 11'd409;
            endcase
          end // if sizeEnum
        end
        5'd6 : begin // 4.3 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd410; // BaseAddr=82
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd411;
              2'd1    : nCfgAddr = 11'd412;
              2'd2    : nCfgAddr = 11'd413;
              default : nCfgAddr = 11'd414;
            endcase
          end // if sizeEnum
        end
        5'd7 : begin // 7.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd415; // BaseAddr=83
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd416;
              2'd1    : nCfgAddr = 11'd417;
              2'd2    : nCfgAddr = 11'd418;
              default : nCfgAddr = 11'd419;
            endcase
          end // if sizeEnum
        end
        5'd8 : begin // 7.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd420; // BaseAddr=84
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd421;
              2'd1    : nCfgAddr = 11'd422;
              2'd2    : nCfgAddr = 11'd423;
              default : nCfgAddr = 11'd424;
            endcase
          end // if sizeEnum
        end
        5'd9 : begin // 8.6 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd425; // BaseAddr=85
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd426;
              2'd1    : nCfgAddr = 11'd427;
              2'd2    : nCfgAddr = 11'd428;
              default : nCfgAddr = 11'd429;
            endcase
          end // if sizeEnum
        end
        5'd10 : begin // 15.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd430; // BaseAddr=86
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd431;
              2'd1    : nCfgAddr = 11'd432;
              2'd2    : nCfgAddr = 11'd433;
              default : nCfgAddr = 11'd434;
            endcase
          end // if sizeEnum
        end
        5'd11 : begin // 17.2 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd435; // BaseAddr=87
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd436;
              2'd1    : nCfgAddr = 11'd437;
              2'd2    : nCfgAddr = 11'd438;
              default : nCfgAddr = 11'd439;
            endcase
          end // if sizeEnum
        end
`ifdef RW_NX_DERIV_CHBW804020ONLY
        5'd12 : begin // 18.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd835; // BaseAddr=167
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd836;
              2'd1    : nCfgAddr = 11'd837;
              2'd2    : nCfgAddr = 11'd838;
              default : nCfgAddr = 11'd839;
            endcase
          end // if sizeEnum
        end
`endif 
        5'd13 : begin // 34.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd440; // BaseAddr=88
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd441;
              2'd1    : nCfgAddr = 11'd442;
              2'd2    : nCfgAddr = 11'd443;
              default : nCfgAddr = 11'd444;
            endcase
          end // if sizeEnum
        end
`ifdef RW_NX_DERIV_CHBW804020ONLY
        5'd14 : begin // 36.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd840; // BaseAddr=168
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd841;
              2'd1    : nCfgAddr = 11'd842;
              2'd2    : nCfgAddr = 11'd843;
              default : nCfgAddr = 11'd844;
            endcase
          end // if sizeEnum
        end
`endif 
        5'd15 : begin // 68.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd630; // BaseAddr=126
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd631;
              2'd1    : nCfgAddr = 11'd632;
              2'd2    : nCfgAddr = 11'd633;
              default : nCfgAddr = 11'd634;
            endcase
          end // if sizeEnum
        end
`ifdef RW_NX_DERIV_CHBW804020ONLY
        5'd16 : begin // 72.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd845; // BaseAddr=169
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd846;
              2'd1    : nCfgAddr = 11'd847;
              2'd2    : nCfgAddr = 11'd848;
              default : nCfgAddr = 11'd849;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
        5'd17 : begin // 144.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd850; // BaseAddr=170
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd851;
              2'd1    : nCfgAddr = 11'd852;
              2'd2    : nCfgAddr = 11'd853;
              default : nCfgAddr = 11'd854;
            endcase
          end // if sizeEnum
        end
`endif 
      endcase // dataRateIdx

    // Coding Rate 2/3
    2'd1 : 
      case (dataRateIdx)
        default : begin // 7.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd445; // BaseAddr=89
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd446;
              2'd1    : nCfgAddr = 11'd447;
              2'd2    : nCfgAddr = 11'd448;
              default : nCfgAddr = 11'd449;
            endcase
          end // if sizeEnum
        end
        5'd1 : begin // 14.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd450; // BaseAddr=90
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd451;
              2'd1    : nCfgAddr = 11'd452;
              2'd2    : nCfgAddr = 11'd453;
              default : nCfgAddr = 11'd454;
            endcase
          end // if sizeEnum
        end
        5'd2 : begin // 30.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd455; // BaseAddr=91
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd456;
              2'd1    : nCfgAddr = 11'd457;
              2'd2    : nCfgAddr = 11'd458;
              default : nCfgAddr = 11'd459;
            endcase
          end // if sizeEnum
        end
        5'd3 : begin // 68.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd460; // BaseAddr=92
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd461;
              2'd1    : nCfgAddr = 11'd462;
              2'd2    : nCfgAddr = 11'd463;
              default : nCfgAddr = 11'd464;
            endcase
          end // if sizeEnum
        end
        5'd4 : begin // 137.6 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd635; // BaseAddr=127
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd636;
              2'd1    : nCfgAddr = 11'd637;
              2'd2    : nCfgAddr = 11'd638;
              default : nCfgAddr = 11'd639;
            endcase
          end // if sizeEnum
        end
`ifdef RW_NX_DERIV_CHBW804020ONLY
        5'd5 : begin // 288.2 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd855; // BaseAddr=171
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd856;
              2'd1    : nCfgAddr = 11'd857;
              2'd2    : nCfgAddr = 11'd858;
              default : nCfgAddr = 11'd859;
            endcase
          end // if sizeEnum
        end
`endif 
      endcase // dataRateIdx

    // Coding Rate 3/4
    2'd2 : 
      case (dataRateIdx)
        default : begin // 2.6 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd465; // BaseAddr=93
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd466;
              2'd1    : nCfgAddr = 11'd467;
              2'd2    : nCfgAddr = 11'd468;
              default : nCfgAddr = 11'd469;
            endcase
          end // if sizeEnum
        end
        5'd1 : begin // 5.3 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd470; // BaseAddr=94
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd471;
              2'd1    : nCfgAddr = 11'd472;
              2'd2    : nCfgAddr = 11'd473;
              default : nCfgAddr = 11'd474;
            endcase
          end // if sizeEnum
        end
        5'd2 : begin // 7.9 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd475; // BaseAddr=95
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd476;
              2'd1    : nCfgAddr = 11'd477;
              2'd2    : nCfgAddr = 11'd478;
              default : nCfgAddr = 11'd479;
            endcase
          end // if sizeEnum
        end
        5'd3 : begin // 10.6 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd480; // BaseAddr=96
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd481;
              2'd1    : nCfgAddr = 11'd482;
              2'd2    : nCfgAddr = 11'd483;
              default : nCfgAddr = 11'd484;
            endcase
          end // if sizeEnum
        end
        5'd4 : begin // 11.2 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd485; // BaseAddr=97
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd486;
              2'd1    : nCfgAddr = 11'd487;
              2'd2    : nCfgAddr = 11'd488;
              default : nCfgAddr = 11'd489;
            endcase
          end // if sizeEnum
        end
        5'd5 : begin // 15.9 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd490; // BaseAddr=98
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd491;
              2'd1    : nCfgAddr = 11'd492;
              2'd2    : nCfgAddr = 11'd493;
              default : nCfgAddr = 11'd494;
            endcase
          end // if sizeEnum
        end
        5'd6 : begin // 21.2 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd495; // BaseAddr=99
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd496;
              2'd1    : nCfgAddr = 11'd497;
              2'd2    : nCfgAddr = 11'd498;
              default : nCfgAddr = 11'd499;
            endcase
          end // if sizeEnum
        end
        5'd7 : begin // 22.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd500; // BaseAddr=100
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd501;
              2'd1    : nCfgAddr = 11'd502;
              2'd2    : nCfgAddr = 11'd503;
              default : nCfgAddr = 11'd504;
            endcase
          end // if sizeEnum
        end
        5'd8 : begin // 25.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd505; // BaseAddr=101
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd506;
              2'd1    : nCfgAddr = 11'd507;
              2'd2    : nCfgAddr = 11'd508;
              default : nCfgAddr = 11'd509;
            endcase
          end // if sizeEnum
        end
        5'd9 : begin // 33.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd510; // BaseAddr=102
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd511;
              2'd1    : nCfgAddr = 11'd512;
              2'd2    : nCfgAddr = 11'd513;
              default : nCfgAddr = 11'd514;
            endcase
          end // if sizeEnum
        end
        5'd10 : begin // 45.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd515; // BaseAddr=103
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd516;
              2'd1    : nCfgAddr = 11'd517;
              2'd2    : nCfgAddr = 11'd518;
              default : nCfgAddr = 11'd519;
            endcase
          end // if sizeEnum
        end
        5'd11 : begin // 51.6 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd520; // BaseAddr=104
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd521;
              2'd1    : nCfgAddr = 11'd522;
              2'd2    : nCfgAddr = 11'd523;
              default : nCfgAddr = 11'd524;
            endcase
          end // if sizeEnum
        end
        5'd12 : begin // 77.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd525; // BaseAddr=105
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd526;
              2'd1    : nCfgAddr = 11'd527;
              2'd2    : nCfgAddr = 11'd528;
              default : nCfgAddr = 11'd529;
            endcase
          end // if sizeEnum
        end
        5'd13 : begin // 103.2 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd530; // BaseAddr=106
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd531;
              2'd1    : nCfgAddr = 11'd532;
              2'd2    : nCfgAddr = 11'd533;
              default : nCfgAddr = 11'd534;
            endcase
          end // if sizeEnum
        end
`ifdef RW_NX_DERIV_CHBW804020ONLY
        5'd14 : begin // 108.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd860; // BaseAddr=172
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd861;
              2'd1    : nCfgAddr = 11'd862;
              2'd2    : nCfgAddr = 11'd863;
              default : nCfgAddr = 11'd864;
            endcase
          end // if sizeEnum
        end
`endif 
        5'd15 : begin // 129.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd535; // BaseAddr=107
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd536;
              2'd1    : nCfgAddr = 11'd537;
              2'd2    : nCfgAddr = 11'd538;
              default : nCfgAddr = 11'd539;
            endcase
          end // if sizeEnum
        end
        5'd16 : begin // 154.9 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd640; // BaseAddr=128
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd641;
              2'd1    : nCfgAddr = 11'd642;
              2'd2    : nCfgAddr = 11'd643;
              default : nCfgAddr = 11'd644;
            endcase
          end // if sizeEnum
        end
        5'd17 : begin // 206.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd645; // BaseAddr=129
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd646;
              2'd1    : nCfgAddr = 11'd647;
              2'd2    : nCfgAddr = 11'd648;
              default : nCfgAddr = 11'd649;
            endcase
          end // if sizeEnum
        end
`ifdef RW_NX_DERIV_CHBW804020ONLY
        5'd18 : begin // 216.2 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd865; // BaseAddr=173
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd866;
              2'd1    : nCfgAddr = 11'd867;
              2'd2    : nCfgAddr = 11'd868;
              default : nCfgAddr = 11'd869;
            endcase
          end // if sizeEnum
        end
`endif 
        5'd19 : begin // 258.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd650; // BaseAddr=130
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd651;
              2'd1    : nCfgAddr = 11'd652;
              2'd2    : nCfgAddr = 11'd653;
              default : nCfgAddr = 11'd654;
            endcase
          end // if sizeEnum
        end
`ifdef RW_NX_DERIV_CHBW804020ONLY
        5'd20 : begin // 324.3 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd870; // BaseAddr=174
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd871;
              2'd1    : nCfgAddr = 11'd872;
              2'd2    : nCfgAddr = 11'd873;
              default : nCfgAddr = 11'd874;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
        5'd21 : begin // 432.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd875; // BaseAddr=175
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd876;
              2'd1    : nCfgAddr = 11'd877;
              2'd2    : nCfgAddr = 11'd878;
              default : nCfgAddr = 11'd879;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
        5'd22 : begin // 540.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd880; // BaseAddr=176
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd881;
              2'd1    : nCfgAddr = 11'd882;
              2'd2    : nCfgAddr = 11'd883;
              default : nCfgAddr = 11'd884;
            endcase
          end // if sizeEnum
        end
`endif 
      endcase // dataRateIdx

    // Coding Rate 5/6
    default : 
      case (dataRateIdx)
        default : begin // 8.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd540; // BaseAddr=108
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd541;
              2'd1    : nCfgAddr = 11'd542;
              2'd2    : nCfgAddr = 11'd543;
              default : nCfgAddr = 11'd544;
            endcase
          end // if sizeEnum
        end
        5'd1 : begin // 11.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd545; // BaseAddr=109
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd546;
              2'd1    : nCfgAddr = 11'd547;
              2'd2    : nCfgAddr = 11'd548;
              default : nCfgAddr = 11'd549;
            endcase
          end // if sizeEnum
        end
        5'd2 : begin // 17.6 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd550; // BaseAddr=110
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd551;
              2'd1    : nCfgAddr = 11'd552;
              2'd2    : nCfgAddr = 11'd553;
              default : nCfgAddr = 11'd554;
            endcase
          end // if sizeEnum
        end
        5'd3 : begin // 23.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd555; // BaseAddr=111
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd556;
              2'd1    : nCfgAddr = 11'd557;
              2'd2    : nCfgAddr = 11'd558;
              default : nCfgAddr = 11'd559;
            endcase
          end // if sizeEnum
        end
        5'd4 : begin // 37.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd560; // BaseAddr=112
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd561;
              2'd1    : nCfgAddr = 11'd562;
              2'd2    : nCfgAddr = 11'd563;
              default : nCfgAddr = 11'd564;
            endcase
          end // if sizeEnum
        end
        5'd5 : begin // 50.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd565; // BaseAddr=113
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd566;
              2'd1    : nCfgAddr = 11'd567;
              2'd2    : nCfgAddr = 11'd568;
              default : nCfgAddr = 11'd569;
            endcase
          end // if sizeEnum
        end
        5'd6 : begin // 86.0 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd570; // BaseAddr=114
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd571;
              2'd1    : nCfgAddr = 11'd572;
              2'd2    : nCfgAddr = 11'd573;
              default : nCfgAddr = 11'd574;
            endcase
          end // if sizeEnum
        end
        5'd7 : begin // 114.7 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd575; // BaseAddr=115
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd576;
              2'd1    : nCfgAddr = 11'd577;
              2'd2    : nCfgAddr = 11'd578;
              default : nCfgAddr = 11'd579;
            endcase
          end // if sizeEnum
        end
        5'd8 : begin // 143.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd580; // BaseAddr=116
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd581;
              2'd1    : nCfgAddr = 11'd582;
              2'd2    : nCfgAddr = 11'd583;
              default : nCfgAddr = 11'd584;
            endcase
          end // if sizeEnum
        end
        5'd9 : begin // 172.1 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd655; // BaseAddr=131
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd656;
              2'd1    : nCfgAddr = 11'd657;
              2'd2    : nCfgAddr = 11'd658;
              default : nCfgAddr = 11'd659;
            endcase
          end // if sizeEnum
        end
        5'd10 : begin // 229.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd660; // BaseAddr=132
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd661;
              2'd1    : nCfgAddr = 11'd662;
              2'd2    : nCfgAddr = 11'd663;
              default : nCfgAddr = 11'd664;
            endcase
          end // if sizeEnum
        end
        5'd11 : begin // 286.8 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd665; // BaseAddr=133
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd666;
              2'd1    : nCfgAddr = 11'd667;
              2'd2    : nCfgAddr = 11'd668;
              default : nCfgAddr = 11'd669;
            endcase
          end // if sizeEnum
        end
`ifdef RW_NX_DERIV_CHBW804020ONLY
        5'd12 : begin // 360.3 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd885; // BaseAddr=177
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd886;
              2'd1    : nCfgAddr = 11'd887;
              2'd2    : nCfgAddr = 11'd888;
              default : nCfgAddr = 11'd889;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
        5'd13 : begin // 480.4 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd890; // BaseAddr=178
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd891;
              2'd1    : nCfgAddr = 11'd892;
              2'd2    : nCfgAddr = 11'd893;
              default : nCfgAddr = 11'd894;
            endcase
          end // if sizeEnum
        end
`endif 
`ifdef RW_NX_DERIV_CHBW804020ONLY
        5'd14 : begin // 600.5 Mbps
          if ((sizeEnum == 2'd0) || (sizeEnum == 2'd1)) begin
            nCfgAddr = 11'd895; // BaseAddr=179
          end else begin
            case (bucketIdx)
              2'd0    : nCfgAddr = 11'd896;
              2'd1    : nCfgAddr = 11'd897;
              2'd2    : nCfgAddr = 11'd898;
              default : nCfgAddr = 11'd899;
            endcase
          end // if sizeEnum
        end
`endif 
      endcase // dataRateIdx
  endcase
end // always

  always @(posedge clk, negedge rst_n)
    if(!rst_n) begin
      CfgAddr             <= 11'd0;
      dataRateIdx         <= 5'd0;
      bucketIdx           <= 2'd0;
    end else begin
      CfgAddr             <= nCfgAddr - 11'd335; // refs #10147: stbc temporary hack
      dataRateIdx         <= ndataRateIdx;
      bucketIdx           <= nbucketIdx;
    end

endmodule
