//------------------------------------------------------------------------------
// ldpcDecCellRam.v
// 
// Description:
//   RAM wrapper for the Cell RAM.
//
// 30 Apr 2010 M. Rumsey. Created.
// 04 Apr 2011 M. Rumsey. `LDEC_USE_ALT_RAMS added.
//
// (c) Copyright 2010-2011, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcDec.vh"

module ldpcDecCellRam
  (  
     // A port
     input                         ckA,
     input                         selA,
     input [`LDEC_CELL_RAM_A-1:0]  addrA,
     input [`LDEC_CELL_RAM_W-1:0]  dInA,
     input                         weA,
     output [`LDEC_CELL_RAM_W-1:0] dOutA,
     // B port
     input                         ckB,
     input                         selB,
     input [`LDEC_CELL_RAM_A-1:0]  addrB,
     input [`LDEC_CELL_RAM_W-1:0]  dInB,
     input                         weB,
     output [`LDEC_CELL_RAM_W-1:0] dOutB);

`include "ldpcDecFuncs.vh"

  wire weB2;
  wire selB2;
  wire [`LDEC_CELL_RAM_A-1:0] addrB2;
  
  //---------------------------------------------------------------------------
  // Dual port version
  //---------------------------------------------------------------------------

  generate
    if (!`LDEC_USE_ALT_RAMS) begin: gAlt0
    ldpcDecTrueDpRam # (
        .depth   (`LDEC_CELL_RAM_D),
        .width   (`LDEC_CELL_RAM_W))
    cellRam (
        .ckA   (ckA),
        .selA  (selA),
        .addrA (addrA),
        .dInA  (dInA),
        .weA   (weA),
        .dOutA (dOutA),
        .ckB   (ckB),
        .selB  (selB),
        .addrB (addrB),
        .dInB  (dInB),
        .weB   (weB),
        .dOutB (dOutB));
  end
  endgenerate //  gAlt0

  //---------------------------------------------------------------------------
  // 2 Single ports
  //---------------------------------------------------------------------------

  generate
    if (`LDEC_USE_ALT_RAMS) begin: gAlt1

      ldpcDecSpRam # (
         .depth   (`LDEC_CELL_RAM_D),
         .width   (`LDEC_CELL_RAM_W))
      cellRamA (
                .ck   (ckA),
                .sel  (selA),
                .addr (addrA),
                .dIn  (dInA),
                .we   (weA),
                .dOut (dOutA));
      
      // Second RAM gets written the same info as A but effectively
      // adds a second read port. When weA is high the RAM inputs
      // are switched to the A port.
      
      assign selB2 = (weA == 1'b1 ) ? selA : selB;
      assign addrB2 = (weA == 1'b1 ) ? addrA : addrB;
      assign weB2 = weA;
      
      ldpcDecSpRam #
        (.depth   (`LDEC_CELL_RAM_D),
         .width   (`LDEC_CELL_RAM_W))
      cellRamB (
                .ck   (ckA),
                .sel  (selB2),
                .addr (addrB2),
                .dIn  (dInA),
                .we   (weB2),
                .dOut (dOutB));
      
    end
  endgenerate //  gAlt1
  
endmodule

    
    

