//------------------------------------------------------------------------------
// ldcpDecCellRom.v
// 
// Description:
//   An alternative to the ldpcDecCellRam block. This version hardcodes the
//   code information instead of allowing it to be programmed over the processor
//   bus.
//
// 21 Apr 2011 M. Rumsey. c.
//
// (Created) Copyright 2011, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcDec.vh"

module ldpcDecCellRom
  ( 
    input                                    nReset,
    input [numBits(`LDEC_Z_ENUM_MAX)-1:0]    zEnum,
    input [numBits(`LDEC_R_ENUM_MAX)-1:0]    rEnum,
    input                                    enable,
    output reg [numBits(`LDEC_NCELLS)-1:0]   numMacroCells,
    // A port       
    input                                    ckA,
    input                                    selA,
    input [`LDEC_CELL_RAM_A-1:0]             addrA,
    output reg [`LDEC_CELL_RAM_W-1:0]        dOutA,
    // B port      
    input                                    ckB,
    input                                    selB,
    input  [`LDEC_CELL_RAM_A-1:0]            addrB,
    output reg [`LDEC_CELL_RAM_W-1:0]        dOutB);

`include "ldpcDecFuncs.vh"

  // Only 2-port version is coded.

  // Code tables are imported from config/vhdl.

  //---------------------------------------------------------------------------
  // Select the 'cell' information for the current code case
  //---------------------------------------------------------------------------

//  generate
//    if (`LDEC_NUM_PORTS == 1) begin: g1Port
//      always @(posedge(ckA) `LDEC_RESET_STR)
//      begin : pSelA
//        if (nReset == 1'b0) begin
//          dOutA <= '0;
//          numMacroCells <= 0;
//        end else begin
//          if (selA == 1'b1 && enable == 1'b1) begin
//            numMacroCells <= NUM_MACRO_CELLS1P[zEnum][rEnum];
//            case (zEnum)
//              2'd0 :
//                case (rEnum)
//                  2'd0 : dOutA <= CODE1P_0_0[addrA];
//                  2'd1 : dOutA <= CODE1P_0_1[addrA];
//                  2'd2 : dOutA <= CODE1P_0_2[addrA];
//                  default : dOutA <= CODE1P_0_3[addrA];
//                endcase
//              2'd1 :
//                case (rEnum)
//                  2'd0 : dOutA <= CODE1P_1_0[addrA];
//                  2'd1 : dOutA <= CODE1P_1_1[addrA];
//                  2'd2 : dOutA <= CODE1P_1_2[addrA];
//                  default : dOutA <= CODE1P_1_3[addrA];
//                endcase
//              default :
//                case (rEnum)
//                  2'd0 : dOutA <= CODE1P_2_0[addrA];
//                  2'd1 : dOutA <= CODE1P_2_1[addrA];
//                  2'd2 : dOutA <= CODE1P_2_2[addrA];
//                  default : dOutA <= CODE1P_2_3[addrA];
//                endcase
//            endcase
//          end
//          end
//      end //pSelA
//
//      always @(posedge(ckB) `LDEC_RESET_STR)
//      begin : pSelB
//        if (nReset == 1'b0) begin
//          dOutB <= '0;
//        end else begin
//          if (selB == 1'b1) begin
//            case (zEnum)
//              2'd0 :
//                case (rEnum)
//                  2'd0 : dOutB <= CODE1P_0_0[addrB];
//                  2'd1 : dOutB <= CODE1P_0_1[addrB];
//                  2'd2 : dOutB <= CODE1P_0_2[addrB];
//                  default : dOutB <= CODE1P_0_3[addrB];
//                endcase
//              2'd1 :
//                case (rEnum)
//                  2'd0 : dOutB <= CODE1P_1_0[addrB];
//                  2'd1 : dOutB <= CODE1P_1_1[addrB];
//                  2'd2 : dOutB <= CODE1P_1_2[addrB];
//                  default : dOutB <= CODE1P_1_3[addrB];
//                endcase
//              default :
//                case (rEnum)
//                  2'd0 : dOutB <= CODE1P_2_0[addrB];
//                  2'd1 : dOutB <= CODE1P_2_1[addrB];
//                  2'd2 : dOutB <= CODE1P_2_2[addrB];
//                  default : dOutB <= CODE1P_2_3[addrB];
//                endcase
//            endcase
//          end
//        end
//      end //pSelB
//    end
//  endgenerate // g1Port
//
//// Identical code but for 2 port
//  generate
//    if (`LDEC_NUM_PORTS == 2) begin: g2Port
       
      always @(posedge(ckA) `LDEC_RESET_STR)
      begin : pSelA
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_0_0 [0:87];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_0_1 [0:87];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_0_2 [0:87];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_0_3 [0:87];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_1_0 [0:85];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_1_1 [0:87];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_1_2 [0:87];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_1_3 [0:84];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_2_0 [0:85];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_2_1 [0:87];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_2_2 [0:84];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_2_3 [0:78];

        reg [numBits(`LDEC_NCELLS)-1:0] NUM_MACRO_CELLS2P [0:2][0:3];
        
        if (nReset == 1'b0) begin
          dOutA <= `LDEC_PAD(1'b0, `LDEC_CELL_RAM_W-1);
          numMacroCells <= `LDEC_PAD(1'b0, numBits(`LDEC_NCELLS)-1);
        end else begin

          // The following table is in-line as we don't trust 'initial' blocks to work in synthesis.
          // A System Verilog form is available but Cadence HAL doesn't understand it.

    CODE2P_0_0[0] = 15'd50; CODE2P_0_0[1] = 15'd4178; CODE2P_0_0[2] = 15'd8386; CODE2P_0_0[3] = 15'd2050; CODE2P_0_0[4] = 15'd10242; CODE2P_0_0[5] = 15'd14338; CODE2P_0_0[6] = 15'd15363; CODE2P_0_0[7] = 15'd0; CODE2P_0_0[8] = 15'd4096; CODE2P_0_0[9] = 15'd8192; CODE2P_0_0[10] = 15'd12298; CODE2P_0_0[11] = 15'd5122; CODE2P_0_0[12] = 15'd11266; CODE2P_0_0[13] = 15'd13315; CODE2P_0_0[14] = 15'd200; CODE2P_0_0[15] = 15'd4160; CODE2P_0_0[16] = 15'd8248; CODE2P_0_0[17] = 15'd12288; CODE2P_0_0[18] = 15'd9362; CODE2P_0_0[19] = 15'd18434; CODE2P_0_0[20] = 15'd19463; CODE2P_0_0[21] = 15'd16; CODE2P_0_0[22] = 15'd4256; CODE2P_0_0[23] = 15'd8392; CODE2P_0_0[24] = 15'd3074; CODE2P_0_0[25] = 15'd9216; CODE2P_0_0[26] = 15'd15364; CODE2P_0_0[27] = 15'd16387; CODE2P_0_0[28] = 15'd24; CODE2P_0_0[29] = 15'd4224; CODE2P_0_0[30] = 15'd8392; CODE2P_0_0[31] = 15'd7186; CODE2P_0_0[32] = 15'd9260; CODE2P_0_0[33] = 15'd12300; CODE2P_0_0[34] = 15'd23555; CODE2P_0_0[35] = 15'd88; CODE2P_0_0[36] = 15'd4248; CODE2P_0_0[37] = 15'd8296; CODE2P_0_0[38] = 15'd10264; CODE2P_0_0[39] = 15'd11400; CODE2P_0_0[40] = 15'd21506; CODE2P_0_0[41] = 15'd22531; CODE2P_0_0[42] = 15'd176; CODE2P_0_0[43] = 15'd4232; CODE2P_0_0[44] = 15'd8288; CODE2P_0_0[45] = 15'd1026; CODE2P_0_0[46] = 15'd6146; CODE2P_0_0[47] = 15'd7168; CODE2P_0_0[48] = 15'd13316; CODE2P_0_0[49] = 15'd14341; CODE2P_0_0[50] = 15'd56; CODE2P_0_0[51] = 15'd4272; CODE2P_0_0[52] = 15'd8376; CODE2P_0_0[53] = 15'd1188; CODE2P_0_0[54] = 15'd5200; CODE2P_0_0[55] = 15'd3200; CODE2P_0_0[56] = 15'd20486; CODE2P_0_0[57] = 15'd21509; CODE2P_0_0[58] = 15'd200; CODE2P_0_0[59] = 15'd4280; CODE2P_0_0[60] = 15'd8264; CODE2P_0_0[61] = 15'd2112; CODE2P_0_0[62] = 15'd5268; CODE2P_0_0[63] = 15'd7284; CODE2P_0_0[64] = 15'd22532; CODE2P_0_0[65] = 15'd23557; CODE2P_0_0[66] = 15'd192; CODE2P_0_0[67] = 15'd4232; CODE2P_0_0[68] = 15'd8272; CODE2P_0_0[69] = 15'd2236; CODE2P_0_0[70] = 15'd17410; CODE2P_0_0[71] = 15'd3084; CODE2P_0_0[72] = 15'd6172; CODE2P_0_0[73] = 15'd18437; CODE2P_0_0[74] = 15'd188; CODE2P_0_0[75] = 15'd4124; CODE2P_0_0[76] = 15'd8196; CODE2P_0_0[77] = 15'd10316; CODE2P_0_0[78] = 15'd17412; CODE2P_0_0[79] = 15'd11356; CODE2P_0_0[80] = 15'd16389; CODE2P_0_0[81] = 15'd104; CODE2P_0_0[82] = 15'd4096; CODE2P_0_0[83] = 15'd8240; CODE2P_0_0[84] = 15'd1216; CODE2P_0_0[85] = 15'd6208; CODE2P_0_0[86] = 15'd19456; CODE2P_0_0[87] = 15'd20481;
    
    CODE2P_0_1[0] = 15'd186; CODE2P_0_1[1] = 15'd1138; CODE2P_0_1[2] = 15'd2242; CODE2P_0_1[3] = 15'd4194; CODE2P_0_1[4] = 15'd6298; CODE2P_0_1[5] = 15'd8330; CODE2P_0_1[6] = 15'd20482; CODE2P_0_1[7] = 15'd21506; CODE2P_0_1[8] = 15'd12450; CODE2P_0_1[9] = 15'd14506; CODE2P_0_1[10] = 15'd16387; CODE2P_0_1[11] = 15'd80; CODE2P_0_1[12] = 15'd1096; CODE2P_0_1[13] = 15'd2168; CODE2P_0_1[14] = 15'd3162; CODE2P_0_1[15] = 15'd17410; CODE2P_0_1[16] = 15'd5122; CODE2P_0_1[17] = 15'd7178; CODE2P_0_1[18] = 15'd10386; CODE2P_0_1[19] = 15'd12356; CODE2P_0_1[20] = 15'd14420; CODE2P_0_1[21] = 15'd18435; CODE2P_0_1[22] = 15'd200; CODE2P_0_1[23] = 15'd1232; CODE2P_0_1[24] = 15'd2160; CODE2P_0_1[25] = 15'd16396; CODE2P_0_1[26] = 15'd17412; CODE2P_0_1[27] = 15'd13442; CODE2P_0_1[28] = 15'd15506; CODE2P_0_1[29] = 15'd4256; CODE2P_0_1[30] = 15'd6160; CODE2P_0_1[31] = 15'd8224; CODE2P_0_1[32] = 15'd11331; CODE2P_0_1[33] = 15'd80; CODE2P_0_1[34] = 15'd1128; CODE2P_0_1[35] = 15'd2088; CODE2P_0_1[36] = 15'd3072; CODE2P_0_1[37] = 15'd19458; CODE2P_0_1[38] = 15'd13416; CODE2P_0_1[39] = 15'd15488; CODE2P_0_1[40] = 15'd5144; CODE2P_0_1[41] = 15'd7224; CODE2P_0_1[42] = 15'd10448; CODE2P_0_1[43] = 15'd20485; CODE2P_0_1[44] = 15'd128; CODE2P_0_1[45] = 15'd1040; CODE2P_0_1[46] = 15'd2208; CODE2P_0_1[47] = 15'd3280; CODE2P_0_1[48] = 15'd19460; CODE2P_0_1[49] = 15'd4264; CODE2P_0_1[50] = 15'd6192; CODE2P_0_1[51] = 15'd8200; CODE2P_0_1[52] = 15'd9426; CODE2P_0_1[53] = 15'd11320; CODE2P_0_1[54] = 15'd18437; CODE2P_0_1[55] = 15'd112; CODE2P_0_1[56] = 15'd1208; CODE2P_0_1[57] = 15'd2216; CODE2P_0_1[58] = 15'd3160; CODE2P_0_1[59] = 15'd22530; CODE2P_0_1[60] = 15'd4260; CODE2P_0_1[61] = 15'd6340; CODE2P_0_1[62] = 15'd8340; CODE2P_0_1[63] = 15'd10396; CODE2P_0_1[64] = 15'd15540; CODE2P_0_1[65] = 15'd23559; CODE2P_0_1[66] = 15'd52; CODE2P_0_1[67] = 15'd1204; CODE2P_0_1[68] = 15'd2124; CODE2P_0_1[69] = 15'd3236; CODE2P_0_1[70] = 15'd22532; CODE2P_0_1[71] = 15'd5324; CODE2P_0_1[72] = 15'd7308; CODE2P_0_1[73] = 15'd9284; CODE2P_0_1[74] = 15'd11380; CODE2P_0_1[75] = 15'd13460; CODE2P_0_1[76] = 15'd21509; CODE2P_0_1[77] = 15'd136; CODE2P_0_1[78] = 15'd1112; CODE2P_0_1[79] = 15'd2136; CODE2P_0_1[80] = 15'd3232; CODE2P_0_1[81] = 15'd12432; CODE2P_0_1[82] = 15'd14544; CODE2P_0_1[83] = 15'd16392; CODE2P_0_1[84] = 15'd5288; CODE2P_0_1[85] = 15'd7376; CODE2P_0_1[86] = 15'd9240; CODE2P_0_1[87] = 15'd23553;
    
    CODE2P_0_2[0] = 15'd202; CODE2P_0_2[1] = 15'd1122; CODE2P_0_2[2] = 15'd2146; CODE2P_0_2[3] = 15'd3098; CODE2P_0_2[4] = 15'd4122; CODE2P_0_2[5] = 15'd7338; CODE2P_0_2[6] = 15'd9338; CODE2P_0_2[7] = 15'd17538; CODE2P_0_2[8] = 15'd19458; CODE2P_0_2[9] = 15'd5330; CODE2P_0_2[10] = 15'd6194; CODE2P_0_2[11] = 15'd10418; CODE2P_0_2[12] = 15'd12410; CODE2P_0_2[13] = 15'd14370; CODE2P_0_2[14] = 15'd20487; CODE2P_0_2[15] = 15'd72; CODE2P_0_2[16] = 15'd1080; CODE2P_0_2[17] = 15'd2048; CODE2P_0_2[18] = 15'd3080; CODE2P_0_2[19] = 15'd4232; CODE2P_0_2[20] = 15'd7224; CODE2P_0_2[21] = 15'd8218; CODE2P_0_2[22] = 15'd11450; CODE2P_0_2[23] = 15'd13442; CODE2P_0_2[24] = 15'd22530; CODE2P_0_2[25] = 15'd16554; CODE2P_0_2[26] = 15'd10264; CODE2P_0_2[27] = 15'd18434; CODE2P_0_2[28] = 15'd21511; CODE2P_0_2[29] = 15'd192; CODE2P_0_2[30] = 15'd1064; CODE2P_0_2[31] = 15'd2256; CODE2P_0_2[32] = 15'd3128; CODE2P_0_2[33] = 15'd4104; CODE2P_0_2[34] = 15'd7288; CODE2P_0_2[35] = 15'd8384; CODE2P_0_2[36] = 15'd11328; CODE2P_0_2[37] = 15'd13416; CODE2P_0_2[38] = 15'd22532; CODE2P_0_2[39] = 15'd9336; CODE2P_0_2[40] = 15'd15466; CODE2P_0_2[41] = 15'd17496; CODE2P_0_2[42] = 15'd23555; CODE2P_0_2[43] = 15'd16; CODE2P_0_2[44] = 15'd1040; CODE2P_0_2[45] = 15'd2200; CODE2P_0_2[46] = 15'd3184; CODE2P_0_2[47] = 15'd4288; CODE2P_0_2[48] = 15'd5128; CODE2P_0_2[49] = 15'd6264; CODE2P_0_2[50] = 15'd7324; CODE2P_0_2[51] = 15'd13508; CODE2P_0_2[52] = 15'd11284; CODE2P_0_2[53] = 15'd9384; CODE2P_0_2[54] = 15'd15388; CODE2P_0_2[55] = 15'd17428; CODE2P_0_2[56] = 15'd23556; CODE2P_0_2[57] = 15'd18441; CODE2P_0_2[58] = 15'd132; CODE2P_0_2[59] = 15'd1164; CODE2P_0_2[60] = 15'd2228; CODE2P_0_2[61] = 15'd3268; CODE2P_0_2[62] = 15'd4172; CODE2P_0_2[63] = 15'd5148; CODE2P_0_2[64] = 15'd6260; CODE2P_0_2[65] = 15'd10300; CODE2P_0_2[66] = 15'd12500; CODE2P_0_2[67] = 15'd14356; CODE2P_0_2[68] = 15'd9236; CODE2P_0_2[69] = 15'd8228; CODE2P_0_2[70] = 15'd16556; CODE2P_0_2[71] = 15'd19460; CODE2P_0_2[72] = 15'd18445; CODE2P_0_2[73] = 15'd200; CODE2P_0_2[74] = 15'd1168; CODE2P_0_2[75] = 15'd2256; CODE2P_0_2[76] = 15'd3200; CODE2P_0_2[77] = 15'd4272; CODE2P_0_2[78] = 15'd5304; CODE2P_0_2[79] = 15'd6216; CODE2P_0_2[80] = 15'd10272; CODE2P_0_2[81] = 15'd12320; CODE2P_0_2[82] = 15'd14400; CODE2P_0_2[83] = 15'd20480; CODE2P_0_2[84] = 15'd8192; CODE2P_0_2[85] = 15'd16472; CODE2P_0_2[86] = 15'd15544; CODE2P_0_2[87] = 15'd21505;
    
    CODE2P_0_3[0] = 15'd58; CODE2P_0_3[1] = 15'd1082; CODE2P_0_3[2] = 15'd2162; CODE2P_0_3[3] = 15'd3186; CODE2P_0_3[4] = 15'd4130; CODE2P_0_3[5] = 15'd5250; CODE2P_0_3[6] = 15'd6274; CODE2P_0_3[7] = 15'd7362; CODE2P_0_3[8] = 15'd8386; CODE2P_0_3[9] = 15'd9298; CODE2P_0_3[10] = 15'd10250; CODE2P_0_3[11] = 15'd11322; CODE2P_0_3[12] = 15'd13362; CODE2P_0_3[13] = 15'd14418; CODE2P_0_3[14] = 15'd15570; CODE2P_0_3[15] = 15'd16450; CODE2P_0_3[16] = 15'd17554; CODE2P_0_3[17] = 15'd18602; CODE2P_0_3[18] = 15'd19570; CODE2P_0_3[19] = 15'd20490; CODE2P_0_3[20] = 15'd23554; CODE2P_0_3[21] = 15'd12411; CODE2P_0_3[22] = 15'd136; CODE2P_0_3[23] = 15'd1128; CODE2P_0_3[24] = 15'd2112; CODE2P_0_3[25] = 15'd3240; CODE2P_0_3[26] = 15'd4168; CODE2P_0_3[27] = 15'd5144; CODE2P_0_3[28] = 15'd6288; CODE2P_0_3[29] = 15'd7264; CODE2P_0_3[30] = 15'd8272; CODE2P_0_3[31] = 15'd9216; CODE2P_0_3[32] = 15'd10272; CODE2P_0_3[33] = 15'd11384; CODE2P_0_3[34] = 15'd13328; CODE2P_0_3[35] = 15'd14376; CODE2P_0_3[36] = 15'd15440; CODE2P_0_3[37] = 15'd16592; CODE2P_0_3[38] = 15'd17560; CODE2P_0_3[39] = 15'd18536; CODE2P_0_3[40] = 15'd19560; CODE2P_0_3[41] = 15'd20488; CODE2P_0_3[42] = 15'd21510; CODE2P_0_3[43] = 15'd12445; CODE2P_0_3[44] = 15'd180; CODE2P_0_3[45] = 15'd1156; CODE2P_0_3[46] = 15'd2084; CODE2P_0_3[47] = 15'd3100; CODE2P_0_3[48] = 15'd4180; CODE2P_0_3[49] = 15'd5292; CODE2P_0_3[50] = 15'd6244; CODE2P_0_3[51] = 15'd7212; CODE2P_0_3[52] = 15'd8364; CODE2P_0_3[53] = 15'd9332; CODE2P_0_3[54] = 15'd10396; CODE2P_0_3[55] = 15'd11308; CODE2P_0_3[56] = 15'd13380; CODE2P_0_3[57] = 15'd14380; CODE2P_0_3[58] = 15'd15508; CODE2P_0_3[59] = 15'd16476; CODE2P_0_3[60] = 15'd17452; CODE2P_0_3[61] = 15'd18476; CODE2P_0_3[62] = 15'd19580; CODE2P_0_3[63] = 15'd20484; CODE2P_0_3[64] = 15'd22534; CODE2P_0_3[65] = 15'd23557; CODE2P_0_3[66] = 15'd24; CODE2P_0_3[67] = 15'd1120; CODE2P_0_3[68] = 15'd2136; CODE2P_0_3[69] = 15'd3184; CODE2P_0_3[70] = 15'd4184; CODE2P_0_3[71] = 15'd5320; CODE2P_0_3[72] = 15'd6184; CODE2P_0_3[73] = 15'd7312; CODE2P_0_3[74] = 15'd8192; CODE2P_0_3[75] = 15'd9288; CODE2P_0_3[76] = 15'd10256; CODE2P_0_3[77] = 15'd11472; CODE2P_0_3[78] = 15'd13392; CODE2P_0_3[79] = 15'd14528; CODE2P_0_3[80] = 15'd15416; CODE2P_0_3[81] = 15'd16496; CODE2P_0_3[82] = 15'd17568; CODE2P_0_3[83] = 15'd18464; CODE2P_0_3[84] = 15'd19472; CODE2P_0_3[85] = 15'd12496; CODE2P_0_3[86] = 15'd22528; CODE2P_0_3[87] = 15'd21505;
    
    CODE2P_1_0[0] = 15'd266; CODE2P_1_0[1] = 15'd4394; CODE2P_1_0[2] = 15'd8202; CODE2P_1_0[3] = 15'd3378; CODE2P_1_0[4] = 15'd7202; CODE2P_1_0[5] = 15'd15362; CODE2P_1_0[6] = 15'd16387; CODE2P_1_0[7] = 15'd376; CODE2P_1_0[8] = 15'd12290; CODE2P_1_0[9] = 15'd8600; CODE2P_1_0[10] = 15'd1114; CODE2P_1_0[11] = 15'd5258; CODE2P_1_0[12] = 15'd18434; CODE2P_1_0[13] = 15'd19463; CODE2P_1_0[14] = 15'd392; CODE2P_1_0[15] = 15'd4336; CODE2P_1_0[16] = 15'd8464; CODE2P_1_0[17] = 15'd12296; CODE2P_1_0[18] = 15'd2186; CODE2P_1_0[19] = 15'd11418; CODE2P_1_0[20] = 15'd23555; CODE2P_1_0[21] = 15'd360; CODE2P_1_0[22] = 15'd4096; CODE2P_1_0[23] = 15'd8352; CODE2P_1_0[24] = 15'd5296; CODE2P_1_0[25] = 15'd9554; CODE2P_1_0[26] = 15'd16388; CODE2P_1_0[27] = 15'd17411; CODE2P_1_0[28] = 15'd8; CODE2P_1_0[29] = 15'd4104; CODE2P_1_0[30] = 15'd8496; CODE2P_1_0[31] = 15'd2268; CODE2P_1_0[32] = 15'd10594; CODE2P_1_0[33] = 15'd21506; CODE2P_1_0[34] = 15'd22531; CODE2P_1_0[35] = 15'd320; CODE2P_1_0[36] = 15'd4272; CODE2P_1_0[37] = 15'd8536; CODE2P_1_0[38] = 15'd7352; CODE2P_1_0[39] = 15'd6538; CODE2P_1_0[40] = 15'd12300; CODE2P_1_0[41] = 15'd13315; CODE2P_1_0[42] = 15'd1168; CODE2P_1_0[43] = 15'd4280; CODE2P_1_0[44] = 15'd8192; CODE2P_1_0[45] = 15'd7236; CODE2P_1_0[46] = 15'd9500; CODE2P_1_0[47] = 15'd22532; CODE2P_1_0[48] = 15'd23557; CODE2P_1_0[49] = 15'd408; CODE2P_1_0[50] = 15'd4376; CODE2P_1_0[51] = 15'd8544; CODE2P_1_0[52] = 15'd3456; CODE2P_1_0[53] = 15'd10384; CODE2P_1_0[54] = 15'd17412; CODE2P_1_0[55] = 15'd18437; CODE2P_1_0[56] = 15'd264; CODE2P_1_0[57] = 15'd4288; CODE2P_1_0[58] = 15'd8376; CODE2P_1_0[59] = 15'd3348; CODE2P_1_0[60] = 15'd11632; CODE2P_1_0[61] = 15'd20486; CODE2P_1_0[62] = 15'd21509;CODE2P_1_0[63] = 15'd312; CODE2P_1_0[64] = 15'd4128; CODE2P_1_0[65] = 15'd1424; CODE2P_1_0[66] = 15'd14338; CODE2P_1_0[67] = 15'd11660; CODE2P_1_0[68] = 15'd6164; CODE2P_1_0[69] = 15'd15365; CODE2P_1_0[70] = 15'd404; CODE2P_1_0[71] = 15'd4484; CODE2P_1_0[72] = 15'd8300; CODE2P_1_0[73] = 15'd14340; CODE2P_1_0[74] = 15'd1036; CODE2P_1_0[75] = 15'd5404; CODE2P_1_0[76] = 15'd10484; CODE2P_1_0[77] = 15'd13317; CODE2P_1_0[78] = 15'd40; CODE2P_1_0[79] = 15'd4144; CODE2P_1_0[80] = 15'd8296; CODE2P_1_0[81] = 15'd2248; CODE2P_1_0[82] = 15'd6504; CODE2P_1_0[83] = 15'd9536; CODE2P_1_0[84] = 15'd19456; CODE2P_1_0[85] = 15'd20481;
          
    CODE2P_1_1[0] = 15'd282; CODE2P_1_1[1] = 15'd1346; CODE2P_1_1[2] = 15'd2306; CODE2P_1_1[3] = 15'd11674; CODE2P_1_1[4] = 15'd7314; CODE2P_1_1[5] = 15'd10586; CODE2P_1_1[6] = 15'd13570; CODE2P_1_1[7] = 15'd21506; CODE2P_1_1[8] = 15'd22530; CODE2P_1_1[9] = 15'd3202; CODE2P_1_1[10] = 15'd4139; CODE2P_1_1[11] = 15'd256; CODE2P_1_1[12] = 15'd1200; CODE2P_1_1[13] = 15'd2080; CODE2P_1_1[14] = 15'd11568; CODE2P_1_1[15] = 15'd8410; CODE2P_1_1[16] = 15'd15426; CODE2P_1_1[17] = 15'd16394; CODE2P_1_1[18] = 15'd9442; CODE2P_1_1[19] = 15'd23554; CODE2P_1_1[20] = 15'd3240; CODE2P_1_1[21] = 15'd4225; CODE2P_1_1[22] = 15'd312; CODE2P_1_1[23] = 15'd1272; CODE2P_1_1[24] = 15'd2224; CODE2P_1_1[25] = 15'd11668; CODE2P_1_1[26] = 15'd8280; CODE2P_1_1[27] = 15'd15408; CODE2P_1_1[28] = 15'd16392; CODE2P_1_1[29] = 15'd5442; CODE2P_1_1[30] = 15'd6178; CODE2P_1_1[31] = 15'd3416; CODE2P_1_1[32] = 15'd17411; CODE2P_1_1[33] = 15'd72; CODE2P_1_1[34] = 15'd1216; CODE2P_1_1[35] = 15'd2152; CODE2P_1_1[36] = 15'd4320; CODE2P_1_1[37] = 15'd7464; CODE2P_1_1[38] = 15'd15468; CODE2P_1_1[39] = 15'd10440; CODE2P_1_1[40] = 15'd13728; CODE2P_1_1[41] = 15'd22532; CODE2P_1_1[42] = 15'd3248; CODE2P_1_1[43] = 15'd23557; CODE2P_1_1[44] = 15'd200; CODE2P_1_1[45] = 15'd1440; CODE2P_1_1[46] = 15'd2376; CODE2P_1_1[47] = 15'd4144; CODE2P_1_1[48] = 15'd14634; CODE2P_1_1[49] = 15'd6260; CODE2P_1_1[50] = 15'd8468; CODE2P_1_1[51] = 15'd12482; CODE2P_1_1[52] = 15'd17412; CODE2P_1_1[53] = 15'd3088; CODE2P_1_1[54] = 15'd18439; CODE2P_1_1[55] = 15'd160; CODE2P_1_1[56] = 15'd1288; CODE2P_1_1[57] = 15'd2432; CODE2P_1_1[58] = 15'd4128; CODE2P_1_1[59] = 15'd14676; CODE2P_1_1[60] = 15'd5224; CODE2P_1_1[61] = 15'd20482; CODE2P_1_1[62] = 15'd7380; CODE2P_1_1[63] = 15'd10420; CODE2P_1_1[64] = 15'd13684; CODE2P_1_1[65] = 15'd19463; CODE2P_1_1[66] = 15'd364; CODE2P_1_1[67] = 15'd1084; CODE2P_1_1[68] = 15'd2196; CODE2P_1_1[69] = 15'd3484; CODE2P_1_1[70] = 15'd9620; CODE2P_1_1[71] = 15'd4196; CODE2P_1_1[72] = 15'd20484; CODE2P_1_1[73] = 15'd5324; CODE2P_1_1[74] = 15'd12332; CODE2P_1_1[75] = 15'd16388; CODE2P_1_1[76] = 15'd21509; CODE2P_1_1[77] = 15'd344; CODE2P_1_1[78] = 15'd1272; CODE2P_1_1[79] = 15'd2280; CODE2P_1_1[80] = 15'd3072; CODE2P_1_1[81] = 15'd9232; CODE2P_1_1[82] = 15'd4264; CODE2P_1_1[83] = 15'd6368; CODE2P_1_1[84] = 15'd14472; CODE2P_1_1[85] = 15'd12344; CODE2P_1_1[86] = 15'd18432; CODE2P_1_1[87] = 15'd19457;
          
    CODE2P_1_2[0] = 15'd386; CODE2P_1_2[1] = 15'd1194; CODE2P_1_2[2] = 15'd2426; CODE2P_1_2[3] = 15'd3146; CODE2P_1_2[4] = 15'd4482; CODE2P_1_2[5] = 15'd5402; CODE2P_1_2[6] = 15'd6554; CODE2P_1_2[7] = 15'd8498; CODE2P_1_2[8] = 15'd10466; CODE2P_1_2[9] = 15'd12562; CODE2P_1_2[10] = 15'd14738; CODE2P_1_2[11] = 15'd16786; CODE2P_1_2[12] = 15'd19458; CODE2P_1_2[13] = 15'd20483; CODE2P_1_2[14] = 15'd104; CODE2P_1_2[15] = 15'd1080; CODE2P_1_2[16] = 15'd2168; CODE2P_1_2[17] = 15'd3448; CODE2P_1_2[18] = 15'd4280; CODE2P_1_2[19] = 15'd5248; CODE2P_1_2[20] = 15'd6520; CODE2P_1_2[21] = 15'd8536; CODE2P_1_2[22] = 15'd10472; CODE2P_1_2[23] = 15'd12704; CODE2P_1_2[24] = 15'd14352; CODE2P_1_2[25] = 15'd16808; CODE2P_1_2[26] = 15'd18442; CODE2P_1_2[27] = 15'd23559; CODE2P_1_2[28] = 15'd312; CODE2P_1_2[29] = 15'd1344; CODE2P_1_2[30] = 15'd2456; CODE2P_1_2[31] = 15'd3400; CODE2P_1_2[32] = 15'd4120; CODE2P_1_2[33] = 15'd5352; CODE2P_1_2[34] = 15'd6208; CODE2P_1_2[35] = 15'd7458; CODE2P_1_2[36] = 15'd9330; CODE2P_1_2[37] = 15'd11314; CODE2P_1_2[38] = 15'd13578; CODE2P_1_2[39] = 15'd15450; CODE2P_1_2[40] = 15'd18440; CODE2P_1_2[41] = 15'd17442; CODE2P_1_2[42] = 15'd19461; CODE2P_1_2[43] = 15'd232; CODE2P_1_2[44] = 15'd1024; CODE2P_1_2[45] = 15'd2056; CODE2P_1_2[46] = 15'd3416; CODE2P_1_2[47] = 15'd4384; CODE2P_1_2[48] = 15'd5360; CODE2P_1_2[49] = 15'd6520; CODE2P_1_2[50] = 15'd21506; CODE2P_1_2[51] = 15'd8588; CODE2P_1_2[52] = 15'd10620; CODE2P_1_2[53] = 15'd12316; CODE2P_1_2[54] = 15'd14620; CODE2P_1_2[55] = 15'd18436; CODE2P_1_2[56] = 15'd16660; CODE2P_1_2[57] = 15'd22535; CODE2P_1_2[58] = 15'd244; CODE2P_1_2[59] = 15'd1340; CODE2P_1_2[60] = 15'd2276; CODE2P_1_2[61] = 15'd3412; CODE2P_1_2[62] = 15'd4500; CODE2P_1_2[63] = 15'd5436; CODE2P_1_2[64] = 15'd6188; CODE2P_1_2[65] = 15'd21508; CODE2P_1_2[66] = 15'd7308; CODE2P_1_2[67] = 15'd9268; CODE2P_1_2[68] = 15'd11412; CODE2P_1_2[69] = 15'd13476; CODE2P_1_2[70] = 15'd15484; CODE2P_1_2[71] = 15'd17732; CODE2P_1_2[72] = 15'd20485; CODE2P_1_2[73] = 15'd8; CODE2P_1_2[74] = 15'd1280; CODE2P_1_2[75] = 15'd2136; CODE2P_1_2[76] = 15'd3256; CODE2P_1_2[77] = 15'd4176; CODE2P_1_2[78] = 15'd5472; CODE2P_1_2[79] = 15'd6240; CODE2P_1_2[80] = 15'd22528; CODE2P_1_2[81] = 15'd7224; CODE2P_1_2[82] = 15'd9600; CODE2P_1_2[83] = 15'd11296; CODE2P_1_2[84] = 15'd13384; CODE2P_1_2[85] = 15'd15496; CODE2P_1_2[86] = 15'd17536; CODE2P_1_2[87] = 15'd23553;
          
    CODE2P_1_3[0] = 15'd138; CODE2P_1_3[1] = 15'd1058; CODE2P_1_3[2] = 15'd2290; CODE2P_1_3[3] = 15'd3130; CODE2P_1_3[4] = 15'd4442; CODE2P_1_3[5] = 15'd5210; CODE2P_1_3[6] = 15'd6338; CODE2P_1_3[7] = 15'd7218; CODE2P_1_3[8] = 15'd8306; CODE2P_1_3[9] = 15'd9386; CODE2P_1_3[10] = 15'd10290; CODE2P_1_3[11] = 15'd11578; CODE2P_1_3[12] = 15'd12426; CODE2P_1_3[13] = 15'd13634; CODE2P_1_3[14] = 15'd14714; CODE2P_1_3[15] = 15'd15418; CODE2P_1_3[16] = 15'd18586; CODE2P_1_3[17] = 15'd22530; CODE2P_1_3[18] = 15'd21506; CODE2P_1_3[19] = 15'd16506; CODE2P_1_3[20] = 15'd17739; CODE2P_1_3[21] = 15'd56; CODE2P_1_3[22] = 15'd1040; CODE2P_1_3[23] = 15'd2456; CODE2P_1_3[24] = 15'd3320; CODE2P_1_3[25] = 15'd4464; CODE2P_1_3[26] = 15'd5304; CODE2P_1_3[27] = 15'd6272; CODE2P_1_3[28] = 15'd7256; CODE2P_1_3[29] = 15'd8616; CODE2P_1_3[30] = 15'd9536; CODE2P_1_3[31] = 15'd10320; CODE2P_1_3[32] = 15'd11320; CODE2P_1_3[33] = 15'd12656; CODE2P_1_3[34] = 15'd13736; CODE2P_1_3[35] = 15'd14600; CODE2P_1_3[36] = 15'd15640; CODE2P_1_3[37] = 15'd18712; CODE2P_1_3[38] = 15'd19762; CODE2P_1_3[39] = 15'd20482; CODE2P_1_3[40] = 15'd22532; CODE2P_1_3[41] = 15'd17612; CODE2P_1_3[42] = 15'd23559; CODE2P_1_3[43] = 15'd388; CODE2P_1_3[44] = 15'd1260; CODE2P_1_3[45] = 15'd2348; CODE2P_1_3[46] = 15'd3492; CODE2P_1_3[47] = 15'd4116; CODE2P_1_3[48] = 15'd5252; CODE2P_1_3[49] = 15'd6196; CODE2P_1_3[50] = 15'd7284; CODE2P_1_3[51] = 15'd8620; CODE2P_1_3[52] = 15'd9468; CODE2P_1_3[53] = 15'd10516; CODE2P_1_3[54] = 15'd11308; CODE2P_1_3[55] = 15'd12436; CODE2P_1_3[56] = 15'd13652; CODE2P_1_3[57] = 15'd14764; CODE2P_1_3[58] = 15'd15612; CODE2P_1_3[59] = 15'd16748; CODE2P_1_3[60] = 15'd19876; CODE2P_1_3[61] = 15'd18804; CODE2P_1_3[62] = 15'd21508; CODE2P_1_3[63] = 15'd20493; CODE2P_1_3[64] = 15'd152; CODE2P_1_3[65] = 15'd1408; CODE2P_1_3[66] = 15'd2376; CODE2P_1_3[67] = 15'd3080; CODE2P_1_3[68] = 15'd4176; CODE2P_1_3[69] = 15'd5176; CODE2P_1_3[70] = 15'd6432; CODE2P_1_3[71] = 15'd7544; CODE2P_1_3[72] = 15'd8232; CODE2P_1_3[73] = 15'd9448; CODE2P_1_3[74] = 15'd10656; CODE2P_1_3[75] = 15'd11680; CODE2P_1_3[76] = 15'd12536; CODE2P_1_3[77] = 15'd13392; CODE2P_1_3[78] = 15'd14544; CODE2P_1_3[79] = 15'd15408; CODE2P_1_3[80] = 15'd16408; CODE2P_1_3[81] = 15'd17424; CODE2P_1_3[82] = 15'd23552; CODE2P_1_3[83] = 15'd19864; CODE2P_1_3[84] = 15'd20489;
          
    CODE2P_2_0[0] = 15'd322; CODE2P_2_0[1] = 15'd4626; CODE2P_2_0[2] = 15'd8418; CODE2P_2_0[3] = 15'd3234; CODE2P_2_0[4] = 15'd7346; CODE2P_2_0[5] = 15'd16386; CODE2P_2_0[6] = 15'd17411; CODE2P_2_0[7] = 15'd456; CODE2P_2_0[8] = 15'd4496; CODE2P_2_0[9] = 15'd8592; CODE2P_2_0[10] = 15'd6234; CODE2P_2_0[11] = 15'd10874; CODE2P_2_0[12] = 15'd12298; CODE2P_2_0[13] = 15'd13319; CODE2P_2_0[14] = 15'd496; CODE2P_2_0[15] = 15'd4520; CODE2P_2_0[16] = 15'd8472; CODE2P_2_0[17] = 15'd1450; CODE2P_2_0[18] = 15'd7192; CODE2P_2_0[19] = 15'd15362; CODE2P_2_0[20] = 15'd16389; CODE2P_2_0[21] = 15'd3632; CODE2P_2_0[22] = 15'd4096; CODE2P_2_0[23] = 15'd8808; CODE2P_2_0[24] = 15'd1384; CODE2P_2_0[25] = 15'd9290; CODE2P_2_0[26] = 15'd21506; CODE2P_2_0[27] = 15'd22531; CODE2P_2_0[28] = 15'd552; CODE2P_2_0[29] = 15'd2682; CODE2P_2_0[30] = 15'd8608; CODE2P_2_0[31] = 15'd1656; CODE2P_2_0[32] = 15'd12288; CODE2P_2_0[33] = 15'd6592; CODE2P_2_0[34] = 15'd18434; CODE2P_2_0[35] = 15'd19459; CODE2P_2_0[36] = 15'd192; CODE2P_2_0[37] = 15'd4576; CODE2P_2_0[38] = 15'd8600; CODE2P_2_0[39] = 15'd2540; CODE2P_2_0[40] = 15'd12300; CODE2P_2_0[41] = 15'd7388; CODE2P_2_0[42] = 15'd11394; CODE2P_2_0[43] = 15'd23555; CODE2P_2_0[44] = 15'd240; CODE2P_2_0[45] = 15'd4288; CODE2P_2_0[46] = 15'd8640; CODE2P_2_0[47] = 15'd5418; CODE2P_2_0[48] = 15'd9332; CODE2P_2_0[49] = 15'd14342; CODE2P_2_0[50] = 15'd15365; CODE2P_2_0[51] = 15'd520; CODE2P_2_0[52] = 15'd4400; CODE2P_2_0[53] = 15'd8768; CODE2P_2_0[54] = 15'd5576; CODE2P_2_0[55] = 15'd20482; CODE2P_2_0[56] = 15'd10456; CODE2P_2_0[57] = 15'd19461; CODE2P_2_0[58] = 15'd512; CODE2P_2_0[59] = 15'd4208; CODE2P_2_0[60] = 15'd8432; CODE2P_2_0[61] = 15'd5540; CODE2P_2_0[62] = 15'd20484; CODE2P_2_0[63] = 15'd11520; CODE2P_2_0[64] = 15'd21509; CODE2P_2_0[65] = 15'd16; CODE2P_2_0[66] = 15'd4376; CODE2P_2_0[67] = 15'd1476; CODE2P_2_0[68] = 15'd3532; CODE2P_2_0[69] = 15'd10340; CODE2P_2_0[70] = 15'd22532; CODE2P_2_0[71] = 15'd23557; CODE2P_2_0[72] = 15'd4; CODE2P_2_0[73] = 15'd4164; CODE2P_2_0[74] = 15'd8596; CODE2P_2_0[75] = 15'd6484; CODE2P_2_0[76] = 15'd11332; CODE2P_2_0[77] = 15'd17412; CODE2P_2_0[78] = 15'd18437; CODE2P_2_0[79] = 15'd24; CODE2P_2_0[80] = 15'd4096; CODE2P_2_0[81] = 15'd8632; CODE2P_2_0[82] = 15'd2272; CODE2P_2_0[83] = 15'd9272; CODE2P_2_0[84] = 15'd13312; CODE2P_2_0[85] = 15'd14337;
          
    CODE2P_2_1[0] = 15'd322; CODE2P_2_1[1] = 15'd1042; CODE2P_2_1[2] = 15'd2474; CODE2P_2_1[3] = 15'd3274; CODE2P_2_1[4] = 15'd8354; CODE2P_2_1[5] = 15'd5538; CODE2P_2_1[6] = 15'd6642; CODE2P_2_1[7] = 15'd20482; CODE2P_2_1[8] = 15'd21506; CODE2P_2_1[9] = 15'd11618; CODE2P_2_1[10] = 15'd16387; CODE2P_2_1[11] = 15'd464; CODE2P_2_1[12] = 15'd1088; CODE2P_2_1[13] = 15'd2320; CODE2P_2_1[14] = 15'd3584; CODE2P_2_1[15] = 15'd4722; CODE2P_2_1[16] = 15'd7258; CODE2P_2_1[17] = 15'd8816; CODE2P_2_1[18] = 15'd9410; CODE2P_2_1[19] = 15'd15826; CODE2P_2_1[20] = 15'd23554; CODE2P_2_1[21] = 15'd16397; CODE2P_2_1[22] = 15'd552; CODE2P_2_1[23] = 15'd1208; CODE2P_2_1[24] = 15'd2560; CODE2P_2_1[25] = 15'd3152; CODE2P_2_1[26] = 15'd4272; CODE2P_2_1[27] = 15'd6312; CODE2P_2_1[28] = 15'd14570; CODE2P_2_1[29] = 15'd12834; CODE2P_2_1[30] = 15'd13498; CODE2P_2_1[31] = 15'd21508; CODE2P_2_1[32] = 15'd22531; CODE2P_2_1[33] = 15'd224; CODE2P_2_1[34] = 15'd1192; CODE2P_2_1[35] = 15'd2592; CODE2P_2_1[36] = 15'd3152; CODE2P_2_1[37] = 15'd4152; CODE2P_2_1[38] = 15'd6668; CODE2P_2_1[39] = 15'd14940; CODE2P_2_1[40] = 15'd10426; CODE2P_2_1[41] = 15'd18434; CODE2P_2_1[42] = 15'd5232; CODE2P_2_1[43] = 15'd19459; CODE2P_2_1[44] = 15'd448; CODE2P_2_1[45] = 15'd1616; CODE2P_2_1[46] = 15'd2664; CODE2P_2_1[47] = 15'd3232; CODE2P_2_1[48] = 15'd9248; CODE2P_2_1[49] = 15'd12344; CODE2P_2_1[50] = 15'd7680; CODE2P_2_1[51] = 15'd10776; CODE2P_2_1[52] = 15'd18436; CODE2P_2_1[53] = 15'd8388; CODE2P_2_1[54] = 15'd17415; CODE2P_2_1[55] = 15'd384; CODE2P_2_1[56] = 15'd1328; CODE2P_2_1[57] = 15'd2392; CODE2P_2_1[58] = 15'd3696; CODE2P_2_1[59] = 15'd4704; CODE2P_2_1[60] = 15'd12412; CODE2P_2_1[61] = 15'd9260; CODE2P_2_1[62] = 15'd10532; CODE2P_2_1[63] = 15'd13892; CODE2P_2_1[64] = 15'd19460; CODE2P_2_1[65] = 15'd20485; CODE2P_2_1[66] = 15'd100; CODE2P_2_1[67] = 15'd1028; CODE2P_2_1[68] = 15'd2596; CODE2P_2_1[69] = 15'd3236; CODE2P_2_1[70] = 15'd4540; CODE2P_2_1[71] = 15'd11684; CODE2P_2_1[72] = 15'd15716; CODE2P_2_1[73] = 15'd5612; CODE2P_2_1[74] = 15'd7492; CODE2P_2_1[75] = 15'd22532; CODE2P_2_1[76] = 15'd23557; CODE2P_2_1[77] = 15'd488; CODE2P_2_1[78] = 15'd1624; CODE2P_2_1[79] = 15'd2080; CODE2P_2_1[80] = 15'd3576; CODE2P_2_1[81] = 15'd4544; CODE2P_2_1[82] = 15'd11328; CODE2P_2_1[83] = 15'd16392; CODE2P_2_1[84] = 15'd13328; CODE2P_2_1[85] = 15'd15560; CODE2P_2_1[86] = 15'd14472; CODE2P_2_1[87] = 15'd17409;
          
    CODE2P_2_2[0] = 15'd34; CODE2P_2_2[1] = 15'd1418; CODE2P_2_2[2] = 15'd2386; CODE2P_2_2[3] = 15'd3458; CODE2P_2_2[4] = 15'd4186; CODE2P_2_2[5] = 15'd5362; CODE2P_2_2[6] = 15'd10378; CODE2P_2_2[7] = 15'd11594; CODE2P_2_2[8] = 15'd15794; CODE2P_2_2[9] = 15'd19458; CODE2P_2_2[10] = 15'd12586; CODE2P_2_2[11] = 15'd9610; CODE2P_2_2[12] = 15'd13434; CODE2P_2_2[13] = 15'd20487; CODE2P_2_2[14] = 15'd384; CODE2P_2_2[15] = 15'd1256; CODE2P_2_2[16] = 15'd2272; CODE2P_2_2[17] = 15'd3384; CODE2P_2_2[18] = 15'd4168; CODE2P_2_2[19] = 15'd5608; CODE2P_2_2[20] = 15'd10600; CODE2P_2_2[21] = 15'd11904; CODE2P_2_2[22] = 15'd15656; CODE2P_2_2[23] = 15'd19460; CODE2P_2_2[24] = 15'd18442; CODE2P_2_2[25] = 15'd9724; CODE2P_2_2[26] = 15'd16642; CODE2P_2_2[27] = 15'd17587; CODE2P_2_2[28] = 15'd208; CODE2P_2_2[29] = 15'd1624; CODE2P_2_2[30] = 15'd2312; CODE2P_2_2[31] = 15'd3240; CODE2P_2_2[32] = 15'd4648; CODE2P_2_2[33] = 15'd5592; CODE2P_2_2[34] = 15'd13812; CODE2P_2_2[35] = 15'd11548; CODE2P_2_2[36] = 15'd15572; CODE2P_2_2[37] = 15'd6170; CODE2P_2_2[38] = 15'd18440; CODE2P_2_2[39] = 15'd7474; CODE2P_2_2[40] = 15'd14626; CODE2P_2_2[41] = 15'd23555; CODE2P_2_2[42] = 15'd72; CODE2P_2_2[43] = 15'd1544; CODE2P_2_2[44] = 15'd2400; CODE2P_2_2[45] = 15'd3144; CODE2P_2_2[46] = 15'd4528; CODE2P_2_2[47] = 15'd5568; CODE2P_2_2[48] = 15'd8530; CODE2P_2_2[49] = 15'd12568; CODE2P_2_2[50] = 15'd16752; CODE2P_2_2[51] = 15'd6732; CODE2P_2_2[52] = 15'd18436; CODE2P_2_2[53] = 15'd7440; CODE2P_2_2[54] = 15'd22530; CODE2P_2_2[55] = 15'd17724; CODE2P_2_2[56] = 15'd21511; CODE2P_2_2[57] = 15'd28; CODE2P_2_2[58] = 15'd1524; CODE2P_2_2[59] = 15'd2108; CODE2P_2_2[60] = 15'd3716; CODE2P_2_2[61] = 15'd4644; CODE2P_2_2[62] = 15'd5332; CODE2P_2_2[63] = 15'd8636; CODE2P_2_2[64] = 15'd12500; CODE2P_2_2[65] = 15'd16964; CODE2P_2_2[66] = 15'd14412; CODE2P_2_2[67] = 15'd10532; CODE2P_2_2[68] = 15'd7812; CODE2P_2_2[69] = 15'd22532; CODE2P_2_2[70] = 15'd23557; CODE2P_2_2[71] = 15'd280; CODE2P_2_2[72] = 15'd1632; CODE2P_2_2[73] = 15'd2672; CODE2P_2_2[74] = 15'd3480; CODE2P_2_2[75] = 15'd4392; CODE2P_2_2[76] = 15'd5400; CODE2P_2_2[77] = 15'd9728; CODE2P_2_2[78] = 15'd13784; CODE2P_2_2[79] = 15'd20480; CODE2P_2_2[80] = 15'd8328; CODE2P_2_2[81] = 15'd6312; CODE2P_2_2[82] = 15'd14392; CODE2P_2_2[83] = 15'd17664; CODE2P_2_2[84] = 15'd21505;
          
    CODE2P_2_3 [0] = 15'd106; CODE2P_2_3[1] = 15'd1410; CODE2P_2_3[2] = 15'd2690; CODE2P_2_3[3] = 15'd3602; CODE2P_2_3[4] = 15'd4130; CODE2P_2_3[5] = 15'd5714; CODE2P_2_3[6] = 15'd6202; CODE2P_2_3[7] = 15'd7410; CODE2P_2_3[8] = 15'd8802; CODE2P_2_3[9] = 15'd9634; CODE2P_2_3[10] = 15'd10538; CODE2P_2_3[11] = 15'd15610; CODE2P_2_3[12] = 15'd17994; CODE2P_2_3[13] = 15'd21506; CODE2P_2_3[14] = 15'd11746; CODE2P_2_3[15] = 15'd13706; CODE2P_2_3[16] = 15'd14922; CODE2P_2_3[17] = 15'd16978; CODE2P_2_3[18] = 15'd18618; CODE2P_2_3[19] = 15'd20491; CODE2P_2_3[20] = 15'd552; CODE2P_2_3[21] = 15'd1528; CODE2P_2_3[22] = 15'd2640; CODE2P_2_3[23] = 15'd3520; CODE2P_2_3[24] = 15'd4608; CODE2P_2_3[25] = 15'd5736; CODE2P_2_3[26] = 15'd6600; CODE2P_2_3[27] = 15'd7688; CODE2P_2_3[28] = 15'd8240; CODE2P_2_3[29] = 15'd9344; CODE2P_2_3[30] = 15'd10648; CODE2P_2_3[31] = 15'd12802; CODE2P_2_3[32] = 15'd17904; CODE2P_2_3[33] = 15'd15432; CODE2P_2_3[34] = 15'd19674; CODE2P_2_3[35] = 15'd21508; CODE2P_2_3[36] = 15'd14884; CODE2P_2_3[37] = 15'd16772; CODE2P_2_3[38] = 15'd18868; CODE2P_2_3[39] = 15'd22531; CODE2P_2_3[40] = 15'd412; CODE2P_2_3[41] = 15'd1148; CODE2P_2_3[42] = 15'd2052; CODE2P_2_3[43] = 15'd3716; CODE2P_2_3[44] = 15'd4292; CODE2P_2_3[45] = 15'd5324; CODE2P_2_3[46] = 15'd6484; CODE2P_2_3[47] = 15'd7604; CODE2P_2_3[48] = 15'd8548; CODE2P_2_3[49] = 15'd9788; CODE2P_2_3[50] = 15'd10812; CODE2P_2_3[51] = 15'd11340; CODE2P_2_3[52] = 15'd13596; CODE2P_2_3[53] = 15'd12828; CODE2P_2_3[54] = 15'd17644; CODE2P_2_3[55] = 15'd15828; CODE2P_2_3[56] = 15'd19884; CODE2P_2_3[57] = 15'd20484; CODE2P_2_3[58] = 15'd23558; CODE2P_2_3[59] = 15'd22533; CODE2P_2_3[60] = 15'd128; CODE2P_2_3[61] = 15'd1256; CODE2P_2_3[62] = 15'd2336; CODE2P_2_3[63] = 15'd3400; CODE2P_2_3[64] = 15'd4448; CODE2P_2_3[65] = 15'd5568; CODE2P_2_3[66] = 15'd6616; CODE2P_2_3[67] = 15'd7464; CODE2P_2_3[68] = 15'd8592; CODE2P_2_3[69] = 15'd9408; CODE2P_2_3[70] = 15'd14752; CODE2P_2_3[71] = 15'd11784; CODE2P_2_3[72] = 15'd13832; CODE2P_2_3[73] = 15'd12320; CODE2P_2_3[74] = 15'd16416; CODE2P_2_3[75] = 15'd19016; CODE2P_2_3[76] = 15'd19872; CODE2P_2_3[77] = 15'd20488; CODE2P_2_3[78] = 15'd23553;
    
//  parameter bit [numBits(`LDEC_NCELLS)-1:0] NUM_MACRO_CELLS2P [0:2][0:3] = '{'{88, 88, 88, 88}, '{86, 88, 88, 85}, '{86, 88, 85, 79}};
NUM_MACRO_CELLS2P[0][0] = 7'd88;
NUM_MACRO_CELLS2P[0][1] = 7'd88;
NUM_MACRO_CELLS2P[0][2] = 7'd88;
NUM_MACRO_CELLS2P[0][3] = 7'd88;
NUM_MACRO_CELLS2P[1][0] = 7'd86;
NUM_MACRO_CELLS2P[1][1] = 7'd88;
NUM_MACRO_CELLS2P[1][2] = 7'd88;
NUM_MACRO_CELLS2P[1][3] = 7'd85;
NUM_MACRO_CELLS2P[2][0] = 7'd86;
NUM_MACRO_CELLS2P[2][1] = 7'd88;
NUM_MACRO_CELLS2P[2][2] = 7'd85;
NUM_MACRO_CELLS2P[2][3] = 7'd79;
          
          if (selA == 1'b1 && enable == 1'b1) begin
            numMacroCells <= NUM_MACRO_CELLS2P[zEnum][rEnum];
            case (zEnum)
              2'd0 :
                case (rEnum)
                  2'd0 : dOutA <= CODE2P_0_0[addrA];
                  2'd1 : dOutA <= CODE2P_0_1[addrA];
                  2'd2 : dOutA <= CODE2P_0_2[addrA];
                  default : dOutA <= CODE2P_0_3[addrA];
                endcase
              2'd1 :
                case (rEnum)
                  2'd0 : dOutA <= CODE2P_1_0[addrA];
                  2'd1 : dOutA <= CODE2P_1_1[addrA];
                  2'd2 : dOutA <= CODE2P_1_2[addrA];
                  default : dOutA <= CODE2P_1_3[addrA];
                endcase
              default :
                case (rEnum)
                  2'd0 : dOutA <= CODE2P_2_0[addrA];
                  2'd1 : dOutA <= CODE2P_2_1[addrA];
                  2'd2 : dOutA <= CODE2P_2_2[addrA];
                  default : dOutA <= CODE2P_2_3[addrA];
                endcase
            endcase
          end
        end
      end //pSelA

      always @(posedge(ckB) `LDEC_RESET_STR)
      begin : pSelB
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_0_0 [0:87];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_0_1 [0:87];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_0_2 [0:87];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_0_3 [0:87];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_1_0 [0:85];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_1_1 [0:87];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_1_2 [0:87];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_1_3 [0:84];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_2_0 [0:85];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_2_1 [0:87];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_2_2 [0:84];
        reg [`LDEC_CELL_RAM_W-1:0] CODE2P_2_3 [0:78];

        if (nReset == 1'b0) begin
          dOutB <= `LDEC_PAD(1'b0, `LDEC_CELL_RAM_W-1);
        end else begin
          // The following table is in-line as we don't trust 'initial' blocks to work in synthesis.
          // A System Verilog form is available but Cadence HAL doesn't understand it.

    CODE2P_0_0[0] = 15'd50; CODE2P_0_0[1] = 15'd4178; CODE2P_0_0[2] = 15'd8386; CODE2P_0_0[3] = 15'd2050; CODE2P_0_0[4] = 15'd10242; CODE2P_0_0[5] = 15'd14338; CODE2P_0_0[6] = 15'd15363; CODE2P_0_0[7] = 15'd0; CODE2P_0_0[8] = 15'd4096; CODE2P_0_0[9] = 15'd8192; CODE2P_0_0[10] = 15'd12298; CODE2P_0_0[11] = 15'd5122; CODE2P_0_0[12] = 15'd11266; CODE2P_0_0[13] = 15'd13315; CODE2P_0_0[14] = 15'd200; CODE2P_0_0[15] = 15'd4160; CODE2P_0_0[16] = 15'd8248; CODE2P_0_0[17] = 15'd12288; CODE2P_0_0[18] = 15'd9362; CODE2P_0_0[19] = 15'd18434; CODE2P_0_0[20] = 15'd19463; CODE2P_0_0[21] = 15'd16; CODE2P_0_0[22] = 15'd4256; CODE2P_0_0[23] = 15'd8392; CODE2P_0_0[24] = 15'd3074; CODE2P_0_0[25] = 15'd9216; CODE2P_0_0[26] = 15'd15364; CODE2P_0_0[27] = 15'd16387; CODE2P_0_0[28] = 15'd24; CODE2P_0_0[29] = 15'd4224; CODE2P_0_0[30] = 15'd8392; CODE2P_0_0[31] = 15'd7186; CODE2P_0_0[32] = 15'd9260; CODE2P_0_0[33] = 15'd12300; CODE2P_0_0[34] = 15'd23555; CODE2P_0_0[35] = 15'd88; CODE2P_0_0[36] = 15'd4248; CODE2P_0_0[37] = 15'd8296; CODE2P_0_0[38] = 15'd10264; CODE2P_0_0[39] = 15'd11400; CODE2P_0_0[40] = 15'd21506; CODE2P_0_0[41] = 15'd22531; CODE2P_0_0[42] = 15'd176; CODE2P_0_0[43] = 15'd4232; CODE2P_0_0[44] = 15'd8288; CODE2P_0_0[45] = 15'd1026; CODE2P_0_0[46] = 15'd6146; CODE2P_0_0[47] = 15'd7168; CODE2P_0_0[48] = 15'd13316; CODE2P_0_0[49] = 15'd14341; CODE2P_0_0[50] = 15'd56; CODE2P_0_0[51] = 15'd4272; CODE2P_0_0[52] = 15'd8376; CODE2P_0_0[53] = 15'd1188; CODE2P_0_0[54] = 15'd5200; CODE2P_0_0[55] = 15'd3200; CODE2P_0_0[56] = 15'd20486; CODE2P_0_0[57] = 15'd21509; CODE2P_0_0[58] = 15'd200; CODE2P_0_0[59] = 15'd4280; CODE2P_0_0[60] = 15'd8264; CODE2P_0_0[61] = 15'd2112; CODE2P_0_0[62] = 15'd5268; CODE2P_0_0[63] = 15'd7284; CODE2P_0_0[64] = 15'd22532; CODE2P_0_0[65] = 15'd23557; CODE2P_0_0[66] = 15'd192; CODE2P_0_0[67] = 15'd4232; CODE2P_0_0[68] = 15'd8272; CODE2P_0_0[69] = 15'd2236; CODE2P_0_0[70] = 15'd17410; CODE2P_0_0[71] = 15'd3084; CODE2P_0_0[72] = 15'd6172; CODE2P_0_0[73] = 15'd18437; CODE2P_0_0[74] = 15'd188; CODE2P_0_0[75] = 15'd4124; CODE2P_0_0[76] = 15'd8196; CODE2P_0_0[77] = 15'd10316; CODE2P_0_0[78] = 15'd17412; CODE2P_0_0[79] = 15'd11356; CODE2P_0_0[80] = 15'd16389; CODE2P_0_0[81] = 15'd104; CODE2P_0_0[82] = 15'd4096; CODE2P_0_0[83] = 15'd8240; CODE2P_0_0[84] = 15'd1216; CODE2P_0_0[85] = 15'd6208; CODE2P_0_0[86] = 15'd19456; CODE2P_0_0[87] = 15'd20481;
    
    CODE2P_0_1[0] = 15'd186; CODE2P_0_1[1] = 15'd1138; CODE2P_0_1[2] = 15'd2242; CODE2P_0_1[3] = 15'd4194; CODE2P_0_1[4] = 15'd6298; CODE2P_0_1[5] = 15'd8330; CODE2P_0_1[6] = 15'd20482; CODE2P_0_1[7] = 15'd21506; CODE2P_0_1[8] = 15'd12450; CODE2P_0_1[9] = 15'd14506; CODE2P_0_1[10] = 15'd16387; CODE2P_0_1[11] = 15'd80; CODE2P_0_1[12] = 15'd1096; CODE2P_0_1[13] = 15'd2168; CODE2P_0_1[14] = 15'd3162; CODE2P_0_1[15] = 15'd17410; CODE2P_0_1[16] = 15'd5122; CODE2P_0_1[17] = 15'd7178; CODE2P_0_1[18] = 15'd10386; CODE2P_0_1[19] = 15'd12356; CODE2P_0_1[20] = 15'd14420; CODE2P_0_1[21] = 15'd18435; CODE2P_0_1[22] = 15'd200; CODE2P_0_1[23] = 15'd1232; CODE2P_0_1[24] = 15'd2160; CODE2P_0_1[25] = 15'd16396; CODE2P_0_1[26] = 15'd17412; CODE2P_0_1[27] = 15'd13442; CODE2P_0_1[28] = 15'd15506; CODE2P_0_1[29] = 15'd4256; CODE2P_0_1[30] = 15'd6160; CODE2P_0_1[31] = 15'd8224; CODE2P_0_1[32] = 15'd11331; CODE2P_0_1[33] = 15'd80; CODE2P_0_1[34] = 15'd1128; CODE2P_0_1[35] = 15'd2088; CODE2P_0_1[36] = 15'd3072; CODE2P_0_1[37] = 15'd19458; CODE2P_0_1[38] = 15'd13416; CODE2P_0_1[39] = 15'd15488; CODE2P_0_1[40] = 15'd5144; CODE2P_0_1[41] = 15'd7224; CODE2P_0_1[42] = 15'd10448; CODE2P_0_1[43] = 15'd20485; CODE2P_0_1[44] = 15'd128; CODE2P_0_1[45] = 15'd1040; CODE2P_0_1[46] = 15'd2208; CODE2P_0_1[47] = 15'd3280; CODE2P_0_1[48] = 15'd19460; CODE2P_0_1[49] = 15'd4264; CODE2P_0_1[50] = 15'd6192; CODE2P_0_1[51] = 15'd8200; CODE2P_0_1[52] = 15'd9426; CODE2P_0_1[53] = 15'd11320; CODE2P_0_1[54] = 15'd18437; CODE2P_0_1[55] = 15'd112; CODE2P_0_1[56] = 15'd1208; CODE2P_0_1[57] = 15'd2216; CODE2P_0_1[58] = 15'd3160; CODE2P_0_1[59] = 15'd22530; CODE2P_0_1[60] = 15'd4260; CODE2P_0_1[61] = 15'd6340; CODE2P_0_1[62] = 15'd8340; CODE2P_0_1[63] = 15'd10396; CODE2P_0_1[64] = 15'd15540; CODE2P_0_1[65] = 15'd23559; CODE2P_0_1[66] = 15'd52; CODE2P_0_1[67] = 15'd1204; CODE2P_0_1[68] = 15'd2124; CODE2P_0_1[69] = 15'd3236; CODE2P_0_1[70] = 15'd22532; CODE2P_0_1[71] = 15'd5324; CODE2P_0_1[72] = 15'd7308; CODE2P_0_1[73] = 15'd9284; CODE2P_0_1[74] = 15'd11380; CODE2P_0_1[75] = 15'd13460; CODE2P_0_1[76] = 15'd21509; CODE2P_0_1[77] = 15'd136; CODE2P_0_1[78] = 15'd1112; CODE2P_0_1[79] = 15'd2136; CODE2P_0_1[80] = 15'd3232; CODE2P_0_1[81] = 15'd12432; CODE2P_0_1[82] = 15'd14544; CODE2P_0_1[83] = 15'd16392; CODE2P_0_1[84] = 15'd5288; CODE2P_0_1[85] = 15'd7376; CODE2P_0_1[86] = 15'd9240; CODE2P_0_1[87] = 15'd23553;
    
    CODE2P_0_2[0] = 15'd202; CODE2P_0_2[1] = 15'd1122; CODE2P_0_2[2] = 15'd2146; CODE2P_0_2[3] = 15'd3098; CODE2P_0_2[4] = 15'd4122; CODE2P_0_2[5] = 15'd7338; CODE2P_0_2[6] = 15'd9338; CODE2P_0_2[7] = 15'd17538; CODE2P_0_2[8] = 15'd19458; CODE2P_0_2[9] = 15'd5330; CODE2P_0_2[10] = 15'd6194; CODE2P_0_2[11] = 15'd10418; CODE2P_0_2[12] = 15'd12410; CODE2P_0_2[13] = 15'd14370; CODE2P_0_2[14] = 15'd20487; CODE2P_0_2[15] = 15'd72; CODE2P_0_2[16] = 15'd1080; CODE2P_0_2[17] = 15'd2048; CODE2P_0_2[18] = 15'd3080; CODE2P_0_2[19] = 15'd4232; CODE2P_0_2[20] = 15'd7224; CODE2P_0_2[21] = 15'd8218; CODE2P_0_2[22] = 15'd11450; CODE2P_0_2[23] = 15'd13442; CODE2P_0_2[24] = 15'd22530; CODE2P_0_2[25] = 15'd16554; CODE2P_0_2[26] = 15'd10264; CODE2P_0_2[27] = 15'd18434; CODE2P_0_2[28] = 15'd21511; CODE2P_0_2[29] = 15'd192; CODE2P_0_2[30] = 15'd1064; CODE2P_0_2[31] = 15'd2256; CODE2P_0_2[32] = 15'd3128; CODE2P_0_2[33] = 15'd4104; CODE2P_0_2[34] = 15'd7288; CODE2P_0_2[35] = 15'd8384; CODE2P_0_2[36] = 15'd11328; CODE2P_0_2[37] = 15'd13416; CODE2P_0_2[38] = 15'd22532; CODE2P_0_2[39] = 15'd9336; CODE2P_0_2[40] = 15'd15466; CODE2P_0_2[41] = 15'd17496; CODE2P_0_2[42] = 15'd23555; CODE2P_0_2[43] = 15'd16; CODE2P_0_2[44] = 15'd1040; CODE2P_0_2[45] = 15'd2200; CODE2P_0_2[46] = 15'd3184; CODE2P_0_2[47] = 15'd4288; CODE2P_0_2[48] = 15'd5128; CODE2P_0_2[49] = 15'd6264; CODE2P_0_2[50] = 15'd7324; CODE2P_0_2[51] = 15'd13508; CODE2P_0_2[52] = 15'd11284; CODE2P_0_2[53] = 15'd9384; CODE2P_0_2[54] = 15'd15388; CODE2P_0_2[55] = 15'd17428; CODE2P_0_2[56] = 15'd23556; CODE2P_0_2[57] = 15'd18441; CODE2P_0_2[58] = 15'd132; CODE2P_0_2[59] = 15'd1164; CODE2P_0_2[60] = 15'd2228; CODE2P_0_2[61] = 15'd3268; CODE2P_0_2[62] = 15'd4172; CODE2P_0_2[63] = 15'd5148; CODE2P_0_2[64] = 15'd6260; CODE2P_0_2[65] = 15'd10300; CODE2P_0_2[66] = 15'd12500; CODE2P_0_2[67] = 15'd14356; CODE2P_0_2[68] = 15'd9236; CODE2P_0_2[69] = 15'd8228; CODE2P_0_2[70] = 15'd16556; CODE2P_0_2[71] = 15'd19460; CODE2P_0_2[72] = 15'd18445; CODE2P_0_2[73] = 15'd200; CODE2P_0_2[74] = 15'd1168; CODE2P_0_2[75] = 15'd2256; CODE2P_0_2[76] = 15'd3200; CODE2P_0_2[77] = 15'd4272; CODE2P_0_2[78] = 15'd5304; CODE2P_0_2[79] = 15'd6216; CODE2P_0_2[80] = 15'd10272; CODE2P_0_2[81] = 15'd12320; CODE2P_0_2[82] = 15'd14400; CODE2P_0_2[83] = 15'd20480; CODE2P_0_2[84] = 15'd8192; CODE2P_0_2[85] = 15'd16472; CODE2P_0_2[86] = 15'd15544; CODE2P_0_2[87] = 15'd21505;
    
    CODE2P_0_3[0] = 15'd58; CODE2P_0_3[1] = 15'd1082; CODE2P_0_3[2] = 15'd2162; CODE2P_0_3[3] = 15'd3186; CODE2P_0_3[4] = 15'd4130; CODE2P_0_3[5] = 15'd5250; CODE2P_0_3[6] = 15'd6274; CODE2P_0_3[7] = 15'd7362; CODE2P_0_3[8] = 15'd8386; CODE2P_0_3[9] = 15'd9298; CODE2P_0_3[10] = 15'd10250; CODE2P_0_3[11] = 15'd11322; CODE2P_0_3[12] = 15'd13362; CODE2P_0_3[13] = 15'd14418; CODE2P_0_3[14] = 15'd15570; CODE2P_0_3[15] = 15'd16450; CODE2P_0_3[16] = 15'd17554; CODE2P_0_3[17] = 15'd18602; CODE2P_0_3[18] = 15'd19570; CODE2P_0_3[19] = 15'd20490; CODE2P_0_3[20] = 15'd23554; CODE2P_0_3[21] = 15'd12411; CODE2P_0_3[22] = 15'd136; CODE2P_0_3[23] = 15'd1128; CODE2P_0_3[24] = 15'd2112; CODE2P_0_3[25] = 15'd3240; CODE2P_0_3[26] = 15'd4168; CODE2P_0_3[27] = 15'd5144; CODE2P_0_3[28] = 15'd6288; CODE2P_0_3[29] = 15'd7264; CODE2P_0_3[30] = 15'd8272; CODE2P_0_3[31] = 15'd9216; CODE2P_0_3[32] = 15'd10272; CODE2P_0_3[33] = 15'd11384; CODE2P_0_3[34] = 15'd13328; CODE2P_0_3[35] = 15'd14376; CODE2P_0_3[36] = 15'd15440; CODE2P_0_3[37] = 15'd16592; CODE2P_0_3[38] = 15'd17560; CODE2P_0_3[39] = 15'd18536; CODE2P_0_3[40] = 15'd19560; CODE2P_0_3[41] = 15'd20488; CODE2P_0_3[42] = 15'd21510; CODE2P_0_3[43] = 15'd12445; CODE2P_0_3[44] = 15'd180; CODE2P_0_3[45] = 15'd1156; CODE2P_0_3[46] = 15'd2084; CODE2P_0_3[47] = 15'd3100; CODE2P_0_3[48] = 15'd4180; CODE2P_0_3[49] = 15'd5292; CODE2P_0_3[50] = 15'd6244; CODE2P_0_3[51] = 15'd7212; CODE2P_0_3[52] = 15'd8364; CODE2P_0_3[53] = 15'd9332; CODE2P_0_3[54] = 15'd10396; CODE2P_0_3[55] = 15'd11308; CODE2P_0_3[56] = 15'd13380; CODE2P_0_3[57] = 15'd14380; CODE2P_0_3[58] = 15'd15508; CODE2P_0_3[59] = 15'd16476; CODE2P_0_3[60] = 15'd17452; CODE2P_0_3[61] = 15'd18476; CODE2P_0_3[62] = 15'd19580; CODE2P_0_3[63] = 15'd20484; CODE2P_0_3[64] = 15'd22534; CODE2P_0_3[65] = 15'd23557; CODE2P_0_3[66] = 15'd24; CODE2P_0_3[67] = 15'd1120; CODE2P_0_3[68] = 15'd2136; CODE2P_0_3[69] = 15'd3184; CODE2P_0_3[70] = 15'd4184; CODE2P_0_3[71] = 15'd5320; CODE2P_0_3[72] = 15'd6184; CODE2P_0_3[73] = 15'd7312; CODE2P_0_3[74] = 15'd8192; CODE2P_0_3[75] = 15'd9288; CODE2P_0_3[76] = 15'd10256; CODE2P_0_3[77] = 15'd11472; CODE2P_0_3[78] = 15'd13392; CODE2P_0_3[79] = 15'd14528; CODE2P_0_3[80] = 15'd15416; CODE2P_0_3[81] = 15'd16496; CODE2P_0_3[82] = 15'd17568; CODE2P_0_3[83] = 15'd18464; CODE2P_0_3[84] = 15'd19472; CODE2P_0_3[85] = 15'd12496; CODE2P_0_3[86] = 15'd22528; CODE2P_0_3[87] = 15'd21505;
    
    CODE2P_1_0[0] = 15'd266; CODE2P_1_0[1] = 15'd4394; CODE2P_1_0[2] = 15'd8202; CODE2P_1_0[3] = 15'd3378; CODE2P_1_0[4] = 15'd7202; CODE2P_1_0[5] = 15'd15362; CODE2P_1_0[6] = 15'd16387; CODE2P_1_0[7] = 15'd376; CODE2P_1_0[8] = 15'd12290; CODE2P_1_0[9] = 15'd8600; CODE2P_1_0[10] = 15'd1114; CODE2P_1_0[11] = 15'd5258; CODE2P_1_0[12] = 15'd18434; CODE2P_1_0[13] = 15'd19463; CODE2P_1_0[14] = 15'd392; CODE2P_1_0[15] = 15'd4336; CODE2P_1_0[16] = 15'd8464; CODE2P_1_0[17] = 15'd12296; CODE2P_1_0[18] = 15'd2186; CODE2P_1_0[19] = 15'd11418; CODE2P_1_0[20] = 15'd23555; CODE2P_1_0[21] = 15'd360; CODE2P_1_0[22] = 15'd4096; CODE2P_1_0[23] = 15'd8352; CODE2P_1_0[24] = 15'd5296; CODE2P_1_0[25] = 15'd9554; CODE2P_1_0[26] = 15'd16388; CODE2P_1_0[27] = 15'd17411; CODE2P_1_0[28] = 15'd8; CODE2P_1_0[29] = 15'd4104; CODE2P_1_0[30] = 15'd8496; CODE2P_1_0[31] = 15'd2268; CODE2P_1_0[32] = 15'd10594; CODE2P_1_0[33] = 15'd21506; CODE2P_1_0[34] = 15'd22531; CODE2P_1_0[35] = 15'd320; CODE2P_1_0[36] = 15'd4272; CODE2P_1_0[37] = 15'd8536; CODE2P_1_0[38] = 15'd7352; CODE2P_1_0[39] = 15'd6538; CODE2P_1_0[40] = 15'd12300; CODE2P_1_0[41] = 15'd13315; CODE2P_1_0[42] = 15'd1168; CODE2P_1_0[43] = 15'd4280; CODE2P_1_0[44] = 15'd8192; CODE2P_1_0[45] = 15'd7236; CODE2P_1_0[46] = 15'd9500; CODE2P_1_0[47] = 15'd22532; CODE2P_1_0[48] = 15'd23557; CODE2P_1_0[49] = 15'd408; CODE2P_1_0[50] = 15'd4376; CODE2P_1_0[51] = 15'd8544; CODE2P_1_0[52] = 15'd3456; CODE2P_1_0[53] = 15'd10384; CODE2P_1_0[54] = 15'd17412; CODE2P_1_0[55] = 15'd18437; CODE2P_1_0[56] = 15'd264; CODE2P_1_0[57] = 15'd4288; CODE2P_1_0[58] = 15'd8376; CODE2P_1_0[59] = 15'd3348; CODE2P_1_0[60] = 15'd11632; CODE2P_1_0[61] = 15'd20486; CODE2P_1_0[62] = 15'd21509;CODE2P_1_0[63] = 15'd312; CODE2P_1_0[64] = 15'd4128; CODE2P_1_0[65] = 15'd1424; CODE2P_1_0[66] = 15'd14338; CODE2P_1_0[67] = 15'd11660; CODE2P_1_0[68] = 15'd6164; CODE2P_1_0[69] = 15'd15365; CODE2P_1_0[70] = 15'd404; CODE2P_1_0[71] = 15'd4484; CODE2P_1_0[72] = 15'd8300; CODE2P_1_0[73] = 15'd14340; CODE2P_1_0[74] = 15'd1036; CODE2P_1_0[75] = 15'd5404; CODE2P_1_0[76] = 15'd10484; CODE2P_1_0[77] = 15'd13317; CODE2P_1_0[78] = 15'd40; CODE2P_1_0[79] = 15'd4144; CODE2P_1_0[80] = 15'd8296; CODE2P_1_0[81] = 15'd2248; CODE2P_1_0[82] = 15'd6504; CODE2P_1_0[83] = 15'd9536; CODE2P_1_0[84] = 15'd19456; CODE2P_1_0[85] = 15'd20481;
          
    CODE2P_1_1[0] = 15'd282; CODE2P_1_1[1] = 15'd1346; CODE2P_1_1[2] = 15'd2306; CODE2P_1_1[3] = 15'd11674; CODE2P_1_1[4] = 15'd7314; CODE2P_1_1[5] = 15'd10586; CODE2P_1_1[6] = 15'd13570; CODE2P_1_1[7] = 15'd21506; CODE2P_1_1[8] = 15'd22530; CODE2P_1_1[9] = 15'd3202; CODE2P_1_1[10] = 15'd4139; CODE2P_1_1[11] = 15'd256; CODE2P_1_1[12] = 15'd1200; CODE2P_1_1[13] = 15'd2080; CODE2P_1_1[14] = 15'd11568; CODE2P_1_1[15] = 15'd8410; CODE2P_1_1[16] = 15'd15426; CODE2P_1_1[17] = 15'd16394; CODE2P_1_1[18] = 15'd9442; CODE2P_1_1[19] = 15'd23554; CODE2P_1_1[20] = 15'd3240; CODE2P_1_1[21] = 15'd4225; CODE2P_1_1[22] = 15'd312; CODE2P_1_1[23] = 15'd1272; CODE2P_1_1[24] = 15'd2224; CODE2P_1_1[25] = 15'd11668; CODE2P_1_1[26] = 15'd8280; CODE2P_1_1[27] = 15'd15408; CODE2P_1_1[28] = 15'd16392; CODE2P_1_1[29] = 15'd5442; CODE2P_1_1[30] = 15'd6178; CODE2P_1_1[31] = 15'd3416; CODE2P_1_1[32] = 15'd17411; CODE2P_1_1[33] = 15'd72; CODE2P_1_1[34] = 15'd1216; CODE2P_1_1[35] = 15'd2152; CODE2P_1_1[36] = 15'd4320; CODE2P_1_1[37] = 15'd7464; CODE2P_1_1[38] = 15'd15468; CODE2P_1_1[39] = 15'd10440; CODE2P_1_1[40] = 15'd13728; CODE2P_1_1[41] = 15'd22532; CODE2P_1_1[42] = 15'd3248; CODE2P_1_1[43] = 15'd23557; CODE2P_1_1[44] = 15'd200; CODE2P_1_1[45] = 15'd1440; CODE2P_1_1[46] = 15'd2376; CODE2P_1_1[47] = 15'd4144; CODE2P_1_1[48] = 15'd14634; CODE2P_1_1[49] = 15'd6260; CODE2P_1_1[50] = 15'd8468; CODE2P_1_1[51] = 15'd12482; CODE2P_1_1[52] = 15'd17412; CODE2P_1_1[53] = 15'd3088; CODE2P_1_1[54] = 15'd18439; CODE2P_1_1[55] = 15'd160; CODE2P_1_1[56] = 15'd1288; CODE2P_1_1[57] = 15'd2432; CODE2P_1_1[58] = 15'd4128; CODE2P_1_1[59] = 15'd14676; CODE2P_1_1[60] = 15'd5224; CODE2P_1_1[61] = 15'd20482; CODE2P_1_1[62] = 15'd7380; CODE2P_1_1[63] = 15'd10420; CODE2P_1_1[64] = 15'd13684; CODE2P_1_1[65] = 15'd19463; CODE2P_1_1[66] = 15'd364; CODE2P_1_1[67] = 15'd1084; CODE2P_1_1[68] = 15'd2196; CODE2P_1_1[69] = 15'd3484; CODE2P_1_1[70] = 15'd9620; CODE2P_1_1[71] = 15'd4196; CODE2P_1_1[72] = 15'd20484; CODE2P_1_1[73] = 15'd5324; CODE2P_1_1[74] = 15'd12332; CODE2P_1_1[75] = 15'd16388; CODE2P_1_1[76] = 15'd21509; CODE2P_1_1[77] = 15'd344; CODE2P_1_1[78] = 15'd1272; CODE2P_1_1[79] = 15'd2280; CODE2P_1_1[80] = 15'd3072; CODE2P_1_1[81] = 15'd9232; CODE2P_1_1[82] = 15'd4264; CODE2P_1_1[83] = 15'd6368; CODE2P_1_1[84] = 15'd14472; CODE2P_1_1[85] = 15'd12344; CODE2P_1_1[86] = 15'd18432; CODE2P_1_1[87] = 15'd19457;
          
    CODE2P_1_2[0] = 15'd386; CODE2P_1_2[1] = 15'd1194; CODE2P_1_2[2] = 15'd2426; CODE2P_1_2[3] = 15'd3146; CODE2P_1_2[4] = 15'd4482; CODE2P_1_2[5] = 15'd5402; CODE2P_1_2[6] = 15'd6554; CODE2P_1_2[7] = 15'd8498; CODE2P_1_2[8] = 15'd10466; CODE2P_1_2[9] = 15'd12562; CODE2P_1_2[10] = 15'd14738; CODE2P_1_2[11] = 15'd16786; CODE2P_1_2[12] = 15'd19458; CODE2P_1_2[13] = 15'd20483; CODE2P_1_2[14] = 15'd104; CODE2P_1_2[15] = 15'd1080; CODE2P_1_2[16] = 15'd2168; CODE2P_1_2[17] = 15'd3448; CODE2P_1_2[18] = 15'd4280; CODE2P_1_2[19] = 15'd5248; CODE2P_1_2[20] = 15'd6520; CODE2P_1_2[21] = 15'd8536; CODE2P_1_2[22] = 15'd10472; CODE2P_1_2[23] = 15'd12704; CODE2P_1_2[24] = 15'd14352; CODE2P_1_2[25] = 15'd16808; CODE2P_1_2[26] = 15'd18442; CODE2P_1_2[27] = 15'd23559; CODE2P_1_2[28] = 15'd312; CODE2P_1_2[29] = 15'd1344; CODE2P_1_2[30] = 15'd2456; CODE2P_1_2[31] = 15'd3400; CODE2P_1_2[32] = 15'd4120; CODE2P_1_2[33] = 15'd5352; CODE2P_1_2[34] = 15'd6208; CODE2P_1_2[35] = 15'd7458; CODE2P_1_2[36] = 15'd9330; CODE2P_1_2[37] = 15'd11314; CODE2P_1_2[38] = 15'd13578; CODE2P_1_2[39] = 15'd15450; CODE2P_1_2[40] = 15'd18440; CODE2P_1_2[41] = 15'd17442; CODE2P_1_2[42] = 15'd19461; CODE2P_1_2[43] = 15'd232; CODE2P_1_2[44] = 15'd1024; CODE2P_1_2[45] = 15'd2056; CODE2P_1_2[46] = 15'd3416; CODE2P_1_2[47] = 15'd4384; CODE2P_1_2[48] = 15'd5360; CODE2P_1_2[49] = 15'd6520; CODE2P_1_2[50] = 15'd21506; CODE2P_1_2[51] = 15'd8588; CODE2P_1_2[52] = 15'd10620; CODE2P_1_2[53] = 15'd12316; CODE2P_1_2[54] = 15'd14620; CODE2P_1_2[55] = 15'd18436; CODE2P_1_2[56] = 15'd16660; CODE2P_1_2[57] = 15'd22535; CODE2P_1_2[58] = 15'd244; CODE2P_1_2[59] = 15'd1340; CODE2P_1_2[60] = 15'd2276; CODE2P_1_2[61] = 15'd3412; CODE2P_1_2[62] = 15'd4500; CODE2P_1_2[63] = 15'd5436; CODE2P_1_2[64] = 15'd6188; CODE2P_1_2[65] = 15'd21508; CODE2P_1_2[66] = 15'd7308; CODE2P_1_2[67] = 15'd9268; CODE2P_1_2[68] = 15'd11412; CODE2P_1_2[69] = 15'd13476; CODE2P_1_2[70] = 15'd15484; CODE2P_1_2[71] = 15'd17732; CODE2P_1_2[72] = 15'd20485; CODE2P_1_2[73] = 15'd8; CODE2P_1_2[74] = 15'd1280; CODE2P_1_2[75] = 15'd2136; CODE2P_1_2[76] = 15'd3256; CODE2P_1_2[77] = 15'd4176; CODE2P_1_2[78] = 15'd5472; CODE2P_1_2[79] = 15'd6240; CODE2P_1_2[80] = 15'd22528; CODE2P_1_2[81] = 15'd7224; CODE2P_1_2[82] = 15'd9600; CODE2P_1_2[83] = 15'd11296; CODE2P_1_2[84] = 15'd13384; CODE2P_1_2[85] = 15'd15496; CODE2P_1_2[86] = 15'd17536; CODE2P_1_2[87] = 15'd23553;
          
    CODE2P_1_3[0] = 15'd138; CODE2P_1_3[1] = 15'd1058; CODE2P_1_3[2] = 15'd2290; CODE2P_1_3[3] = 15'd3130; CODE2P_1_3[4] = 15'd4442; CODE2P_1_3[5] = 15'd5210; CODE2P_1_3[6] = 15'd6338; CODE2P_1_3[7] = 15'd7218; CODE2P_1_3[8] = 15'd8306; CODE2P_1_3[9] = 15'd9386; CODE2P_1_3[10] = 15'd10290; CODE2P_1_3[11] = 15'd11578; CODE2P_1_3[12] = 15'd12426; CODE2P_1_3[13] = 15'd13634; CODE2P_1_3[14] = 15'd14714; CODE2P_1_3[15] = 15'd15418; CODE2P_1_3[16] = 15'd18586; CODE2P_1_3[17] = 15'd22530; CODE2P_1_3[18] = 15'd21506; CODE2P_1_3[19] = 15'd16506; CODE2P_1_3[20] = 15'd17739; CODE2P_1_3[21] = 15'd56; CODE2P_1_3[22] = 15'd1040; CODE2P_1_3[23] = 15'd2456; CODE2P_1_3[24] = 15'd3320; CODE2P_1_3[25] = 15'd4464; CODE2P_1_3[26] = 15'd5304; CODE2P_1_3[27] = 15'd6272; CODE2P_1_3[28] = 15'd7256; CODE2P_1_3[29] = 15'd8616; CODE2P_1_3[30] = 15'd9536; CODE2P_1_3[31] = 15'd10320; CODE2P_1_3[32] = 15'd11320; CODE2P_1_3[33] = 15'd12656; CODE2P_1_3[34] = 15'd13736; CODE2P_1_3[35] = 15'd14600; CODE2P_1_3[36] = 15'd15640; CODE2P_1_3[37] = 15'd18712; CODE2P_1_3[38] = 15'd19762; CODE2P_1_3[39] = 15'd20482; CODE2P_1_3[40] = 15'd22532; CODE2P_1_3[41] = 15'd17612; CODE2P_1_3[42] = 15'd23559; CODE2P_1_3[43] = 15'd388; CODE2P_1_3[44] = 15'd1260; CODE2P_1_3[45] = 15'd2348; CODE2P_1_3[46] = 15'd3492; CODE2P_1_3[47] = 15'd4116; CODE2P_1_3[48] = 15'd5252; CODE2P_1_3[49] = 15'd6196; CODE2P_1_3[50] = 15'd7284; CODE2P_1_3[51] = 15'd8620; CODE2P_1_3[52] = 15'd9468; CODE2P_1_3[53] = 15'd10516; CODE2P_1_3[54] = 15'd11308; CODE2P_1_3[55] = 15'd12436; CODE2P_1_3[56] = 15'd13652; CODE2P_1_3[57] = 15'd14764; CODE2P_1_3[58] = 15'd15612; CODE2P_1_3[59] = 15'd16748; CODE2P_1_3[60] = 15'd19876; CODE2P_1_3[61] = 15'd18804; CODE2P_1_3[62] = 15'd21508; CODE2P_1_3[63] = 15'd20493; CODE2P_1_3[64] = 15'd152; CODE2P_1_3[65] = 15'd1408; CODE2P_1_3[66] = 15'd2376; CODE2P_1_3[67] = 15'd3080; CODE2P_1_3[68] = 15'd4176; CODE2P_1_3[69] = 15'd5176; CODE2P_1_3[70] = 15'd6432; CODE2P_1_3[71] = 15'd7544; CODE2P_1_3[72] = 15'd8232; CODE2P_1_3[73] = 15'd9448; CODE2P_1_3[74] = 15'd10656; CODE2P_1_3[75] = 15'd11680; CODE2P_1_3[76] = 15'd12536; CODE2P_1_3[77] = 15'd13392; CODE2P_1_3[78] = 15'd14544; CODE2P_1_3[79] = 15'd15408; CODE2P_1_3[80] = 15'd16408; CODE2P_1_3[81] = 15'd17424; CODE2P_1_3[82] = 15'd23552; CODE2P_1_3[83] = 15'd19864; CODE2P_1_3[84] = 15'd20489;
          
    CODE2P_2_0[0] = 15'd322; CODE2P_2_0[1] = 15'd4626; CODE2P_2_0[2] = 15'd8418; CODE2P_2_0[3] = 15'd3234; CODE2P_2_0[4] = 15'd7346; CODE2P_2_0[5] = 15'd16386; CODE2P_2_0[6] = 15'd17411; CODE2P_2_0[7] = 15'd456; CODE2P_2_0[8] = 15'd4496; CODE2P_2_0[9] = 15'd8592; CODE2P_2_0[10] = 15'd6234; CODE2P_2_0[11] = 15'd10874; CODE2P_2_0[12] = 15'd12298; CODE2P_2_0[13] = 15'd13319; CODE2P_2_0[14] = 15'd496; CODE2P_2_0[15] = 15'd4520; CODE2P_2_0[16] = 15'd8472; CODE2P_2_0[17] = 15'd1450; CODE2P_2_0[18] = 15'd7192; CODE2P_2_0[19] = 15'd15362; CODE2P_2_0[20] = 15'd16389; CODE2P_2_0[21] = 15'd3632; CODE2P_2_0[22] = 15'd4096; CODE2P_2_0[23] = 15'd8808; CODE2P_2_0[24] = 15'd1384; CODE2P_2_0[25] = 15'd9290; CODE2P_2_0[26] = 15'd21506; CODE2P_2_0[27] = 15'd22531; CODE2P_2_0[28] = 15'd552; CODE2P_2_0[29] = 15'd2682; CODE2P_2_0[30] = 15'd8608; CODE2P_2_0[31] = 15'd1656; CODE2P_2_0[32] = 15'd12288; CODE2P_2_0[33] = 15'd6592; CODE2P_2_0[34] = 15'd18434; CODE2P_2_0[35] = 15'd19459; CODE2P_2_0[36] = 15'd192; CODE2P_2_0[37] = 15'd4576; CODE2P_2_0[38] = 15'd8600; CODE2P_2_0[39] = 15'd2540; CODE2P_2_0[40] = 15'd12300; CODE2P_2_0[41] = 15'd7388; CODE2P_2_0[42] = 15'd11394; CODE2P_2_0[43] = 15'd23555; CODE2P_2_0[44] = 15'd240; CODE2P_2_0[45] = 15'd4288; CODE2P_2_0[46] = 15'd8640; CODE2P_2_0[47] = 15'd5418; CODE2P_2_0[48] = 15'd9332; CODE2P_2_0[49] = 15'd14342; CODE2P_2_0[50] = 15'd15365; CODE2P_2_0[51] = 15'd520; CODE2P_2_0[52] = 15'd4400; CODE2P_2_0[53] = 15'd8768; CODE2P_2_0[54] = 15'd5576; CODE2P_2_0[55] = 15'd20482; CODE2P_2_0[56] = 15'd10456; CODE2P_2_0[57] = 15'd19461; CODE2P_2_0[58] = 15'd512; CODE2P_2_0[59] = 15'd4208; CODE2P_2_0[60] = 15'd8432; CODE2P_2_0[61] = 15'd5540; CODE2P_2_0[62] = 15'd20484; CODE2P_2_0[63] = 15'd11520; CODE2P_2_0[64] = 15'd21509; CODE2P_2_0[65] = 15'd16; CODE2P_2_0[66] = 15'd4376; CODE2P_2_0[67] = 15'd1476; CODE2P_2_0[68] = 15'd3532; CODE2P_2_0[69] = 15'd10340; CODE2P_2_0[70] = 15'd22532; CODE2P_2_0[71] = 15'd23557; CODE2P_2_0[72] = 15'd4; CODE2P_2_0[73] = 15'd4164; CODE2P_2_0[74] = 15'd8596; CODE2P_2_0[75] = 15'd6484; CODE2P_2_0[76] = 15'd11332; CODE2P_2_0[77] = 15'd17412; CODE2P_2_0[78] = 15'd18437; CODE2P_2_0[79] = 15'd24; CODE2P_2_0[80] = 15'd4096; CODE2P_2_0[81] = 15'd8632; CODE2P_2_0[82] = 15'd2272; CODE2P_2_0[83] = 15'd9272; CODE2P_2_0[84] = 15'd13312; CODE2P_2_0[85] = 15'd14337;
          
    CODE2P_2_1[0] = 15'd322; CODE2P_2_1[1] = 15'd1042; CODE2P_2_1[2] = 15'd2474; CODE2P_2_1[3] = 15'd3274; CODE2P_2_1[4] = 15'd8354; CODE2P_2_1[5] = 15'd5538; CODE2P_2_1[6] = 15'd6642; CODE2P_2_1[7] = 15'd20482; CODE2P_2_1[8] = 15'd21506; CODE2P_2_1[9] = 15'd11618; CODE2P_2_1[10] = 15'd16387; CODE2P_2_1[11] = 15'd464; CODE2P_2_1[12] = 15'd1088; CODE2P_2_1[13] = 15'd2320; CODE2P_2_1[14] = 15'd3584; CODE2P_2_1[15] = 15'd4722; CODE2P_2_1[16] = 15'd7258; CODE2P_2_1[17] = 15'd8816; CODE2P_2_1[18] = 15'd9410; CODE2P_2_1[19] = 15'd15826; CODE2P_2_1[20] = 15'd23554; CODE2P_2_1[21] = 15'd16397; CODE2P_2_1[22] = 15'd552; CODE2P_2_1[23] = 15'd1208; CODE2P_2_1[24] = 15'd2560; CODE2P_2_1[25] = 15'd3152; CODE2P_2_1[26] = 15'd4272; CODE2P_2_1[27] = 15'd6312; CODE2P_2_1[28] = 15'd14570; CODE2P_2_1[29] = 15'd12834; CODE2P_2_1[30] = 15'd13498; CODE2P_2_1[31] = 15'd21508; CODE2P_2_1[32] = 15'd22531; CODE2P_2_1[33] = 15'd224; CODE2P_2_1[34] = 15'd1192; CODE2P_2_1[35] = 15'd2592; CODE2P_2_1[36] = 15'd3152; CODE2P_2_1[37] = 15'd4152; CODE2P_2_1[38] = 15'd6668; CODE2P_2_1[39] = 15'd14940; CODE2P_2_1[40] = 15'd10426; CODE2P_2_1[41] = 15'd18434; CODE2P_2_1[42] = 15'd5232; CODE2P_2_1[43] = 15'd19459; CODE2P_2_1[44] = 15'd448; CODE2P_2_1[45] = 15'd1616; CODE2P_2_1[46] = 15'd2664; CODE2P_2_1[47] = 15'd3232; CODE2P_2_1[48] = 15'd9248; CODE2P_2_1[49] = 15'd12344; CODE2P_2_1[50] = 15'd7680; CODE2P_2_1[51] = 15'd10776; CODE2P_2_1[52] = 15'd18436; CODE2P_2_1[53] = 15'd8388; CODE2P_2_1[54] = 15'd17415; CODE2P_2_1[55] = 15'd384; CODE2P_2_1[56] = 15'd1328; CODE2P_2_1[57] = 15'd2392; CODE2P_2_1[58] = 15'd3696; CODE2P_2_1[59] = 15'd4704; CODE2P_2_1[60] = 15'd12412; CODE2P_2_1[61] = 15'd9260; CODE2P_2_1[62] = 15'd10532; CODE2P_2_1[63] = 15'd13892; CODE2P_2_1[64] = 15'd19460; CODE2P_2_1[65] = 15'd20485; CODE2P_2_1[66] = 15'd100; CODE2P_2_1[67] = 15'd1028; CODE2P_2_1[68] = 15'd2596; CODE2P_2_1[69] = 15'd3236; CODE2P_2_1[70] = 15'd4540; CODE2P_2_1[71] = 15'd11684; CODE2P_2_1[72] = 15'd15716; CODE2P_2_1[73] = 15'd5612; CODE2P_2_1[74] = 15'd7492; CODE2P_2_1[75] = 15'd22532; CODE2P_2_1[76] = 15'd23557; CODE2P_2_1[77] = 15'd488; CODE2P_2_1[78] = 15'd1624; CODE2P_2_1[79] = 15'd2080; CODE2P_2_1[80] = 15'd3576; CODE2P_2_1[81] = 15'd4544; CODE2P_2_1[82] = 15'd11328; CODE2P_2_1[83] = 15'd16392; CODE2P_2_1[84] = 15'd13328; CODE2P_2_1[85] = 15'd15560; CODE2P_2_1[86] = 15'd14472; CODE2P_2_1[87] = 15'd17409;
          
    CODE2P_2_2[0] = 15'd34; CODE2P_2_2[1] = 15'd1418; CODE2P_2_2[2] = 15'd2386; CODE2P_2_2[3] = 15'd3458; CODE2P_2_2[4] = 15'd4186; CODE2P_2_2[5] = 15'd5362; CODE2P_2_2[6] = 15'd10378; CODE2P_2_2[7] = 15'd11594; CODE2P_2_2[8] = 15'd15794; CODE2P_2_2[9] = 15'd19458; CODE2P_2_2[10] = 15'd12586; CODE2P_2_2[11] = 15'd9610; CODE2P_2_2[12] = 15'd13434; CODE2P_2_2[13] = 15'd20487; CODE2P_2_2[14] = 15'd384; CODE2P_2_2[15] = 15'd1256; CODE2P_2_2[16] = 15'd2272; CODE2P_2_2[17] = 15'd3384; CODE2P_2_2[18] = 15'd4168; CODE2P_2_2[19] = 15'd5608; CODE2P_2_2[20] = 15'd10600; CODE2P_2_2[21] = 15'd11904; CODE2P_2_2[22] = 15'd15656; CODE2P_2_2[23] = 15'd19460; CODE2P_2_2[24] = 15'd18442; CODE2P_2_2[25] = 15'd9724; CODE2P_2_2[26] = 15'd16642; CODE2P_2_2[27] = 15'd17587; CODE2P_2_2[28] = 15'd208; CODE2P_2_2[29] = 15'd1624; CODE2P_2_2[30] = 15'd2312; CODE2P_2_2[31] = 15'd3240; CODE2P_2_2[32] = 15'd4648; CODE2P_2_2[33] = 15'd5592; CODE2P_2_2[34] = 15'd13812; CODE2P_2_2[35] = 15'd11548; CODE2P_2_2[36] = 15'd15572; CODE2P_2_2[37] = 15'd6170; CODE2P_2_2[38] = 15'd18440; CODE2P_2_2[39] = 15'd7474; CODE2P_2_2[40] = 15'd14626; CODE2P_2_2[41] = 15'd23555; CODE2P_2_2[42] = 15'd72; CODE2P_2_2[43] = 15'd1544; CODE2P_2_2[44] = 15'd2400; CODE2P_2_2[45] = 15'd3144; CODE2P_2_2[46] = 15'd4528; CODE2P_2_2[47] = 15'd5568; CODE2P_2_2[48] = 15'd8530; CODE2P_2_2[49] = 15'd12568; CODE2P_2_2[50] = 15'd16752; CODE2P_2_2[51] = 15'd6732; CODE2P_2_2[52] = 15'd18436; CODE2P_2_2[53] = 15'd7440; CODE2P_2_2[54] = 15'd22530; CODE2P_2_2[55] = 15'd17724; CODE2P_2_2[56] = 15'd21511; CODE2P_2_2[57] = 15'd28; CODE2P_2_2[58] = 15'd1524; CODE2P_2_2[59] = 15'd2108; CODE2P_2_2[60] = 15'd3716; CODE2P_2_2[61] = 15'd4644; CODE2P_2_2[62] = 15'd5332; CODE2P_2_2[63] = 15'd8636; CODE2P_2_2[64] = 15'd12500; CODE2P_2_2[65] = 15'd16964; CODE2P_2_2[66] = 15'd14412; CODE2P_2_2[67] = 15'd10532; CODE2P_2_2[68] = 15'd7812; CODE2P_2_2[69] = 15'd22532; CODE2P_2_2[70] = 15'd23557; CODE2P_2_2[71] = 15'd280; CODE2P_2_2[72] = 15'd1632; CODE2P_2_2[73] = 15'd2672; CODE2P_2_2[74] = 15'd3480; CODE2P_2_2[75] = 15'd4392; CODE2P_2_2[76] = 15'd5400; CODE2P_2_2[77] = 15'd9728; CODE2P_2_2[78] = 15'd13784; CODE2P_2_2[79] = 15'd20480; CODE2P_2_2[80] = 15'd8328; CODE2P_2_2[81] = 15'd6312; CODE2P_2_2[82] = 15'd14392; CODE2P_2_2[83] = 15'd17664; CODE2P_2_2[84] = 15'd21505;
          
    CODE2P_2_3 [0] = 15'd106; CODE2P_2_3[1] = 15'd1410; CODE2P_2_3[2] = 15'd2690; CODE2P_2_3[3] = 15'd3602; CODE2P_2_3[4] = 15'd4130; CODE2P_2_3[5] = 15'd5714; CODE2P_2_3[6] = 15'd6202; CODE2P_2_3[7] = 15'd7410; CODE2P_2_3[8] = 15'd8802; CODE2P_2_3[9] = 15'd9634; CODE2P_2_3[10] = 15'd10538; CODE2P_2_3[11] = 15'd15610; CODE2P_2_3[12] = 15'd17994; CODE2P_2_3[13] = 15'd21506; CODE2P_2_3[14] = 15'd11746; CODE2P_2_3[15] = 15'd13706; CODE2P_2_3[16] = 15'd14922; CODE2P_2_3[17] = 15'd16978; CODE2P_2_3[18] = 15'd18618; CODE2P_2_3[19] = 15'd20491; CODE2P_2_3[20] = 15'd552; CODE2P_2_3[21] = 15'd1528; CODE2P_2_3[22] = 15'd2640; CODE2P_2_3[23] = 15'd3520; CODE2P_2_3[24] = 15'd4608; CODE2P_2_3[25] = 15'd5736; CODE2P_2_3[26] = 15'd6600; CODE2P_2_3[27] = 15'd7688; CODE2P_2_3[28] = 15'd8240; CODE2P_2_3[29] = 15'd9344; CODE2P_2_3[30] = 15'd10648; CODE2P_2_3[31] = 15'd12802; CODE2P_2_3[32] = 15'd17904; CODE2P_2_3[33] = 15'd15432; CODE2P_2_3[34] = 15'd19674; CODE2P_2_3[35] = 15'd21508; CODE2P_2_3[36] = 15'd14884; CODE2P_2_3[37] = 15'd16772; CODE2P_2_3[38] = 15'd18868; CODE2P_2_3[39] = 15'd22531; CODE2P_2_3[40] = 15'd412; CODE2P_2_3[41] = 15'd1148; CODE2P_2_3[42] = 15'd2052; CODE2P_2_3[43] = 15'd3716; CODE2P_2_3[44] = 15'd4292; CODE2P_2_3[45] = 15'd5324; CODE2P_2_3[46] = 15'd6484; CODE2P_2_3[47] = 15'd7604; CODE2P_2_3[48] = 15'd8548; CODE2P_2_3[49] = 15'd9788; CODE2P_2_3[50] = 15'd10812; CODE2P_2_3[51] = 15'd11340; CODE2P_2_3[52] = 15'd13596; CODE2P_2_3[53] = 15'd12828; CODE2P_2_3[54] = 15'd17644; CODE2P_2_3[55] = 15'd15828; CODE2P_2_3[56] = 15'd19884; CODE2P_2_3[57] = 15'd20484; CODE2P_2_3[58] = 15'd23558; CODE2P_2_3[59] = 15'd22533; CODE2P_2_3[60] = 15'd128; CODE2P_2_3[61] = 15'd1256; CODE2P_2_3[62] = 15'd2336; CODE2P_2_3[63] = 15'd3400; CODE2P_2_3[64] = 15'd4448; CODE2P_2_3[65] = 15'd5568; CODE2P_2_3[66] = 15'd6616; CODE2P_2_3[67] = 15'd7464; CODE2P_2_3[68] = 15'd8592; CODE2P_2_3[69] = 15'd9408; CODE2P_2_3[70] = 15'd14752; CODE2P_2_3[71] = 15'd11784; CODE2P_2_3[72] = 15'd13832; CODE2P_2_3[73] = 15'd12320; CODE2P_2_3[74] = 15'd16416; CODE2P_2_3[75] = 15'd19016; CODE2P_2_3[76] = 15'd19872; CODE2P_2_3[77] = 15'd20488; CODE2P_2_3[78] = 15'd23553;

          if (selB == 1'b1) begin
            case (zEnum)
              2'd0 :
                case (rEnum)
                  2'd0 : dOutB <= CODE2P_0_0[addrB];
                  2'd1 : dOutB <= CODE2P_0_1[addrB];
                  2'd2 : dOutB <= CODE2P_0_2[addrB];
                  default : dOutB <= CODE2P_0_3[addrB];
                endcase
              2'd1 :
                case (rEnum)
                  2'd0 : dOutB <= CODE2P_1_0[addrB];
                  2'd1 : dOutB <= CODE2P_1_1[addrB];
                  2'd2 : dOutB <= CODE2P_1_2[addrB];
                  default : dOutB <= CODE2P_1_3[addrB];
                endcase
              default :
                case (rEnum)
                  2'd0 : dOutB <= CODE2P_2_0[addrB];
                  2'd1 : dOutB <= CODE2P_2_1[addrB];
                  2'd2 : dOutB <= CODE2P_2_2[addrB];
                  default : dOutB <= CODE2P_2_3[addrB];
                endcase
            endcase
          end
        end
      end //pSelB
//    end
  
//  endgenerate // g2Port
  
endmodule




