//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of ldpcDecConfigCtrl module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module ldpcDecConfigCtrl (       
  input  wire         nRst,
  input  wire         Clk,

  input  wire         CfgEnable,
  output reg          ldecEnable,
  
  input  wire [ 1:0]  sizeEnum,
  input  wire [`RW_LDPCCFGRAM_AWIDTH-1:0] CfgAddrIn,
  
  /* Config RAM read interface */
  output reg [`RW_LDPCCFGRAM_AWIDTH-1:0] CfgAddrOut,
  output reg          CfgAddrUpdate,
  input  wire [28:0]  CfgData,
  input  wire         CfgDataUpdate,

  /* Iteration control */
  output reg  [ 7:0]  nomIterations,
  output reg  [ 4:0]  earlyTestIterations,
  output reg  [ 7:0]  maxRunningCount,
  output reg  [ 7:0]  endRunningCount
);
  
  reg        CfgDataUpdateD1, CfgDataUpdateD2;
  reg        CfgEnableD1;
  
  /* Iteration control */
  reg  [ 7:0]  nnomIterations;
  reg  [ 4:0]  nearlyTestIterations;
  reg  [ 7:0]  nmaxRunningCount;
  reg  [ 7:0]  nendRunningCount;
  
  // When enable goes high, read config from config RAM
  // Set ldecEnable when config outputs are ready
  always @(posedge Clk,negedge nRst)
  begin
    if(!nRst)
    begin
      CfgEnableD1         <= 1'b0;
      ldecEnable          <= 1'b0;
      CfgAddrUpdate       <= 1'b0;
      CfgAddrOut          <= {`RW_LDPCCFGRAM_AWIDTH{1'b0}};
      CfgDataUpdateD1     <= 1'b0;
      CfgDataUpdateD2     <= 1'b0;
      nomIterations       <= 8'd0;
      earlyTestIterations <= 5'd0;
      maxRunningCount     <= 8'd0;
      endRunningCount     <= 8'd0;
    end
    else if (CfgEnable == 1'b0)
    begin
      CfgAddrUpdate  <= 1'b0;
      ldecEnable          <= 1'b0;
      CfgEnableD1         <= 1'b0;
      CfgDataUpdateD1     <= 1'b0;
      CfgDataUpdateD2     <= 1'b0;
    end
    else
    begin
      // Config RAM read access on CfgEnable rising edge
      CfgEnableD1      <= CfgEnable;
      if (CfgEnable && !CfgEnableD1) begin
        CfgAddrUpdate <= 1'b1;
        CfgAddrOut    <= CfgAddrIn;
      end

      // Detect rising edge of data update to decode config data
      CfgDataUpdateD1 <= CfgDataUpdate;
      if (CfgDataUpdate && !CfgDataUpdateD1) begin
        nomIterations       <= nnomIterations;
        earlyTestIterations <= nearlyTestIterations;
        maxRunningCount     <= nmaxRunningCount;
        endRunningCount     <= nendRunningCount;
      end

      // Set enable after config is ready
      CfgDataUpdateD2 <= CfgDataUpdateD1;
      if (CfgDataUpdateD1 && !CfgDataUpdateD2) 
        ldecEnable     <= 1'b1;
      else if (CfgEnable == 1'b0)
        ldecEnable     <= 1'b0;
    end
  end


 // Decode config data
 always @(*)
   case (sizeEnum)
     2'd0    : begin
       nearlyTestIterations  = 5'd31;
       nnomIterations        = CfgData[ 7: 0];
       nmaxRunningCount      = CfgData[ 7: 0];
       nendRunningCount      = CfgData[ 7: 0];
     end
     2'd1    : begin
       nearlyTestIterations  = 5'd31;
       nnomIterations        = CfgData[23:16];
       nmaxRunningCount      = CfgData[15: 8];
       nendRunningCount      = CfgData[15: 8];
     end
     default :  begin
       nearlyTestIterations  = CfgData[28:24];
       nnomIterations        = CfgData[23:16];
       nmaxRunningCount      = CfgData[15: 8];
       nendRunningCount      = CfgData[ 7: 0];
     end
   endcase
   
 endmodule
`default_nettype wire
