`default_nettype none

`include "ldpcDec.vh"

module ldpcDecCoreWrap
 # (
 parameter NUM_USERS = 1 )
(
  input  wire                                 nReset,
  // Clocking
  input  wire                                 FreeClk,
  input  wire                                 DecClk,
  output wire                                 DecClkEn,
  // User control
  input  wire [4:0]                           inUser,
  output wire [4:0]                           opUser,
  // input wires from sender
  input  wire [`LDEC_IP_WIDTH*`LDEC_IP_BITS-1:0] inDataWord,
  input  wire                                 inStrobe,
  input  wire [numBits(`LDEC_IP_WIDTH)-1:0]   ipWidth,
  input  wire                                 ipSkipBlock,
  output wire                                 ipLoaded,
  output wire [numBits(`LDEC_MAX_IPBITS)-1:0] numIpBits,
  output wire                                 numIpBitsValid,
  // output wires to sender
  output wire                                 rdyToRcvOut,
  // output wires to downstream hardware
  output wire [`LDEC_OP_WIDTH-1:0]            opDataWordOut,
  output wire                                 opStrobeOut,
  output wire [`LDEC_OP_WIDTH/8-1:0]          opByteEnOut,
  output wire [numBits(`LDEC_OP_WIDTH)-1:0]   opBitEnOut,
  output wire                                 opDoneOut,
  output wire                                 decodeCompleteOut,
  output wire                                 decodeStatusOut,
  output wire                                 packetCompleteOut,
  output wire                                 packetOpCompleteOut,
  output wire                                 packetStatusOut,
  // input wires from downstream hardware
  input  wire                                 clrToSend,
  // Registers and controls
  input  wire                                 enable,
  input  wire                                 enableIp, 
  input  wire                                 iterationAbort, 
  input  wire                                 enLostTime,
  input  wire                                 beatTimeLine,
  // Code characteristics
  input  wire [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
  input  wire [numBits(`LDEC_R_ENUM_MAX)-1:0] rEnum,
  input  wire [numBits(`LDEC_BPS_MAX)-1:0]    bitsPerSymbol,
  input  wire                                 stbc,           // 0: non STBC, 1: STBC
  input  wire [2:0]                           qamEnum,        // 0:4 is BPSK, QPSK, 16QAM, 64QAM, 256QAM
  input  wire                                 ac,             // 0:11n 1:11ac
  input  wire                                 he,             // 0:11n/11ac 1: 11ax
  input  wire [1:0]                           bw,             // 0:3 is 20/40/80/160MHz
  input  wire [6:0]                           mcs,            // 0-9 for 11ac, 0-72 for 11n
  input  wire [1:0]                           nssLess1,       // e.g. NSS=4 is specified as a 3.
  input  wire [1:0]                           nSym,           // num OFDM symbols. clip this to 3.
  input  wire [2:0]                           RuType,
  input  wire [5:0]                           llrUnity,
  // Packet Management
  input  wire [numBits(`LDEC_MAX_BLKNUM)-1:0] RegNcw,
  input  wire [15:0]                          packetBytesLs,            
  input  wire [`LDEC_PB_MS_LEFT:0]            packetBytesMs,            
  input  wire [15:0]                          frameEndByteLs,           
  input  wire [`LDEC_PB_MS_LEFT+1:0]          frameEndByteMs,           
  // Shortening etc parameters
  input  wire [numBits(`LDEC_N_MAX-1)-1:0]    nShrtFloor,
  input  wire [numBits(`LDEC_MAX_BLKNUM)-1:0] shrtMod,
  input  wire [numBits(`LDEC_M_MAX-1)-1:0]    nPuncFloor,
  input  wire [numBits(`LDEC_MAX_BLKNUM)-1:0] puncMod,
  input  wire [numBits(`LDEC_NREPS_MAX)-1:0]  nRepFloor,
  input  wire [numBits(`LDEC_MAX_BLKNUM)-1:0] repMod,
  // Config data interface
  output wire [`RW_LDPCCFGRAM_AWIDTH-1:0]     CfgAddr,
  output wire                                 CfgAddrUpdate,
  input  wire [28:0]                          CfgData,
  input  wire                                 CfgDataUpdate,

  // Memories
  // VM RAMs
  output wire [`LDEC_VM_RAM_A-1:0]            vmRamAddrAX,
  output wire [`LDEC_VM_RAM_A-1:0]            vmRamAddrBX,
  output wire [`LDEC_VM_RAM_W-1:0]            vmRamWrDataX,
  output wire [`LDEC_VM_RAM_WE-1:0]           vmRamWriteX,
  output wire                                 vmRamEnAX,
  input  wire [`LDEC_VM_RAM_W-1:0]            vmRamRdDataX,
  output wire [`LDEC_VM_RAM_A-1:0]            vmRamAddrAY,
  output wire [`LDEC_VM_RAM_A-1:0]            vmRamAddrBY,
  output wire [`LDEC_VM_RAM_W-1:0]            vmRamWrDataY,
  output wire [`LDEC_VM_RAM_WE-1:0]           vmRamWriteY,
  output wire                                 vmRamEnAY,
  input  wire [`LDEC_VM_RAM_W-1:0]            vmRamRdDataY,
  // HD RAMs
  output wire [`LDEC_HD_RAM_A-1:0]            hdRamAddrAX,
  output wire [`LDEC_HD_RAM_A-1:0]            hdRamAddrB,
  output wire [`LDEC_HD_RAM_W-1:0]            hdRamWrData,
  output wire                                 hdRamWriteX,
  output wire                                 hdRamEnAX,
  input  wire [`LDEC_HD_RAM_W-1:0]            hdRamRdDataX,
  output wire [`LDEC_HD_RAM_A-1:0]            hdRamAddrAY,
  output wire                                 hdRamWriteY,
  output wire                                 hdRamEnAY,
  input  wire [`LDEC_HD_RAM_W-1:0]            hdRamRdDataY,
  // Cr RAMs
  output wire [`LDEC_CR_RAM_A-1:0]            crRamAddrA,
  output wire [`LDEC_CR_RAM_A-1:0]            crRamAddrB,
  output wire [`LDEC_CR_RAM_W-1:0]            crRamWrData,
  output wire                                 crRamEn,
  output wire                                 crRamWr,
  input  wire [`LDEC_CR_RAM_W-1:0]            crRamRdData,
  // Vr RAMs
  output wire [`LDEC_VR_RAM_A-1:0]            vrRamAddrA,
  output wire [`LDEC_VR_RAM_A-1:0]            vrRamAddrB,
  output wire [`LDEC_VR_RAM_W-1:0]            vrRamWrData,
  output wire                                 vrRamEn,
  output wire                                 vrRamWr,
  input  wire [`LDEC_VR_RAM_W-1:0]            vrRamRdData,
  // Debug port
  output wire [15:0]                          dbgIter,
  output wire [15:0]                          dbgIp,
  output wire [`LDEC_DBG_PORT_WIDTH-1:0]      dbgCfg,
  output wire [`LDEC_DBG_PORT_WIDTH-1:0]      dbgCtrl,
  // Status signals to debug
  output wire [numBits(`LDEC_MAX_BLKNUM)-1:0]   blkErrs,
  output wire [numBits(`LDEC_MAX_ITER)-1:0]     prevIterations,
  output wire [numBits(`LDEC_PAR_ERRS_MAX)-1:0] prevParityErrs,
  output wire                                   prevDecodeStatus,
  output wire [numBits(`LDEC_MAX_ITER)-1:0]     curIteration
  );

`include "ldpcDecFuncs.vh"  

  wire [NUM_USERS-1:0]                 enabledUsers;

  // Config RAM control
  wire                                   lutEnable, ldecEnable;
  wire [`RW_LDPCCFGRAM_AWIDTH-1:0]       CfgAddrInt;
  wire                                   Zero;

  // Cell RAM interface (not used)
  wire                                   cellAccess;
  wire                                   cellRead;
  wire                                   cellWrite;
  wire [`LDEC_CELL_RAM_W-1:0]            cellWrData;
  wire [14:0]                            cellRdData;
  // Status not used
  wire [13:0] varMetricChkSum; // only for tb

  // Scaling and iteration controls from parameters LUT to LDPC               
  wire [`LDEC_VAR_BITS-1+7:0]            targetLevel;
  wire [numBits(`LDEC_K_MAX)-1:0]        parityThresh;
  wire [numBits(8*`LDEC_MAX_ITER)-1:0]   nomIterations;
  wire [numBits(`LDEC_MAX_ITER)-1:0]     earlyTestIterations;
  wire [numBits(8*`LDEC_MAX_ITER)-1:0]   maxRunningCount;
  wire [numBits(8*`LDEC_MAX_ITER)-1:0]   endRunningCount;
  
  // Wire packing for Memories
  wire [`LDEC_VM_RAM_O-1:0]              vmRamOps;
  wire [`LDEC_VM_RAM_I-1:0]              vmRamIps;
  wire [`LDEC_HD_RAM_O-1:0]              hdRamOps;
  wire [`LDEC_HD_RAM_I-1:0]              hdRamIps;
`ifdef LDEC_2_PORTS
  wire [`LDEC_CR_RAM_I-1:0]              crRamIps;
`else
  wire [`LDEC_CR1_RAM_I-1:0]             cr1RamIps;
`endif
`ifdef LDEC_2_PORTS
  wire [`LDEC_VR_RAM_I-1:0]              vrRamIps;
`else
  wire [`LDEC_VR1_RAM_I-1:0]             vr1RamIps;
`endif

  // Users mapping
  assign enabledUsers[0]       = enable;

  // Memories wire packing
  assign vmRamOps = {vmRamRdDataX, vmRamRdDataY};
  assign hdRamOps = {hdRamRdDataX, hdRamRdDataY};

  assign {crRamWr, crRamEn, crRamAddrA, crRamWrData, crRamAddrB} = crRamIps;
  assign {vrRamWr, vrRamEn, vrRamAddrA, vrRamWrData, vrRamAddrB} = vrRamIps;
  // Unpack what was packed in ldpcDecVmRamMux.
  assign {vmRamEnAX, vmRamEnAY, vmRamWriteX, vmRamAddrAX, vmRamAddrBX,
          vmRamWrDataX, vmRamWriteY, vmRamAddrAY, vmRamAddrBY,
          vmRamWrDataY} = vmRamIps;  
  // Unpack what was packed in ldpcDecHdRamMux.
  assign {hdRamEnAX, hdRamEnAY, hdRamWriteX, hdRamWriteY,
          hdRamAddrAX, hdRamAddrB, hdRamWrData, hdRamAddrAY} = hdRamIps;

  // The Cell RAM is not used
  assign cellAccess = 1'b0;
  assign cellRead   = 1'b0;
  assign cellWrite  = 1'b0;
  assign cellWrData = 'b0;
	
  assign Zero = 1'b0;
  

  // LUT for LDPC parameters
  ldpcDecLuTop luTop
    (
     // Clock and reset
     .clk                 (FreeClk),
     .rst_n               (nReset),
     // Controls
     .stbc                (stbc),
     .enable              (enable),
     .lutEnable           (lutEnable),
     .qamEnum             (qamEnum),
     .sizeEnum            (zEnum),
     .rateEnum            (rEnum),
     .RuType              (RuType),
     .ac                  (ac),
     .he                  (he),
     .bw                  (bw),
     .mcs                 (mcs),
     .nssLess1            (nssLess1),
     .nCw                 (RegNcw[numBits(`LDEC_MAX_BLKNUM)-1:0]),
     .nSym                (nSym),
     // Outputs
     .targetLevel         (targetLevel),
     .parityThresh        (parityThresh),
     .CfgAddr             (CfgAddrInt)
  );


  ldpcDecConfigCtrl u_ldpcDecConfigCtrl
    (       
     .nRst                   (nReset),
     .Clk                    (FreeClk),

     .CfgEnable              (lutEnable),
     .ldecEnable             (ldecEnable),
    
     .sizeEnum               (zEnum),
     .CfgAddrIn              (CfgAddrInt),
    
     /* Config RAM read interface */
     .CfgAddrOut             (CfgAddr),
     .CfgAddrUpdate          (CfgAddrUpdate),  
     .CfgData                (CfgData),
     .CfgDataUpdate          (CfgDataUpdate),

     /* Iteration control */
     .nomIterations          (nomIterations),
     .earlyTestIterations    (earlyTestIterations),
     .maxRunningCount        (maxRunningCount),
     .endRunningCount        (endRunningCount)
  );

  // config diag
  assign dbgCfg = {1'b0,
                   ldecEnable,
                   stbc,
                   earlyTestIterations,
                   nomIterations,
                   maxRunningCount,
                   endRunningCount};
                   
  // LDPC Decoder
  ldpcDecCore # (
    .NUM_USERS            (NUM_USERS)
  ) core (
     .nReset              (nReset),
     // Inputs from sender
     .inStrobe            (inStrobe),
     .inDataWord          (inDataWord),
     .ipSkipBlock         (ipSkipBlock),
     .ipLoaded            (ipLoaded),
     .numIpBits           (numIpBits),
     .numIpBitsValid      (numIpBitsValid),
     .llrUnity            (llrUnity),
     .iterationAbort      (iterationAbort),
     // User control
     .inUser              (inUser),
     .opUser              (opUser),
     // Inputs from output interface
     .clrToSend           (clrToSend),
     // Outputs to sender
     .rdyToRcvOut         (rdyToRcvOut),
     // Outputs to downstream hardware
     .decodeCompleteOut   (decodeCompleteOut),
     .decodeStatusOut     (decodeStatusOut),
     .packetCompleteOut   (packetCompleteOut),
     .packetOpCompleteOut (packetOpCompleteOut),
     .packetStatusOut     (packetStatusOut),
     .opDoneOut           (opDoneOut),
     .opStrobeOut         (opStrobeOut),
     .opDataWordOut       (opDataWordOut),
     .opByteEnOut         (opByteEnOut),
     .opBitEnOut          (opBitEnOut),
     //-----------------------------------------
     // Registers
     //-----------------------------------------
     // Master enable to control.
     .enabledUsers        (enabledUsers),
     .enableIp            (enableIp),
     .enLostTime          (enLostTime),
     .beatTimeLine        (beatTimeLine),     
     // To mem block to program the code cell information.
     .cellAccess          (cellAccess),
     .cellRead            (cellRead),
     .cellWrite           (cellWrite),
     .cellWrData          (cellWrData),
     // Code characteristics to control.
     .ipWidth             (ipWidth),
     .zEnumU0             (zEnum),
     .rEnumU0             (rEnum),
     .bitsPerSymbolU0     (bitsPerSymbol),
     .RegNcwU0            (RegNcw),
     .packetBytesLs       (packetBytesLs),
     .packetBytesMs       (packetBytesMs),
     .frameEndByteLs      (frameEndByteLs),
     .frameEndByteMs      (frameEndByteMs),    
     // Shortening etc parameters to control.
     .nShrtFloorU0        (nShrtFloor),
     .shrtModU0           (shrtMod),
     .nPuncFloorU0        (nPuncFloor),
     .puncModU0           (puncMod),
     .nRepFloorU0         (nRepFloor),
     .repModU0            (repMod),
     .targetLevel         (targetLevel),
     .parityThresh        (parityThresh),
     .nomIterations       (nomIterations),
     .earlyTestIterations (earlyTestIterations),
     .maxRunningCount     (maxRunningCount),
     .endRunningCount     (endRunningCount),
     // Status registers
     .blkErrsOut          (blkErrs),
     .curIterationOut     (curIteration),
     .prevParityErrsOut   (prevParityErrs),
     .prevIterationsOut   (prevIterations),
     .prevDecodeStatusOut (prevDecodeStatus),
     .varMetricChkSumOut  (varMetricChkSum),
     .cellRdDataOut       (cellRdData),
     //-----------------------------------------
     // Clocking
     //-----------------------------------------
     .freeClk             (FreeClk),
     .regsClk             (FreeClk),
     .ipClk               (FreeClk),
     .opClk               (FreeClk),
     .decClk              (DecClk),
     .cellClk             (FreeClk),
     .vmRam1Clk           (Zero),
     .vmRam2Clk           (Zero),
     .hdRamClk            (Zero),
     .crRamClk            (FreeClk),
     .ctrlClk             (FreeClk),
     .ipClkEnOut          (),
     .opClkEnOut          (),
     .decClkEnOut         (DecClkEn),
     .cellClkEnOut        (),
     .vmRam1ClkEnOut      (),
     .vmRam2ClkEnOut      (),
     .hdRamClkEnOut       (),
     .crRamClkEnOut       (),
     .ctrlClkEnOut        (),
     //-----------------------------------------------------------------------
     // I/O busses to RAMS (when `LDEC_RAMS_AT_TOP == 1)
     //-----------------------------------------------------------------------
`ifdef LDEC_RAMS_AT_TOP
`ifndef LDEC_USE_CELL_ROM
     .cellRamOps          (cellRamOps),
     .cellRamIps          (cellRamIps),
`endif
     .vmRamOps            (vmRamOps),
     .vmRamIps            (vmRamIps),
     .hdRamOps            (hdRamOps),
     .hdRamIps            (hdRamIps),
`ifdef LDEC_2_PORTS
     .crRamOps            (crRamRdData),
     .crRamIps            (crRamIps),
     .vrRamOps            (vrRamRdData),
     .vrRamIps            (vrRamIps),
`else
     .cr1RamOps           (crRamRdData),
     .cr1RamIps           (cr1RamIps),
     .vr1RamOps           (vrRamRdData),
     .vr1RamIps           (vr1RamIps),
`endif
`endif
     //----------------------------
     //  Debug Port
     //----------------------------
     .dbgIter             (dbgIter),
     .dbgIp               (dbgIp),
     .dbgIp2Out           (),
     .dbgOpOut            (),
     .dbgCtrlOut          (dbgCtrl)
  );

endmodule
`default_nettype wire
