//------------------------------------------------------------------------------
// ldpcDecVr1pRam.v
// 
// Description:
//   RAM wrapper for the ChkResp RAM. This is the sinlge port version.
//
// 21 July 2010 M. Rumsey. Created.
//
// (c) Copyright 2010, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcDec.vh"

module ldpcDecCr1pRam
(
    // A port
 input                       ck,
 input                       sel,
 input [`LDEC_CR_RAM_A-1:0]  addr,
 input [`LDEC_CR_RAM_W-1:0]  dIn,
 input                       we,
 output [`LDEC_CR_RAM_W-1:0] dOut);

`include "ldpcDecFuncs.vh"

  
  ldpcDecSpRam # (
      .depth   (`LDEC_CR_RAM_D),
      .width   (`LDEC_CR_RAM_W))

  crRam (
      .ck   (ck),
      .sel  (sel),
      .addr (addr),
      .dIn  (dIn),
      .we   (we),
      .dOut (dOut));

endmodule

    
    

