//------------------------------------------------------------------------------
// ldcpDecCrRam.v
// 
// Description:
//   RAM wrapper for the Check Response RAM.
//
// 9 June 2010 M. Rumsey. Created.
//
// (c) Copyright 2010, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcDec.vh"

module ldpcDecCrRam
(  
    input                       ck,
   // A port
    input [`LDEC_CR_RAM_A-1:0]  addrA,
    input [`LDEC_CR_RAM_W-1:0]  dInA,
    input                       weA,
   // B port
    input                       selB,
    input [`LDEC_CR_RAM_A-1:0]  addrB,
    output [`LDEC_CR_RAM_W-1:0] dOutB);

`include "ldpcDecFuncs.vh"
  
  ldpcDecDpRam # (
      .depth   (`LDEC_CR_RAM_D),
      .width   (`LDEC_CR_RAM_W))

  crRam (
      // Write port
      .ck     (ck),
      .wrAddr (addrA),
      .dIn    (dInA),
      .we     (weA),
      // Read port
      .sel    (selB),
      .rdAddr (addrB),
      .dOut   (dOutB));

endmodule

    
    

