//------------------------------------------------------------------------------
// ldpcDecDpArRam.v
// 
// Description:
//   RAM model with asynchronous read. One write port one read port.
//
//   generics
//     depth     number of addressable locations.
//     width     bit width of data port.
//
// 04 May 2010 M. Rumsey. Created.
//
// (c) ( Copyright 2010, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcDec.vh"

module ldpcDecDpArRam # (parameter depth = 64,
                         width = 8)
  (  
   input                        ck,
   // A port
   input [numBits(depth-1)-1:0] addrA,
   input [width-1:0]            dInA,
   input                        weA,
   // B port
   input [numBits(depth-1)-1:0] addrB,
   output [width-1:0]           dOutB);

`include "ldpcDecFuncs.vh"

  reg [width-1:0] mem [depth-1:0]; 

  //---------------------------------------------------------------------------
  // Write for both ports
  //---------------------------------------------------------------------------

  always @(posedge(ck))
  begin : pWriteA 
    if (weA == 1'b1) begin
      mem[addrA] <= dInA;
    end
  end //pWriteA
  
  //---------------------------------------------------------------------------
  // Port B Read
  //---------------------------------------------------------------------------

  assign dOutB  = mem[addrB];
 
endmodule

    
    

