//------------------------------------------------------------------------------
// ldpcDecDpRam.v
// 
// Description:
//   Dual port RAM model. This should !appear in your ASIC synthesis as the
//   Wrap block should have been changed to instance generated ASIC RAMs.
//
//   "Read First" operation is implemented. This means that during a write the
//   previous contents of a location is presented on the outputs.
//
//   generics
//     depth     number of addressable locations.
//     width     bit width of data port.
//     weWidth   Number of data bits that are write-enabled by each
//                write-enable. Put weWidth width to just have one write enable.
//
// 04 May 2010 M. Rumsey. Created.
//
// # (parameter c) ( Copyright 2010, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcDec.vh"

module ldpcDecDpRam
  # (parameter 
     depth = 32,
     width = 8,
     xChk = 0
     ) (

  
   // Write port
   input                        ck,
   input [numBits(depth-1)-1:0] wrAddr,
   input [width-1:0]            dIn,
   input                        we,
   // Read port
   input                        sel,
   input [numBits(depth-1)-1:0] rdAddr,
   output reg [width-1:0]       dOut);

`include "ldpcDecFuncs.vh"

  reg [width-1:0]  mem [depth-1:0]; 

  //---------------------------------------------------------------------------
  // Write 
  //---------------------------------------------------------------------------

  always @(posedge(ck))
  begin : pWrite 
    if (we == 1'b1) begin
      mem[wrAddr] <= dIn;
      // A limited check for Xs being written. Restricted to 27 bits because
      // Xs will often be written to higher locations for code rates 0 and 1.

`ifdef BRC_SIMU_ON
//synthesis translate_off
//synopsys translate_off
      if (xChk)
        if (!(^dIn[26:0] !== 1'bX))
          $warning("X written to memory.");             
//synopsys translate_on
//synthesis translate_on
`endif //BRC_SIMU_ON

    end
  end //pWrite
 
  //---------------------------------------------------------------------------
  // Read
  //---------------------------------------------------------------------------


  always @(posedge(ck))
  begin : pRead 
    if (sel == 1'b1) begin
      dOut <= mem[rdAddr];
    end
  end //pRead

endmodule

    
    

