//------------------------------------------------------------------------------
// ldcpDecDpWeWrFirstRam.v
// 
// Description:
//   Dual port RAM model. This should !appear in your ASIC synthesis as the
//   Wrap block should have been changed to instance generated ASIC RAMs.
//
// Parameters:
//     depth     number of addressable locations.
//     width     bit width of data port.
//     weWidth   Number of data bits that are write-enabled by each
//                write-enable. Put weWidth width to just have one write enable.
//
// 05 Oct 2010 M. Rumsey. Created.
//
// (c) Copyright 2010, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcDec.vh"

module ldpcDecDpWeWrFirstRam # (parameter 
                                depth   =  256,
                                width   =  32,
                                weWidth =  16) (
  
   // Write port
   input                               ck,
   input [numBits(depth-1)-1:0]        wrAddr,
   input [width-1:0]                   dIn,
   input [ceilDiv(width, weWidth)-1:0] we,
   // Read port
   input                               sel,
   input [numBits(depth-1)-1:0]        rdAddr,
   output [width-1:0]                  dOut);

`include "ldpcDecFuncs.vh"

  localparam WE_HI = ceilDiv(width, weWidth)-1;

  // Where the data may be written in sections we map this to
  // a RAM per section. This works well in Xilinx XST synthesis
  // but ASICs can be done with a single compiled RAM if the
  // generator allows it.

  generate
    genvar idx;    
    for (idx=0; idx<=WE_HI; idx=idx+1) begin: gMem 
      ldpcDecDpWrFirstRam # (.depth (depth),
                             .width (minimum(width, (idx+1)*weWidth) - weWidth*idx))
      ram (.ck     (ck),
           .wrAddr (wrAddr),
           .dIn    (dIn[minimum(width, (idx+1)*weWidth)-1 : weWidth*idx]),
           .we     (we[idx]),
           .sel    (sel),
           .rdAddr (rdAddr),
           .dOut   (dOut[minimum(width, (idx+1)*weWidth)-1 : weWidth*idx]));
    end
  endgenerate

endmodule

    
    

