//-----------------------------------------------------------------------------
// ldpcDecGlobal.v
// 
// Description
//   Global signals used by the ldpcDec test bench. This is a separate module
//   from the testbench. When you invoke the simulator you need to reference
//   both, for example:
//
//     vsim ldpcDec_tb ldpcDecGlobal
//   
// 6 Aug 2012 M. Rumsey. Created.
//
// (c) Copyright 2012, Blue Rum Consulting Limited, All Rights Reserved.
//------------------------------------------------------------------------------


module ldpcDecGlobal;

`ifdef BRC_SIMU_ON
//synthesis translate_off
//synopsys translate_off

  realtime period;
  // We re-create the assumed clock speed and the mean period of the LDPC block as
  // scaled by volume of data from the OFDM period. The test vectors pass in
  // this information and behavioural checkers in ldpcDecRead verify that the
  // required throughput is being maintained. Defaults below are just to allow
  // a startup.
  realtime halfPeriod   = 2.083;  // 240 MHz
  // This one now resides in ldpcDecPkg to allow access from RTL logging.
  realtime onAirPeriod      = 2.7e3;
  // Blk latencies are decode times for an individual block relative to
  // completion of load of the input data. Pkt latency is also analysed on
  // a block by block basis but the time is measured relative to the on-air
  // arrival of the data for the LDPC block.
  realtime maxBlkLatency    = 2.7e3;
  realtime initialLatency   = 0;
  realtime endBlkLatency    = 2.7e3;
  realtime maxPktLatency    = 2.7e3;
  realtime endPktLatency    = 2.7e3;
  realtime nominalPeriod    = 2.7e3;
  real ipWidthFloat     = 8.0;
  integer opStallIdx    = 0;
  integer opStallCount  = 0;
  
  // For logging
  integer fwdLogFile = 0;
  integer bwdLogFile = 0;

//synthesis translate_on
//synopsys translate_on
`endif //BRC_SIMU_ON
  
endmodule // ldpcDecGlobal
