//------------------------------------------------------------------------------
// ldpcDecHdRam.v
// 
// Description:
//   RAM wrapper for the HardDecion RAM. This is ping-ponged to allow output
//   data to be fetched during the following decode. Furthermore
//   it is dual ported so that the bwd part can read previous
//   estimates and test if there has been a bit inversion.
//
// 7 June 2010 M. Rumsey. Created.
//
// (c) Copyright 2010, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcDec.vh"

module ldpcDecHdRam
(
    input                       ck,
 // A port used for reads only
    input                       selA,
    input [`LDEC_HD_RAM_A-1:0]  addrA,
    output [`LDEC_HD_RAM_W-1:0] dOutA,
 // B port used for write only
    input [`LDEC_HD_RAM_A-1:0]  addrB,
    input [`LDEC_HD_RAM_W-1:0]  dInB,
    input                       weB);

`include "ldpcDecFuncs.vh"

  ldpcDecDpRam # (
      .depth   (`LDEC_HD_RAM_D),
      .width   (`LDEC_HD_RAM_W))
  hdRam (
      // Write port
      .ck     (ck),
      .wrAddr (addrB),
      .dIn    (dInB),
      .we     (weB),
      // Read port
      .sel    (selA),
      .rdAddr (addrA),
      .dOut   (dOutA));

endmodule

    
    

