//------------------------------------------------------------------------------
// ldcpDecLookup.v
// 
// Description
//   Derives code parameters (size etc) from enums. These registers can be
//   multi-cycle (2 cycles should be sufficient) and they are separated into
//   a sub block to make them easier to locate for constraint setting.
//
// 17 Jan 2012 M. Rumsey. Created.
//
// (c) Copyright 2012, Blue Rum Consulting Limited, All Rights Reserved.
//------------------------------------------------------------------------------

`include "ldpcDec.vh"

module ldpcDecLookup
(  
   input                                   nReset,
   input                                   clk,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0]   zEnum,
   input [numBits(`LDEC_R_ENUM_MAX)-1:0]   rEnum, 
   output reg [numBits(`LDEC_Z_MAX)-1:0]   zOut,
   output reg [numBits(ceilDiv(`LDEC_Z_MAX,
   `LDEC_DEC_RAM_IP_WIDTH))-1:0]           numWrPerZOut, 
   output reg [numBits(`LDEC_N_MAX)-1:0]   nOut,
   output reg [numBits(`LDEC_K_MAX)-1:0]   kOut,
   output reg [numBits(`LDEC_NCOLS-1)-1:0] parityStartColOut);
  

`include "ldpcDecFuncs.vh"

  always @(posedge(clk) `LDEC_RESET_STR)
  begin : pLookup
    if (nReset == 1'b0) begin
      numWrPerZOut <= NUM_WR_PER_Z(2'd2);
      zOut <= Z_SIZES2(2'd2);
      nOut <= N_SIZES(2'd2);
      parityStartColOut <= PARITY_START_COL(2'd3);
      kOut <= K_SIZES(2'd2, 2'd3);
    end else begin
      numWrPerZOut <= NUM_WR_PER_Z(zEnum);
      zOut <= Z_SIZES2(zEnum);
      nOut <= N_SIZES(zEnum);
      parityStartColOut <= PARITY_START_COL(rEnum);
      kOut <= K_SIZES(zEnum, rEnum);
    end
  end //pLookup

endmodule
    
