// This function is recursive, but here we do a manually expanded version for tools
// that cannot support this.
// (c) Copyright 2012, Blue Rum Consulting Limited, All Rights Reserved.

// Rotate a, which is of length Z_MAX*VAR_BITS, by 2^level if shift(level)===1.
//  Called recursively to rotate for all bits of shift.

function automatic `LDEC_varZ_P ldpcDecRotateDownZ
  (input `LDEC_varZ_P                     aP,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                         level,
   input integer                         bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;
                      
  reg     [`LDEC_VAR_BITS-1:0]  a      `LDEC_varZ_R;
  reg     [`LDEC_VAR_BITS-1:0]  y      `LDEC_varZ_R;
  integer                opIdx;
  integer                ipIdx;
  integer                zE;
  // For pack / unpack
  integer                idx1;
  reg     `LDEC_varZ_P    yP;
    
  begin

    `LDEC_UNPACKF(aP, a, `LDEC_VAR_BITS, `LDEC_Z_MAX);    
    
    `LDEC_COPY(a, y, `LDEC_Z_MAX);   // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (shift[level] == 1'b1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (2**level < Z_SIZES2_INT(zE)) begin
            for (opIdx=0; opIdx<Z_SIZES2_INT(zE); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                  ipIdx = ipIdx - Z_SIZES2_INT(zE);
                end
                if (ipIdx < Z_SIZES2_INT(zE)) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end
 
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_VAR_BITS, `LDEC_Z_MAX);
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      yP = ldpcDecRotateDownZ_1(yP, zEnum, level-1, bottom, shift);
    end
    ldpcDecRotateDownZ = yP;
  end
endfunction

function automatic `LDEC_varZ_P ldpcDecRotateDownZ_1
  (input `LDEC_varZ_P                     aP,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                         level,
   input integer                         bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;
                      
  reg     [`LDEC_VAR_BITS-1:0]  a      `LDEC_varZ_R;
  reg     [`LDEC_VAR_BITS-1:0]  y      `LDEC_varZ_R;
  integer                opIdx;
  integer                ipIdx;
  integer                zE;
  // For pack / unpack
  integer                idx1;
  reg     `LDEC_varZ_P    yP;
    
  begin

    `LDEC_UNPACKF(aP, a, `LDEC_VAR_BITS, `LDEC_Z_MAX);    
    
    `LDEC_COPY(a, y, `LDEC_Z_MAX);   // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (shift[level] == 1'b1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (2**level < Z_SIZES2_INT(zE)) begin
            for (opIdx=0; opIdx<Z_SIZES2_INT(zE); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                  ipIdx = ipIdx - Z_SIZES2_INT(zE);
                end
                if (ipIdx < Z_SIZES2_INT(zE)) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end
 
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_VAR_BITS, `LDEC_Z_MAX);
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      yP = ldpcDecRotateDownZ_2(yP, zEnum, level-1, bottom, shift);
    end
    ldpcDecRotateDownZ_1 = yP;
  end
endfunction

function automatic `LDEC_varZ_P ldpcDecRotateDownZ_2
  (input `LDEC_varZ_P                     aP,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                         level,
   input integer                         bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;
                      
  reg     [`LDEC_VAR_BITS-1:0]  a      `LDEC_varZ_R;
  reg     [`LDEC_VAR_BITS-1:0]  y      `LDEC_varZ_R;
  integer                opIdx;
  integer                ipIdx;
  integer                zE;
  // For pack / unpack
  integer                idx1;
  reg     `LDEC_varZ_P    yP;
    
  begin

    `LDEC_UNPACKF(aP, a, `LDEC_VAR_BITS, `LDEC_Z_MAX);    
    
    `LDEC_COPY(a, y, `LDEC_Z_MAX);   // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (shift[level] == 1'b1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (2**level < Z_SIZES2_INT(zE)) begin
            for (opIdx=0; opIdx<Z_SIZES2_INT(zE); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                  ipIdx = ipIdx - Z_SIZES2_INT(zE);
                end
                if (ipIdx < Z_SIZES2_INT(zE)) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end
 
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_VAR_BITS, `LDEC_Z_MAX);
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      yP = ldpcDecRotateDownZ_3(yP, zEnum, level-1, bottom, shift);
    end
    ldpcDecRotateDownZ_2 = yP;
  end
endfunction

function automatic `LDEC_varZ_P ldpcDecRotateDownZ_3
  (input `LDEC_varZ_P                     aP,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                         level,
   input integer                         bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;
                      
  reg     [`LDEC_VAR_BITS-1:0]  a      `LDEC_varZ_R;
  reg     [`LDEC_VAR_BITS-1:0]  y      `LDEC_varZ_R;
  integer                opIdx;
  integer                ipIdx;
  integer                zE;
  // For pack / unpack
  integer                idx1;
  reg     `LDEC_varZ_P    yP;
    
  begin

    `LDEC_UNPACKF(aP, a, `LDEC_VAR_BITS, `LDEC_Z_MAX);    
    
    `LDEC_COPY(a, y, `LDEC_Z_MAX);   // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (shift[level] == 1'b1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (2**level < Z_SIZES2_INT(zE)) begin
            for (opIdx=0; opIdx<Z_SIZES2_INT(zE); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                  ipIdx = ipIdx - Z_SIZES2_INT(zE);
                end
                if (ipIdx < Z_SIZES2_INT(zE)) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end
 
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_VAR_BITS, `LDEC_Z_MAX);
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      yP = ldpcDecRotateDownZ_4(yP, zEnum, level-1, bottom, shift);
    end
    ldpcDecRotateDownZ_3 = yP;
  end
endfunction

function automatic `LDEC_varZ_P ldpcDecRotateDownZ_4
  (input `LDEC_varZ_P                     aP,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                         level,
   input integer                         bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;
                      
  reg     [`LDEC_VAR_BITS-1:0]  a      `LDEC_varZ_R;
  reg     [`LDEC_VAR_BITS-1:0]  y      `LDEC_varZ_R;
  integer                opIdx;
  integer                ipIdx;
  integer                zE;
  // For pack / unpack
  integer                idx1;
  reg     `LDEC_varZ_P    yP;
    
  begin

    `LDEC_UNPACKF(aP, a, `LDEC_VAR_BITS, `LDEC_Z_MAX);    
    
    `LDEC_COPY(a, y, `LDEC_Z_MAX);   // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (shift[level] == 1'b1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (2**level < Z_SIZES2_INT(zE)) begin
            for (opIdx=0; opIdx<Z_SIZES2_INT(zE); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                  ipIdx = ipIdx - Z_SIZES2_INT(zE);
                end
                if (ipIdx < Z_SIZES2_INT(zE)) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end
 
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_VAR_BITS, `LDEC_Z_MAX);
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      yP = ldpcDecRotateDownZ_5(yP, zEnum, level-1, bottom, shift);
    end
    ldpcDecRotateDownZ_4 = yP;
  end
endfunction

function automatic `LDEC_varZ_P ldpcDecRotateDownZ_5
  (input `LDEC_varZ_P                     aP,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                         level,
   input integer                         bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;
                      
  reg     [`LDEC_VAR_BITS-1:0]  a      `LDEC_varZ_R;
  reg     [`LDEC_VAR_BITS-1:0]  y      `LDEC_varZ_R;
  integer                opIdx;
  integer                ipIdx;
  integer                zE;
  // For pack / unpack
  integer                idx1;
  reg     `LDEC_varZ_P    yP;
    
  begin

    `LDEC_UNPACKF(aP, a, `LDEC_VAR_BITS, `LDEC_Z_MAX);    
    
    `LDEC_COPY(a, y, `LDEC_Z_MAX);   // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (shift[level] == 1'b1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (2**level < Z_SIZES2_INT(zE)) begin
            for (opIdx=0; opIdx<Z_SIZES2_INT(zE); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                  ipIdx = ipIdx - Z_SIZES2_INT(zE);
                end
                if (ipIdx < Z_SIZES2_INT(zE)) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end
 
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_VAR_BITS, `LDEC_Z_MAX);
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      yP = ldpcDecRotateDownZ_6(yP, zEnum, level-1, bottom, shift);
    end
    ldpcDecRotateDownZ_5 = yP;
  end
endfunction

function automatic `LDEC_varZ_P ldpcDecRotateDownZ_6
  (input `LDEC_varZ_P                     aP,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                         level,
   input integer                         bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;
                      
  reg     [`LDEC_VAR_BITS-1:0]  a      `LDEC_varZ_R;
  reg     [`LDEC_VAR_BITS-1:0]  y      `LDEC_varZ_R;
  integer                opIdx;
  integer                ipIdx;
  integer                zE;
  // For pack / unpack
  integer                idx1;
  reg     `LDEC_varZ_P    yP;
    
  begin

    `LDEC_UNPACKF(aP, a, `LDEC_VAR_BITS, `LDEC_Z_MAX);    
    
    `LDEC_COPY(a, y, `LDEC_Z_MAX);   // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (shift[level] == 1'b1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (2**level < Z_SIZES2_INT(zE)) begin
            for (opIdx=0; opIdx<Z_SIZES2_INT(zE); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                  ipIdx = ipIdx - Z_SIZES2_INT(zE);
                end
                if (ipIdx < Z_SIZES2_INT(zE)) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end
 
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_VAR_BITS, `LDEC_Z_MAX);
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      yP = ldpcDecRotateDownZ_7(yP, zEnum, level-1, bottom, shift);
    end
    ldpcDecRotateDownZ_6 = yP;
  end
endfunction

function automatic `LDEC_varZ_P ldpcDecRotateDownZ_7
  (input `LDEC_varZ_P                     aP,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                         level,
   input integer                         bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;
                      
  reg     [`LDEC_VAR_BITS-1:0]  a      `LDEC_varZ_R;
  reg     [`LDEC_VAR_BITS-1:0]  y      `LDEC_varZ_R;
  integer                opIdx;
  integer                ipIdx;
  integer                zE;
  // For pack / unpack
  integer                idx1;
  reg     `LDEC_varZ_P    yP;
    
  begin

    `LDEC_UNPACKF(aP, a, `LDEC_VAR_BITS, `LDEC_Z_MAX);    
    
    `LDEC_COPY(a, y, `LDEC_Z_MAX);   // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (shift[level] == 1'b1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (2**level < Z_SIZES2_INT(zE)) begin
            for (opIdx=0; opIdx<Z_SIZES2_INT(zE); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                  ipIdx = ipIdx - Z_SIZES2_INT(zE);
                end
                if (ipIdx < Z_SIZES2_INT(zE)) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end
 
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_VAR_BITS, `LDEC_Z_MAX);
      
`ifdef BRC_SIMU_ON
//synthesis translate_off
//synopsys translate_off
    if (level <= bottom)
      $error("ERROR ldpcDecRotateDownZ recursion level reached");      
//synthesis translate_on
//synopsys translate_on
`endif //BRC_SIMU_ON
    ldpcDecRotateDownZ_7 = yP;
  end
endfunction

