// This function is recursive, but here we do a manually expanded version for tools
// that cannot support this.
// (c) Copyright 2012, Blue Rum Consulting Limited, All Rights Reserved.

// Rotate a, which is of length Z_MAX, by 2^level if shift(level)===1. Called
// recursively to rotate for all bits of shift.

function automatic [`LDEC_Z_MAX-1:0] ldpcDecRotateDownZ1
  (input [`LDEC_Z_MAX-1:0]               a,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);
                      
  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;

  reg [`LDEC_Z_MAX-1:0]      y;
  //integer             offset;
  integer               opIdx;
  integer               ipIdx;
  integer               zE;
    
  begin
    
    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      for (opIdx=0; opIdx<=`LDEC_Z_MAX-1; opIdx=opIdx+1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (($signed(zE[ZE_LEFT+1:0]) == $signed({1'b0, zEnum})) &&
              (opIdx < Z_SIZES2_INT(zE))) begin
            if (shift[level] == 1'b1) begin
              ipIdx = opIdx + 2**level;
              if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                ipIdx = ipIdx - Z_SIZES2_INT(zE);
              end
              if (ipIdx < Z_SIZES2_INT(zE)) begin
                y[opIdx] = a[ipIdx];
              end
            end
          end
        end
      end
    end 
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = ldpcDecRotateDownZ1_1(y, zEnum, level-1, bottom, shift);
    end
    ldpcDecRotateDownZ1 = y;
  end
endfunction

function automatic [`LDEC_Z_MAX-1:0] ldpcDecRotateDownZ1_1
  (input [`LDEC_Z_MAX-1:0]               a,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);
                      
  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;

  reg [`LDEC_Z_MAX-1:0]      y;
  //integer             offset;
  integer               opIdx;
  integer               ipIdx;
  integer               zE;
    
  begin
    
    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      for (opIdx=0; opIdx<=`LDEC_Z_MAX-1; opIdx=opIdx+1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (($signed(zE[ZE_LEFT+1:0]) == $signed({1'b0, zEnum})) &&
              (opIdx < Z_SIZES2_INT(zE))) begin
            if (shift[level] == 1'b1) begin
              ipIdx = opIdx + 2**level;
              if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                ipIdx = ipIdx - Z_SIZES2_INT(zE);
              end
              if (ipIdx < Z_SIZES2_INT(zE)) begin
                y[opIdx] = a[ipIdx];
              end
            end
          end
        end
      end
    end 
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = ldpcDecRotateDownZ1_2(y, zEnum, level-1, bottom, shift);
    end
    ldpcDecRotateDownZ1_1 = y;
  end
endfunction

function automatic [`LDEC_Z_MAX-1:0] ldpcDecRotateDownZ1_2
  (input [`LDEC_Z_MAX-1:0]               a,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);
                      
  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;

  reg [`LDEC_Z_MAX-1:0]      y;
  //integer             offset;
  integer               opIdx;
  integer               ipIdx;
  integer               zE;
    
  begin
    
    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      for (opIdx=0; opIdx<=`LDEC_Z_MAX-1; opIdx=opIdx+1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (($signed(zE[ZE_LEFT+1:0]) == $signed({1'b0, zEnum})) &&
              (opIdx < Z_SIZES2_INT(zE))) begin
            if (shift[level] == 1'b1) begin
              ipIdx = opIdx + 2**level;
              if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                ipIdx = ipIdx - Z_SIZES2_INT(zE);
              end
              if (ipIdx < Z_SIZES2_INT(zE)) begin
                y[opIdx] = a[ipIdx];
              end
            end
          end
        end
      end
    end 
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = ldpcDecRotateDownZ1_3(y, zEnum, level-1, bottom, shift);
    end
    ldpcDecRotateDownZ1_2 = y;
  end
endfunction

function automatic [`LDEC_Z_MAX-1:0] ldpcDecRotateDownZ1_3
  (input [`LDEC_Z_MAX-1:0]               a,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);
                      
  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;

  reg [`LDEC_Z_MAX-1:0]      y;
  //integer             offset;
  integer               opIdx;
  integer               ipIdx;
  integer               zE;
    
  begin
    
    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      for (opIdx=0; opIdx<=`LDEC_Z_MAX-1; opIdx=opIdx+1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (($signed(zE[ZE_LEFT+1:0]) == $signed({1'b0, zEnum})) &&
              (opIdx < Z_SIZES2_INT(zE))) begin
            if (shift[level] == 1'b1) begin
              ipIdx = opIdx + 2**level;
              if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                ipIdx = ipIdx - Z_SIZES2_INT(zE);
              end
              if (ipIdx < Z_SIZES2_INT(zE)) begin
                y[opIdx] = a[ipIdx];
              end
            end
          end
        end
      end
    end 
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = ldpcDecRotateDownZ1_4(y, zEnum, level-1, bottom, shift);
    end
    ldpcDecRotateDownZ1_3 = y;
  end
endfunction

function automatic [`LDEC_Z_MAX-1:0] ldpcDecRotateDownZ1_4
  (input [`LDEC_Z_MAX-1:0]               a,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);
                      
  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;

  reg [`LDEC_Z_MAX-1:0]      y;
  //integer             offset;
  integer               opIdx;
  integer               ipIdx;
  integer               zE;
    
  begin
    
    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      for (opIdx=0; opIdx<=`LDEC_Z_MAX-1; opIdx=opIdx+1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (($signed(zE[ZE_LEFT+1:0]) == $signed({1'b0, zEnum})) &&
              (opIdx < Z_SIZES2_INT(zE))) begin
            if (shift[level] == 1'b1) begin
              ipIdx = opIdx + 2**level;
              if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                ipIdx = ipIdx - Z_SIZES2_INT(zE);
              end
              if (ipIdx < Z_SIZES2_INT(zE)) begin
                y[opIdx] = a[ipIdx];
              end
            end
          end
        end
      end
    end 
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = ldpcDecRotateDownZ1_5(y, zEnum, level-1, bottom, shift);
    end
    ldpcDecRotateDownZ1_4 = y;
  end
endfunction

function automatic [`LDEC_Z_MAX-1:0] ldpcDecRotateDownZ1_5
  (input [`LDEC_Z_MAX-1:0]               a,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);
                      
  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;

  reg [`LDEC_Z_MAX-1:0]      y;
  //integer             offset;
  integer               opIdx;
  integer               ipIdx;
  integer               zE;
    
  begin
    
    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      for (opIdx=0; opIdx<=`LDEC_Z_MAX-1; opIdx=opIdx+1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (($signed(zE[ZE_LEFT+1:0]) == $signed({1'b0, zEnum})) &&
              (opIdx < Z_SIZES2_INT(zE))) begin
            if (shift[level] == 1'b1) begin
              ipIdx = opIdx + 2**level;
              if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                ipIdx = ipIdx - Z_SIZES2_INT(zE);
              end
              if (ipIdx < Z_SIZES2_INT(zE)) begin
                y[opIdx] = a[ipIdx];
              end
            end
          end
        end
      end
    end 
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = ldpcDecRotateDownZ1_6(y, zEnum, level-1, bottom, shift);
    end
    ldpcDecRotateDownZ1_5 = y;
  end
endfunction

function automatic [`LDEC_Z_MAX-1:0] ldpcDecRotateDownZ1_6
  (input [`LDEC_Z_MAX-1:0]               a,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);
                      
  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;

  reg [`LDEC_Z_MAX-1:0]      y;
  //integer             offset;
  integer               opIdx;
  integer               ipIdx;
  integer               zE;
    
  begin
    
    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      for (opIdx=0; opIdx<=`LDEC_Z_MAX-1; opIdx=opIdx+1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (($signed(zE[ZE_LEFT+1:0]) == $signed({1'b0, zEnum})) &&
              (opIdx < Z_SIZES2_INT(zE))) begin
            if (shift[level] == 1'b1) begin
              ipIdx = opIdx + 2**level;
              if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                ipIdx = ipIdx - Z_SIZES2_INT(zE);
              end
              if (ipIdx < Z_SIZES2_INT(zE)) begin
                y[opIdx] = a[ipIdx];
              end
            end
          end
        end
      end
    end 
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = ldpcDecRotateDownZ1_7(y, zEnum, level-1, bottom, shift);
    end
    ldpcDecRotateDownZ1_6 = y;
  end
endfunction

function automatic [`LDEC_Z_MAX-1:0] ldpcDecRotateDownZ1_7
  (input [`LDEC_Z_MAX-1:0]               a,
   input [numBits(`LDEC_Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`LDEC_Z_MAX-1)-1:0]    shift);
                      
  localparam ZE_LEFT = numBits(`LDEC_Z_ENUM_MAX)-1;

  reg [`LDEC_Z_MAX-1:0]      y;
  //integer             offset;
  integer               opIdx;
  integer               ipIdx;
  integer               zE;
    
  begin
    
    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      for (opIdx=0; opIdx<=`LDEC_Z_MAX-1; opIdx=opIdx+1) begin
        for (zE=0; zE<=`LDEC_Z_ENUM_MAX; zE=zE+1) begin
          if (($signed(zE[ZE_LEFT+1:0]) == $signed({1'b0, zEnum})) &&
              (opIdx < Z_SIZES2_INT(zE))) begin
            if (shift[level] == 1'b1) begin
              ipIdx = opIdx + 2**level;
              if (ipIdx > Z_SIZES2_INT(zE)-1) begin
                ipIdx = ipIdx - Z_SIZES2_INT(zE);
              end
              if (ipIdx < Z_SIZES2_INT(zE)) begin
                y[opIdx] = a[ipIdx];
              end
            end
          end
        end
      end
    end 

    // Do shifts recursively for lower levels.
`ifdef BRC_SIMU_ON
//synthesis translate_off
//synopsys translate_off
    if (level <= bottom)
      $error("ERROR ldpcDecRotateDownZ1 recursion level reached");      
//synthesis translate_on
//synopsys translate_on
`endif //BRC_SIMU_ON
    ldpcDecRotateDownZ1_7 = y;
  end
endfunction

