// This function is recursive, but here we do a manually expanded version for tools
// that cannot support this.
// (c) Copyright 2012, Blue Rum Consulting Limited, All Rights Reserved.

// Shift down a by 2^level if shift(level)===1. Called recursively to rotate
// for all bits of shift.
`define LDEC_CR_HI `LDEC_DEC_RAM_IP_WIDTH - 2 + `LDEC_IP_WIDTH*(1+`LDEC_IP_STALL_OK)

function automatic `LDEC_ip2DCr_P  ldpcDecShiftDown 
  (input `LDEC_ip2DCr_P   aP,
   input integer                               level,
   input integer                               bottom,
   input [numBits(`LDEC_DEC_RAM_IP_WIDTH)-1:0] shift);
  
  reg [`LDEC_IP_BITS-1:0]       a       `LDEC_ip2DCr_R;
  reg [`LDEC_IP_BITS-1:0]       y       `LDEC_ip2DCr_R;
  integer                       opIdx;
  // For pack / unpack
  integer                       idx1;
  reg `LDEC_ip2DCr_P            yP;
  
  begin
//`define LDEC_UNPACKF(src, dest, w0, w1) for (idx1=0; idx1<(w1); idx1=idx1+1) dest[idx1] = src[(1+idx1)*(w0)-1 : idx1*(w0)];

    `LDEC_UNPACKF(aP, a, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    
    // default for no shift
    for (opIdx=0; opIdx<=`LDEC_CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`LDEC_CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      yP = ldpcDecShiftDown1(yP, level-1, bottom, shift);
    end
    
    ldpcDecShiftDown = yP;
   
  end
endfunction

function automatic `LDEC_ip2DCr_P  ldpcDecShiftDown1
  (input `LDEC_ip2DCr_P   aP,
   input integer                               level,
   input integer                               bottom,
   input [numBits(`LDEC_DEC_RAM_IP_WIDTH)-1:0] shift);
  
  reg [`LDEC_IP_BITS-1:0]      a       `LDEC_ip2DCr_R;
  reg [`LDEC_IP_BITS-1:0]      y       `LDEC_ip2DCr_R;
  integer                      opIdx;
  // For pack / unpack
  integer                      idx1;
  reg `LDEC_ip2DCr_P           yP;
  
  begin

    `LDEC_UNPACKF(aP, a, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    
    // default for no shift
    for (opIdx=0; opIdx<=`LDEC_CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`LDEC_CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      yP = ldpcDecShiftDown2(yP, level-1, bottom, shift);
    end
    
    ldpcDecShiftDown1 = yP;
   
  end
endfunction

function automatic `LDEC_ip2DCr_P  ldpcDecShiftDown2
  (input `LDEC_ip2DCr_P   aP,
   input integer                               level,
   input integer                               bottom,
   input [numBits(`LDEC_DEC_RAM_IP_WIDTH)-1:0] shift);
  
  reg [`LDEC_IP_BITS-1:0]                      a       `LDEC_ip2DCr_R;
  reg [`LDEC_IP_BITS-1:0]                      y       `LDEC_ip2DCr_R;
  integer                                      opIdx;
  // For pack / unpack
  integer                                      idx1;
  reg `LDEC_ip2DCr_P                           yP;
  
  begin

    `LDEC_UNPACKF(aP, a, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    
    // default for no shift
    for (opIdx=0; opIdx<=`LDEC_CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`LDEC_CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      yP = ldpcDecShiftDown3(yP, level-1, bottom, shift);
    end
    
    ldpcDecShiftDown2 = yP;
   
  end
endfunction

function automatic `LDEC_ip2DCr_P  ldpcDecShiftDown3
  (input `LDEC_ip2DCr_P   aP,
   input integer                               level,
   input integer                               bottom,
   input [numBits(`LDEC_DEC_RAM_IP_WIDTH)-1:0] shift);
  
  reg [`LDEC_IP_BITS-1:0]                      a       `LDEC_ip2DCr_R;
  reg [`LDEC_IP_BITS-1:0]                      y       `LDEC_ip2DCr_R;
  integer                                      opIdx;
  // For pack / unpack
  integer                                      idx1;
  reg `LDEC_ip2DCr_P                           yP;
  
  begin

    `LDEC_UNPACKF(aP, a, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    
    // default for no shift
    for (opIdx=0; opIdx<=`LDEC_CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`LDEC_CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      yP = ldpcDecShiftDown4(yP, level-1, bottom, shift);
    end
    
    ldpcDecShiftDown3 = yP;
   
  end
endfunction

function automatic `LDEC_ip2DCr_P  ldpcDecShiftDown4
  (input `LDEC_ip2DCr_P   aP,
   input integer                               level,
   input integer                               bottom,
   input [numBits(`LDEC_DEC_RAM_IP_WIDTH)-1:0] shift);
  
  reg [`LDEC_IP_BITS-1:0]                      a       `LDEC_ip2DCr_R;
  reg [`LDEC_IP_BITS-1:0]                      y       `LDEC_ip2DCr_R;
  integer                                      opIdx;
  // For pack / unpack
  integer                                      idx1;
  reg `LDEC_ip2DCr_P                            yP;
  
  begin

    `LDEC_UNPACKF(aP, a, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    
    // default for no shift
    for (opIdx=0; opIdx<=`LDEC_CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`LDEC_CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      yP = ldpcDecShiftDown5(yP, level-1, bottom, shift);
    end
    
    ldpcDecShiftDown4 = yP;
   
  end
endfunction

function automatic `LDEC_ip2DCr_P  ldpcDecShiftDown5
  (input `LDEC_ip2DCr_P   aP,
   input integer                               level,
   input integer                               bottom,
   input [numBits(`LDEC_DEC_RAM_IP_WIDTH)-1:0] shift);
  
  reg [`LDEC_IP_BITS-1:0]                      a       `LDEC_ip2DCr_R;
  reg [`LDEC_IP_BITS-1:0]                      y       `LDEC_ip2DCr_R;
  integer                                      opIdx;
  // For pack / unpack
  integer                                      idx1;
  reg `LDEC_ip2DCr_P                           yP;
  
  begin

    `LDEC_UNPACKF(aP, a, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    
    // default for no shift
    for (opIdx=0; opIdx<=`LDEC_CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`LDEC_CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      yP = ldpcDecShiftDown6(yP, level-1, bottom, shift);
    end
    
    ldpcDecShiftDown5 = yP;
   
  end
endfunction

function automatic `LDEC_ip2DCr_P  ldpcDecShiftDown6
  (input `LDEC_ip2DCr_P   aP,
   input integer                               level,
   input integer                               bottom,
   input [numBits(`LDEC_DEC_RAM_IP_WIDTH)-1:0] shift);
  
  reg [`LDEC_IP_BITS-1:0]                      a       `LDEC_ip2DCr_R;
  reg [`LDEC_IP_BITS-1:0]                      y       `LDEC_ip2DCr_R;
  integer                                      opIdx;
  // For pack / unpack
  integer                                      idx1;
  reg `LDEC_ip2DCr_P                           yP;
  
  begin

    `LDEC_UNPACKF(aP, a, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    
    // default for no shift
    for (opIdx=0; opIdx<=`LDEC_CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`LDEC_CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      yP = ldpcDecShiftDown7(yP, level-1, bottom, shift);
    end
    
    ldpcDecShiftDown6 = yP;
   
  end
endfunction

function automatic `LDEC_ip2DCr_P  ldpcDecShiftDown7 
  (input `LDEC_ip2DCr_P   aP,
   input integer                               level,
   input integer                               bottom,
   input [numBits(`LDEC_DEC_RAM_IP_WIDTH)-1:0] shift);
  
  reg [`LDEC_IP_BITS-1:0]                      a       `LDEC_ip2DCr_R;
  reg [`LDEC_IP_BITS-1:0]                      y       `LDEC_ip2DCr_R;
  integer                                      opIdx;
  // For pack / unpack
  integer                                      idx1;
  reg `LDEC_ip2DCr_P                           yP;
  
  begin

    `LDEC_UNPACKF(aP, a, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    
    // default for no shift
    for (opIdx=0; opIdx<=`LDEC_CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`LDEC_CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    
`ifdef BRC_SIMU_ON
//synthesis translate_off
//synopsys translate_off
    if (level <= bottom)
      $error("ERROR ldpcDecShiftDown function needs more levels.");
//synthesis translate_on
//synopsys translate_on
`endif //BRC_SIMU_ON
    
    yP = {`LDEC_Z_MAX*`LDEC_VAR_BITS{1'b0}};
    `LDEC_PACKF(y, yP, `LDEC_IP_BITS, `LDEC_CR_HI+1);
    ldpcDecShiftDown7 = yP;
  end
endfunction
