//------------------------------------------------------------------------------
// ldpcDecTrueDpRam.v
// 
// Description:
//   Dual port RAM model. This should not appear in your ASIC synthesis as the
//   Wrap block should have been changed to instance generated ASIC RAMs.
//
//   generics
//     depth     number of addressable locations.
//     width     bit width of data port.
//     weWidth   Number of data bits that are write-enabled by each
//                write-enable. Put weWidth width to just have one write enable.
//
// 04 May 2010 M. Rumsey. Created.
//
// # (parameter c) ( Copyright 2010, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcDec.vh"

module ldpcDecTrueDpRam # (parameter depth = 32, width = 8) (  
   // A port
   input                        ckA,
   input                        selA,
   input [numBits(depth-1)-1:0] addrA,
   input [width-1:0]            dInA,
   input                        weA,
   output reg [width-1:0]       dOutA,
   // B port
   input                        ckB,
   input                        selB,
   input [numBits(depth-1)-1:0] addrB,
   input [width-1:0]            dInB,
   input                        weB,
   output reg [width-1:0]       dOutB);

`include "ldpcDecFuncs.vh"

  reg [width-1:0] mem [depth-1:0]; 

  //---------------------------------------------------------------------------
  // Write for both ports
  //---------------------------------------------------------------------------

  always @(posedge(ckA))
  begin : pWriteA 
    if (selA == 1'b1) begin
      if (weA == 1'b1) begin
        mem[addrA] = dInA;
      end
    end
  end //pWriteA
  
  always @(posedge(ckB))
  begin : pWriteB 
    if (selB == 1'b1) begin
      if (weB == 1'b1) begin
        mem[addrB] = dInB;
      end
    end
  end //pWriteB
  
  //---------------------------------------------------------------------------
  // Port A Read
  //---------------------------------------------------------------------------

  always @(posedge(ckA))
  begin : pReadA 
    if (selA == 1'b1) begin
      dOutA <= mem[addrA];
    end
  end //pReadA


  //---------------------------------------------------------------------------
  // Port B Read
  //---------------------------------------------------------------------------

  always @(posedge(ckB))
  begin : pReadB 
    if (selB == 1'b1) begin
      dOutB <= mem[addrB];
    end
  end //pReadB

endmodule

    
    

