//------------------------------------------------------------------------------
// ldpcDecVmRam.v
// 
// Description:
//   RAM wrapper for the Vm RAM. 
//
// 30 Apr 2010 M. Rumsey. Created.
// 04 Apr 2011 M. Rumsey. `USE_ALT_RAMS added.
// 11 May 2011 M. Rumsey. Muxing that was here is now pushed up to decVmMux 
//                        and vmDecRam is now just a simple RAM wrapper.
//
// (c) Copyright 2010-2011, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcDec.vh"

module ldpcDecVmRam
  (  
     input                       ck,
     // A port for read
     input                       selA,
     input [`LDEC_VM_RAM_A-1:0]  addrA,
     output [`LDEC_VM_RAM_W-1:0] dOutA,
     // B port for write
     input [`LDEC_VM_RAM_A-1:0]  addrB,
     input [`LDEC_VM_RAM_W-1:0]  dInB,
     input [`LDEC_VM_RAM_WE-1:0] weB);
  

`include "ldpcDecFuncs.vh"

  // If `BWD_FWD_LATENCY==1 begin data written to an address on a clock edge should be
  // addressable for read in the same cycle so that the new data appears
  // following the clock edge. This is 'write-first || read after write behaviour'.
  // `BWD_FWD_LATENCY>1 gives an extra cycle and is supported by all rams.
  // `BWD_FWD_LATENCY==0 results in a bypass mux in ldpcDecVmMem.

    generate
      if (`LDEC_BWD_FWD_LATENCY == 1) begin: gWriteFirst
        
        ldpcDecDpWeWrFirstRam 
          # (.depth   (`LDEC_VM_RAM_D),
             .width   (`LDEC_VM_RAM_W),
             .weWidth (`LDEC_DEC_RAM_IP_WIDTH*`LDEC_VAR_BITS))
        vmRam (// Write Port
              .ck     (ck),
              .wrAddr (addrB),
              .dIn    (dInB),
              .we     (weB),
              // Read port
              .sel    (selA),
              .rdAddr (addrA),
              .dOut   (dOutA));
        
      end else begin

        ldpcDecDpWeRam 
          # (.depth   (`LDEC_VM_RAM_D),
             .width   (`LDEC_VM_RAM_W),
             .weWidth (`LDEC_DEC_RAM_IP_WIDTH*`LDEC_VAR_BITS),
             .xChk    (0))
        vmRam (
          // Write Port
          .ck     (ck),
          .wrAddr (addrB),
          .dIn    (dInB),
          .we     (weB),
          // Read port
          .sel    (selA),
          .rdAddr (addrA),
          .dOut   (dOutA));

      end
    endgenerate //  gRegular
  
endmodule

    
    

