//------------------------------------------------------------------------------
// ldcpDecVrRam.sv
// 
// Description:
//   RAM wrapper for the Variable Response RAM.
//
// 8 June 2010 M. Rumsey. Created.
//
// (c) Copyright 2010, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcDec.vh"

module ldpcDecVrRam
( 
  input                       ck,
  // A port
  input [`LDEC_VR_RAM_A-1:0]  addrA,
  input [`LDEC_VR_RAM_W-1:0]  dInA,
  input                       weA,
  // B port
  input                       selB,
  input [`LDEC_VR_RAM_A-1:0]  addrB,
  output [`LDEC_VR_RAM_W-1:0] dOutB);

`include "ldpcDecFuncs.vh"

  ldpcDecDpRam # (
      .depth   (`LDEC_VR_RAM_D),
      .width   (`LDEC_VR_RAM_W))

  vrRam (
      // Write port
      .ck     (ck),
      .wrAddr (addrA),
      .dIn    (dInA),
      .we     (weA),
      // Read port
      .sel    (selB),
      .rdAddr (addrB),
      .dOut   (dOutB));

endmodule

    
    

