/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module ofdm_rx_bd
(
  /*****************************************************************************
  * system 
  *****************************************************************************/
  input  wire         phy_rst_n,
  input  wire         phy_clk,
  
  input  wire         vtb_rst_n,
  input  wire         vtb_clk,
  output wire         vtb_clken,
  input  wire         vtbcore0_clk,
  output wire         vtbcore0_clken,
  
`ifdef RW_NX_LDPC_DEC
  input  wire         ldpcrx0_rst_n,
  input  wire         ldpcrx0_clk,
  input  wire         ldpcrx0_dec_clk,
  output wire         ldpcrx0_clken,
  output wire         ldpcrx0_dec_clken,
`endif // RW_NX_LDPC_DEC

  /*****************************************************************************
  * modem configuration 
  *****************************************************************************/
  input  wire [  1:0] mdmcfg_conf_bw,
  input  wire [  2:0] mdmcfg_conf_primary,
  input  wire         mdmcfg_qam256_en,
  input  wire         mdmcfg_qam1024_en,
  input  wire         mdmcfg_htmm_en,
  input  wire         mdmcfg_htgf_en,
  input  wire         mdmcfg_vht_en,
  input  wire         mdmcfg_he_en,
  input  wire         mdmcfg_stbc_en,
  input  wire         mdmcfg_ldpc_en,
  input  wire         mdmcfg_dcm_en,
  input  wire [  5:0] mdmcfg_ldpcdec_llrunity,
  input  wire [  2:0] mdmcfg_nss_max,
  input  wire [  2:0] mdmcfg_ndp_nsts_max,
  input  wire [ 15:0] mdmcfg_bcc_lgi_ndbps_max,
  input  wire [ 15:0] mdmcfg_bcc_sgi_ndbps_max,
  input  wire [ 15:0] mdmcfg_ldpc_lgi_ndbps_max,
  input  wire [ 15:0] mdmcfg_ldpc_sgi_ndbps_max,
  input  wire [ 35:0] mdmcfg_frame_violation_mask,
  input  wire [ 31:0] mdmcfg_he_frame_violation_mask,
  input  wire         mdmcfg_vht_mumimo_en,
  input  wire         mdmcfg_he_mumimo_en,
  input  wire [ 63:0] mdmcfg_vht_membershipstat,
  input  wire [127:0] mdmcfg_vht_userposid,
  input  wire [ 10:0] mdmcfg_he_staid0,
  input  wire [ 10:0] mdmcfg_he_staid1,
  input  wire [ 10:0] mdmcfg_he_staid2,
  input  wire [ 10:0] mdmcfg_he_staid3,
  
  /*****************************************************************************
  * main fsm
  *****************************************************************************/
  input  wire         enable,
  output wire         done,
  
  output wire         mfsm_rxv_update,
  output wire         mfsm_frame_unsupported,
  output wire         mfsm_frame_violation,
  output wire         mfsm_phy_error,
 
  /*****************************************************************************
  * AGC/CCA
  *****************************************************************************/
  output wire         cca_lsig_valid,
  output wire         cca_htsig_vhtsiga_valid,
  
  /*****************************************************************************
  * FD/BD pointers
  *****************************************************************************/
  input  wire         bdfd_wrptr,
  output wire         bdfd_rdptr,
  input  wire [ 2:0]  bdfd_ch0_wrptr,
  output wire [ 2:0]  bdfd_ch0_rdptr,
  input  wire [ 2:0]  bdfd_ch1_wrptr,
  output wire [ 2:0]  bdfd_ch1_rdptr,
  input  wire         bdfd_qbpsk,
 
  input  wire [ 2:0]  bdfd_row_fifo_wrptr,
  output wire [ 2:0]  bdfd_row_fifo_rdptr,
  
  /* bcc */
  output wire         bdfd_bcc_rsel,
  output wire         bdfd_bcc_ren,
  output wire [ 8:0]  bdfd_bcc_raddr,
  input  wire [39:0]  bdfd_bcc_rdata,
  
`ifdef RW_NX_LDPC_DEC
  /* ldpc */
  output wire         bdfd_ldpc_ready,
  input  wire [59:0]  bdfd_ldpc_data,
  input  wire [ 3:0]  bdfd_ldpc_len,
  input  wire         bdfd_ldpc_last, 
  input  wire         bdfd_ldpc_valid,
  
  /*****************************************************************************
  * LDPC 
  *****************************************************************************/
  /* Config data interface */
  output wire [`RW_LDPCCFGRAM_AWIDTH-1:0] ldec0_cfg_addr,
  output wire                             ldec0_cfg_addr_update,
  input  wire [28:0]                      ldec0_cfg_data,
  input  wire                             ldec0_cfg_data_update,
  
  /*  LDPC0 Memories */
  // Cr _s
  output wire [6:0]       ldpcrx0_cr_waddr,   
  output wire [6:0]       ldpcrx0_cr_raddr,   
  output wire [485:0]     ldpcrx0_cr_wdata,   
  output wire             ldpcrx0_cr_ren,     
  output wire             ldpcrx0_cr_wen,     
  input  wire  [485:0]    ldpcrx0_cr_rdata,   
  // Vr _s
  output wire [4:0]       ldpcrx0_vr_waddr,   
  output wire [4:0]       ldpcrx0_vr_raddr,   
  output wire [647:0]     ldpcrx0_vr_wdata,   
  output wire             ldpcrx0_vr_ren,     
  output wire             ldpcrx0_vr_wen,     
  input  wire [647:0]     ldpcrx0_vr_rdata,   
  // VM _s
  output wire [4:0]       ldpcrx0_vmx_waddr,  
  output wire [4:0]       ldpcrx0_vmx_raddr,  
  output wire [647:0]     ldpcrx0_vmx_wdata,  
  output wire             ldpcrx0_vmx_ren,    
  output wire [`RW_NX_DERIV_LDPC_VMWE_WIDTH-1:0] ldpcrx0_vmx_wen,    
  input  wire [647:0]     ldpcrx0_vmx_rdata,  

  output wire [4:0]       ldpcrx0_vmy_waddr,  
  output wire [4:0]       ldpcrx0_vmy_raddr,  
  output wire [647:0]     ldpcrx0_vmy_wdata,  
  output wire             ldpcrx0_vmy_ren,    
  output wire [`RW_NX_DERIV_LDPC_VMWE_WIDTH-1:0] ldpcrx0_vmy_wen,
  input  wire [647:0]     ldpcrx0_vmy_rdata,  
  // HD _s
  output wire [4:0]       ldpcrx0_hd_waddr,   
  output wire [80:0]      ldpcrx0_hd_wdata,   

  output wire [4:0]       ldpcrx0_hdx_raddr,  
  input  wire [80:0]      ldpcrx0_hdx_rdata,  
  output wire             ldpcrx0_hdx_ren,    
  output wire             ldpcrx0_hdx_wen,    
  
  output wire [4:0]       ldpcrx0_hdy_raddr,  
  output wire             ldpcrx0_hdy_wen,  
  output wire             ldpcrx0_hdy_ren,    
  input  wire [80:0]      ldpcrx0_hdy_rdata,

  /*****************************************************************************
  * diags
  *****************************************************************************/
  output wire [15:0]      ldpc_rx_dbg0,  
  output wire [15:0]      ldpc_rx_dbg1,  
  output wire [15:0]      ldpc_rx_dbg2,  
  output wire [15:0]      ldpc_rx_dbg3,  
  output wire [15:0]      ldpc_rx_dbg4,  
  output wire [15:0]      ldpc_rx_dbg5,  
  output wire [15:0]      ldpc_rx_dbg6,  
  output wire [15:0]      ldpc_rx_dbg7,  
  output wire [15:0]      ldpc_rx_dbg8,  
  output wire [15:0]      ldpc_rx_dbg9,  
  output wire [15:0]      ldpc_rx_dbg10,  
`endif // RW_NX_LDPC_DEC

  /*****************************************************************************
  * frame parameters
  *****************************************************************************/
  /* part 1 */
  output wire             framep1_update,
  output wire [ 3:0]      framep1_format,
  output wire [ 1:0]      framep1_nsd,
  output wire [ 1:0]      framep1_cr,
  output wire [ 2:0]      framep1_nbpsc,
  output wire [ 2:0]      framep1_nss,
  output wire [ 2:0]      framep1_nsts,
  output wire [ 1:0]      framep1_ness,
  output wire             framep1_stbc,
  output wire             framep1_fec,
  output wire             framep1_smoothing,
  output wire             framep1_htndp,
  output wire             framep1_mumimo,
  output wire             framep1_beamformed,
  output wire [ 2:0]      framep1_vhtmu_nsts_tot,
  output wire [ 2:0]      framep1_vhtmu_nsts_prev,
  output wire [ 1:0]      framep1_vhtmu_userpos,
  output wire             framep1_dcm,
  output wire [ 2:0]      framep1_rulen,
  output wire [ 1:0]      framep1_gi_type,
  output wire [ 6:0]      framep1_mcs,
  output wire [ 3:0]      framep1_legrate,
  output wire [ 2:0]      framep1_bandwidth,
  output wire             framep1_vhtndp,
  output wire [ 2:0]      framep1_hesigb_mcs, 
  output wire             framep1_hesigb_dcm, 
  output wire [ 2:0]      framep1_hesigb_nbpsc,
  output wire [ 1:0]      framep1_hesigb_cr,
  output wire [ 7:0]      framep1_hesigb_ndbps,
  output wire [ 2:0]      framep1_nheltf, 
  output wire [ 1:0]      framep1_heltftype, 
  output wire             framep1_doppler, 
  output wire             framep1_midamble, 
  /* part 2 */
  output wire             framep2_update,
  output wire [ 2:0]      framep2_mu_nbpsc,
  output wire             framep2_hemu_beamformed,
  output wire             framep2_hemu_rusegment,
  output wire [ 2:0]      framep2_hemu_rulen,
  output wire [ 5:0]      framep2_hemu_ruindex,
  output wire [ 3:0]      framep2_hemu_runuser,
  output wire [ 2:0]      framep2_hemu_ruuser,
  output wire             framep2_hemu_dcm,
  output wire [ 2:0]      framep2_hemu_nsts,
  output wire [ 2:0]      framep2_hemu_nsts_tot,
  output wire [ 2:0]      framep2_hemu_nsts_prev,
  output wire             framep2_hemu_fec,
  /* part 3 */
  output wire             framep3_update,
  output wire             framep3_he_confirmed,
  /* part 4 */
  output wire             framep4_update,
  output wire             framep4_lsig6m,
  /* part 5 */
  output wire [11:0]      framep5_ncw,
  output wire [ 1:0]      framep5_lldpc,
  output wire [11:0]      framep5_nshrtq,
  output wire [11:0]      framep5_nshrtr,
  output wire [11:0]      framep5_npuncq,
  output wire [11:0]      framep5_npuncr,
  output wire [13:0]      framep5_nrepq,
  output wire [11:0]      framep5_nrepr,
  /* part 6 */
  output wire             framep6_update,
  output wire             framep6_l_length_mod3_eq_1,
  /* part 7 */
  output wire             framep7_update,
  output wire [ 7:0]      framep7_hesigb_nsym,
  /* part 8 */
  output wire             framep8_update,
  output wire [15:0]      framep8_nsym,
  output wire [ 2:0]      framep8_tpe,
  output wire [ 8:0]      framep8_nma,
  output wire [15:0]      framep8_ncbps,
 
  /*****************************************************************************
  * MAC/PHY interface
  *****************************************************************************/
  /* rxvector */
  output wire             rxv1_update,
  output wire [ 3:0]      rxv1_format,
  output wire [ 2:0]      rxv1_ch_bandwidth,
  output wire             rxv2_update,
  output wire [11:0]      rxv2_l_length,
  output wire [ 3:0]      rxv2_l_rate,
  output wire [ 7:0]      rxv2_rssi,
  output wire             rxv2_dyn_bandwidth_in_non_ht,
  output wire [ 1:0]      rxv2_ch_bandwidth_in_non_ht,
  output wire             rxv2_sounding,
  output wire             rxv2_smoothing,
  output wire [ 1:0]      rxv2_gi_type,
  output wire             rxv2_aggregation,
  output wire             rxv2_stbc,
  output wire [ 1:0]      rxv2_num_ext_ss,
  output wire             rxv2_l_sig_valid,
  output wire             rxv2_beamformed,
  output wire             rxv2_doze_not_allowed,
  output wire             rxv2_first_user,
  output wire [ 8:0]      rxv2_partial_aid,
  output wire [ 5:0]      rxv2_group_id,
  output wire [ 6:0]      rxv2_mcs,
  output wire [ 2:0]      rxv2_nss,
  output wire             rxv2_fec_coding,
  output wire [19:0]      rxv2_length,
  output wire             rxv2_uplink_flag,
  output wire             rxv2_beam_change,
  output wire             rxv2_dcm,
  output wire [ 2:0]      rxv2_rulen,
  output wire [ 1:0]      rxv2_he_ltf_type,
  output wire             rxv2_doppler,
  output wire [ 5:0]      rxv2_bss_color,
  output wire [ 6:0]      rxv2_txop_duration,
  output wire [ 3:0]      rxv2_pe_duration,
  output wire [ 3:0]      rxv2_spatial_reuse,
  output wire             rxv2_sig_b_compression_mode,
  output wire             rxv2_dcm_sig_b,
  output wire [ 2:0]      rxv2_mcs_sig_b,
  output wire [ 7:0]      rxv2_n_user,
  output wire [10:0]      rxv2_staid,
  /* data */
  input  wire             mpif_ready,
  output wire [ 7:0]      mpif_data,              
  output wire             mpif_last,         
  output wire             mpif_valid,
  
  /*****************************************************************************
  * diag
  *****************************************************************************/
  output  wire [15:0]     diag0,
  output  wire [15:0]     diag1,
  output  wire [15:0]     diag2,
  output  wire [15:0]     diag3
  
);
  /*****************************************************************************
  * DECLARATIONS
  *****************************************************************************/
  /* global bd control */
  wire         bd_bcc_enable;
  wire         bd_ldpc_enable;
  wire         bd_sigen;
  wire         bd_fec;            
  wire         bd_dcm;            
  wire         bd_qbpsk;
  wire [ 1:0]  bd_nsd;            
  wire         bd_ruen;            
  wire [ 2:0]  bd_rulen;            
  wire         bd_nes;              
  wire [ 2:0]  bd_nss;              
  wire [ 2:0]  bd_nbpsc;          
  wire         bd_stbc;             
  wire [ 1:0]  bd_cr;               
  wire [23:0]  bd_field_length;
  wire         bd_field_stfix;
  wire [ 1:0]  bd_ch0_sigsel;            
  wire         bd_ch0_symbol_start;
  wire         bd_ch0_symbol_done;
  wire         bd_ch0_field_start;
  wire [ 1:0]  bd_ch1_sigsel;            
  wire         bd_ch1_symbol_start;
  wire         bd_ch1_symbol_done;      
  wire         bd_ch1_field_start;
  wire         bd_row_fifo_en;

  /* deinterleaver / smux */
  wire [ 3:0]  smux0_ready,      smux1_ready;
  wire [ 3:0]  smux0_valid,      smux1_valid;
  wire [ 4:0]  smux0_sb0,        smux1_sb0;
  wire [ 4:0]  smux0_sb1,        smux1_sb1;
  wire [ 4:0]  smux0_sb2,        smux1_sb2;
  wire [ 4:0]  smux0_sb3,        smux1_sb3;
  wire [ 4:0]  smux0_sb4,        smux1_sb4;
  wire [ 4:0]  smux0_sb5,        smux1_sb5;
  wire [ 4:0]  smux0_sb6,        smux1_sb6;
  wire [ 4:0]  smux0_sb7,        smux1_sb7;
 
  /* depunct */
  wire  [3:0]  depunct0_ready,   depunct1_ready;
  wire  [4:0]  depunct0_sb0,     depunct1_sb0;
  wire  [4:0]  depunct0_sb1,     depunct1_sb1;
  wire  [4:0]  depunct0_sb2,     depunct1_sb2;
  wire  [4:0]  depunct0_sb3,     depunct1_sb3;
  wire  [4:0]  depunct0_sb4,     depunct1_sb4;
  wire  [4:0]  depunct0_sb5,     depunct1_sb5;
  wire  [4:0]  depunct0_sb6,     depunct1_sb6;
  wire  [4:0]  depunct0_sb7,     depunct1_sb7;
  wire  [3:0]  depunct0_valid,   depunct1_valid; 

  /* field */
  reg   [3:0]  field0_ready,     field1_ready;
  wire  [4:0]  field0_sb0,       field1_sb0;
  wire  [4:0]  field0_sb1,       field1_sb1;
  wire  [4:0]  field0_sb2,       field1_sb2;
  wire  [4:0]  field0_sb3,       field1_sb3;
  wire  [4:0]  field0_sb4,       field1_sb4;
  wire  [4:0]  field0_sb5,       field1_sb5;
  wire  [4:0]  field0_sb6,       field1_sb6;
  wire  [4:0]  field0_sb7,       field1_sb7;
  wire  [1:0]  field0_last,      field1_last;
  wire  [3:0]  field0_valid,     field1_valid;

  /* channel mux */
  reg          chmux_sel;
  wire  [3:0]  chmux_ready; 
  reg   [3:0]  chmux_valid; 
  reg   [1:0]  chmux_last;  
  reg   [4:0]  chmux_sb0;   
  reg   [4:0]  chmux_sb1;   
  reg   [4:0]  chmux_sb2;   
  reg   [4:0]  chmux_sb3;   
  reg   [4:0]  chmux_sb4;   
  reg   [4:0]  chmux_sb5;   
  reg   [4:0]  chmux_sb6;   
  reg   [4:0]  chmux_sb7;   
  
  /* vtbin resync */
  wire         vtbin_ready;
  wire         vtbin_valid;
  wire         vtbin_last;
  wire  [4:0]  vtbin_sb0;
  wire  [4:0]  vtbin_sb1;
  wire  [4:0]  vtbin_sb2;
  wire  [4:0]  vtbin_sb3;
 
  /* viterbi */
  wire         vtb_enable;
  wire         vtbctrl_vtrbinvalid;
  wire  [ 7:0] vtbctrl_cntrvtrbrd;
  wire         vtbctrl_flushvtrb;
  wire         vtbctrl_initviterbi;
  wire         vtbctrl_flushdone;
  
  wire  [1:0]  vtb_data;
  wire         vtb_valid;
  
  /* vtbout resync */
  wire         bcc_overflow;
  wire         bcc_ready;
  wire  [7:0]  bcc_data;
  wire         bcc_last;
  wire         bcc_valid;  
 
  /* bmux */
  wire         bmux_ready;
  wire  [7:0]  bmux_data;
  wire         bmux_last;
  wire         bmux_valid;  

  /*****************************************************************************
  *
  *
  *
  * PHY CLOCK DOMAIN
  *
  *
  *
  * 
  *****************************************************************************/
 
  /*****************************************************************************
  * rx_bd_deinterleaver2
  *****************************************************************************/
  rx_bd_deinterleaver2 u_rx_bd_deinterleaver2
  (
    /* system */
    .rst_n(                          phy_rst_n),
    .clk(                            phy_clk),

    /* symbol/control */
    .enable(                         bd_bcc_enable),
  
    .sigen(                          bd_sigen),
    .nss(                            bd_nss),
    .nsd(                            bd_nsd),
    .nbpsc(                          bd_nbpsc),
    .ruen(                           bd_ruen),
    .rulen(                          bd_rulen),
    .dcm(                            bd_dcm),
    .qbpsk(                          bd_qbpsk),
  
    .row_fifo(                       bd_row_fifo_en),
    .row_fifo_wrptr(                 bdfd_row_fifo_wrptr),
    .row_fifo_rdptr(                 bdfd_row_fifo_rdptr),
  
    /* soft bit interfaces */
    /* ch0 channel content and other fields */
    .ch0_start(                      bd_ch0_symbol_start),
    .ch0_sigsel(                     bd_ch0_sigsel),
    .ch0_done(                       bd_ch0_symbol_done),
   
    .ch0_ready(                      smux0_ready),
    .ch0_sb0(                        smux0_sb0),  
    .ch0_sb1(                        smux0_sb1),  
    .ch0_sb2(                        smux0_sb2),  
    .ch0_sb3(                        smux0_sb3),
    .ch0_sb4(                        smux0_sb4),
    .ch0_sb5(                        smux0_sb5),
    .ch0_sb6(                        smux0_sb6),
    .ch0_sb7(                        smux0_sb7),
    .ch0_last(                       /* do not connect */),
    .ch0_valid(                      smux0_valid),
  
    /* ch1 channel content only */
    .ch1_start(                      bd_ch1_symbol_start),
    .ch1_sigsel(                     bd_ch1_sigsel),
    .ch1_done(                       bd_ch1_symbol_done),
 
    .ch1_ready(                      smux1_ready),
    .ch1_sb0(                        smux1_sb0),  
    .ch1_sb1(                        smux1_sb1),  
    .ch1_sb2(                        smux1_sb2),  
    .ch1_sb3(                        smux1_sb3),
    .ch1_sb4(                        smux1_sb4),
    .ch1_sb5(                        smux1_sb5),
    .ch1_sb6(                        smux1_sb6),
    .ch1_sb7(                        smux1_sb7),
    .ch1_last(                       /* do not connect */),
    .ch1_valid(                      smux1_valid),
  
    /* sram interface */
    .ren(                            bdfd_bcc_ren),
    .raddr(                          bdfd_bcc_raddr),
    .rdata(                          bdfd_bcc_rdata)
  );

  assign bdfd_bcc_rsel = bd_row_fifo_en;
  
  /*****************************************************************************
  * depuncturer es0/ch0
  *****************************************************************************/
  rx_bd_depunct u_rx_bd_depunct_es0
  (
    /* system */
    .rst_n(                          phy_rst_n),
    .clk(                            phy_clk),
                                     
    /* symbol parameters */
    .cr(                             bd_cr),
    
    /* control */
    .enable(                         bd_bcc_enable),

    /* punctured bit stream */
    .esi_ready(                      smux0_ready),
    .esi_sb0(                        smux0_sb0),  
    .esi_sb1(                        smux0_sb1),  
    .esi_sb2(                        smux0_sb2),  
    .esi_sb3(                        smux0_sb3),
    .esi_sb4(                        smux0_sb4),
    .esi_sb5(                        smux0_sb5),
    .esi_sb6(                        smux0_sb6),
    .esi_sb7(                        smux0_sb7),
    .esi_valid(                      smux0_valid),
    
    /* depunctured bit stream */
    .eso_ready(                      depunct0_ready),
    .eso_sb0(                        depunct0_sb0),
    .eso_sb1(                        depunct0_sb1),
    .eso_sb2(                        depunct0_sb2),
    .eso_sb3(                        depunct0_sb3),
    .eso_sb4(                        depunct0_sb4),
    .eso_sb5(                        depunct0_sb5),
    .eso_sb6(                        depunct0_sb6),
    .eso_sb7(                        depunct0_sb7),
    .eso_valid(                      depunct0_valid)
  );

  /*****************************************************************************
  * field delimiter es0/ch0
  *****************************************************************************/
  rx_bd_field u_rx_bd_field_ch0
  (
    /* system */
    .rst_n(                          phy_rst_n),
    .clk(                            phy_clk),
    
    /* control */
    .enable(                         bd_bcc_enable),

    /* field parameters */
    .start(                          bd_ch0_field_start),
    .nes(                            1'b0),
    .length(                         bd_field_length),
    .stfix(                          bd_field_stfix),
    .busy(                           /* not connected */),
    
    /* input depunctured stream */
    .esi_ready(                      depunct0_ready),
    .esi_sb0(                        depunct0_sb0),
    .esi_sb1(                        depunct0_sb1),
    .esi_sb2(                        depunct0_sb2),
    .esi_sb3(                        depunct0_sb3),
    .esi_sb4(                        depunct0_sb4),
    .esi_sb5(                        depunct0_sb5),
    .esi_sb6(                        depunct0_sb6),
    .esi_sb7(                        depunct0_sb7),
    .esi_valid(                      depunct0_valid),
    
    /* field stream */
    .eso_ready(                      field0_ready),
    .eso_sb0(                        field0_sb0),
    .eso_sb1(                        field0_sb1),
    .eso_sb2(                        field0_sb2),
    .eso_sb3(                        field0_sb3),
    .eso_sb4(                        field0_sb4),
    .eso_sb5(                        field0_sb5),
    .eso_sb6(                        field0_sb6),
    .eso_sb7(                        field0_sb7),
    .eso_last(                       field0_last),
    .eso_valid(                      field0_valid)
  );  

  /*****************************************************************************
  * depuncturer es1/ch1
  *****************************************************************************/
  rx_bd_depunct u_rx_bd_depunct_es1
  (
    /* system */
    .rst_n(                          phy_rst_n),
    .clk(                            phy_clk),

    /* symbol parameters */
    .cr(                             bd_cr),
    
    /* control */
    .enable(                         bd_bcc_enable),

    /* punctured bit stream */
    .esi_ready(                      smux1_ready),
    .esi_sb0(                        smux1_sb0),
    .esi_sb1(                        smux1_sb1),
    .esi_sb2(                        smux1_sb2),
    .esi_sb3(                        smux1_sb3),
    .esi_sb4(                        smux1_sb4),
    .esi_sb5(                        smux1_sb5),
    .esi_sb6(                        smux1_sb6),
    .esi_sb7(                        smux1_sb7),
    .esi_valid(                      smux1_valid),
    
    /* depunctured bit stream */
    .eso_ready(                      depunct1_ready),
    .eso_sb0(                        depunct1_sb0),
    .eso_sb1(                        depunct1_sb1),
    .eso_sb2(                        depunct1_sb2),
    .eso_sb3(                        depunct1_sb3),
    .eso_sb4(                        depunct1_sb4),
    .eso_sb5(                        depunct1_sb5),
    .eso_sb6(                        depunct1_sb6),
    .eso_sb7(                        depunct1_sb7),
    .eso_valid(                      depunct1_valid)
  );
  
  /*****************************************************************************
  * field delimiter es1/ch1
  *****************************************************************************/
  rx_bd_field u_rx_bd_field_ch1
  (
    /* system */
    .rst_n(                          phy_rst_n),
    .clk(                            phy_clk),
    
    /* control */
    .enable(                         bd_bcc_enable),

    /* field parameters */
    .start(                          bd_ch1_field_start),
    .nes(                            1'b0),
    .length(                         bd_field_length),
    .stfix(                          bd_field_stfix),
    .busy(                           /* not connected */),
    
    /* input depunctured stream */
    .esi_ready(                      depunct1_ready),
    .esi_sb0(                        depunct1_sb0),
    .esi_sb1(                        depunct1_sb1),
    .esi_sb2(                        depunct1_sb2),
    .esi_sb3(                        depunct1_sb3),
    .esi_sb4(                        depunct1_sb4),
    .esi_sb5(                        depunct1_sb5),
    .esi_sb6(                        depunct1_sb6),
    .esi_sb7(                        depunct1_sb7),
    .esi_valid(                      depunct1_valid),
    
    /* field stream */
    .eso_ready(                      field1_ready),
    .eso_sb0(                        field1_sb0),
    .eso_sb1(                        field1_sb1),
    .eso_sb2(                        field1_sb2),
    .eso_sb3(                        field1_sb3),
    .eso_sb4(                        field1_sb4),
    .eso_sb5(                        field1_sb5),
    .eso_sb6(                        field1_sb6),
    .eso_sb7(                        field1_sb7),
    .eso_last(                       field1_last),
    .eso_valid(                      field1_valid)
  );  

  /*****************************************************************************
  * channel mux
  *****************************************************************************/
  always @(posedge phy_clk, negedge phy_rst_n)
  begin:b_chmux
    if(!phy_rst_n)
    begin
      chmux_sel <= 1'b0;
    end
    else
    begin
      if(bd_ch0_field_start) chmux_sel <= 1'b0;
      if(bd_ch1_field_start) chmux_sel <= 1'b1;
    end
  end

  always @(*)
  begin
    if(!chmux_sel)
    begin
      field0_ready = chmux_ready;
      field1_ready = 4'd0;
      chmux_sb0    = field0_sb0;
      chmux_sb1    = field0_sb1;
      chmux_sb2    = field0_sb2;
      chmux_sb3    = field0_sb3;
      chmux_sb4    = field0_sb4;
      chmux_sb5    = field0_sb5;
      chmux_sb6    = field0_sb6;
      chmux_sb7    = field0_sb7;
      chmux_last   = field0_last;
      chmux_valid  = field0_valid;
    end
    else
    begin
      field0_ready = 4'd0;
      field1_ready = chmux_ready;
      chmux_sb0    = field1_sb0;
      chmux_sb1    = field1_sb1;
      chmux_sb2    = field1_sb2;
      chmux_sb3    = field1_sb3;
      chmux_sb4    = field1_sb4;
      chmux_sb5    = field1_sb5;
      chmux_sb6    = field1_sb6;
      chmux_sb7    = field1_sb7;
      chmux_last   = field1_last;
      chmux_valid  = field1_valid;
    end
  end

  /*****************************************************************************
  *
  * VTB CLOCK DOMAIN
  *
  *****************************************************************************/
  ClkSyncSimple u_vtb_global_enable_resync
  ( 
    .dstclk(          vtb_clk),
    .dstresetn(       vtb_rst_n),
    .srcdata(         enable),
    .dstdata(         vtb_enable)
  );

  rx_bd_vtbin_resync u_rx_bd_vtbin_resync
  (
    /* regular domain */
    .rst_n(                          phy_rst_n),
    .clk(                            phy_clk),
    
    .enable(                         enable),
    
    .ready(                          chmux_ready),
    .sb0(                            chmux_sb0),  
    .sb1(                            chmux_sb1),           
    .sb2(                            chmux_sb2),           
    .sb3(                            chmux_sb3),           
    .sb4(                            chmux_sb4),           
    .sb5(                            chmux_sb5),           
    .sb6(                            chmux_sb6),           
    .sb7(                            chmux_sb7),           
    .last(                           chmux_last),
    .valid(                          chmux_valid),     

    /* vtb domain */
    .vtb_rst_n(                      vtb_rst_n),     
    .vtb_clk(                        vtb_clk),
    
    .vtb_enable(                     vtb_enable),
    
    .vtb_ready(                      vtbin_ready),    
    .vtb_sb0(                        vtbin_sb0),  
    .vtb_sb1(                        vtbin_sb1),    
    .vtb_sb2(                        vtbin_sb2),    
    .vtb_sb3(                        vtbin_sb3),    
    .vtb_last(                       vtbin_last),    
    .vtb_valid(                      vtbin_valid)   
  );
 
  /*****************************************************************************
  * viterbi controller
  *****************************************************************************/
  wire     vtbctrl_start;
  wire     vtbctrl_flush;
  wire     vtbctrl_valid_ready;
  
  assign   vtb_clken = 1'b1;
  
  rx_bd_vtb_clkctrl u_rx_bd_vtb_clkctrl
  (
    /* system */
    .clk(                           vtb_clk),
    .rst_n(                         vtb_rst_n),
  
    .global_enable(                 vtb_enable),
  
    /* vtbin if */
    .vtbin_valid(                   vtbin_valid),
    .vtbin_last(                    vtbin_last),
    .vtbin_ready(                   vtbin_ready),
  
    /* vtbctrl if */
    .vtbctrl_start(                 vtbctrl_start),
    .vtbctrl_flush(                 vtbctrl_flush),
    .vtbctrl_ready_valid(           vtbctrl_valid_ready),
    .vtbctrl_flushdone(             vtbctrl_flushdone),
  
    /* clock enable */
    .vtb_core_clken(                vtbcore0_clken)
  );
  
  ViterbiController 
  #(
    .REGLENGTHG(                     120)
  )
  u_viterbicontroller 
  (
    //Inputs
    .ViterbiClk(                     vtb_clk),
    .nHrdRst(                        vtb_rst_n),
    .Enable(                         vtb_enable),
    .StartFieldIn(                   vtbctrl_start),
    .FlushEop(                       vtbctrl_flush),
    .DataValidIn(                    vtbctrl_valid_ready),
    //Outputs
    .VtrbInValid(                    vtbctrl_vtrbinvalid),
    .CntrVtrbRd(                     vtbctrl_cntrvtrbrd),
    .FlushVtrb(                      vtbctrl_flushvtrb),
    .InitViterbi(                    vtbctrl_initviterbi),
    .FlushDoneP(                     vtbctrl_flushdone),
    .ValidOut(                       vtb_valid)
  );
 
  /*****************************************************************************
  * viterbi0
  *****************************************************************************/
  wire [4:0] vtbin_fixed_sb0;
  wire [4:0] vtbin_fixed_sb1;
  wire [4:0] vtbin_fixed_sb2;
  wire [4:0] vtbin_fixed_sb3;
  
  assign vtbin_fixed_sb0 = vtbin_sb0 + 5'd15;
  assign vtbin_fixed_sb1 = vtbin_sb1 + 5'd15;
  assign vtbin_fixed_sb2 = vtbin_sb2 + 5'd15;
  assign vtbin_fixed_sb3 = vtbin_sb3 + 5'd15;
  
  Viterbi 
  #(
    .REGLENGTHG(                     120),
    .DATAINWIDTHG(                   5)
  )
  u_viterbi0 
  (
    //Inputs                                                   
    .ViterbiClk(                     vtbcore0_clk),                     
    .nHrdRst(                        vtb_rst_n),                       
    .InitViterbi(                    vtbctrl_initviterbi),                   
    .DataInValid(                    vtbctrl_vtrbinvalid),                   
    .FlushEop(                       vtbctrl_flushvtrb),                       
    .CntrVtrbRd(                     vtbctrl_cntrvtrbrd),                     
    .InputSoftMetrics0(              vtbin_fixed_sb0),        
    .InputSoftMetrics1(              vtbin_fixed_sb1),        
    .InputSoftMetrics2(              vtbin_fixed_sb2),        
    .InputSoftMetrics3(              vtbin_fixed_sb3),        
    //Outputs                                                    
    .ViterbiOutput(                  {vtb_data[0],vtb_data[1]})                  
  );  
  
  /*****************************************************************************
  * rx_bd_bmux
  *****************************************************************************/
  rx_bd_vtbout_resync u_rx_bd_vtbout_resync
  (
  
    /* vtb domain */
    .vtb_rst_n(                      vtb_rst_n),
    .vtb_clk(                        vtb_clk),
   
    .vtb_enable(                     vtb_enable),
    
    .vtb_flush(                      vtbctrl_flushdone),
    .vtb_data(                       vtb_data),
    .vtb_valid(                      vtb_valid), 

    /* regular domain */
    .rst_n(                          phy_rst_n),
    .clk(                            phy_clk),
    
    .overflow(                       bcc_overflow),
    .enable(                         enable),
    .ready(                          bcc_ready),
    .data(                           bcc_data),
    .last(                           bcc_last),
    .valid(                          bcc_valid)
  );
  
`ifdef RW_NX_LDPC_DEC
  /*****************************************************************************
  *
  * LDPC CLOCK DOMAIN
  *
  *****************************************************************************/
  wire          ldpc_global_enable;
  
  wire  [ 4:0]  bdfd_ldpc_sb0,bdfd_ldpc_sb1,bdfd_ldpc_sb2,bdfd_ldpc_sb3;
  wire  [ 4:0]  bdfd_ldpc_sb4,bdfd_ldpc_sb5,bdfd_ldpc_sb6,bdfd_ldpc_sb7;
  wire  [ 4:0]  bdfd_ldpc_sb8,bdfd_ldpc_sb9,bdfd_ldpc_sb10,bdfd_ldpc_sb11;

  wire  [ 3:0]  ldpcin_ready;
  wire  [ 4:0]  ldpcin_sb0,ldpcin_sb1,ldpcin_sb2,ldpcin_sb3,ldpcin_sb4;
  wire  [ 4:0]  ldpcin_sb5,ldpcin_sb6,ldpcin_sb7,ldpcin_sb8,ldpcin_sb9;
  wire  [ 3:0]  ldpcin_valid;
  
  wire          ldpcin_update;
  wire  [ 3:0]  ldpcin_format;
  wire  [ 2:0]  ldpcin_bandwidth;
  wire  [ 6:0]  ldpcin_mcs;
  wire  [ 1:0]  ldpcin_cr;
  wire  [ 2:0]  ldpcin_nbpsc;
  wire  [ 2:0]  ldpcin_nss;
  wire          ldpcin_stbc;
  wire  [ 2:0]  ldpcin_rulen;
  wire  [15:0]  ldpcin_nsym;
  wire  [15:0]  ldpcin_ncbps;
  wire  [11:0]  ldpcin_ncw;
  wire  [ 1:0]  ldpcin_lldpc;
  wire  [11:0]  ldpcin_nshrtq;
  wire  [11:0]  ldpcin_nshrtr;
  wire  [11:0]  ldpcin_npuncq;
  wire  [11:0]  ldpcin_npuncr;
  wire  [13:0]  ldpcin_nrepq;
  wire  [11:0]  ldpcin_nrepr;
  
  ClkSyncSimple u_ldpc_global_enable_resync
  ( 
    .dstclk(          ldpcrx0_clk),
    .dstresetn(       ldpcrx0_rst_n),
    .srcdata(         enable),
    .dstdata(         ldpc_global_enable)
  );
  
  assign {bdfd_ldpc_sb11,bdfd_ldpc_sb10, bdfd_ldpc_sb9, bdfd_ldpc_sb8,
          bdfd_ldpc_sb7, bdfd_ldpc_sb6, bdfd_ldpc_sb5, bdfd_ldpc_sb4,
          bdfd_ldpc_sb3, bdfd_ldpc_sb2, bdfd_ldpc_sb1, bdfd_ldpc_sb0} = bdfd_ldpc_data;

  rx_bd_ldpcin_resync u_rx_bd_ldpcin_resync
  (
    /*****************************************************************************
    * regular domain
    *****************************************************************************/
    /* system */
    .clk(                   phy_clk),
    .rst_n(                 phy_rst_n),

    /* clken */
    .ldpc_clken(            ldpcrx0_clken),
    
    /* global enable */
    .global_enable(         enable),

    .ready(                 bdfd_ldpc_ready),
    .sb0(                   bdfd_ldpc_sb0),
    .sb1(                   bdfd_ldpc_sb1),
    .sb2(                   bdfd_ldpc_sb2),
    .sb3(                   bdfd_ldpc_sb3),
    .sb4(                   bdfd_ldpc_sb4),
    .sb5(                   bdfd_ldpc_sb5),
    .sb6(                   bdfd_ldpc_sb6),
    .sb7(                   bdfd_ldpc_sb7),
    .sb8(                   bdfd_ldpc_sb8),
    .sb9(                   bdfd_ldpc_sb9),
    .sb10(                  bdfd_ldpc_sb10),
    .sb11(                  bdfd_ldpc_sb11),
    .len(                   bdfd_ldpc_len),
    .valid(                 bdfd_ldpc_valid),

    /* parameters */
    .update(                bd_ldpc_enable),
    .format(                framep1_format),
    .bandwidth(             framep1_bandwidth),
    .mcs(                   framep1_mcs),
    .cr(                    framep1_cr),
    .nbpsc(                 bd_nbpsc),
    .nss(                   framep1_nss),
    .stbc(                  framep1_stbc),
    .rulen(                 bd_rulen),
    .nsym(                  framep8_nsym),
    .ncbps(                 framep8_ncbps),
    .ncw(                   framep5_ncw),
    .lldpc(                 framep5_lldpc),
    .nshrtq(                framep5_nshrtq),
    .nshrtr(                framep5_nshrtr),
    .npuncq(                framep5_npuncq),
    .npuncr(                framep5_npuncr),
    .nrepq(                 framep5_nrepq),
    .nrepr(                 framep5_nrepr),

    /*****************************************************************************
    * ldpc domain
    *****************************************************************************/
    /* system */
    .ldpc_clk(              ldpcrx0_clk),
    .ldpc_rst_n(            ldpcrx0_rst_n),

    /* global enable */
    .ldpc_global_enable(    ldpc_global_enable),

    /* input stream */
    .ldpc_ready(            ldpcin_ready),
    .ldpc_sb0(              ldpcin_sb0),
    .ldpc_sb1(              ldpcin_sb1),
    .ldpc_sb2(              ldpcin_sb2),
    .ldpc_sb3(              ldpcin_sb3),
    .ldpc_sb4(              ldpcin_sb4),
    .ldpc_sb5(              ldpcin_sb5),
    .ldpc_sb6(              ldpcin_sb6),
    .ldpc_sb7(              ldpcin_sb7),
    .ldpc_sb8(              ldpcin_sb8),
    .ldpc_sb9(              ldpcin_sb9),
    .ldpc_valid(            ldpcin_valid),
 
    /* parameters */
    .ldpc_update(           ldpcin_update),
    .ldpc_format(           ldpcin_format),
    .ldpc_bandwidth(        ldpcin_bandwidth),
    .ldpc_mcs(              ldpcin_mcs),
    .ldpc_cr(               ldpcin_cr),
    .ldpc_nbpsc(            ldpcin_nbpsc),
    .ldpc_nss(              ldpcin_nss),
    .ldpc_stbc(             ldpcin_stbc),
    .ldpc_rulen(            ldpcin_rulen),
    .ldpc_nsym(             ldpcin_nsym),
    .ldpc_ncbps(            ldpcin_ncbps),
    .ldpc_ncw(              ldpcin_ncw),
    .ldpc_lldpc(            ldpcin_lldpc),
    .ldpc_nshrtq(           ldpcin_nshrtq),
    .ldpc_nshrtr(           ldpcin_nshrtr),
    .ldpc_npuncq(           ldpcin_npuncq),
    .ldpc_npuncr(           ldpcin_npuncr),
    .ldpc_nrepq(            ldpcin_nrepq),
    .ldpc_nrepr(            ldpcin_nrepr)
  );
  
  wire       ldpccore_ready;
  wire [7:0] ldpccore_data;
  wire       ldpccore_last;
  wire       ldpccore_valid; 
  
  rx_bd_ldpc u_rx_bd_ldpc
  (
    /*****************************************************************************
    * regular domain
    *****************************************************************************/
    /* system */
    .ldpc_rst_n(                     ldpcrx0_rst_n),
    .ldpc_clk(                       ldpcrx0_clk),
    .ldpc_dec_clk(                   ldpcrx0_dec_clk),
    
    .ldpc_dec_clken(                 ldpcrx0_dec_clken),

    /* config registers */
    .mdmcfg_ldpcdec_llrunity(        mdmcfg_ldpcdec_llrunity),
  
    /* parameters */
    .param_update(                   ldpcin_update),
    .param_format(                   ldpcin_format),
    .param_bandwidth(                ldpcin_bandwidth),
    .param_mcs(                      ldpcin_mcs),
    .param_cr(                       ldpcin_cr),
    .param_nbpsc(                    ldpcin_nbpsc),
    .param_nss(                      ldpcin_nss),
    .param_stbc(                     ldpcin_stbc),
    .param_rulen(                    ldpcin_rulen),
    .param_nsym(                     ldpcin_nsym),
    .param_ncbps(                    ldpcin_ncbps),
    .param_ncw(                      ldpcin_ncw),
    .param_lldpc(                    ldpcin_lldpc),
    .param_nshrtq(                   ldpcin_nshrtq),
    .param_nshrtr(                   ldpcin_nshrtr),
    .param_npuncq(                   ldpcin_npuncq),
    .param_npuncr(                   ldpcin_npuncr),
    .param_nrepq(                    ldpcin_nrepq),
    .param_nrepr(                    ldpcin_nrepr),
  
    /* input soft-bit stream */
    .in_ready(                       ldpcin_ready),
    .in_sb0(                         ldpcin_sb0),
    .in_sb1(                         ldpcin_sb1),
    .in_sb2(                         ldpcin_sb2),
    .in_sb3(                         ldpcin_sb3),
    .in_sb4(                         ldpcin_sb4),
    .in_sb5(                         ldpcin_sb5),
    .in_sb6(                         ldpcin_sb6),
    .in_sb7(                         ldpcin_sb7),
    .in_sb8(                         ldpcin_sb8),
    .in_sb9(                         ldpcin_sb9),
    .in_valid(                       ldpcin_valid),

    /* output byte stream */
    .out_ready(                      ldpccore_ready),
    .out_data(                       ldpccore_data),
    .out_last(                       ldpccore_last),
    .out_valid(                      ldpccore_valid),
  
    /* Config data interface */
    .ldec0_cfg_addr(                 ldec0_cfg_addr),
    .ldec0_cfg_addr_update(          ldec0_cfg_addr_update),
    .ldec0_cfg_data(                 ldec0_cfg_data),
    .ldec0_cfg_data_update(          ldec0_cfg_data_update),
  
    /*  LDPC0 Memories */
    // Cr _s
    .ldpcrx0_cr_waddr(               ldpcrx0_cr_waddr),   
    .ldpcrx0_cr_raddr(               ldpcrx0_cr_raddr),  
    .ldpcrx0_cr_wdata(               ldpcrx0_cr_wdata),  
    .ldpcrx0_cr_ren(                 ldpcrx0_cr_ren),    
    .ldpcrx0_cr_wen(                 ldpcrx0_cr_wen),    
    .ldpcrx0_cr_rdata(               ldpcrx0_cr_rdata),  
    // Vr _s
    .ldpcrx0_vr_waddr(               ldpcrx0_vr_waddr), 
    .ldpcrx0_vr_raddr(               ldpcrx0_vr_raddr), 
    .ldpcrx0_vr_wdata(               ldpcrx0_vr_wdata), 
    .ldpcrx0_vr_ren(                 ldpcrx0_vr_ren),   
    .ldpcrx0_vr_wen(                 ldpcrx0_vr_wen),   
    .ldpcrx0_vr_rdata(               ldpcrx0_vr_rdata), 
    // VM _s
    .ldpcrx0_vmx_waddr(              ldpcrx0_vmx_waddr), 
    .ldpcrx0_vmx_raddr(              ldpcrx0_vmx_raddr), 
    .ldpcrx0_vmx_wdata(              ldpcrx0_vmx_wdata), 
    .ldpcrx0_vmx_ren(                ldpcrx0_vmx_ren),   
    .ldpcrx0_vmx_wen(                ldpcrx0_vmx_wen),   
    .ldpcrx0_vmx_rdata(              ldpcrx0_vmx_rdata), 

    .ldpcrx0_vmy_waddr(              ldpcrx0_vmy_waddr),
    .ldpcrx0_vmy_raddr(              ldpcrx0_vmy_raddr),
    .ldpcrx0_vmy_wdata(              ldpcrx0_vmy_wdata),
    .ldpcrx0_vmy_ren(                ldpcrx0_vmy_ren),  
    .ldpcrx0_vmy_wen(                ldpcrx0_vmy_wen),
    .ldpcrx0_vmy_rdata(              ldpcrx0_vmy_rdata),
    // HD _s
    .ldpcrx0_hd_waddr(               ldpcrx0_hd_waddr),  
    .ldpcrx0_hd_wdata(               ldpcrx0_hd_wdata),
                                       
    .ldpcrx0_hdx_raddr(              ldpcrx0_hdx_raddr),
    .ldpcrx0_hdx_rdata(              ldpcrx0_hdx_rdata),
    .ldpcrx0_hdx_ren(                ldpcrx0_hdx_ren),  
    .ldpcrx0_hdx_wen(                ldpcrx0_hdx_wen), 
                                       
    .ldpcrx0_hdy_raddr(              ldpcrx0_hdy_raddr),
    .ldpcrx0_hdy_wen(                ldpcrx0_hdy_wen),  
    .ldpcrx0_hdy_ren(                ldpcrx0_hdy_ren),  
    .ldpcrx0_hdy_rdata(              ldpcrx0_hdy_rdata),

    /* debug ports */
    .dbg0(                           ldpc_rx_dbg0), 
    .dbg1(                           ldpc_rx_dbg1), 
    .dbg2(                           ldpc_rx_dbg2), 
    .dbg3(                           ldpc_rx_dbg3), 
    .dbg4(                           ldpc_rx_dbg4), 
    .dbg5(                           ldpc_rx_dbg5), 
    .dbg6(                           ldpc_rx_dbg6), 
    .dbg7(                           ldpc_rx_dbg7), 
    .dbg8(                           ldpc_rx_dbg8), 
    .dbg9(                           ldpc_rx_dbg9), 
    .dbg10(                          ldpc_rx_dbg10)
  );
  
  wire       ldpc_ready;
  wire [7:0] ldpc_data;
  wire       ldpc_last;
  wire       ldpc_valid;
  
  rx_bd_ldpcout_resync u_rx_bd_ldpcout_resync
  (
    /*****************************************************************************
    * ldpc domain
    *****************************************************************************/
    /* system */
    .ldpc_clk(              ldpcrx0_clk),
    .ldpc_rst_n(            ldpcrx0_rst_n),

    /* global enable */
    .ldpc_global_enable(    ldpc_global_enable),

    /* input stream */
    .ldpc_ready(            ldpccore_ready),
    .ldpc_data(             ldpccore_data),
    .ldpc_last(             ldpccore_last),
    .ldpc_valid(            ldpccore_valid),

    /*****************************************************************************
    * regular domain
    *****************************************************************************/
    /* system */
    .clk(                   phy_clk),
    .rst_n(                 phy_rst_n),

    /* global enable */
    .global_enable(         enable),

    /* input stream */
    .ready(                 ldpc_ready),
    .data(                  ldpc_data),
    .last(                  ldpc_last),
    .valid(                 ldpc_valid)
  );
`endif  
 
  /*****************************************************************************
  * bmux
  *****************************************************************************/
`ifdef RW_NX_LDPC_DEC
  assign bcc_ready                        = !bd_ldpc_enable & bmux_ready;
  assign ldpc_ready                       =  bd_ldpc_enable & bmux_ready;
  assign {bmux_valid,bmux_last,bmux_data} = (!bd_ldpc_enable)?{ bcc_valid, bcc_last, bcc_data}
                                                             :{ldpc_valid,ldpc_last,ldpc_data};

`else
  assign bcc_ready                        = bmux_ready;
  assign {bmux_valid,bmux_last,bmux_data} = { bcc_valid, bcc_last, bcc_data};
`endif
  
  /*****************************************************************************
  * rx_bd_ctrl
  *****************************************************************************/
  rx_bd_ctrl u_rx_bd_ctrl
  (
    /*****************************************************************************
    * system 
    *****************************************************************************/
    .rst_n(                          phy_rst_n),
    .clk(                            phy_clk),

    /*****************************************************************************
    * modem configuration 
    *****************************************************************************/
    .mdmcfg_conf_bw(                 mdmcfg_conf_bw),
    .mdmcfg_conf_primary(            mdmcfg_conf_primary),
    .mdmcfg_qam256_en(               mdmcfg_qam256_en),
    .mdmcfg_qam1024_en(              mdmcfg_qam1024_en),
    .mdmcfg_htmm_en(                 mdmcfg_htmm_en),
    .mdmcfg_htgf_en(                 mdmcfg_htgf_en),
    .mdmcfg_vht_en(                  mdmcfg_vht_en),
    .mdmcfg_he_en(                   mdmcfg_he_en),
    .mdmcfg_stbc_en(                 mdmcfg_stbc_en),
    .mdmcfg_ldpc_en(                 mdmcfg_ldpc_en),
    .mdmcfg_dcm_en(                  mdmcfg_dcm_en),
    .mdmcfg_nss_max(                 mdmcfg_nss_max),
    .mdmcfg_ndp_nsts_max(            mdmcfg_ndp_nsts_max),
    .mdmcfg_bcc_lgi_ndbps_max(       mdmcfg_bcc_lgi_ndbps_max),
    .mdmcfg_bcc_sgi_ndbps_max(       mdmcfg_bcc_sgi_ndbps_max),
    .mdmcfg_ldpc_lgi_ndbps_max(      mdmcfg_ldpc_lgi_ndbps_max),
    .mdmcfg_ldpc_sgi_ndbps_max(      mdmcfg_ldpc_sgi_ndbps_max),
    .mdmcfg_frame_violation_mask(    mdmcfg_frame_violation_mask),
    .mdmcfg_he_frame_violation_mask( mdmcfg_he_frame_violation_mask),
    .mdmcfg_vht_mumimo_en(           mdmcfg_vht_mumimo_en),
    .mdmcfg_he_mumimo_en(            mdmcfg_he_mumimo_en),
    .mdmcfg_vht_membershipstat(      mdmcfg_vht_membershipstat),
    .mdmcfg_vht_userposid(           mdmcfg_vht_userposid),
    .mdmcfg_he_staid0(               mdmcfg_he_staid0),
    .mdmcfg_he_staid1(               mdmcfg_he_staid1),
    .mdmcfg_he_staid2(               mdmcfg_he_staid2),
    .mdmcfg_he_staid3(               mdmcfg_he_staid3),
    
    /*****************************************************************************
    * main fsm
    *****************************************************************************/
    .enable(                         enable),
    .done(                           done),
    
    .mfsm_rxv_update(                mfsm_rxv_update),
    .mfsm_frame_unsupported(         mfsm_frame_unsupported),
    .mfsm_frame_violation(           mfsm_frame_violation),
    .mfsm_phy_error(                 mfsm_phy_error),
   
    /*****************************************************************************
    * AGC/CCA
    *****************************************************************************/
    .cca_lsig_valid(                 cca_lsig_valid),
    .cca_htsig_vhtsiga_valid(        cca_htsig_vhtsiga_valid),
     
    /*****************************************************************************
    * data path
    *****************************************************************************/
    .bdfd_wrptr(                     bdfd_wrptr),
    .bdfd_rdptr(                     bdfd_rdptr),
    .bdfd_ch0_wrptr(                 bdfd_ch0_wrptr),
    .bdfd_ch0_rdptr(                 bdfd_ch0_rdptr),
    .bdfd_ch1_wrptr(                 bdfd_ch1_wrptr),
    .bdfd_ch1_rdptr(                 bdfd_ch1_rdptr),
    .bdfd_qbpsk(                     bdfd_qbpsk),
    
    /* datapath symbol control */
    .bd_bcc_enable(                  bd_bcc_enable),           
    .bd_ldpc_enable(                 bd_ldpc_enable),           
    .bd_fec(                         bd_fec),            
    .bd_dcm(                         bd_dcm),            
    .bd_sigen(                       bd_sigen),            
    .bd_qbpsk(                       bd_qbpsk),
    .bd_nsd(                         bd_nsd),            
    .bd_ruen(                        bd_ruen),            
    .bd_rulen(                       bd_rulen),            
    .bd_nes(                         bd_nes),              
    .bd_nss(                         bd_nss),              
    .bd_nbpsc(                       bd_nbpsc),          
    .bd_stbc(                        bd_stbc),             
    .bd_cr(                          bd_cr),               
    .bd_field_length(                bd_field_length),
    .bd_field_stfix(                 bd_field_stfix),
    .bd_row_fifo_en(                 bd_row_fifo_en),
    
    .bd_ch0_sel(                     bd_ch0_sigsel),           
    .bd_ch0_symbol_start(            bd_ch0_symbol_start),
    .bd_ch0_field_start(             bd_ch0_field_start),
    .bd_ch0_symbol_done(             bd_ch0_symbol_done),
    
    .bd_ch1_sel(                     bd_ch1_sigsel),           
    .bd_ch1_symbol_start(            bd_ch1_symbol_start),
    .bd_ch1_field_start(             bd_ch1_field_start),
    .bd_ch1_symbol_done(             bd_ch1_symbol_done),   

    /* from decoded data */
    .bd_ready(                       bmux_ready),
    .bd_data(                        bmux_data),
    .bd_last(                        bmux_last),
    .bd_valid(                       bmux_valid),
   
    /*****************************************************************************
    * frame parameters
    *****************************************************************************/
    /* part 1 */
    .framep1_update(                 framep1_update),
    .framep1_format(                 framep1_format),
    .framep1_nsd(                    framep1_nsd),
    .framep1_cr(                     framep1_cr),
    .framep1_nbpsc(                  framep1_nbpsc),
    .framep1_nss(                    framep1_nss),
    .framep1_nsts(                   framep1_nsts),
    .framep1_ness(                   framep1_ness),
    .framep1_stbc(                   framep1_stbc),
    .framep1_fec(                    framep1_fec),
    .framep1_smoothing(              framep1_smoothing),
    .framep1_htndp(                  framep1_htndp),
    .framep1_mumimo(                 framep1_mumimo),
    .framep1_beamformed(             framep1_beamformed),
    .framep1_vhtmu_nsts_tot(         framep1_vhtmu_nsts_tot),
    .framep1_vhtmu_nsts_prev(        framep1_vhtmu_nsts_prev),
    .framep1_vhtmu_userpos(          framep1_vhtmu_userpos),
    .framep1_dcm(                    framep1_dcm),
    .framep1_rulen(                  framep1_rulen),
    .framep1_gi_type(                framep1_gi_type),
    .framep1_mcs(                    framep1_mcs),
    .framep1_legrate(                framep1_legrate),
    .framep1_bandwidth(              framep1_bandwidth),
    .framep1_vhtndp(                 framep1_vhtndp),
    .framep1_hesigb_mcs(             framep1_hesigb_mcs),
    .framep1_hesigb_dcm(             framep1_hesigb_dcm),
    .framep1_hesigb_nbpsc(           framep1_hesigb_nbpsc),       
    .framep1_hesigb_cr(              framep1_hesigb_cr),     
    .framep1_hesigb_ndbps(           framep1_hesigb_ndbps),         
    .framep1_nheltf(                 framep1_nheltf),        
    .framep1_heltftype(              framep1_heltftype),        
    .framep1_doppler(                framep1_doppler),        
    .framep1_midamble(               framep1_midamble),        
    /* part 2 */   
    .framep2_update(                 framep2_update),
    .framep2_mu_nbpsc(               framep2_mu_nbpsc),                  
    .framep2_hemu_beamformed(        framep2_hemu_beamformed),            
    .framep2_hemu_rusegment(         framep2_hemu_rusegment),            
    .framep2_hemu_rulen(             framep2_hemu_rulen),            
    .framep2_hemu_ruindex(           framep2_hemu_ruindex),            
    .framep2_hemu_runuser(           framep2_hemu_runuser),            
    .framep2_hemu_ruuser(            framep2_hemu_ruuser),            
    .framep2_hemu_dcm(               framep2_hemu_dcm),             
    .framep2_hemu_nsts(              framep2_hemu_nsts),            
    .framep2_hemu_nsts_tot(          framep2_hemu_nsts_tot),            
    .framep2_hemu_nsts_prev(         framep2_hemu_nsts_prev),            
    .framep2_hemu_fec(               framep2_hemu_fec),             
    /* part 3 */
    .framep3_update(                 framep3_update),            
    .framep3_he_confirmed(           framep3_he_confirmed),      
    /* part 4 */  
    .framep4_update(                 framep4_update),
    .framep4_lsig6m(                 framep4_lsig6m),
    /* part 5 */
    .framep5_ncw(                    framep5_ncw),
    .framep5_lldpc(                  framep5_lldpc),
    .framep5_nshrtq(                 framep5_nshrtq),
    .framep5_nshrtr(                 framep5_nshrtr),
    .framep5_npuncq(                 framep5_npuncq),
    .framep5_npuncr(                 framep5_npuncr),
    .framep5_nrepq(                  framep5_nrepq),
    .framep5_nrepr(                  framep5_nrepr),
    /* part 6 */   
    .framep6_update(                 framep6_update),
    .framep6_l_length_mod3_eq_1(     framep6_l_length_mod3_eq_1),
    /* part 7 */   
    .framep7_update(                 framep7_update),
    .framep7_hesigb_nsym(            framep7_hesigb_nsym),
    /* part 8 */
    .framep8_update(                 framep8_update),
    .framep8_nsym(                   framep8_nsym),
    .framep8_tpe(                    framep8_tpe),
    .framep8_nma(                    framep8_nma),
    .framep8_ncbps(                  framep8_ncbps),
    
    /*****************************************************************************
    * MAC/PHY interface
    *****************************************************************************/
    /* rxvector */
    .rxv1_update(                    rxv1_update),
    .rxv1_format(                    rxv1_format),
    .rxv1_ch_bandwidth(              rxv1_ch_bandwidth),
    .rxv2_update(                    rxv2_update),
    .rxv2_l_length(                  rxv2_l_length),
    .rxv2_l_rate(                    rxv2_l_rate),
    .rxv2_rssi(                      rxv2_rssi),
    .rxv2_dyn_bandwidth_in_non_ht(   rxv2_dyn_bandwidth_in_non_ht),
    .rxv2_ch_bandwidth_in_non_ht(    rxv2_ch_bandwidth_in_non_ht),
    .rxv2_sounding(                  rxv2_sounding),
    .rxv2_smoothing(                 rxv2_smoothing),
    .rxv2_gi_type(                   rxv2_gi_type),
    .rxv2_aggregation(               rxv2_aggregation),
    .rxv2_stbc(                      rxv2_stbc),
    .rxv2_num_ext_ss(                rxv2_num_ext_ss),
    .rxv2_l_sig_valid(               rxv2_l_sig_valid),
    .rxv2_beamformed(                rxv2_beamformed),
    .rxv2_doze_not_allowed(          rxv2_doze_not_allowed),
    .rxv2_first_user(                rxv2_first_user),
    .rxv2_partial_aid(               rxv2_partial_aid),
    .rxv2_group_id(                  rxv2_group_id),
    .rxv2_mcs(                       rxv2_mcs),
    .rxv2_nss(                       rxv2_nss),
    .rxv2_fec_coding(                rxv2_fec_coding),
    .rxv2_length(                    rxv2_length),
    .rxv2_uplink_flag(               rxv2_uplink_flag),
    .rxv2_beam_change(               rxv2_beam_change),
    .rxv2_dcm(                       rxv2_dcm),
    .rxv2_rulen(                     rxv2_rulen),
    .rxv2_he_ltf_type(               rxv2_he_ltf_type),
    .rxv2_doppler(                   rxv2_doppler),
    .rxv2_bss_color(                 rxv2_bss_color),
    .rxv2_txop_duration(             rxv2_txop_duration),
    .rxv2_pe_duration(               rxv2_pe_duration),
    .rxv2_spatial_reuse(             rxv2_spatial_reuse),
    .rxv2_sig_b_compression_mode(    rxv2_sig_b_compression_mode),
    .rxv2_dcm_sig_b(                 rxv2_dcm_sig_b),
    .rxv2_mcs_sig_b(                 rxv2_mcs_sig_b),
    .rxv2_n_user(                    rxv2_n_user),
    .rxv2_staid(                     rxv2_staid),
    /* data */
    .mpif_ready(                     mpif_ready),                       
    .mpif_data(                      mpif_data),                        
    .mpif_last(                      mpif_last),                        
    .mpif_valid(                     mpif_valid),
    
    /*****************************************************************************
    * diag
    *****************************************************************************/
    .diag0(                          diag0),                     
    .diag1(                          diag1),                     
    .diag2(                          diag2),                     
    .diag3(                          diag3)
  );

endmodule
`default_nettype wire

