/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_bmux
(
  /* system */
  input  wire        rst_n,
  input  wire        clk,
  
  /* control */
  input  wire        enable,
  input  wire        nes,
  
  /* incoming encoded bit stream */
  input  wire        vtb_flush,
  input  wire        vtb_valid,                              
  input  wire [ 1:0] vtb0_data,
  input  wire [ 1:0] vtb1_data,
  
  /* outgoing byte stream */
  input  wire        ready,
  output wire [ 7:0] data,
  output wire        last,
  output wire        valid
);
  /*****************************************************************************
  * declaration
  *****************************************************************************/
  reg          vtb_flushed; /* indicates the last vtb_data entered the fifo */
  
  reg  [63:0]  fifo;   /* 32 entries of 2 bits */
  reg  [ 4:0]  fifo_count;
 
  wire [63:0]  n_fifo;
  wire [ 4:0]  n_fifo_count;
  
  wire [ 1:0]  fifo_wren;  /* write 0,1 or 2 entries */
  wire         fifo_rden;  /* read 0 or 4 entries */
 
  wire [ 3:0]  fifo_in;
  wire [ 3:0]  fifo_in_sh;
  wire [63:0]  fifo_in_sh2,fifo_in_sh4,fifo_in_sh8,fifo_in_sh16;
  wire [63:0]  fifo_out_sh8;
  
  /* input shift */
  assign fifo_wren    = {2{vtb_valid}} & { (!nes)?            2'd1:                                                    2'd2   }; 
  assign fifo_in      = {4{vtb_valid}} & { (!nes)?{2'b0,vtb0_data}:{ vtb1_data[1], vtb0_data[1], vtb1_data[0], vtb0_data[0]} };
  
  assign fifo_in_sh   = fifo_count[3:0] - {1'b0, fifo_rden,2'b0};
  
  assign fifo_in_sh2  = fifo_in_sh[0]?{    58'b0,  fifo_in,  2'b0}:     fifo_in;
  assign fifo_in_sh4  = fifo_in_sh[1]?{  fifo_in_sh2[59:0],  4'b0}: fifo_in_sh2;
  assign fifo_in_sh8  = fifo_in_sh[2]?{  fifo_in_sh4[55:0],  8'b0}: fifo_in_sh4;
  assign fifo_in_sh16 = fifo_in_sh[3]?{  fifo_in_sh8[47:0], 16'b0}: fifo_in_sh8;
 
  /* output shift */
  assign fifo_out_sh8 = fifo_rden ? {8'b0, fifo[63:8]} : fifo; 
  
  assign n_fifo       = fifo_out_sh8 | fifo_in_sh16;
  assign n_fifo_count = fifo_count + {3'b0,fifo_wren} - {2'b0, fifo_rden,2'b0};

  assign fifo_rden    = ready && valid;
 
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      fifo_count  <= 5'd0;
      fifo        <= 64'd0;
      vtb_flushed <= 1'b0;
    end
    else if(!enable)
    begin
      fifo_count  <= 5'd0;
      fifo        <= 64'd0;
      vtb_flushed <= 1'b0;
    end
    else
    begin
      /* detect capture of the last incoming bits */
      if(vtb_flush)
        vtb_flushed <= 1'b1;
      
      if(ready && valid && last)     
      begin                          
        fifo_count  <= 5'd0;         
        fifo        <= 64'd0;
        vtb_flushed <= 1'b0;
      end                            
      else                           
      begin                          
        fifo_count <= n_fifo_count;  
        fifo       <= n_fifo;        
      end                            
    end
  end 

  assign data   = fifo[7:0];
  assign valid  = fifo_count>5'd4 || last;
  assign last   = fifo_count<=5'd4 && fifo_count!=5'd0 && vtb_flushed;



  integer debug_in_count;
  integer debug_out_count;

  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      debug_in_count  <= 'd0;
      debug_out_count <= 'd0;
    end
    else if(!enable)
    begin
      debug_in_count  <= 'd0;
      debug_out_count <= 'd0;
    end
    else
    begin
      if(vtb_valid)
        debug_in_count  <= debug_in_count  + 'd2;
      if(valid && ready)
        debug_out_count <= debug_out_count + 'd8;
    end
  end

endmodule
`default_nettype wire
