#!/usr/bin/perl
use strict;


open(my $f_prog,">".$ARGV[1]) or die "error can't open $ARGV[1]\n";

my ($t,$u);
# label
my %label;
my @l_name;
my @l_addr;

# cc 
my %cc=();

# w
my %w=();

# op
my %op=();

# r
my %r=();


# pass 1 parse label
my $l=0;
my $pc = 0;
my $n;
open(my $f_src,$ARGV[0]) or die "error can't $ARGV[0]\n";
while(<$f_src>)
{
  # parse label
  if($_ =~ /^ *([A-Za-z_0-9]+):/)
  {
    $label{$pc} = $1;
    $l++;
  }

  if($_ =~ /^ *({.+?}.+)$/)
  {
    $pc++;
  }
  
  # parse operands for I opcode
  if($_ =~ /^ +({ *I *, *(.+?), *(.+?), *(.+?)}.+)$/)
  {
    $w{$2}=0  if($w{$2} eq "");
    $w{$2}++;
    $op{$3}=0 if($op{$3} eq "");
    $op{$3}++;
    $r{$4}=0  if($r{$4} eq "");
    $r{$4}++;
  }
  
  # parse operands for J opcode
  if($_ =~ /^ +({ *J *, *(.+?), *(.+?)}.+)$/)
  {
    $cc{$2}=0  if($cc{$2} eq "");
    $cc{$2}++;
  }
}

print "# label usage #######################\n";
my $p=0;
for(my $k=0;$k<$pc;$k++)
{
  if($label{$k} ne "")
  {
    printf "%4d %-16s %5d\n",$p,$label{$k},$k;
    $p++; 
  }
}

print "# write operands usage #######################\n";
my $p=0;
foreach my $k (sort keys %w)
{
  printf "%4d %-16s %5d\n",$p,$k,$w{$k};
  $p++; 
}

print "# opcode usage ###############################\n";
my $p=0;
foreach my $k (sort keys %op)
{
  printf "%4d %-16s %5d\n",$p,$k,$op{$k}; 
  $p++; 
}

print "# read operands usage ########################\n";
my $p=0;
foreach my $k (sort keys %r)
{
  printf "%4d %-16s %5d\n",$p,$k,$r{$k}; 
  $p++; 
}

print "# code conditions usage ######################\n";
my $p=0;
foreach my $k (sort keys %cc)
{
  printf "%4d %-16s %5d\n",$p,$k,$cc{$k}; 
  $p++; 
}

printf $f_prog "  wire [15:0]  p[0:%d];\n\n",$pc-1;
 
my @tl=();
my @ta=();
my $k=0;
for(my $l=0;$l<$pc;$l++)
{
  if($label{$l} ne "")
  {
    @tl[$k] = $label{$l};
    @ta[$k] = $l;
    $k++;
  }
}

for(my $k=0;$k<int(@tl);$k++)
{
  
  printf $f_prog "  localparam  %-16s = 9'd%d",@tl[$k],@ta[$k] if($k==0);
  printf $f_prog "              %-16s = 9'd%d",@tl[$k],@ta[$k] if($k!=0);
  
  if($k==(int(@tl)-1))
  {
    printf $f_prog ";\n";
  }
  else
  {
    printf $f_prog ",\n";
  }
}
printf $f_prog "\n";

close($f_src);

# pass 1 label
my $l=0;
my $pc = 0;
open(my $f_src,"source.v") or die "error can't source.txt\n";
while(<$f_src>)
{
  next if($_ =~ /^ *([A-Za-z_0-9]+):/); # skip label tag
  next if($_ =~ /^[ \t]*$/);
  if($_ =~ /^ +({.+?}.+)$/)
  {
    if($label{$pc} ne "")
    {
      $t = $label{$pc};
    }
    else
    {
      $t = sprintf "%d",$pc;
    }
    printf $f_prog "  assign p[%15s] = %s\n",$t,$1;
    $pc++;
  }
  else
  {
    print $f_prog $_;
  }
}

close($f_src);
close($f_prog);


# generate trace genration for debug
open(my $f_trace,">debug.v") or die "error can't open debug.v\n";


printf $f_trace "  /*****************************************************************************\n";
printf $f_trace "  * for debug/development\n";
printf $f_trace "  *****************************************************************************/\n";
printf $f_trace "  // pragma coverage block = off, expr = off, toggle = off\n";
printf $f_trace "  reg [8:0] op_pc_s;\n";
printf $f_trace "  reg       op_drop_s;\n";
printf $f_trace "\n";
printf $f_trace "  always @(posedge clk,negedge rst_n)\n";
printf $f_trace "    if(!rst_n)\n";
printf $f_trace "    begin\n";
printf $f_trace "      op_pc_s   <= 'd0;\n";
printf $f_trace "      op_drop_s <= 'b0;\n";
printf $f_trace "    end\n";
printf $f_trace "    else if(!u_ucpu.enable || u_ucpu.done)\n";
printf $f_trace "    begin\n";
printf $f_trace "      op_pc_s   <= 'd0;\n";
printf $f_trace "      op_drop_s <= 'b0;\n";
printf $f_trace "    end\n";
printf $f_trace "    else\n";
printf $f_trace "    begin\n"; 
printf $f_trace "      op_drop_s <= u_ucpu.op_jmp && u_ucpu.cc_flag;\n";
printf $f_trace "      op_pc_s   <= u_ucpu.pc;\n";
printf $f_trace "    end\n";
printf $f_trace "\n";  
printf $f_trace "  reg [32*8-1:0] op_wb_s;\n";
printf $f_trace "  reg [32*8-1:0] op_rb_s;\n";
printf $f_trace "  reg [32*8-1:0] op_alu_s;\n";
printf $f_trace "  reg [32*8-1:0] op_cond_s;\n";
printf $f_trace "  reg [ 8:0]     op_target_s;\n";
printf $f_trace "\n";
printf $f_trace "  always @(*)\n";
printf $f_trace "  begin\n";
printf $f_trace "    op_wb_s     = \"XXXXXXXX\";\n";
printf $f_trace "    op_alu_s    = \"XXXXXXXX\";\n";
printf $f_trace "    op_rb_s     = \"XXXXXXXX\";\n";
printf $f_trace "    op_cond_s   = \"XXXXXXXX\";\n";
printf $f_trace "    op_target_s = 0;\n";
printf $f_trace "\n";  
printf $f_trace "    if(!u_ucpu.done)\n";
printf $f_trace "    begin\n";
printf $f_trace "      if(op_drop_s)\n";
printf $f_trace "      begin\n";
printf $f_trace "        op_wb_s     = \" \";\n";
printf $f_trace "        op_alu_s    = \"DROP\";\n";
printf $f_trace "        op_rb_s     = \" \";\n";
printf $f_trace "        op_target_s = 0;\n";
printf $f_trace "        op_cond_s   = \" \";\n";
printf $f_trace "      end\n";
printf $f_trace "      else if(u_ucpu.op_jmp)\n";
printf $f_trace "      begin\n";
printf $f_trace "        op_wb_s     = \" \";\n";
printf $f_trace "        op_alu_s    = \" \";\n";
printf $f_trace "        op_rb_s     = \" \";\n";
printf $f_trace "        op_target_s = u_ucpu.op_target;\n";
printf $f_trace "        case(u_ucpu.op_cond)\n";
foreach my $k (keys %cc)
{
  printf $f_trace "          %s: op_cond_s = \"%s\";\n",$k,$k;
}
printf $f_trace "          default: op_cond_s = \"XXXXXX\";\n";
printf $f_trace "        endcase\n";
printf $f_trace "      end\n";
printf $f_trace "      else\n";
printf $f_trace "      begin\n";
printf $f_trace "        op_cond_s = \" \";\n";
printf $f_trace "        case (u_ucpu.op_wb)\n";
foreach my $k (keys %w)
{
  printf $f_trace "          %s: op_wb_s = \"%s\";\n",$k,$k;
}
printf $f_trace "          default:             op_wb_s = \"XXXXXX\";\n";
printf $f_trace "        endcase\n";
printf $f_trace "        case(u_ucpu.op_rb)\n";
foreach my $k (keys %r)
{
  printf $f_trace "          %s: op_rb_s = \"%s\";\n",$k,$k;
}
printf $f_trace "          default:        op_rb_s = \"XXXXXX\";\n";
printf $f_trace "        endcase\n";
printf $f_trace "        case (u_ucpu.op_alu)\n";
printf $f_trace "          NOP:     op_alu_s = \"NOP\";\n";      
printf $f_trace "          CLRXY:   op_alu_s = \"CLRXY\";\n"; 
printf $f_trace "          ADD:     op_alu_s = \"ADD\";\n";    
printf $f_trace "          SUB:     op_alu_s = \"SUB\";\n";    
printf $f_trace "          MUL:     op_alu_s = \"MUL\";\n";   
printf $f_trace "          DIV:     op_alu_s = \"DIV\";\n";    
printf $f_trace "          TERM:    op_alu_s = \"TERM\";\n";  
printf $f_trace "        endcase\n";
printf $f_trace "      end\n";
printf $f_trace "    end\n"; 
printf $f_trace "  end\n";
printf $f_trace "  // pragma coverage block = on, expr = on, toggle = on\n";
close($f_trace);

