#!/usr/bin/perl
use strict;

# copies from 802.11ax draft 3.1
my @spec=
(
  "00000000 26 26 26 26 26 26 26 26 26 1",
  "00000001 26 26 26 26 26 26 26 52 1",
  "00000010 26 26 26 26 26 52 26 26 1",
  "00000011 26 26 26 26 26 52 52 1",
  "00000100 26 26 52 26 26 26 26 26 1",
  "00000101 26 26 52 26 26 26 52 1",
  "00000110 26 26 52 26 52 26 26 1",
  "00000111 26 26 52 26 52 52 1",
  "00001000 52 26 26 26 26 26 26 26 1",
  "00001001 52 26 26 26 26 26 52 1",
  "00001010 52 26 26 26 52 26 26 1",
  "00001011 52 26 26 26 52 52 1",
  "00001100 52 52 26 26 26 26 26 1",
  "00001101 52 52 26 26 26 52 1",
  "00001110 52 52 26 52 26 26 1",
  "00001111 52 52 26 52 52 1",
  "00010y2y1y0 52 52 - 106 8",
  "00011y2y1y0 106 - 52 52 8",
  "00100y2y1y0 26 26 26 26 26 106 8",
  "00101y2y1y0 26 26 52 26 106 8",
  "00110y2y1y0 52 26 26 26 106 8",
  "00111y2y1y0 52 52 26 106 8",
  "01000y2y1y0 106 26 26 26 26 26 8",
  "01001y2y1y0 106 26 26 26 52 8",
  "01010y2y1y0 106 26 52 26 26 8",
  "01011y2y1y0 106 26 52 52 8",
  "0110y1y0z1z0 106 - 106 16",
  "01110000 52 52 - 52 52 1",
  "01110001 242-tone RU empty 1",
  "01110010 484-tone RU with zero User fields indicated in this RU Allocation subfield ofthe HE-SIG-B content channel1",
  "01110011 996-tone RU with zero User fields indicated in this RU Allocation subfield ofthe HE-SIG-B content channel1",
  "011101x1x0 Reserved 4",
  "01111y2y1y0 Reserved 8",
  "10y2y1y0z2z1z0 106 26 106 64",
  "11000y2y1y0 242 8",
  "11001y2y1y0 484 8",
  "11010y2y1y0 996 8",
  "11011y2y1y0 Reserved 8",
  "111x4x3x2x1x0 Reserved 32"
);

my %ru26_index  = ( 0=>1, 1=>2, 2=>3, 3=>4, 4=>5, 5=>6, 6=>7, 7=>8, 8=>9);
my %ru52_index  = ( 0=>1, 2=>2, 5=>3, 7=>4);
my %ru106_index = ( 0=>1, 5=>2);
my @f;
my $indice;
my $user;
my $col;
my $first_max;
my $second_max;
my @nu;
my $entry=0;

foreach my $l(@spec)
{
  @f = split " ",$l;
  my $indice = shift @f;
  
  
  $first_max  = 1;
  $first_max  = 2 if($indice =~ "y0");
  $first_max  = 4 if($indice =~ "y1y0");
  $first_max  = 8 if($indice =~ "y2y1y0");
  $second_max = 1;
  $second_max = 2 if($indice =~ "z0");
  $second_max = 4 if($indice =~ "z1z0");
  $second_max = 8 if($indice =~ "z2z1z0");
  
  for(my $first=1;$first<=$first_max;$first++)
  {
    for(my $second=1;$second<=$second_max;$second++)
    {
      printf "      8'b";
      for(my $k=0;$k<8;$k++)
      {
        if($entry&(1<<(7-$k)))
        {
          printf "1";
        }
        else
        {
          printf "0";
        }
      }
      printf ":  /* %s %d %d */\n",$indice,$first,$second;
      printf "      begin\n";
      
      my $user   = 0;
      my $col    = 0;
      @nu = ($first,$second);
      for my $c (@f)
      {
        if($c eq "26")
        {
          printf "        { u%d_ru_len, u%d_ru_index, u%d_ru_nuser, u%d_ru_user} = ",$user,$user,$user,$user;
          printf " { RU_%d, 4'd%d, 4'd%d, 3'd0};\n",$c,$ru26_index{$col},1;
          $user += 1;
          $col  += 1;
        }
        elsif($c eq "52")
        {
          printf "        { u%d_ru_len, u%d_ru_index, u%d_ru_nuser, u%d_ru_user} = ",$user,$user,$user,$user;
          printf " { RU_%d, 4'd%d, 4'd%d, 3'd0};\n",$c,$ru52_index{$col},1;
          $user += 1;
          $col  += 2;
        }
        elsif($c eq "106")
        {
          my $t=shift(@nu);
          for(my $k=0;$k<$t;$k++)
          {
            printf "        { u%d_ru_len, u%d_ru_index, u%d_ru_nuser, u%d_ru_user} = ",$user,$user,$user,$user;
            printf " { RU_%d, 4'd%d, 4'd%d, 3'd%d};\n",$c,$ru106_index{$col},$t,$k;
            $user += 1;
          }
          $col  += 4;
        }
        elsif($c eq "242" || $c eq "484" || $c eq "996")
        {
          my $t=shift(@nu);
          for(my $k=0;$k<$t;$k++)
          {
            printf "        { u%d_ru_len, u%d_ru_index, u%d_ru_nuser, u%d_ru_user} = ",$user,$user,$user,$user;
            printf " { RU_%d, 4'd%d, 4'd%d, 3'd%d};\n",$c,$ru106_index{$col},$t,$k;
            $user += 1;
          }
          last;
        }
        elsif($c eq "-")
        {
          $col+=1;
        }
        elsif($c =~ "-tone" || $c =~ "Reserved")
        {
          $entry+=3 if($indice =~ "x1x0");
          printf "        ;\n";
          last;
        }
        else
        {
          print "error: don't know to handle $c !\n";
          exit;
        }
        last if ($col>8);
      }
      $entry++;
      printf "        nuser = 5'd%d;\n",$user;
      printf "      end\n";
    }
  }
}
