/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_ctrl
(
  /*****************************************************************************
  * system 
  *****************************************************************************/
  input  wire         rst_n,
  input  wire         clk,

  /*****************************************************************************
  * modem configuration 
  *****************************************************************************/
  input  wire  [ 2:0] mdmcfg_conf_primary,
  input  wire  [ 1:0] mdmcfg_conf_bw,
  input  wire         mdmcfg_qam256_en,
  input  wire         mdmcfg_qam1024_en,
  input  wire         mdmcfg_htmm_en,
  input  wire         mdmcfg_htgf_en,
  input  wire         mdmcfg_vht_en,
  input  wire         mdmcfg_he_en,
  input  wire         mdmcfg_stbc_en,
  input  wire         mdmcfg_ldpc_en,
  input  wire         mdmcfg_dcm_en,
  input  wire [  2:0] mdmcfg_nss_max,
  input  wire [  2:0] mdmcfg_ndp_nsts_max,
  input  wire [ 15:0] mdmcfg_bcc_lgi_ndbps_max,
  input  wire [ 15:0] mdmcfg_bcc_sgi_ndbps_max,
  input  wire [ 15:0] mdmcfg_ldpc_lgi_ndbps_max,
  input  wire [ 15:0] mdmcfg_ldpc_sgi_ndbps_max,
  input  wire [ 35:0] mdmcfg_frame_violation_mask,
  input  wire [ 31:0] mdmcfg_he_frame_violation_mask,
  input  wire         mdmcfg_vht_mumimo_en,
  input  wire         mdmcfg_he_mumimo_en,
  input  wire [ 63:0] mdmcfg_vht_membershipstat,
  input  wire [127:0] mdmcfg_vht_userposid,
  input  wire [ 10:0] mdmcfg_he_staid0,
  input  wire [ 10:0] mdmcfg_he_staid1,
  input  wire [ 10:0] mdmcfg_he_staid2,
  input  wire [ 10:0] mdmcfg_he_staid3,
  
  /*****************************************************************************
  * main fsm
  *****************************************************************************/
  input  wire         enable,
  output wire         done,
  
  output wire         mfsm_rxv_update,
  output wire         mfsm_frame_unsupported,
  output wire         mfsm_frame_violation,
  output wire         mfsm_phy_error,
 
  /*****************************************************************************
  * AGC/CCA
  *****************************************************************************/
  output wire         cca_lsig_valid,
  output wire         cca_htsig_vhtsiga_valid,
   
  /*****************************************************************************
  * data path
  *****************************************************************************/
  input  wire         bdfd_wrptr,
  output wire         bdfd_rdptr,
  input  wire [ 2:0]  bdfd_ch0_wrptr,
  output wire [ 2:0]  bdfd_ch0_rdptr,
  input  wire [ 2:0]  bdfd_ch1_wrptr,
  output wire [ 2:0]  bdfd_ch1_rdptr,
  input  wire         bdfd_qbpsk,
  
  /* datapath symbol control */
  output wire         bd_bcc_enable,
  output wire         bd_ldpc_enable,
  output wire         bd_fec,            
  output wire         bd_dcm,            
  output wire         bd_sigen,            
  output wire         bd_qbpsk,
  output wire [ 1:0]  bd_nsd,            
  output wire         bd_ruen,            
  output wire [ 2:0]  bd_rulen,            
  output wire         bd_nes,              
  output wire [ 2:0]  bd_nss,              
  output wire [ 2:0]  bd_nbpsc,          
  output wire         bd_stbc,             
  output wire [ 1:0]  bd_cr,
  output wire         bd_row_fifo_en,               
  output wire [23:0]  bd_field_length,
  output wire         bd_field_stfix,
  
  output wire [ 1:0]  bd_ch0_sel,            
  output wire         bd_ch0_symbol_start,
  input  wire         bd_ch0_symbol_done,
  output wire         bd_ch0_field_start,
        
  output wire [ 1:0]  bd_ch1_sel,            
  output wire         bd_ch1_symbol_start,
  input  wire         bd_ch1_symbol_done,      
  output wire         bd_ch1_field_start,

  /* from decoded data */
  output wire         bd_ready,
  input  wire [ 7:0]  bd_data, 
  input  wire         bd_last,         
  input  wire         bd_valid,
 
  /*****************************************************************************
  * frame parameters
  *****************************************************************************/
  /* part 1 */
  output wire         framep1_update,
  output wire [ 3:0]  framep1_format,
  output wire [ 1:0]  framep1_nsd,
  output wire [ 1:0]  framep1_cr,
  output wire [ 2:0]  framep1_nbpsc,
  output wire [ 2:0]  framep1_nss,
  output wire [ 2:0]  framep1_nsts,
  output wire [ 1:0]  framep1_ness,
  output wire         framep1_stbc,
  output wire         framep1_fec,
  output wire         framep1_smoothing,
  output wire         framep1_htndp,
  output wire         framep1_mumimo,
  output wire         framep1_beamformed,
  output wire [ 2:0]  framep1_vhtmu_nsts_tot,
  output wire [ 2:0]  framep1_vhtmu_nsts_prev,
  output wire [ 1:0]  framep1_vhtmu_userpos,
  output wire         framep1_dcm,
  output wire [ 2:0]  framep1_rulen,
  output wire [ 1:0]  framep1_gi_type,
  output wire [ 6:0]  framep1_mcs,
  output wire [ 3:0]  framep1_legrate,
  output wire [ 2:0]  framep1_bandwidth,
  output wire         framep1_vhtndp,
  output wire [ 2:0]  framep1_hesigb_mcs, 
  output wire         framep1_hesigb_dcm, 
  output wire [ 2:0]  framep1_hesigb_nbpsc,
  output wire [ 1:0]  framep1_hesigb_cr,
  output wire [ 7:0]  framep1_hesigb_ndbps,
  output wire [ 2:0]  framep1_nheltf,
  output wire [ 1:0]  framep1_heltftype,
  output wire         framep1_doppler,
  output wire         framep1_midamble,
  
  /* part 2 */
  output wire         framep2_update,
  output wire [ 2:0]  framep2_mu_nbpsc,
  output wire         framep2_hemu_beamformed,
  output wire         framep2_hemu_rusegment,
  output wire [ 2:0]  framep2_hemu_rulen,
  output wire [ 5:0]  framep2_hemu_ruindex,
  output wire [ 3:0]  framep2_hemu_runuser,
  output wire [ 2:0]  framep2_hemu_ruuser,
  output wire         framep2_hemu_dcm,
  output wire [ 2:0]  framep2_hemu_nsts,
  output wire [ 2:0]  framep2_hemu_nsts_tot,
  output wire [ 2:0]  framep2_hemu_nsts_prev,
  output wire         framep2_hemu_fec,
  /* part 3 */
  output wire         framep3_update,
  output wire         framep3_he_confirmed,
  /* part 4 */
  output wire         framep4_update,
  output wire         framep4_lsig6m,
  /* part 5 */
  output wire [11:0]  framep5_ncw,
  output wire [ 1:0]  framep5_lldpc,
  output wire [11:0]  framep5_nshrtq,
  output wire [11:0]  framep5_nshrtr,
  output wire [11:0]  framep5_npuncq,
  output wire [11:0]  framep5_npuncr,
  output wire [13:0]  framep5_nrepq,
  output wire [11:0]  framep5_nrepr,
  /* part 6 */
  output wire         framep6_update,
  output wire         framep6_l_length_mod3_eq_1,
  /* part 7 */
  output wire         framep7_update,
  output wire [ 7:0]  framep7_hesigb_nsym,
  /* part 8 */
  output wire         framep8_update,
  output wire [15:0]  framep8_nsym,
  output wire [ 2:0]  framep8_tpe,
  output wire [ 8:0]  framep8_nma,
  output wire [15:0]  framep8_ncbps,

  /*****************************************************************************
  * MAC/PHY interface
  *****************************************************************************/
  /* rxvector */
  output wire         rxv1_update,
  output wire [ 3:0]  rxv1_format,
  output wire [ 2:0]  rxv1_ch_bandwidth,
  output wire         rxv2_update,
  output wire [11:0]  rxv2_l_length,
  output wire [ 3:0]  rxv2_l_rate,
  output wire [ 7:0]  rxv2_rssi,
  output wire         rxv2_dyn_bandwidth_in_non_ht,
  output wire [ 1:0]  rxv2_ch_bandwidth_in_non_ht,
  output wire         rxv2_sounding,
  output wire         rxv2_smoothing,
  output wire [ 1:0]  rxv2_gi_type,
  output wire         rxv2_aggregation,
  output wire         rxv2_stbc,
  output wire [ 1:0]  rxv2_num_ext_ss,
  output wire         rxv2_l_sig_valid,
  output wire         rxv2_beamformed,
  output wire         rxv2_doze_not_allowed,
  output wire         rxv2_first_user,
  output wire [ 8:0]  rxv2_partial_aid,
  output wire [ 5:0]  rxv2_group_id,
  output wire [ 6:0]  rxv2_mcs,
  output wire [ 2:0]  rxv2_nss,
  output wire         rxv2_fec_coding,
  output wire [19:0]  rxv2_length,
  output wire         rxv2_uplink_flag,
  output wire         rxv2_beam_change,
  output wire         rxv2_dcm,
  output wire [ 2:0]  rxv2_rulen,
  output wire [ 1:0]  rxv2_he_ltf_type,
  output wire         rxv2_doppler,
  output wire [ 5:0]  rxv2_bss_color,
  output wire [ 6:0]  rxv2_txop_duration,
  output wire [ 3:0]  rxv2_pe_duration,
  output wire [ 3:0]  rxv2_spatial_reuse,
  output wire         rxv2_sig_b_compression_mode,
  output wire         rxv2_dcm_sig_b,
  output wire [ 2:0]  rxv2_mcs_sig_b,
  output wire [ 7:0]  rxv2_n_user,
  output wire [10:0]  rxv2_staid,
  
  /* data */
  input  wire         mpif_ready,
  output wire [ 7:0]  mpif_data,              
  output wire         mpif_last,         
  output wire         mpif_valid,

  /*****************************************************************************
  * diags
  *****************************************************************************/
  output wire [15:0]  diag0,
  output wire [15:0]  diag1,
  output wire [15:0]  diag2,
  output wire [15:0]  diag3
);
  
  /*****************************************************************************
  * DECLARATION
  *****************************************************************************/
  /* constants */
  localparam  HE_SU=4'd5,
              HE_MU=4'd6,
              HE_ER_SU=4'd7,
              HE_TB=4'd8;

  localparam  BD_IDLE=5'd0,
              BD_LSIG=5'd1,
              BD_LDATA0_VHTSIGA1=5'd2,
              BD_LDATA=5'd3,
              BD_HTSIG1=5'd4,
              BD_HTSIG2=5'd5,
              BD_HTDATA=5'd6,
              BD_VHTSIGA2=5'd7,
              BD_VHTSIGB=5'd8,
              BD_VHTDATA=5'd9,
              BD_HERLSIG=5'd10,
              BD_HESIGA1=5'd11,
              BD_HESIGA2=5'd12,
              BD_HEERSUSIGA2=5'd13,
              BD_HEERSUSIGA3=5'd14,
              BD_HEERSUSIGA4=5'd15,
              BD_HESIGB=5'd16,
              BD_HEDATA=5'd17;
  
  /* bd flow control */
  wire         bd_ready_lsig;  
  wire         bd_ready_htsig; 
  wire         bd_ready_vhtsig;
  wire         bd_ready_hesiga;
  wire         bd_ready_hesigb;
  wire         bd_ready_data;
  
  /* field control */
  wire         bd_field_start_fsm;
  wire         bd_ch0_field_start_hesigb;
  wire [ 5:0]  bd_field_length_hesigb;
  wire [23:0]  bd_field_length_others;
  
  /* fsm */
  wire [ 4:0]  bd_symbol;
  wire         lsig_parser_enable;
  wire         herlsig_parser_enable;
  wire         htsig_parser_enable;
  wire         vhtsiga_parser_enable;
  wire         vhtsigb_parser_enable;
  wire         hesiga_parser_enable;
  wire         hesigb_parser_enable;
  wire         data_parser_enable;
  wire         hesiga2_is_qbpsk;
  wire         lsig_ucpu_start;
  wire         htsig_ucpu_start;
  wire         vhtsig_ucpu_start;
  wire         hesig_ucpu_start;
  
  /* lsig parser */
  wire         lsig_captured;
  wire [ 3:0]  lsig_rate;
  wire [11:0]  lsig_length;
  wire [ 2:0]  lsig_nbpsc;
  wire [ 1:0]  lsig_cr;
  wire         lsig_length_lt_12;
  wire         lsig_length_lt_14;
  wire         lsig_invalid_rate;
  wire         lsig_invalid_reserved4;
  wire         lsig_invalid_parity;
  wire         herlsig_captured;
  wire         herlsig_eq_lsig;
  
  /* htsig parser */
  wire         htsig_captured;
  wire [  6:0] htsig_mcs;
  wire [  2:0] htsig_bandwidth;
  wire [ 15:0] htsig_length;
  wire         htsig_smoothing;
  wire         htsig_sounding;
  wire         htsig_aggregation;
  wire         htsig_stbc;
  wire         htsig_fec;
  wire  [ 1:0] htsig_gi_type;
  wire  [ 1:0] htsig_ness;
  wire         htsig_mcs32;
  wire         htsig_ndp;
  wire  [ 2:0] htsig_nss;
  wire  [ 2:0] htsig_nsts;
  wire  [ 1:0] htsig_nsd;
  wire  [ 1:0] htsig_cr;
  wire  [ 2:0] htsig_nbpsc;
  wire         htsig_invalid_reserved26;
  wire         htsig_invalid_mcs;
  wire         htsig_invalid_length;
  wire         htsig_invalid_ndp_stbc;
  wire         htsig_invalid_ndp_nss;
  wire         htsig_invalid_nsts_ness;
  wire         htsig_invalid_nsts_nss;
  wire         htsig_invalid_mcs32_bw;
  wire         htsig_invalid_mcs32_stbc;
  wire         htsig_invalid_crc;
  wire         htsig_invalid_gf_sgi_1ss;
  
  /* vhtsig parser */
  wire         vhtsiga_captured;
  wire         vhtsigb_captured;
  wire [  2:0] vhtsig_bandwidth;
  wire         vhtsig_stbc;
  wire [  5:0] vhtsig_gid;
  wire         vhtsig_dozenotallowed;
  wire [  1:0] vhtsig_gi_type;
  wire         vhtsig_sgidisamb;
  wire         vhtsig_extra;
  wire [  2:0] vhtsig_nss;
  wire         vhtsig_fec;
  wire [  8:0] vhtsig_paid;
  wire [  2:0] vhtsig_nsts;
  wire [  2:0] vhtsig_nsts_tot;
  wire [  3:0] vhtsig_mcs;
  wire         vhtsig_beamformed;
  wire         vhtsig_mumimo;
  wire         vhtsig_mu_user_valid;
  wire         vhtsig_mu_first_user;
  wire [ 1:0]  vhtsig_mu_posid;
  wire [ 2:0]  vhtsig_nsts_prev;
  wire [ 1:0]  vhtsig_nsd;
  wire [ 1:0]  vhtsig_cr;
  wire [ 2:0]  vhtsig_nbpsc;
  wire [ 7:0]  vhtsig_sigb_crc;
  wire         vhtsig_invalid_siga_reserved2;
  wire         vhtsig_invalid_siga_reserved23;
  wire         vhtsig_invalid_siga_reserved31;
  wire         vhtsig_invalid_siga_reserved32;
  wire         vhtsig_invalid_siga_reserved33;
  wire         vhtsig_invalid_siga_crc;
  wire         vhtsig_invalid_sgi;
  wire         vhtsig_invalid_stbc_odd;
  wire         vhtsig_invalid_mcs;
  wire         vhtsig_invalid_su_fec_extra;
  wire         vhtsig_invalid_mu_stbc;
  wire         vhtsig_invalid_mu_nsts_fec;

  /* hesig parser */
  wire         hesiga_captured;
  wire [ 3:0]  hesiga_format;
  wire         hesiga_beamchange;
  wire         hesiga_uplink;
  wire [ 3:0]  hesiga_mcs;
  wire [ 2:0]  hesiga_nbpsc;
  wire [ 1:0]  hesiga_cr;
  wire         hesiga_dcm;
  wire [ 5:0]  hesiga_bss_color;
  wire [ 3:0]  hesiga_spatial_reuse1;
  wire [ 3:0]  hesiga_spatial_reuse2;
  wire [ 3:0]  hesiga_spatial_reuse3;
  wire [ 3:0]  hesiga_spatial_reuse4;
  wire [ 2:0]  hesiga_bandwidth;
  wire [ 2:0]  hesiga_rulen;
  wire [ 1:0]  hesiga_gi_type;
  wire [ 1:0]  hesiga_ltf_type;
  wire [ 2:0]  hesiga_nsts;
  wire [ 2:0]  hesiga_nheltf;
  wire [ 6:0]  hesiga_txop;
  wire         hesiga_fec;
  wire         hesiga_extra;
  wire         hesiga_stbc;
  wire         hesiga_beamformed;
  wire [ 1:0]  hesiga_a;
  wire         hesiga_pedisamb;
  wire         hesiga_doppler;
  wire         hesiga_midamble;
  wire [ 2:0]  hesiga_sigb_mcs;
  wire [ 2:0]  hesiga_sigb_nbpsc;
  wire [ 1:0]  hesiga_sigb_cr;
  wire [ 7:0]  hesiga_sigb_ndbps;
  wire         hesiga_sigb_dcm;
  wire [ 4:0]  hesiga_sigb_nsym;
  //wire [ 7:0]  hesiga_sigb_nsym;
  wire [ 2:0]  hesiga_sigb_compression_nuser;
  wire         hesiga_sigb_compression;
  wire         hesiga_invalid_crc;
  
  /* hesigb */
  wire         hesigb_parser_ch0_done;
  wire         hesigb_parser_ch1_done;
  wire         hesigb_user_valid;
  wire [10:0]  hesigb_staid;
  wire         hesigb_rusegment;
  wire [ 2:0]  hesigb_rulen;
  wire [ 5:0]  hesigb_ruindex;
  wire [ 3:0]  hesigb_runuser;
  wire [ 2:0]  hesigb_ruuser;
  wire         hesigb_beamformed;
  wire [ 3:0]  hesigb_mcs;
  wire [ 2:0]  hesigb_nbpsc;
  wire [ 1:0]  hesigb_cr;
  wire         hesigb_dcm;
  wire         hesigb_fec;
  wire [ 2:0]  hesigb_nsts;
  wire [ 2:0]  hesigb_nsts_prev;
  wire [ 2:0]  hesigb_nsts_tot;
  
  wire         hesigb_matched_user_valid;
  wire [10:0]  hesigb_matched_staid;
  wire         hesigb_matched_rusegment;
  wire [ 2:0]  hesigb_matched_rulen;
  wire [ 5:0]  hesigb_matched_ruindex;
  wire [ 3:0]  hesigb_matched_runuser;
  wire [ 2:0]  hesigb_matched_ruuser;
  wire         hesigb_matched_beamformed;
  wire [ 3:0]  hesigb_matched_mcs;
  wire [ 2:0]  hesigb_matched_nbpsc;
  wire [ 1:0]  hesigb_matched_cr;
  wire         hesigb_matched_dcm;
  wire         hesigb_matched_fec;
  wire [ 2:0]  hesigb_matched_nsts;
  wire [ 2:0]  hesigb_matched_nsts_prev;
  wire [ 2:0]  hesigb_matched_nsts_tot;

  /* mux he fields for ucpu */
  wire  [ 3:0] hesig_mcs;      
  wire  [ 2:0] hesig_nsts;      
  wire         hesig_dcm;       
  wire  [ 2:0] hesig_rulen;     
  wire  [ 1:0] hesig_cr;        
  wire  [ 2:0] hesig_nbpsc;     
  wire         hesig_fec;       
  wire         hesig_beamformed;  
  
  /* service and data */
  wire         service_captured;
  wire [15:0]  service;
  wire         data_confirmed;
  
  /* ucpu */
  wire         ucpu_ndbps_done;
  wire         ucpu_lsig_done;
  wire         ucpu_htsig_done;
  wire         ucpu_vhtsig_done;
  wire         ucpu_hesig_done;  
  wire  [ 1:0] ucpu_l_length_mod3;
  wire  [25:0] ucpu_psdulen;
  wire  [15:0] ucpu_nsym;
  wire  [15:0] ucpu_ndbps;
  wire  [15:0] ucpu_ncbps;
  wire  [ 2:0] ucpu_tpe;
  wire  [ 8:0] ucpu_nma;
  wire         ucpu_inconsistent;
  wire  [ 1:0] ucpu_vht_nes;
  wire  [23:0] ucpu_npld;

  /* diag */
  wire  [ 9:0] diag_fsm;

  /*****************************************************************************
  * ASSIGNMENT
  *****************************************************************************/
  /* bd flow control */
  assign bd_ready = bd_ready_lsig   |
                    bd_ready_htsig  |
                    bd_ready_vhtsig |
                    bd_ready_hesiga |
                    bd_ready_hesigb |
                    bd_ready_data;
  
  /* field control */
  assign bd_ch0_field_start  = bd_field_start_fsm | bd_ch0_field_start_hesigb;
  
  assign bd_field_length     = {18'b0,bd_field_length_hesigb} | 
                                      bd_field_length_others;

  /*****************************************************************************
  * SYMBOL FSM
  *****************************************************************************/
  assign hesig_rulen        = (hesiga_format==HE_MU)? hesigb_matched_rulen      : hesiga_rulen;      
  assign hesig_nsts         = (hesiga_format==HE_MU)? hesigb_matched_nsts       : hesiga_nsts;       
  assign hesig_dcm          = (hesiga_format==HE_MU)? hesigb_matched_dcm        : hesiga_dcm;        
  assign hesig_cr           = (hesiga_format==HE_MU)? hesigb_matched_cr         : hesiga_cr;         
  assign hesig_nbpsc        = (hesiga_format==HE_MU)? hesigb_matched_nbpsc      : hesiga_nbpsc;      
  assign hesig_fec          = (hesiga_format==HE_MU)? hesigb_matched_fec        : hesiga_fec;        
  assign hesig_beamformed   = (hesiga_format==HE_MU)? hesigb_matched_beamformed : hesiga_beamformed; 
  assign hesig_mcs          = (hesiga_format==HE_MU)? hesigb_matched_mcs        : hesiga_mcs;        

  rx_bd_ctrl_fsm u_rx_bd_ctrl_fsm
  (
    /* system */
    .rst_n(                     rst_n),
    .clk(                       clk),
    
    /* control */
    .enable(                    enable),
    
    /* conf */
    .mdmcfg_conf_primary(       mdmcfg_conf_primary),
    .mdmcfg_conf_bw(            mdmcfg_conf_bw),
     
    /* data path */
    .bdfd_wrptr(                bdfd_wrptr),
    .bdfd_rdptr(                bdfd_rdptr),
    .bdfd_ch0_wrptr(            bdfd_ch0_wrptr),
    .bdfd_ch0_rdptr(            bdfd_ch0_rdptr),
    .bdfd_ch1_wrptr(            bdfd_ch1_wrptr),
    .bdfd_ch1_rdptr(            bdfd_ch1_rdptr),
    .bdfd_qbpsk(                bdfd_qbpsk),
    
    /* symbol */
    .bd_symbol(                 bd_symbol),
    
    /* datapath symbol control */
    .bd_bcc_enable(             bd_bcc_enable),
    .bd_ldpc_enable(            bd_ldpc_enable),
    .bd_ch0_sel(                bd_ch0_sel),            
    .bd_ch0_symbol_start(       bd_ch0_symbol_start),
    .bd_ch0_symbol_done(        bd_ch0_symbol_done),
    .bd_ch1_sel(                bd_ch1_sel),            
    .bd_ch1_symbol_start(       bd_ch1_symbol_start),
    .bd_ch1_symbol_done(        bd_ch1_symbol_done),
    .bd_fec(                    bd_fec),    
    .bd_dcm(                    bd_dcm),    
    .bd_sigen(                  bd_sigen),     
    .bd_qbpsk(                  bd_qbpsk),    
    .bd_nsd(                    bd_nsd),      
    .bd_ruen(                   bd_ruen),      
    .bd_rulen(                  bd_rulen),     
    .bd_nes(                    bd_nes),       
    .bd_nss(                    bd_nss),       
    .bd_nbpsc(                  bd_nbpsc),    
    .bd_stbc(                   bd_stbc),      
    .bd_cr(                     bd_cr),
    .bd_row_fifo_en(            bd_row_fifo_en),       
    
    .bd_field_start(            bd_field_start_fsm),
    .bd_field_length(           bd_field_length_others),  
    .bd_field_stfix(            bd_field_stfix),   
    
    /* lsig */
    .lsig_parser_enable(        lsig_parser_enable),   
    .lsig_captured(             lsig_captured),
    .lsig_nbpsc(                lsig_nbpsc),
    .lsig_cr(                   lsig_cr),
    .lsig_length_mod3(          ucpu_l_length_mod3),
    .lsig_length(               lsig_length),
    .lsig_ucpu_start(           lsig_ucpu_start),   
    .lsig_ucpu_done(            ucpu_lsig_done),
    
    /* htsig */
    .htsig_parser_enable(       htsig_parser_enable),
    .htsig_captured(            htsig_captured),
    .htsig_nsd(                 htsig_nsd),
    .htsig_nss(                 htsig_nss),
    .htsig_nbpsc(               htsig_nbpsc),
    .htsig_cr(                  htsig_cr),
    .htsig_fec(                 htsig_fec),
    .htsig_stbc(                htsig_stbc),
    .htsig_length(              htsig_length),
    .htsig_ucpu_start(          htsig_ucpu_start),   
    .htsig_ucpu_done(           ucpu_htsig_done),
    
    /* vhtsig */
    .vhtsiga_parser_enable(     vhtsiga_parser_enable),   
    .vhtsiga_captured(          vhtsiga_captured),
    .vhtsigb_parser_enable(     vhtsigb_parser_enable),   
    .vhtsigb_captured(          vhtsigb_captured),
    .vhtsig_nsd(                vhtsig_nsd),
    .vhtsig_nss(                vhtsig_nss),
    .vhtsig_nes(                ucpu_vht_nes[1]),
    .vhtsig_nbpsc(              vhtsig_nbpsc),
    .vhtsig_cr(                 vhtsig_cr),
    .vhtsig_fec(                vhtsig_fec),
    .vhtsig_stbc(               vhtsig_stbc),
    .vhtsig_ucpu_start(         vhtsig_ucpu_start),
    .vhtsig_ucpu_done(          ucpu_vhtsig_done),
  
    /* herlsig */
    .herlsig_parser_enable(     herlsig_parser_enable),    
    .herlsig_captured(          herlsig_captured),
    .herlsig_eq_lsig(           herlsig_eq_lsig),
   
    /* hesiga, hesigb */
    .hesiga2_is_qbpsk(          hesiga2_is_qbpsk),
    .hesiga_parser_enable(      hesiga_parser_enable),    
    .hesiga_captured(           hesiga_captured),
  
    .hesigb_parser_enable(      hesigb_parser_enable),
    .hesigb_parser_ch0_done(    hesigb_parser_ch0_done),
    .hesigb_parser_ch1_done(    hesigb_parser_ch1_done),
   
    .hesig_bandwidth(           hesiga_bandwidth),
    .hesig_fec(                 hesig_fec),
    .hesig_nbpsc(               hesig_nbpsc), 
    .hesig_cr(                  hesig_cr),    
    .hesig_dcm(                 hesig_dcm),   
    .hesig_rulen(               hesig_rulen), 
    .hesig_stbc(                hesiga_stbc),  
    .hesig_nsts(                hesig_nsts),  
    .hesig_sigb_nbpsc(          hesiga_sigb_nbpsc), 
    .hesig_sigb_cr(             hesiga_sigb_cr),    
    .hesig_sigb_dcm(            hesiga_sigb_dcm),    
 
    .hesig_ucpu_start(          hesig_ucpu_start),
    .hesig_ucpu_done(           ucpu_hesig_done),
    
    /* data */
    .data_parser_enable(        data_parser_enable),
    .data_confirmed(            data_confirmed),
    
    /* common parameters */
    .nsym(                      ucpu_nsym),
    .nsym_hesigb(               {3'd0,hesiga_sigb_nsym}),
    .npld(                      ucpu_npld),
    
    /* diag */
    .diag(                      diag_fsm)
  );

  /*****************************************************************************
  * LSIG PARSER
  *****************************************************************************/
  rx_bd_ctrl_lsig_parser u_rx_bd_ctrl_lsig_parser
  (
    /* system */
    .rst_n(                    rst_n),
    .clk(                      clk),
    
    /* control */
    .lsig_enable(              lsig_parser_enable),
    .lsig_captured(            lsig_captured),
    .herlsig_enable(           herlsig_parser_enable),
    .herlsig_captured(         herlsig_captured),
    
    /* byte stream */
    .bd_ready(                 bd_ready_lsig),
    .bd_data(                  bd_data),
    .bd_last(                  bd_last),
    .bd_valid(                 bd_valid),
    
    /* lsig parameters */
    .rate(                     lsig_rate),
    .length(                   lsig_length),
    .nbpsc(                    lsig_nbpsc),
    .cr(                       lsig_cr),
    .length_lt_12(             lsig_length_lt_12),
    .length_lt_14(             lsig_length_lt_14),
    .invalid_rate(             lsig_invalid_rate),
    .invalid_reserved4(        lsig_invalid_reserved4),
    .invalid_parity(           lsig_invalid_parity),
    
    /* herlsig */
    .herlsig_eq_lsig(          herlsig_eq_lsig)
  );

  /*****************************************************************************
  * HTSIG PARSER
  *****************************************************************************/
  rx_bd_ctrl_htsig_parser u_rx_bd_ctrl_htsig_parser
  (
    /* system */
    .rst_n(                    rst_n),
    .clk(                      clk),
    
    /* control */
    .enable(                   htsig_parser_enable),
    .captured(                 htsig_captured),
    
    /* byte stream */
    .bd_ready(                 bd_ready_htsig),
    .bd_data(                  bd_data),
    .bd_last(                  bd_last),
    .bd_valid(                 bd_valid),
    
    /* output parameters */
    .mcs(                      htsig_mcs),
    .bandwidth(                htsig_bandwidth),
    .length(                   htsig_length),
    .smoothing(                htsig_smoothing),
    .sounding(                 htsig_sounding),
    .aggregation(              htsig_aggregation),
    .stbc(                     htsig_stbc),
    .fec(                      htsig_fec),
    .gi_type(                  htsig_gi_type),
    .ness(                     htsig_ness),
    .mcs32(                    htsig_mcs32),
    .ndp(                      htsig_ndp),
    .nss(                      htsig_nss),
    .nsts(                     htsig_nsts),
    .nsd(                      htsig_nsd),
    .cr(                       htsig_cr),
    .nbpsc(                    htsig_nbpsc),
    
    .invalid_reserved26(       htsig_invalid_reserved26),
    .invalid_mcs(              htsig_invalid_mcs),
    .invalid_length(           htsig_invalid_length),
    .invalid_ndp_stbc(         htsig_invalid_ndp_stbc),
    .invalid_ndp_nss(          htsig_invalid_ndp_nss),
    .invalid_nsts_ness(        htsig_invalid_nsts_ness),
    .invalid_nsts_nss(         htsig_invalid_nsts_nss),
    .invalid_mcs32_bw(         htsig_invalid_mcs32_bw),
    .invalid_mcs32_stbc(       htsig_invalid_mcs32_stbc),
    .invalid_crc(              htsig_invalid_crc),
    .invalid_gf_sgi_1ss(       htsig_invalid_gf_sgi_1ss)
  );

  /*****************************************************************************
  * VHTSIG PARSER
  *****************************************************************************/
  rx_bd_ctrl_vhtsig_parser u_rx_bd_ctrl_vhtsig_parser
  (
    /* system */
    .rst_n(                      rst_n),
    .clk(                        clk),
    
    .mdmcfg_membershipstat(      mdmcfg_vht_membershipstat),
    .mdmcfg_userposid(           mdmcfg_vht_userposid),
    
    .vhtsiga_enable(             vhtsiga_parser_enable),
    .vhtsiga_captured(           vhtsiga_captured),
    .vhtsigb_enable(             vhtsigb_parser_enable),
    .vhtsigb_captured(           vhtsigb_captured),
                                  
    /* byte stream */           
    .bd_ready(                   bd_ready_vhtsig),
    .bd_data(                    bd_data),
    .bd_last(                    bd_last),
    .bd_valid(                   bd_valid),
    
    .bandwidth(                  vhtsig_bandwidth),
    .stbc(                       vhtsig_stbc),
    .gid(                        vhtsig_gid),
    .dozenotallowed(             vhtsig_dozenotallowed),
    .gi_type(                    vhtsig_gi_type),
    .sgidisamb(                  vhtsig_sgidisamb),
    .extra(                      vhtsig_extra),
    .nss(                        vhtsig_nss),
    .fec(                        vhtsig_fec),
    .paid(                       vhtsig_paid),
    .nsts(                       vhtsig_nsts),
    .nsts_tot(                   vhtsig_nsts_tot),
    .mcs(                        vhtsig_mcs),
    .beamformed(                 vhtsig_beamformed),
    
    .mumimo(                     vhtsig_mumimo),
    .mu_user_valid(              vhtsig_mu_user_valid),
    .mu_first_user(              vhtsig_mu_first_user),
    .mu_posid(                   vhtsig_mu_posid),
    .mu_sigb_length(             /* do not connect and do not use this field*/),
    .mu_pre_user_nsts(           vhtsig_nsts_prev),
    
    .nsd(                        vhtsig_nsd),
    .cr(                         vhtsig_cr),
    .nbpsc(                      vhtsig_nbpsc),
    
    .sigb_crc(                   vhtsig_sigb_crc),
    
    .invalid_siga_reserved2(     vhtsig_invalid_siga_reserved2),
    .invalid_siga_reserved23(    vhtsig_invalid_siga_reserved23),
    .invalid_siga_reserved31(    vhtsig_invalid_siga_reserved31),
    .invalid_siga_reserved32(    vhtsig_invalid_siga_reserved32),
    .invalid_siga_reserved33(    vhtsig_invalid_siga_reserved33),
    .invalid_siga_crc(           vhtsig_invalid_siga_crc),
    .invalid_sgi(                vhtsig_invalid_sgi),
    .invalid_stbc_odd(           vhtsig_invalid_stbc_odd),
    .invalid_mcs(                vhtsig_invalid_mcs),
    .invalid_su_fec_extra(       vhtsig_invalid_su_fec_extra),
    .invalid_mu_stbc(            vhtsig_invalid_mu_stbc),
    .invalid_mu_nsts_fec(        vhtsig_invalid_mu_nsts_fec)
  );

  /*****************************************************************************
  * HESIGA PARSER
  *****************************************************************************/
  rx_bd_ctrl_hesiga_parser u_rx_bd_ctrl_hesiga_parser
  (
    /* system */
    .rst_n(                      rst_n),
    .clk(                        clk),
    
    /* control */
    .enable(                     hesiga_parser_enable),
    .captured(                   hesiga_captured),
   
    .lsig_length_mod3(           ucpu_l_length_mod3),
    .hesiga2_is_qbpsk(           hesiga2_is_qbpsk),
    
    /* byte stream */
    .bd_ready(                   bd_ready_hesiga),
    .bd_data(                    bd_data),
    .bd_last(                    bd_last),
    .bd_valid(                   bd_valid),
    
    /* parameters */
    .format(                     hesiga_format),
    .beamchange(                 hesiga_beamchange),
    .uplink(                     hesiga_uplink),
    .mcs(                        hesiga_mcs),
    .nbpsc(                      hesiga_nbpsc),
    .cr(                         hesiga_cr),
    .dcm(                        hesiga_dcm),
    .bss_color(                  hesiga_bss_color),
    .spatial_reuse1(             hesiga_spatial_reuse1),
    .spatial_reuse2(             hesiga_spatial_reuse2),
    .spatial_reuse3(             hesiga_spatial_reuse3),
    .spatial_reuse4(             hesiga_spatial_reuse4),
    .bandwidth(                  hesiga_bandwidth),
    .ru_len(                     hesiga_rulen),
    .gi_type(                    hesiga_gi_type),
    .ltf_type(                   hesiga_ltf_type),
    .nsts(                       hesiga_nsts),
    .nheltf(                     hesiga_nheltf),
    .txop(                       hesiga_txop),
    .fec(                        hesiga_fec),
    .extra(                      hesiga_extra),
    .stbc(                       hesiga_stbc),
    .beamformed(                 hesiga_beamformed),
    .a(                          hesiga_a),
    .pedisamb(                   hesiga_pedisamb),
    .doppler(                    hesiga_doppler),
    .midamble(                   hesiga_midamble),

    .sigb_mcs(                   hesiga_sigb_mcs),
    .sigb_dcm(                   hesiga_sigb_dcm),
    .sigb_cr(                    hesiga_sigb_cr),
    .sigb_nbpsc(                 hesiga_sigb_nbpsc),
    .sigb_ndbps(                 hesiga_sigb_ndbps),
    .sigb_compression(           hesiga_sigb_compression),
    .sigb_compression_nuser(     hesiga_sigb_compression_nuser),
    .sigb_nsym(                  hesiga_sigb_nsym),
    
    .invalid_crc(                hesiga_invalid_crc)
  );

  /*****************************************************************************
  * HESIGB PARSER
  *****************************************************************************/
  rx_bd_ctrl_hesigb_parser u_rx_bd_ctrl_hesigb_parser
  (
    /* system */
    .rst_n(                      rst_n),
    .clk(                        clk),

    /* config */
    .mdmcfg_conf_primary(        mdmcfg_conf_primary),
    .mdmcfg_conf_bw(             mdmcfg_conf_bw),
    
    /* control */
    .enable(                     hesigb_parser_enable),
    .compression(                hesiga_sigb_compression),
    .compression_nuser(          hesiga_sigb_compression_nuser),
    
    .frame_bandwidth(            hesiga_bandwidth),
    .ch0_done(                   hesigb_parser_ch0_done),
    .ch1_done(                   hesigb_parser_ch1_done),
   
    /* byte stream */
    .bd_ready(                   bd_ready_hesigb),
    .bd_data(                    bd_data),
    .bd_last(                    bd_last),
    .bd_valid(                   bd_valid),
    
    /* data path control */
    .bd_ch0_field_start(         bd_ch0_field_start_hesigb),
    .bd_ch1_field_start(         bd_ch1_field_start),
    .bd_field_length(            bd_field_length_hesigb),
    
    /* user info */
    .user_valid(                 hesigb_user_valid),
    .staid(                      hesigb_staid),
    .ru_segment(                 hesigb_rusegment),
    .ru_len(                     hesigb_rulen),
    .ru_index(                   hesigb_ruindex),
    .ru_nuser(                   hesigb_runuser),
    .ru_user(                    hesigb_ruuser),
    .beamformed(                 hesigb_beamformed),
    .mcs(                        hesigb_mcs),
    .nbpsc(                      hesigb_nbpsc),
    .cr(                         hesigb_cr),
    .dcm(                        hesigb_dcm),
    .fec(                        hesigb_fec),
    .nsts(                       hesigb_nsts),
    .nsts_prev(                  hesigb_nsts_prev),
    .nsts_tot(                   hesigb_nsts_tot)
  );

  /*****************************************************************************
  * STAID MATCHING
  *****************************************************************************/
  rx_bd_ctrl_hesigb_staid_match u_rx_bd_ctrl_hesigb_staid_match
  (
    /* system */
    .rst_n(                                rst_n),
    .clk(                                  clk),
   
    /*  */
    .enable(                               hesigb_parser_enable),
   
    /* config registers */
    .mdmcfg_he_staid0(                     mdmcfg_he_staid0),
    .mdmcfg_he_staid1(                     mdmcfg_he_staid1),
    .mdmcfg_he_staid2(                     mdmcfg_he_staid2),
    .mdmcfg_he_staid3(                     mdmcfg_he_staid3),
 
    /* hesigb parser */
    .user_valid(                           hesigb_user_valid),
    .staid(                                hesigb_staid),
    .rusegment(                            hesigb_rusegment),
    .rulen(                                hesigb_rulen),
    .ruindex(                              hesigb_ruindex),
    .runuser(                              hesigb_runuser),
    .ruuser(                               hesigb_ruuser),
    .beamformed(                           hesigb_beamformed),
    .mcs(                                  hesigb_mcs),
    .nbpsc(                                hesigb_nbpsc),
    .cr(                                   hesigb_cr),
    .dcm(                                  hesigb_dcm),
    .fec(                                  hesigb_fec),
    .nsts(                                 hesigb_nsts),
    .nsts_prev(                            hesigb_nsts_prev),
    .nsts_tot(                             hesigb_nsts_tot),
    
    /* matched staid */
    .matched_user_valid(                   hesigb_matched_user_valid),
    .matched_staid(                        hesigb_matched_staid),
    .matched_rusegment(                    hesigb_matched_rusegment),
    .matched_rulen(                        hesigb_matched_rulen),
    .matched_ruindex(                      hesigb_matched_ruindex),
    .matched_runuser(                      hesigb_matched_runuser),
    .matched_ruuser(                       hesigb_matched_ruuser),
    .matched_beamformed(                   hesigb_matched_beamformed),
    .matched_mcs(                          hesigb_matched_mcs),
    .matched_nbpsc(                        hesigb_matched_nbpsc),
    .matched_cr(                           hesigb_matched_cr),
    .matched_dcm(                          hesigb_matched_dcm),
    .matched_fec(                          hesigb_matched_fec),
    .matched_nsts(                         hesigb_matched_nsts),
    .matched_nsts_prev(                    hesigb_matched_nsts_prev),
    .matched_nsts_tot(                     hesigb_matched_nsts_tot)
  );

  /*****************************************************************************
  * SERVICE AND DATA PARSER
  *****************************************************************************/
  reg [19:0] data_parser_length;
  
  always @(posedge clk,negedge rst_n)
  begin
    if(!rst_n)
    begin
      data_parser_length <= 20'b0;
    end
    else if(!enable)
    begin
      data_parser_length <= 20'b0;
    end
    else
    begin
      if(rxv2_update)
      begin
        if(rxv1_format==4'd0 ||  rxv1_format==4'd1)
          data_parser_length <= {8'd0,rxv2_l_length};
        else
          data_parser_length <= rxv2_length;
      end
    end
  end
  
  rx_bd_ctrl_data_parser u_rx_bd_ctrl_data_parser
  (
    /* system */
    .rst_n(                      rst_n),
    .clk(                        clk),
    
    .enable(                     data_parser_enable),
    .done(                       done),
    
    .confirmed(                  data_confirmed),
    .length(                     data_parser_length),
    
    /* byte stream */
    .bd_ready(                   bd_ready_data),
    .bd_data(                    bd_data),
    .bd_last(                    bd_last),
    .bd_valid(                   bd_valid),
    
    /* service */
    .service_captured(           service_captured),
    .service(                    service),
    
    /* mpif */
    .mpif_ready(                 mpif_ready),
    .mpif_data(                  mpif_data),
    .mpif_last(                  mpif_last),
    .mpif_valid(                 mpif_valid)
  );

  /*****************************************************************************
  * CALCULATOR
  *****************************************************************************/
  rx_bd_ctrl_ucpu u_rx_bd_ctrl_ucpu
  (
    /* system */
    .clk(                        clk),
    .rst_n(                      rst_n),
    
    /* control */
    .enable(                     enable),
    
    /* done */
    .ndbps_done(                 ucpu_ndbps_done),
    .l_done(                     ucpu_lsig_done),
    .ht_done(                    ucpu_htsig_done),
    .vht_done(                   ucpu_vhtsig_done),
    .he_done(                    ucpu_hesig_done),
    
    /* lsig parameters */
    .start_lsig(                 lsig_ucpu_start),
    .lsig_length(                lsig_length),
    .lsig_nbpsc(                 lsig_nbpsc),
    .lsig_cr(                    lsig_cr),
    
    /* htsig parameters */ 
    .start_htsig(                htsig_ucpu_start),
    .htsig_stbc(                 htsig_stbc),
    .htsig_nss(                  htsig_nss),
    .htsig_cr(                   htsig_cr),
    .htsig_nsd(                  htsig_nsd),
    .htsig_nbpsc(                htsig_nbpsc),
    .htsig_length(               htsig_length),
    .htsig_fec(                  htsig_fec),

    /* vhtsig parameters */
    .start_vhtsig(               vhtsig_ucpu_start),
    .vhtsig_gi_type(             vhtsig_gi_type),
    .vhtsig_sgidisamb(           vhtsig_sgidisamb),
    .vhtsig_stbc(                vhtsig_stbc),
    .vhtsig_bandwidth(           vhtsig_bandwidth),
    .vhtsig_nsts(                vhtsig_nsts),
    .vhtsig_nsts_total(          vhtsig_nsts_tot),
    .vhtsig_cr(                  vhtsig_cr),
    .vhtsig_nbpsc(               vhtsig_nbpsc),
    .vhtsig_fec(                 vhtsig_fec),
    .vhtsig_extra(               vhtsig_extra),

    /* hesig parameters */
    .start_hesig(                hesig_ucpu_start),
    .hesig_format(               hesiga_format),
    .hesig_a(                    hesiga_a),
    .hesig_nsts(                 hesig_nsts),
    .hesig_nheltf(               hesiga_nheltf),
    .hesig_gi_type(              hesiga_gi_type),
    .hesig_heltf_type(           hesiga_ltf_type),
    .hesig_pedisamb(             hesiga_pedisamb),
    .hesig_dcm(                  hesig_dcm),
    .hesig_rulen(                hesig_rulen),
    .hesig_cr(                   hesig_cr),
    .hesig_nbpsc(                hesig_nbpsc),
    .hesig_stbc(                 hesiga_stbc),
    .hesig_fec(                  hesig_fec),
    .hesig_extra(                hesiga_extra),
    .hesig_doppler(              hesiga_doppler),
    .hesig_midamble(             hesiga_midamble),
    .hesig_sigb_nsym(            {3'b0,hesiga_sigb_nsym}),
     
    /* results */
    .ndbps(                      ucpu_ndbps),
    .ncbps(                      ucpu_ncbps),
    .inconsistent(               ucpu_inconsistent),
    .l_length_mod3(              ucpu_l_length_mod3), 
    .nsym(                       ucpu_nsym),
    .psdulen(                    ucpu_psdulen),
    .rxtime(                     /* do not connect */),
    .tpe(                        ucpu_tpe),
    .nma(                        ucpu_nma),
    .nes(                        ucpu_vht_nes),
    .npld(                       ucpu_npld),
    
    /* ldpc results */
    .ncw(                        framep5_ncw),
    .lldpc(                      framep5_lldpc),
    .nshrtq(                     framep5_nshrtq),
    .nshrtr(                     framep5_nshrtr),
    .npuncq(                     framep5_npuncq),
    .npuncr(                     framep5_npuncr),
    .nrepq(                      framep5_nrepq),
    .nrepr(                      framep5_nrepr)
  );
  
  /*****************************************************************************
  * RXVECTOR AND FRAME PARAMETERS
  *****************************************************************************/
  rx_bd_ctrl_rxvector u_rx_bd_ctrl_rxvector
  (
    /* system */
    .rst_n(                                rst_n),
    .clk(                                  clk),
    
    /* symbol */
    .enable(                               enable),
    .data_confirmed(                       data_confirmed),

    /* config registers */
    .mdmcfg_conf_bw(                       mdmcfg_conf_bw),
    .mdmcfg_qam256_en(                     mdmcfg_qam256_en),
    .mdmcfg_qam1024_en(                    mdmcfg_qam1024_en),
    .mdmcfg_htmm_en(                       mdmcfg_htmm_en),
    .mdmcfg_htgf_en(                       mdmcfg_htgf_en),
    .mdmcfg_vht_en(                        mdmcfg_vht_en),
    .mdmcfg_he_en(                         mdmcfg_he_en),
    .mdmcfg_ldpc_en(                       mdmcfg_ldpc_en),
    .mdmcfg_stbc_en(                       mdmcfg_stbc_en),
    .mdmcfg_dcm_en(                        mdmcfg_dcm_en),
    .mdmcfg_nss_max(                       mdmcfg_nss_max),
    .mdmcfg_bcc_lgi_ndbps_max(             mdmcfg_bcc_lgi_ndbps_max),
    .mdmcfg_bcc_sgi_ndbps_max(             mdmcfg_bcc_sgi_ndbps_max),
    .mdmcfg_ldpc_lgi_ndbps_max(            mdmcfg_ldpc_lgi_ndbps_max),
    .mdmcfg_ldpc_sgi_ndbps_max(            mdmcfg_ldpc_sgi_ndbps_max),
    .mdmcfg_vht_mumimo_en(                 mdmcfg_vht_mumimo_en),
    .mdmcfg_he_mumimo_en(                  mdmcfg_he_mumimo_en),
    .mdmcfg_ndp_nsts_max(                  mdmcfg_ndp_nsts_max),
    .mdmcfg_frame_violation_mask(          mdmcfg_frame_violation_mask),
    .mdmcfg_he_frame_violation_mask(       mdmcfg_he_frame_violation_mask),
    
    /* mfsm */
    .mfsm_rxv_update(                      mfsm_rxv_update),
    .mfsm_frame_unsupported(               mfsm_frame_unsupported),
    .mfsm_frame_violation(                 mfsm_frame_violation),
    .mfsm_phy_error(                       mfsm_phy_error),
    
    /* ucpu */
    .ucpu_lsig_done(                       ucpu_lsig_done),
    .ucpu_htsig_done(                      ucpu_htsig_done),
    .ucpu_vhtsig_done(                     ucpu_vhtsig_done),
    .ucpu_hesig_done(                      ucpu_hesig_done),
    .ucpu_nsym(                            ucpu_nsym),
    .ucpu_ncbps(                           ucpu_ncbps),
    .ucpu_ndbps(                           ucpu_ndbps),
    .ucpu_psdulen(                         ucpu_psdulen[23:0]),
    .ucpu_inconsistent(                    ucpu_inconsistent),
    .ucpu_tpe(                             ucpu_tpe),
    .ucpu_nma(                             ucpu_nma),
    .ucpu_l_length_mod3(                   ucpu_l_length_mod3),
    
    /* lsig parser */
    .lsig_captured(                        lsig_captured),
    .lsig_rate(                            lsig_rate),             
    .lsig_length(                          lsig_length),           
    .lsig_nbpsc(                           lsig_nbpsc),            
    .lsig_cr(                              lsig_cr),               
    .lsig_length_lt_12(                    lsig_length_lt_12),     
    .lsig_length_lt_14(                    lsig_length_lt_14),     
    .lsig_invalid_rate(                    lsig_invalid_rate),     
    .lsig_invalid_reserved4(               lsig_invalid_reserved4),
    .lsig_invalid_parity(                  lsig_invalid_parity),   
    
    /* herlsig parser */
    .herlsig_captured(                     herlsig_captured),
    .herlsig_eq_lsig(                      herlsig_eq_lsig),
    
    /* htsig parser */
    .htsig_captured(                       htsig_captured),
    .htsig_mcs(                            htsig_mcs),
    .htsig_bandwidth(                      htsig_bandwidth),
    .htsig_length(                         htsig_length),
    .htsig_smoothing(                      htsig_smoothing),
    .htsig_sounding(                       htsig_sounding),
    .htsig_aggregation(                    htsig_aggregation),
    .htsig_stbc(                           htsig_stbc),
    .htsig_fec(                            htsig_fec),
    .htsig_gi_type(                        htsig_gi_type),
    .htsig_ness(                           htsig_ness),
    .htsig_mcs32(                          htsig_mcs32),
    .htsig_ndp(                            htsig_ndp),
    .htsig_nss(                            htsig_nss),
    .htsig_nsts(                           htsig_nsts),
    .htsig_nsd(                            htsig_nsd),
    .htsig_cr(                             htsig_cr),
    .htsig_nbpsc(                          htsig_nbpsc),
    
    .htsig_invalid_reserved26(             htsig_invalid_reserved26),
    .htsig_invalid_mcs(                    htsig_invalid_mcs),
    .htsig_invalid_length(                 htsig_invalid_length),
    .htsig_invalid_ndp_stbc(               htsig_invalid_ndp_stbc),
    .htsig_invalid_ndp_nss(                htsig_invalid_ndp_nss),
    .htsig_invalid_nsts_ness(              htsig_invalid_nsts_ness),
    .htsig_invalid_nsts_nss(               htsig_invalid_nsts_nss),
    .htsig_invalid_mcs32_bw(               htsig_invalid_mcs32_bw),
    .htsig_invalid_mcs32_stbc(             htsig_invalid_mcs32_stbc),
    .htsig_invalid_crc(                    htsig_invalid_crc),
    .htsig_invalid_gf_sgi_1ss(             htsig_invalid_gf_sgi_1ss),
    
    /* vhtsig parser */
    .vhtsiga_captured(                     vhtsiga_captured),
    .vhtsigb_captured(                     vhtsigb_captured),
    
    .vhtsig_bandwidth(                     vhtsig_bandwidth),
    .vhtsig_stbc(                          vhtsig_stbc),
    .vhtsig_gid(                           vhtsig_gid),
    .vhtsig_mumimo(                        vhtsig_mumimo),
    .vhtsig_dozenotallowed(                vhtsig_dozenotallowed),
    .vhtsig_gi_type(                       vhtsig_gi_type),
    .vhtsig_sgidisamb(                     vhtsig_sgidisamb),
    .vhtsig_extra(                         vhtsig_extra),
    .vhtsig_nss(                           vhtsig_nss),
    .vhtsig_fec(                           vhtsig_fec),
    .vhtsig_paid(                          vhtsig_paid),
    .vhtsig_nsts(                          vhtsig_nsts),
    .vhtsig_nsts_tot(                      vhtsig_nsts_tot),
    .vhtsig_mcs(                           vhtsig_mcs),
    .vhtsig_beamformed(                    vhtsig_beamformed),
    .vhtsig_mu_user_valid(                 vhtsig_mu_user_valid),
    .vhtsig_mu_first_user(                 vhtsig_mu_first_user),
    .vhtsig_mu_posid(                      vhtsig_mu_posid),
    .vhtsig_mu_nsts_prev(                  vhtsig_nsts_prev),
    .vhtsig_nsd(                           vhtsig_nsd),
    .vhtsig_cr(                            vhtsig_cr),
    .vhtsig_nbpsc(                         vhtsig_nbpsc),
    .vhtsig_sigb_crc(                      vhtsig_sigb_crc),
    .vhtsig_invalid_siga_reserved2(        vhtsig_invalid_siga_reserved2),
    .vhtsig_invalid_siga_reserved23(       vhtsig_invalid_siga_reserved23),
    .vhtsig_invalid_siga_reserved31(       vhtsig_invalid_siga_reserved31),
    .vhtsig_invalid_siga_reserved32(       vhtsig_invalid_siga_reserved32),
    .vhtsig_invalid_siga_reserved33(       vhtsig_invalid_siga_reserved33),
    .vhtsig_invalid_siga_crc(              vhtsig_invalid_siga_crc),
    .vhtsig_invalid_sgi(                   vhtsig_invalid_sgi),
    .vhtsig_invalid_stbc_odd(              vhtsig_invalid_stbc_odd),
    .vhtsig_invalid_mcs(                   vhtsig_invalid_mcs),
    .vhtsig_invalid_su_fec_extra(          vhtsig_invalid_su_fec_extra),
    .vhtsig_invalid_mu_stbc(               vhtsig_invalid_mu_stbc),
    .vhtsig_invalid_mu_nsts_fec(           vhtsig_invalid_mu_nsts_fec),
    
    /* hesiga parser */
    .hesiga_captured(                      hesiga_captured),
    .hesiga_format(                        hesiga_format),           
    .hesiga_beamchange(                    hesiga_beamchange),       
    .hesiga_uplink(                        hesiga_uplink),           
    .hesiga_bss_color(                     hesiga_bss_color),        
    .hesiga_spatial_reuse1(                hesiga_spatial_reuse1),   
    .hesiga_spatial_reuse2(                hesiga_spatial_reuse2),   
    .hesiga_spatial_reuse3(                hesiga_spatial_reuse3),   
    .hesiga_spatial_reuse4(                hesiga_spatial_reuse4),   
    .hesiga_bandwidth(                     hesiga_bandwidth),        
    .hesiga_gi_type(                       hesiga_gi_type),          
    .hesiga_ltf_type(                      hesiga_ltf_type),         
    .hesiga_nheltf(                        hesiga_nheltf),           
    .hesiga_txop(                          hesiga_txop),             
    .hesiga_extra(                         hesiga_extra),            
    .hesiga_stbc(                          hesiga_stbc),             
    .hesiga_a(                             hesiga_a),                
    .hesiga_pedisamb(                      hesiga_pedisamb),         
    .hesiga_doppler(                       hesiga_doppler),          
    .hesiga_midamble(                      hesiga_midamble),          
    .hesiga_sigb_mcs(                      hesiga_sigb_mcs),         
    .hesiga_sigb_nbpsc(                    hesiga_sigb_nbpsc),         
    .hesiga_sigb_cr(                       hesiga_sigb_cr),         
    .hesiga_sigb_dcm(                      hesiga_sigb_dcm),         
    .hesiga_sigb_ndbps(                    hesiga_sigb_ndbps),         
    .hesiga_sigb_nsym(                     {3'd0,hesiga_sigb_nsym}), 
    .hesiga_sigb_compression_nuser(        hesiga_sigb_compression_nuser), 
    .hesiga_sigb_compression(              hesiga_sigb_compression), 
    .hesiga_invalid_crc(                   hesiga_invalid_crc),
    
    /* hesiga/hesigb parser */
    .hesig_mcs(                            hesig_mcs),              
    .hesig_user_valid(                     hesigb_matched_user_valid),
    .hesig_rusegment(                      hesigb_matched_rusegment),
    .hesig_ruindex(                        hesigb_matched_ruindex),
    .hesig_runuser(                        hesigb_matched_runuser),
    .hesig_ruuser(                         hesigb_matched_ruuser),
    .hesig_nsts_prev(                      hesigb_matched_nsts_prev),
    .hesig_nsts_tot(                       hesigb_matched_nsts_tot),
    .hesig_nsts(                           hesig_nsts),             
    .hesig_beamformed(                     hesig_beamformed),       
    .hesig_nbpsc(                          hesig_nbpsc),              
    .hesig_cr(                             hesig_cr),              
    .hesig_dcm(                            hesig_dcm),              
    .hesig_rulen(                          hesig_rulen),        
    .hesig_fec(                            hesig_fec),              
  
    /* data parser */
    .service_captured(                     service_captured),
    .service(                              service),           
    
    /* AGC/CCA */
    .cca_lsig_valid(                       cca_lsig_valid),
    .cca_htsig_vhtsiga_valid(              cca_htsig_vhtsiga_valid),

    /* frame parameters */
    /* part 1 */
    .framep1_update(                       framep1_update),
    .framep1_format(                       framep1_format),
    .framep1_nsd(                          framep1_nsd),
    .framep1_cr(                           framep1_cr),
    .framep1_nbpsc(                        framep1_nbpsc),
    .framep1_nss(                          framep1_nss),
    .framep1_nsts(                         framep1_nsts),
    .framep1_ness(                         framep1_ness),
    .framep1_stbc(                         framep1_stbc),
    .framep1_fec(                          framep1_fec),
    .framep1_smoothing(                    framep1_smoothing),
    .framep1_htndp(                        framep1_htndp),
    .framep1_mumimo(                       framep1_mumimo),
    .framep1_beamformed(                   framep1_beamformed),
    .framep1_vhtmu_nsts_tot(               framep1_vhtmu_nsts_tot),
    .framep1_vhtmu_nsts_prev(              framep1_vhtmu_nsts_prev),
    .framep1_vhtmu_userpos(                framep1_vhtmu_userpos),
    .framep1_dcm(                          framep1_dcm),
    .framep1_rulen(                        framep1_rulen),
    .framep1_gi_type(                      framep1_gi_type),
    .framep1_mcs(                          framep1_mcs),
    .framep1_legrate(                      framep1_legrate),
    .framep1_bandwidth(                    framep1_bandwidth),
    .framep1_vhtndp(                       framep1_vhtndp),
    .framep1_hesigb_mcs(                   framep1_hesigb_mcs),
    .framep1_hesigb_dcm(                   framep1_hesigb_dcm),
    .framep1_hesigb_nbpsc(                 framep1_hesigb_nbpsc),       
    .framep1_hesigb_cr(                    framep1_hesigb_cr),     
    .framep1_hesigb_ndbps(                 framep1_hesigb_ndbps),         
    .framep1_nheltf(                       framep1_nheltf),        
    .framep1_heltftype(                    framep1_heltftype),
    .framep1_doppler(                      framep1_doppler),
    .framep1_midamble(                     framep1_midamble),        
  
    /* part 2 */     
    .framep2_update(                       framep2_update),
    .framep2_mu_nbpsc(                     framep2_mu_nbpsc),                  
    .framep2_hemu_beamformed(              framep2_hemu_beamformed),            
    .framep2_hemu_rusegment(               framep2_hemu_rusegment),            
    .framep2_hemu_rulen(                   framep2_hemu_rulen),            
    .framep2_hemu_ruindex(                 framep2_hemu_ruindex),            
    .framep2_hemu_runuser(                 framep2_hemu_runuser),            
    .framep2_hemu_ruuser(                  framep2_hemu_ruuser),            
    .framep2_hemu_dcm(                     framep2_hemu_dcm),             
    .framep2_hemu_nsts(                    framep2_hemu_nsts),            
    .framep2_hemu_nsts_tot(                framep2_hemu_nsts_tot),            
    .framep2_hemu_nsts_prev(               framep2_hemu_nsts_prev),            
    .framep2_hemu_fec(                     framep2_hemu_fec),             
    /* part 3 */
    .framep3_update(                       framep3_update),            
    .framep3_he_confirmed(                 framep3_he_confirmed),      
    /* part 4 */
    .framep4_update(                       framep4_update),      
    .framep4_lsig6m(                       framep4_lsig6m),
    /* part 5 */
    .framep6_update(                       framep6_update),
    .framep6_l_length_mod3_eq_1(           framep6_l_length_mod3_eq_1),
    /* part 7 */                         
    .framep7_update(                       framep7_update),
    .framep7_hesigb_nsym(                  framep7_hesigb_nsym),
    /* part 8 */     
    .framep8_update(                       framep8_update),
    .framep8_ncbps(                        framep8_ncbps),
    .framep8_nsym(                         framep8_nsym),
    .framep8_tpe(                          framep8_tpe),
    .framep8_nma(                          framep8_nma),
            
    /* MAC/PHY interface */
    /* rxvector */
    .rxv1_update(                          rxv1_update),
    .rxv1_format(                          rxv1_format),
    .rxv1_ch_bandwidth(                    rxv1_ch_bandwidth),
    .rxv2_update(                          rxv2_update),
    .rxv2_l_length(                        rxv2_l_length),
    .rxv2_l_rate(                          rxv2_l_rate),
    .rxv2_rssi(                            rxv2_rssi),
    .rxv2_dyn_bandwidth_in_non_ht(         rxv2_dyn_bandwidth_in_non_ht),
    .rxv2_ch_bandwidth_in_non_ht(          rxv2_ch_bandwidth_in_non_ht),
    .rxv2_sounding(                        rxv2_sounding),
    .rxv2_smoothing(                       rxv2_smoothing),
    .rxv2_gi_type(                         rxv2_gi_type),
    .rxv2_aggregation(                     rxv2_aggregation),
    .rxv2_stbc(                            rxv2_stbc),
    .rxv2_num_ext_ss(                      rxv2_num_ext_ss),
    .rxv2_l_sig_valid(                     rxv2_l_sig_valid),
    .rxv2_beamformed(                      rxv2_beamformed),
    .rxv2_doze_not_allowed(                rxv2_doze_not_allowed),
    .rxv2_first_user(                      rxv2_first_user),
    .rxv2_partial_aid(                     rxv2_partial_aid),
    .rxv2_group_id(                        rxv2_group_id),
    .rxv2_mcs(                             rxv2_mcs),
    .rxv2_nss(                             rxv2_nss),
    .rxv2_fec_coding(                      rxv2_fec_coding),
    .rxv2_length(                          rxv2_length),
    .rxv2_uplink_flag(                     rxv2_uplink_flag),
    .rxv2_beam_change(                     rxv2_beam_change),
    .rxv2_dcm(                             rxv2_dcm),
    .rxv2_rulen(                           rxv2_rulen),
    .rxv2_he_ltf_type(                     rxv2_he_ltf_type),
    .rxv2_doppler(                         rxv2_doppler),
    .rxv2_bss_color(                       rxv2_bss_color),
    .rxv2_txop_duration(                   rxv2_txop_duration),
    .rxv2_pe_duration(                     rxv2_pe_duration),
    .rxv2_spatial_reuse(                   rxv2_spatial_reuse),
    .rxv2_sig_b_compression_mode(          rxv2_sig_b_compression_mode),
    .rxv2_dcm_sig_b(                       rxv2_dcm_sig_b),
    .rxv2_mcs_sig_b(                       rxv2_mcs_sig_b),
    .rxv2_n_user(                          rxv2_n_user),
    .rxv2_staid(                           rxv2_staid)
  );

  /*****************************************************************************
  * diag
  *****************************************************************************/
  assign diag0[   15] = hesigb_user_valid;
  assign diag0[14:12] = hesigb_nsts;
  assign diag0[   11] = hesigb_beamformed;
  assign diag0[10: 0] = hesigb_staid;
  
  assign diag1[   15] = hesigb_user_valid;
  assign diag1[   14] = hesigb_beamformed;
  assign diag1[   13] = hesigb_dcm;
  assign diag1[12: 7] = hesigb_ruindex;
  assign diag1[ 6: 3] = hesigb_runuser;
  assign diag1[ 2: 0] = hesigb_ruuser;
  
  assign diag2[   15] = hesigb_user_valid;
  assign diag2[   14] = hesiga_stbc;
  assign diag2[13:11] = hesigb_rulen;
  assign diag2[   10] = hesigb_dcm;
  assign diag2[    9] = hesigb_fec;
  assign diag2[ 8: 6] = hesigb_nsts;
  assign diag2[ 5: 3] = hesigb_nsts_prev;
  assign diag2[ 2: 0] = hesigb_nsts_tot;

  assign diag3[   15] = data_confirmed;
  assign diag3[   14] = hesigb_matched_user_valid;
  assign diag3[   13] = hesigb_parser_ch1_done;
  assign diag3[   12] = bd_ch1_field_start;
  assign diag3[   11] = hesigb_parser_ch0_done;
  assign diag3[   10] = bd_ch0_field_start_hesigb;
  assign diag3[ 9: 0] = diag_fsm;
  
  
endmodule
`default_nettype wire
